#ifndef _BOARD_CONFIG_H_
#define _BOARD_CONFIG_H_

#include <driver/gpio.h>

#define AUDIO_INPUT_SAMPLE_RATE  24000
#define AUDIO_OUTPUT_SAMPLE_RATE 24000

#define AUDIO_INPUT_REFERENCE    true

#define AUDIO_I2S_GPIO_MCLK GPIO_NUM_5
#define AUDIO_I2S_GPIO_WS GPIO_NUM_7
#define AUDIO_I2S_GPIO_BCLK GPIO_NUM_16
#define AUDIO_I2S_GPIO_DIN  GPIO_NUM_15
#define AUDIO_I2S_GPIO_DOUT GPIO_NUM_6

#define AUDIO_CODEC_PA_PIN       GPIO_NUM_NC
#define AUDIO_CODEC_I2C_SDA_PIN  GPIO_NUM_47
#define AUDIO_CODEC_I2C_SCL_PIN  GPIO_NUM_48
#define AUDIO_CODEC_ES8311_ADDR  ES8311_CODEC_DEFAULT_ADDR
#define AUDIO_CODEC_ES7210_ADDR  ES7210_CODEC_DEFAULT_ADDR

#define I2C_ADDRESS         ESP_IO_EXPANDER_I2C_TCA9554_ADDRESS_000
#define BOOT_BUTTON_GPIO        GPIO_NUM_0

#define BSP_LCD_VSYNC     (GPIO_NUM_3)
#define BSP_LCD_HSYNC     (GPIO_NUM_46)
#define BSP_LCD_DE        (GPIO_NUM_17)
#define BSP_LCD_PCLK      (GPIO_NUM_9)
#define BSP_LCD_DISP      (GPIO_NUM_NC)
#define BSP_LCD_DATA0     (GPIO_NUM_40)
#define BSP_LCD_DATA1     (GPIO_NUM_41)
#define BSP_LCD_DATA2     (GPIO_NUM_42)
#define BSP_LCD_DATA3     (GPIO_NUM_2)
#define BSP_LCD_DATA4     (GPIO_NUM_1)
#define BSP_LCD_DATA5     (GPIO_NUM_21)
#define BSP_LCD_DATA6     (GPIO_NUM_8)
#define BSP_LCD_DATA7     (GPIO_NUM_18)
#define BSP_LCD_DATA8     (GPIO_NUM_45)
#define BSP_LCD_DATA9     (GPIO_NUM_38)
#define BSP_LCD_DATA10    (GPIO_NUM_39)
#define BSP_LCD_DATA11    (GPIO_NUM_10)
#define BSP_LCD_DATA12    (GPIO_NUM_11)
#define BSP_LCD_DATA13    (GPIO_NUM_12)
#define BSP_LCD_DATA14    (GPIO_NUM_13)
#define BSP_LCD_DATA15    (GPIO_NUM_14)

#define BSP_LCD_IO_SPI_CS (IO_EXPANDER_PIN_NUM_0)
#define BSP_LCD_IO_SPI_SCL (IO_EXPANDER_PIN_NUM_2)
#define BSP_LCD_IO_SPI_SDA (IO_EXPANDER_PIN_NUM_1)

#define DISPLAY_WIDTH   480
#define DISPLAY_HEIGHT  480

#define DISPLAY_SWAP_XY false
#define DISPLAY_MIRROR_X false
#define DISPLAY_MIRROR_Y false

#define DISPLAY_OFFSET_X  0
#define DISPLAY_OFFSET_Y  0

#define DISPLAY_BACKLIGHT_PIN GPIO_NUM_4
#define DISPLAY_BACKLIGHT_OUTPUT_INVERT true

#endif // _BOARD_CONFIG_H_
