| Supported Targets | ESP32-S2 | ESP32-S3 |
| ----------------- | -------- | -------- |

# ULP-RISC-V simple example with GPIO Polling:

This example demonstrates how to program the ULP-RISC-V coprocessor to poll a gpio and wakeup the main CPU when it changes its state;

ULP program written in C can be found across `ulp/main.c`. The build system compiles and links this program, converts it into binary format, and embeds it into the .rodata section of the ESP-IDF application.

At runtime, the application running inside the main CPU loads ULP program into the `RTC_SLOW_MEM` memory region using `ulp_riscv_load_binary` function. The main code then configures the ULP wakeup period and starts the coprocessor by using `ulp_riscv_run`. Once the ULP program is started, it runs periodically, with the period set by the main program. The main program enables ULP wakeup source and puts the chip into deep sleep mode.

When the ULP program finds an state changing in the pin, it saves the current state and sends a wakeup signal to the main CPU.

Upon wakeup, the main program prints the current level of the measured gpio and go back to the deep sleep.

In this example the input signal is connected to GPIO0. Note that this pin was chosen because most development boards have a button connected to it, so the pulses to be counted can be generated by pressing the button. For real world applications this is not a good choice of a pin, because GPIO0 also acts as a bootstrapping pin. To change the pin number, check the ESP32-S2 Chip Pin List document and adjust `gpio_num` and `ulp_io_number` variables in main.c.


## Example output

```
Not a ULP wakeup, initializing it!
Entering in deep sleep

...

ULP-RISC-V woke up the main CPU!
ULP-RISC-V read changes in GPIO_0 current is: High
Entering in deep sleep

```