/**
 * SPDX-FileCopyrightText: 2025 Espressif Systems (Shanghai) CO LTD
 *
 *  SPDX-License-Identifier: Apache-2.0
 */
#pragma once

#include <stdint.h>
#include "soc/soc.h"
#ifdef __cplusplus
extern "C" {
#endif

/** LP_GPIO_CLK_EN_REG register
 *  Reserved
 */
#define LP_GPIO_CLK_EN_REG (DR_REG_LP_GPIO_BASE + 0x0)
/** LP_GPIO_REG_CLK_EN : R/W; bitpos: [0]; default: 1;
 *  Reserved
 */
#define LP_GPIO_REG_CLK_EN    (BIT(0))
#define LP_GPIO_REG_CLK_EN_M  (LP_GPIO_REG_CLK_EN_V << LP_GPIO_REG_CLK_EN_S)
#define LP_GPIO_REG_CLK_EN_V  0x00000001U
#define LP_GPIO_REG_CLK_EN_S  0

/** LP_GPIO_VER_DATE_REG register
 *  Reserved
 */
#define LP_GPIO_VER_DATE_REG (DR_REG_LP_GPIO_BASE + 0x4)
/** LP_GPIO_REG_VER_DATE : R/W; bitpos: [27:0]; default: 2294563;
 *  Reserved
 */
#define LP_GPIO_REG_VER_DATE    0x0FFFFFFFU
#define LP_GPIO_REG_VER_DATE_M  (LP_GPIO_REG_VER_DATE_V << LP_GPIO_REG_VER_DATE_S)
#define LP_GPIO_REG_VER_DATE_V  0x0FFFFFFFU
#define LP_GPIO_REG_VER_DATE_S  0

/** LP_GPIO_OUT_REG register
 *  Reserved
 */
#define LP_GPIO_OUT_REG (DR_REG_LP_GPIO_BASE + 0x8)
/** LP_GPIO_REG_GPIO_OUT_DATA : R/W/WTC; bitpos: [15:0]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_OUT_DATA    0x0000FFFFU
#define LP_GPIO_REG_GPIO_OUT_DATA_M  (LP_GPIO_REG_GPIO_OUT_DATA_V << LP_GPIO_REG_GPIO_OUT_DATA_S)
#define LP_GPIO_REG_GPIO_OUT_DATA_V  0x0000FFFFU
#define LP_GPIO_REG_GPIO_OUT_DATA_S  0

/** LP_GPIO_OUT_W1TS_REG register
 *  Reserved
 */
#define LP_GPIO_OUT_W1TS_REG (DR_REG_LP_GPIO_BASE + 0xc)
/** LP_GPIO_REG_GPIO_OUT_DATA_W1TS : WT; bitpos: [15:0]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_OUT_DATA_W1TS    0x0000FFFFU
#define LP_GPIO_REG_GPIO_OUT_DATA_W1TS_M  (LP_GPIO_REG_GPIO_OUT_DATA_W1TS_V << LP_GPIO_REG_GPIO_OUT_DATA_W1TS_S)
#define LP_GPIO_REG_GPIO_OUT_DATA_W1TS_V  0x0000FFFFU
#define LP_GPIO_REG_GPIO_OUT_DATA_W1TS_S  0

/** LP_GPIO_OUT_W1TC_REG register
 *  Reserved
 */
#define LP_GPIO_OUT_W1TC_REG (DR_REG_LP_GPIO_BASE + 0x10)
/** LP_GPIO_REG_GPIO_OUT_DATA_W1TC : WT; bitpos: [15:0]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_OUT_DATA_W1TC    0x0000FFFFU
#define LP_GPIO_REG_GPIO_OUT_DATA_W1TC_M  (LP_GPIO_REG_GPIO_OUT_DATA_W1TC_V << LP_GPIO_REG_GPIO_OUT_DATA_W1TC_S)
#define LP_GPIO_REG_GPIO_OUT_DATA_W1TC_V  0x0000FFFFU
#define LP_GPIO_REG_GPIO_OUT_DATA_W1TC_S  0

/** LP_GPIO_ENABLE_REG register
 *  Reserved
 */
#define LP_GPIO_ENABLE_REG (DR_REG_LP_GPIO_BASE + 0x14)
/** LP_GPIO_REG_GPIO_ENABLE_DATA : R/W/WTC; bitpos: [15:0]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_ENABLE_DATA    0x0000FFFFU
#define LP_GPIO_REG_GPIO_ENABLE_DATA_M  (LP_GPIO_REG_GPIO_ENABLE_DATA_V << LP_GPIO_REG_GPIO_ENABLE_DATA_S)
#define LP_GPIO_REG_GPIO_ENABLE_DATA_V  0x0000FFFFU
#define LP_GPIO_REG_GPIO_ENABLE_DATA_S  0

/** LP_GPIO_ENABLE_W1TS_REG register
 *  Reserved
 */
#define LP_GPIO_ENABLE_W1TS_REG (DR_REG_LP_GPIO_BASE + 0x18)
/** LP_GPIO_REG_GPIO_ENABLE_DATA_W1TS : WT; bitpos: [15:0]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_ENABLE_DATA_W1TS    0x0000FFFFU
#define LP_GPIO_REG_GPIO_ENABLE_DATA_W1TS_M  (LP_GPIO_REG_GPIO_ENABLE_DATA_W1TS_V << LP_GPIO_REG_GPIO_ENABLE_DATA_W1TS_S)
#define LP_GPIO_REG_GPIO_ENABLE_DATA_W1TS_V  0x0000FFFFU
#define LP_GPIO_REG_GPIO_ENABLE_DATA_W1TS_S  0

/** LP_GPIO_ENABLE_W1TC_REG register
 *  Reserved
 */
#define LP_GPIO_ENABLE_W1TC_REG (DR_REG_LP_GPIO_BASE + 0x1c)
/** LP_GPIO_REG_GPIO_ENABLE_DATA_W1TC : WT; bitpos: [15:0]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_ENABLE_DATA_W1TC    0x0000FFFFU
#define LP_GPIO_REG_GPIO_ENABLE_DATA_W1TC_M  (LP_GPIO_REG_GPIO_ENABLE_DATA_W1TC_V << LP_GPIO_REG_GPIO_ENABLE_DATA_W1TC_S)
#define LP_GPIO_REG_GPIO_ENABLE_DATA_W1TC_V  0x0000FFFFU
#define LP_GPIO_REG_GPIO_ENABLE_DATA_W1TC_S  0

/** LP_GPIO_STATUS_REG register
 *  Reserved
 */
#define LP_GPIO_STATUS_REG (DR_REG_LP_GPIO_BASE + 0x20)
/** LP_GPIO_REG_GPIO_STATUS_DATA : R/W/WTC; bitpos: [15:0]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_STATUS_DATA    0x0000FFFFU
#define LP_GPIO_REG_GPIO_STATUS_DATA_M  (LP_GPIO_REG_GPIO_STATUS_DATA_V << LP_GPIO_REG_GPIO_STATUS_DATA_S)
#define LP_GPIO_REG_GPIO_STATUS_DATA_V  0x0000FFFFU
#define LP_GPIO_REG_GPIO_STATUS_DATA_S  0

/** LP_GPIO_STATUS_W1TS_REG register
 *  Reserved
 */
#define LP_GPIO_STATUS_W1TS_REG (DR_REG_LP_GPIO_BASE + 0x24)
/** LP_GPIO_REG_GPIO_STATUS_DATA_W1TS : WT; bitpos: [15:0]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_STATUS_DATA_W1TS    0x0000FFFFU
#define LP_GPIO_REG_GPIO_STATUS_DATA_W1TS_M  (LP_GPIO_REG_GPIO_STATUS_DATA_W1TS_V << LP_GPIO_REG_GPIO_STATUS_DATA_W1TS_S)
#define LP_GPIO_REG_GPIO_STATUS_DATA_W1TS_V  0x0000FFFFU
#define LP_GPIO_REG_GPIO_STATUS_DATA_W1TS_S  0

/** LP_GPIO_STATUS_W1TC_REG register
 *  Reserved
 */
#define LP_GPIO_STATUS_W1TC_REG (DR_REG_LP_GPIO_BASE + 0x28)
/** LP_GPIO_REG_GPIO_STATUS_DATA_W1TC : WT; bitpos: [15:0]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_STATUS_DATA_W1TC    0x0000FFFFU
#define LP_GPIO_REG_GPIO_STATUS_DATA_W1TC_M  (LP_GPIO_REG_GPIO_STATUS_DATA_W1TC_V << LP_GPIO_REG_GPIO_STATUS_DATA_W1TC_S)
#define LP_GPIO_REG_GPIO_STATUS_DATA_W1TC_V  0x0000FFFFU
#define LP_GPIO_REG_GPIO_STATUS_DATA_W1TC_S  0

/** LP_GPIO_STATUS_NEXT_REG register
 *  Reserved
 */
#define LP_GPIO_STATUS_NEXT_REG (DR_REG_LP_GPIO_BASE + 0x2c)
/** LP_GPIO_REG_GPIO_STATUS_INTERRUPT_NEXT : RO; bitpos: [15:0]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_STATUS_INTERRUPT_NEXT    0x0000FFFFU
#define LP_GPIO_REG_GPIO_STATUS_INTERRUPT_NEXT_M  (LP_GPIO_REG_GPIO_STATUS_INTERRUPT_NEXT_V << LP_GPIO_REG_GPIO_STATUS_INTERRUPT_NEXT_S)
#define LP_GPIO_REG_GPIO_STATUS_INTERRUPT_NEXT_V  0x0000FFFFU
#define LP_GPIO_REG_GPIO_STATUS_INTERRUPT_NEXT_S  0

/** LP_GPIO_IN_REG register
 *  Reserved
 */
#define LP_GPIO_IN_REG (DR_REG_LP_GPIO_BASE + 0x30)
/** LP_GPIO_REG_GPIO_IN_DATA_NEXT : RO; bitpos: [15:0]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_IN_DATA_NEXT    0x0000FFFFU
#define LP_GPIO_REG_GPIO_IN_DATA_NEXT_M  (LP_GPIO_REG_GPIO_IN_DATA_NEXT_V << LP_GPIO_REG_GPIO_IN_DATA_NEXT_S)
#define LP_GPIO_REG_GPIO_IN_DATA_NEXT_V  0x0000FFFFU
#define LP_GPIO_REG_GPIO_IN_DATA_NEXT_S  0

/** LP_GPIO_PIN0_REG register
 *  Reserved
 */
#define LP_GPIO_PIN0_REG (DR_REG_LP_GPIO_BASE + 0x34)
/** LP_GPIO_REG_GPIO_PIN0_WAKEUP_ENABLE : R/W; bitpos: [0]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_PIN0_WAKEUP_ENABLE    (BIT(0))
#define LP_GPIO_REG_GPIO_PIN0_WAKEUP_ENABLE_M  (LP_GPIO_REG_GPIO_PIN0_WAKEUP_ENABLE_V << LP_GPIO_REG_GPIO_PIN0_WAKEUP_ENABLE_S)
#define LP_GPIO_REG_GPIO_PIN0_WAKEUP_ENABLE_V  0x00000001U
#define LP_GPIO_REG_GPIO_PIN0_WAKEUP_ENABLE_S  0
/** LP_GPIO_REG_GPIO_PIN0_INT_TYPE : R/W; bitpos: [3:1]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_PIN0_INT_TYPE    0x00000007U
#define LP_GPIO_REG_GPIO_PIN0_INT_TYPE_M  (LP_GPIO_REG_GPIO_PIN0_INT_TYPE_V << LP_GPIO_REG_GPIO_PIN0_INT_TYPE_S)
#define LP_GPIO_REG_GPIO_PIN0_INT_TYPE_V  0x00000007U
#define LP_GPIO_REG_GPIO_PIN0_INT_TYPE_S  1
/** LP_GPIO_REG_GPIO_PIN0_PAD_DRIVER : R/W; bitpos: [4]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_PIN0_PAD_DRIVER    (BIT(4))
#define LP_GPIO_REG_GPIO_PIN0_PAD_DRIVER_M  (LP_GPIO_REG_GPIO_PIN0_PAD_DRIVER_V << LP_GPIO_REG_GPIO_PIN0_PAD_DRIVER_S)
#define LP_GPIO_REG_GPIO_PIN0_PAD_DRIVER_V  0x00000001U
#define LP_GPIO_REG_GPIO_PIN0_PAD_DRIVER_S  4
/** LP_GPIO_REG_GPIO_PIN0_EDGE_WAKEUP_CLR : WT; bitpos: [5]; default: 0;
 *  need des
 */
#define LP_GPIO_REG_GPIO_PIN0_EDGE_WAKEUP_CLR    (BIT(5))
#define LP_GPIO_REG_GPIO_PIN0_EDGE_WAKEUP_CLR_M  (LP_GPIO_REG_GPIO_PIN0_EDGE_WAKEUP_CLR_V << LP_GPIO_REG_GPIO_PIN0_EDGE_WAKEUP_CLR_S)
#define LP_GPIO_REG_GPIO_PIN0_EDGE_WAKEUP_CLR_V  0x00000001U
#define LP_GPIO_REG_GPIO_PIN0_EDGE_WAKEUP_CLR_S  5

/** LP_GPIO_PIN1_REG register
 *  Reserved
 */
#define LP_GPIO_PIN1_REG (DR_REG_LP_GPIO_BASE + 0x38)
/** LP_GPIO_REG_GPIO_PIN1_WAKEUP_ENABLE : R/W; bitpos: [0]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_PIN1_WAKEUP_ENABLE    (BIT(0))
#define LP_GPIO_REG_GPIO_PIN1_WAKEUP_ENABLE_M  (LP_GPIO_REG_GPIO_PIN1_WAKEUP_ENABLE_V << LP_GPIO_REG_GPIO_PIN1_WAKEUP_ENABLE_S)
#define LP_GPIO_REG_GPIO_PIN1_WAKEUP_ENABLE_V  0x00000001U
#define LP_GPIO_REG_GPIO_PIN1_WAKEUP_ENABLE_S  0
/** LP_GPIO_REG_GPIO_PIN1_INT_TYPE : R/W; bitpos: [3:1]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_PIN1_INT_TYPE    0x00000007U
#define LP_GPIO_REG_GPIO_PIN1_INT_TYPE_M  (LP_GPIO_REG_GPIO_PIN1_INT_TYPE_V << LP_GPIO_REG_GPIO_PIN1_INT_TYPE_S)
#define LP_GPIO_REG_GPIO_PIN1_INT_TYPE_V  0x00000007U
#define LP_GPIO_REG_GPIO_PIN1_INT_TYPE_S  1
/** LP_GPIO_REG_GPIO_PIN1_PAD_DRIVER : R/W; bitpos: [4]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_PIN1_PAD_DRIVER    (BIT(4))
#define LP_GPIO_REG_GPIO_PIN1_PAD_DRIVER_M  (LP_GPIO_REG_GPIO_PIN1_PAD_DRIVER_V << LP_GPIO_REG_GPIO_PIN1_PAD_DRIVER_S)
#define LP_GPIO_REG_GPIO_PIN1_PAD_DRIVER_V  0x00000001U
#define LP_GPIO_REG_GPIO_PIN1_PAD_DRIVER_S  4
/** LP_GPIO_REG_GPI1_PIN0_EDGE_WAKEUP_CLR : WT; bitpos: [5]; default: 0;
 *  need des
 */
#define LP_GPIO_REG_GPI1_PIN0_EDGE_WAKEUP_CLR    (BIT(5))
#define LP_GPIO_REG_GPI1_PIN0_EDGE_WAKEUP_CLR_M  (LP_GPIO_REG_GPI1_PIN0_EDGE_WAKEUP_CLR_V << LP_GPIO_REG_GPI1_PIN0_EDGE_WAKEUP_CLR_S)
#define LP_GPIO_REG_GPI1_PIN0_EDGE_WAKEUP_CLR_V  0x00000001U
#define LP_GPIO_REG_GPI1_PIN0_EDGE_WAKEUP_CLR_S  5

/** LP_GPIO_PIN2_REG register
 *  Reserved
 */
#define LP_GPIO_PIN2_REG (DR_REG_LP_GPIO_BASE + 0x3c)
/** LP_GPIO_REG_GPIO_PIN2_WAKEUP_ENABLE : R/W; bitpos: [0]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_PIN2_WAKEUP_ENABLE    (BIT(0))
#define LP_GPIO_REG_GPIO_PIN2_WAKEUP_ENABLE_M  (LP_GPIO_REG_GPIO_PIN2_WAKEUP_ENABLE_V << LP_GPIO_REG_GPIO_PIN2_WAKEUP_ENABLE_S)
#define LP_GPIO_REG_GPIO_PIN2_WAKEUP_ENABLE_V  0x00000001U
#define LP_GPIO_REG_GPIO_PIN2_WAKEUP_ENABLE_S  0
/** LP_GPIO_REG_GPIO_PIN2_INT_TYPE : R/W; bitpos: [3:1]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_PIN2_INT_TYPE    0x00000007U
#define LP_GPIO_REG_GPIO_PIN2_INT_TYPE_M  (LP_GPIO_REG_GPIO_PIN2_INT_TYPE_V << LP_GPIO_REG_GPIO_PIN2_INT_TYPE_S)
#define LP_GPIO_REG_GPIO_PIN2_INT_TYPE_V  0x00000007U
#define LP_GPIO_REG_GPIO_PIN2_INT_TYPE_S  1
/** LP_GPIO_REG_GPIO_PIN2_PAD_DRIVER : R/W; bitpos: [4]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_PIN2_PAD_DRIVER    (BIT(4))
#define LP_GPIO_REG_GPIO_PIN2_PAD_DRIVER_M  (LP_GPIO_REG_GPIO_PIN2_PAD_DRIVER_V << LP_GPIO_REG_GPIO_PIN2_PAD_DRIVER_S)
#define LP_GPIO_REG_GPIO_PIN2_PAD_DRIVER_V  0x00000001U
#define LP_GPIO_REG_GPIO_PIN2_PAD_DRIVER_S  4
/** LP_GPIO_REG_GPI2_PIN0_EDGE_WAKEUP_CLR : WT; bitpos: [5]; default: 0;
 *  need des
 */
#define LP_GPIO_REG_GPI2_PIN0_EDGE_WAKEUP_CLR    (BIT(5))
#define LP_GPIO_REG_GPI2_PIN0_EDGE_WAKEUP_CLR_M  (LP_GPIO_REG_GPI2_PIN0_EDGE_WAKEUP_CLR_V << LP_GPIO_REG_GPI2_PIN0_EDGE_WAKEUP_CLR_S)
#define LP_GPIO_REG_GPI2_PIN0_EDGE_WAKEUP_CLR_V  0x00000001U
#define LP_GPIO_REG_GPI2_PIN0_EDGE_WAKEUP_CLR_S  5

/** LP_GPIO_PIN3_REG register
 *  Reserved
 */
#define LP_GPIO_PIN3_REG (DR_REG_LP_GPIO_BASE + 0x40)
/** LP_GPIO_REG_GPIO_PIN3_WAKEUP_ENABLE : R/W; bitpos: [0]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_PIN3_WAKEUP_ENABLE    (BIT(0))
#define LP_GPIO_REG_GPIO_PIN3_WAKEUP_ENABLE_M  (LP_GPIO_REG_GPIO_PIN3_WAKEUP_ENABLE_V << LP_GPIO_REG_GPIO_PIN3_WAKEUP_ENABLE_S)
#define LP_GPIO_REG_GPIO_PIN3_WAKEUP_ENABLE_V  0x00000001U
#define LP_GPIO_REG_GPIO_PIN3_WAKEUP_ENABLE_S  0
/** LP_GPIO_REG_GPIO_PIN3_INT_TYPE : R/W; bitpos: [3:1]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_PIN3_INT_TYPE    0x00000007U
#define LP_GPIO_REG_GPIO_PIN3_INT_TYPE_M  (LP_GPIO_REG_GPIO_PIN3_INT_TYPE_V << LP_GPIO_REG_GPIO_PIN3_INT_TYPE_S)
#define LP_GPIO_REG_GPIO_PIN3_INT_TYPE_V  0x00000007U
#define LP_GPIO_REG_GPIO_PIN3_INT_TYPE_S  1
/** LP_GPIO_REG_GPIO_PIN3_PAD_DRIVER : R/W; bitpos: [4]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_PIN3_PAD_DRIVER    (BIT(4))
#define LP_GPIO_REG_GPIO_PIN3_PAD_DRIVER_M  (LP_GPIO_REG_GPIO_PIN3_PAD_DRIVER_V << LP_GPIO_REG_GPIO_PIN3_PAD_DRIVER_S)
#define LP_GPIO_REG_GPIO_PIN3_PAD_DRIVER_V  0x00000001U
#define LP_GPIO_REG_GPIO_PIN3_PAD_DRIVER_S  4
/** LP_GPIO_REG_GPI3_PIN0_EDGE_WAKEUP_CLR : WT; bitpos: [5]; default: 0;
 *  need des
 */
#define LP_GPIO_REG_GPI3_PIN0_EDGE_WAKEUP_CLR    (BIT(5))
#define LP_GPIO_REG_GPI3_PIN0_EDGE_WAKEUP_CLR_M  (LP_GPIO_REG_GPI3_PIN0_EDGE_WAKEUP_CLR_V << LP_GPIO_REG_GPI3_PIN0_EDGE_WAKEUP_CLR_S)
#define LP_GPIO_REG_GPI3_PIN0_EDGE_WAKEUP_CLR_V  0x00000001U
#define LP_GPIO_REG_GPI3_PIN0_EDGE_WAKEUP_CLR_S  5

/** LP_GPIO_PIN4_REG register
 *  Reserved
 */
#define LP_GPIO_PIN4_REG (DR_REG_LP_GPIO_BASE + 0x44)
/** LP_GPIO_REG_GPIO_PIN4_WAKEUP_ENABLE : R/W; bitpos: [0]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_PIN4_WAKEUP_ENABLE    (BIT(0))
#define LP_GPIO_REG_GPIO_PIN4_WAKEUP_ENABLE_M  (LP_GPIO_REG_GPIO_PIN4_WAKEUP_ENABLE_V << LP_GPIO_REG_GPIO_PIN4_WAKEUP_ENABLE_S)
#define LP_GPIO_REG_GPIO_PIN4_WAKEUP_ENABLE_V  0x00000001U
#define LP_GPIO_REG_GPIO_PIN4_WAKEUP_ENABLE_S  0
/** LP_GPIO_REG_GPIO_PIN4_INT_TYPE : R/W; bitpos: [3:1]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_PIN4_INT_TYPE    0x00000007U
#define LP_GPIO_REG_GPIO_PIN4_INT_TYPE_M  (LP_GPIO_REG_GPIO_PIN4_INT_TYPE_V << LP_GPIO_REG_GPIO_PIN4_INT_TYPE_S)
#define LP_GPIO_REG_GPIO_PIN4_INT_TYPE_V  0x00000007U
#define LP_GPIO_REG_GPIO_PIN4_INT_TYPE_S  1
/** LP_GPIO_REG_GPIO_PIN4_PAD_DRIVER : R/W; bitpos: [4]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_PIN4_PAD_DRIVER    (BIT(4))
#define LP_GPIO_REG_GPIO_PIN4_PAD_DRIVER_M  (LP_GPIO_REG_GPIO_PIN4_PAD_DRIVER_V << LP_GPIO_REG_GPIO_PIN4_PAD_DRIVER_S)
#define LP_GPIO_REG_GPIO_PIN4_PAD_DRIVER_V  0x00000001U
#define LP_GPIO_REG_GPIO_PIN4_PAD_DRIVER_S  4
/** LP_GPIO_REG_GPI4_PIN0_EDGE_WAKEUP_CLR : WT; bitpos: [5]; default: 0;
 *  need des
 */
#define LP_GPIO_REG_GPI4_PIN0_EDGE_WAKEUP_CLR    (BIT(5))
#define LP_GPIO_REG_GPI4_PIN0_EDGE_WAKEUP_CLR_M  (LP_GPIO_REG_GPI4_PIN0_EDGE_WAKEUP_CLR_V << LP_GPIO_REG_GPI4_PIN0_EDGE_WAKEUP_CLR_S)
#define LP_GPIO_REG_GPI4_PIN0_EDGE_WAKEUP_CLR_V  0x00000001U
#define LP_GPIO_REG_GPI4_PIN0_EDGE_WAKEUP_CLR_S  5

/** LP_GPIO_PIN5_REG register
 *  Reserved
 */
#define LP_GPIO_PIN5_REG (DR_REG_LP_GPIO_BASE + 0x48)
/** LP_GPIO_REG_GPIO_PIN5_WAKEUP_ENABLE : R/W; bitpos: [0]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_PIN5_WAKEUP_ENABLE    (BIT(0))
#define LP_GPIO_REG_GPIO_PIN5_WAKEUP_ENABLE_M  (LP_GPIO_REG_GPIO_PIN5_WAKEUP_ENABLE_V << LP_GPIO_REG_GPIO_PIN5_WAKEUP_ENABLE_S)
#define LP_GPIO_REG_GPIO_PIN5_WAKEUP_ENABLE_V  0x00000001U
#define LP_GPIO_REG_GPIO_PIN5_WAKEUP_ENABLE_S  0
/** LP_GPIO_REG_GPIO_PIN5_INT_TYPE : R/W; bitpos: [3:1]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_PIN5_INT_TYPE    0x00000007U
#define LP_GPIO_REG_GPIO_PIN5_INT_TYPE_M  (LP_GPIO_REG_GPIO_PIN5_INT_TYPE_V << LP_GPIO_REG_GPIO_PIN5_INT_TYPE_S)
#define LP_GPIO_REG_GPIO_PIN5_INT_TYPE_V  0x00000007U
#define LP_GPIO_REG_GPIO_PIN5_INT_TYPE_S  1
/** LP_GPIO_REG_GPIO_PIN5_PAD_DRIVER : R/W; bitpos: [4]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_PIN5_PAD_DRIVER    (BIT(4))
#define LP_GPIO_REG_GPIO_PIN5_PAD_DRIVER_M  (LP_GPIO_REG_GPIO_PIN5_PAD_DRIVER_V << LP_GPIO_REG_GPIO_PIN5_PAD_DRIVER_S)
#define LP_GPIO_REG_GPIO_PIN5_PAD_DRIVER_V  0x00000001U
#define LP_GPIO_REG_GPIO_PIN5_PAD_DRIVER_S  4
/** LP_GPIO_REG_GPI5_PIN0_EDGE_WAKEUP_CLR : WT; bitpos: [5]; default: 0;
 *  need des
 */
#define LP_GPIO_REG_GPI5_PIN0_EDGE_WAKEUP_CLR    (BIT(5))
#define LP_GPIO_REG_GPI5_PIN0_EDGE_WAKEUP_CLR_M  (LP_GPIO_REG_GPI5_PIN0_EDGE_WAKEUP_CLR_V << LP_GPIO_REG_GPI5_PIN0_EDGE_WAKEUP_CLR_S)
#define LP_GPIO_REG_GPI5_PIN0_EDGE_WAKEUP_CLR_V  0x00000001U
#define LP_GPIO_REG_GPI5_PIN0_EDGE_WAKEUP_CLR_S  5

/** LP_GPIO_PIN6_REG register
 *  Reserved
 */
#define LP_GPIO_PIN6_REG (DR_REG_LP_GPIO_BASE + 0x4c)
/** LP_GPIO_REG_GPIO_PIN6_WAKEUP_ENABLE : R/W; bitpos: [0]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_PIN6_WAKEUP_ENABLE    (BIT(0))
#define LP_GPIO_REG_GPIO_PIN6_WAKEUP_ENABLE_M  (LP_GPIO_REG_GPIO_PIN6_WAKEUP_ENABLE_V << LP_GPIO_REG_GPIO_PIN6_WAKEUP_ENABLE_S)
#define LP_GPIO_REG_GPIO_PIN6_WAKEUP_ENABLE_V  0x00000001U
#define LP_GPIO_REG_GPIO_PIN6_WAKEUP_ENABLE_S  0
/** LP_GPIO_REG_GPIO_PIN6_INT_TYPE : R/W; bitpos: [3:1]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_PIN6_INT_TYPE    0x00000007U
#define LP_GPIO_REG_GPIO_PIN6_INT_TYPE_M  (LP_GPIO_REG_GPIO_PIN6_INT_TYPE_V << LP_GPIO_REG_GPIO_PIN6_INT_TYPE_S)
#define LP_GPIO_REG_GPIO_PIN6_INT_TYPE_V  0x00000007U
#define LP_GPIO_REG_GPIO_PIN6_INT_TYPE_S  1
/** LP_GPIO_REG_GPIO_PIN6_PAD_DRIVER : R/W; bitpos: [4]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_PIN6_PAD_DRIVER    (BIT(4))
#define LP_GPIO_REG_GPIO_PIN6_PAD_DRIVER_M  (LP_GPIO_REG_GPIO_PIN6_PAD_DRIVER_V << LP_GPIO_REG_GPIO_PIN6_PAD_DRIVER_S)
#define LP_GPIO_REG_GPIO_PIN6_PAD_DRIVER_V  0x00000001U
#define LP_GPIO_REG_GPIO_PIN6_PAD_DRIVER_S  4
/** LP_GPIO_REG_GPI6_PIN0_EDGE_WAKEUP_CLR : WT; bitpos: [5]; default: 0;
 *  need des
 */
#define LP_GPIO_REG_GPI6_PIN0_EDGE_WAKEUP_CLR    (BIT(5))
#define LP_GPIO_REG_GPI6_PIN0_EDGE_WAKEUP_CLR_M  (LP_GPIO_REG_GPI6_PIN0_EDGE_WAKEUP_CLR_V << LP_GPIO_REG_GPI6_PIN0_EDGE_WAKEUP_CLR_S)
#define LP_GPIO_REG_GPI6_PIN0_EDGE_WAKEUP_CLR_V  0x00000001U
#define LP_GPIO_REG_GPI6_PIN0_EDGE_WAKEUP_CLR_S  5

/** LP_GPIO_PIN7_REG register
 *  Reserved
 */
#define LP_GPIO_PIN7_REG (DR_REG_LP_GPIO_BASE + 0x50)
/** LP_GPIO_REG_GPIO_PIN7_WAKEUP_ENABLE : R/W; bitpos: [0]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_PIN7_WAKEUP_ENABLE    (BIT(0))
#define LP_GPIO_REG_GPIO_PIN7_WAKEUP_ENABLE_M  (LP_GPIO_REG_GPIO_PIN7_WAKEUP_ENABLE_V << LP_GPIO_REG_GPIO_PIN7_WAKEUP_ENABLE_S)
#define LP_GPIO_REG_GPIO_PIN7_WAKEUP_ENABLE_V  0x00000001U
#define LP_GPIO_REG_GPIO_PIN7_WAKEUP_ENABLE_S  0
/** LP_GPIO_REG_GPIO_PIN7_INT_TYPE : R/W; bitpos: [3:1]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_PIN7_INT_TYPE    0x00000007U
#define LP_GPIO_REG_GPIO_PIN7_INT_TYPE_M  (LP_GPIO_REG_GPIO_PIN7_INT_TYPE_V << LP_GPIO_REG_GPIO_PIN7_INT_TYPE_S)
#define LP_GPIO_REG_GPIO_PIN7_INT_TYPE_V  0x00000007U
#define LP_GPIO_REG_GPIO_PIN7_INT_TYPE_S  1
/** LP_GPIO_REG_GPIO_PIN7_PAD_DRIVER : R/W; bitpos: [4]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_PIN7_PAD_DRIVER    (BIT(4))
#define LP_GPIO_REG_GPIO_PIN7_PAD_DRIVER_M  (LP_GPIO_REG_GPIO_PIN7_PAD_DRIVER_V << LP_GPIO_REG_GPIO_PIN7_PAD_DRIVER_S)
#define LP_GPIO_REG_GPIO_PIN7_PAD_DRIVER_V  0x00000001U
#define LP_GPIO_REG_GPIO_PIN7_PAD_DRIVER_S  4
/** LP_GPIO_REG_GPI7_PIN0_EDGE_WAKEUP_CLR : WT; bitpos: [5]; default: 0;
 *  need des
 */
#define LP_GPIO_REG_GPI7_PIN0_EDGE_WAKEUP_CLR    (BIT(5))
#define LP_GPIO_REG_GPI7_PIN0_EDGE_WAKEUP_CLR_M  (LP_GPIO_REG_GPI7_PIN0_EDGE_WAKEUP_CLR_V << LP_GPIO_REG_GPI7_PIN0_EDGE_WAKEUP_CLR_S)
#define LP_GPIO_REG_GPI7_PIN0_EDGE_WAKEUP_CLR_V  0x00000001U
#define LP_GPIO_REG_GPI7_PIN0_EDGE_WAKEUP_CLR_S  5

/** LP_GPIO_PIN8_REG register
 *  Reserved
 */
#define LP_GPIO_PIN8_REG (DR_REG_LP_GPIO_BASE + 0x54)
/** LP_GPIO_REG_GPIO_PIN8_WAKEUP_ENABLE : R/W; bitpos: [0]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_PIN8_WAKEUP_ENABLE    (BIT(0))
#define LP_GPIO_REG_GPIO_PIN8_WAKEUP_ENABLE_M  (LP_GPIO_REG_GPIO_PIN8_WAKEUP_ENABLE_V << LP_GPIO_REG_GPIO_PIN8_WAKEUP_ENABLE_S)
#define LP_GPIO_REG_GPIO_PIN8_WAKEUP_ENABLE_V  0x00000001U
#define LP_GPIO_REG_GPIO_PIN8_WAKEUP_ENABLE_S  0
/** LP_GPIO_REG_GPIO_PIN8_INT_TYPE : R/W; bitpos: [3:1]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_PIN8_INT_TYPE    0x00000007U
#define LP_GPIO_REG_GPIO_PIN8_INT_TYPE_M  (LP_GPIO_REG_GPIO_PIN8_INT_TYPE_V << LP_GPIO_REG_GPIO_PIN8_INT_TYPE_S)
#define LP_GPIO_REG_GPIO_PIN8_INT_TYPE_V  0x00000007U
#define LP_GPIO_REG_GPIO_PIN8_INT_TYPE_S  1
/** LP_GPIO_REG_GPIO_PIN8_PAD_DRIVER : R/W; bitpos: [4]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_PIN8_PAD_DRIVER    (BIT(4))
#define LP_GPIO_REG_GPIO_PIN8_PAD_DRIVER_M  (LP_GPIO_REG_GPIO_PIN8_PAD_DRIVER_V << LP_GPIO_REG_GPIO_PIN8_PAD_DRIVER_S)
#define LP_GPIO_REG_GPIO_PIN8_PAD_DRIVER_V  0x00000001U
#define LP_GPIO_REG_GPIO_PIN8_PAD_DRIVER_S  4
/** LP_GPIO_REG_GPI8_PIN0_EDGE_WAKEUP_CLR : WT; bitpos: [5]; default: 0;
 *  need des
 */
#define LP_GPIO_REG_GPI8_PIN0_EDGE_WAKEUP_CLR    (BIT(5))
#define LP_GPIO_REG_GPI8_PIN0_EDGE_WAKEUP_CLR_M  (LP_GPIO_REG_GPI8_PIN0_EDGE_WAKEUP_CLR_V << LP_GPIO_REG_GPI8_PIN0_EDGE_WAKEUP_CLR_S)
#define LP_GPIO_REG_GPI8_PIN0_EDGE_WAKEUP_CLR_V  0x00000001U
#define LP_GPIO_REG_GPI8_PIN0_EDGE_WAKEUP_CLR_S  5

/** LP_GPIO_PIN9_REG register
 *  Reserved
 */
#define LP_GPIO_PIN9_REG (DR_REG_LP_GPIO_BASE + 0x58)
/** LP_GPIO_REG_GPIO_PIN9_WAKEUP_ENABLE : R/W; bitpos: [0]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_PIN9_WAKEUP_ENABLE    (BIT(0))
#define LP_GPIO_REG_GPIO_PIN9_WAKEUP_ENABLE_M  (LP_GPIO_REG_GPIO_PIN9_WAKEUP_ENABLE_V << LP_GPIO_REG_GPIO_PIN9_WAKEUP_ENABLE_S)
#define LP_GPIO_REG_GPIO_PIN9_WAKEUP_ENABLE_V  0x00000001U
#define LP_GPIO_REG_GPIO_PIN9_WAKEUP_ENABLE_S  0
/** LP_GPIO_REG_GPIO_PIN9_INT_TYPE : R/W; bitpos: [3:1]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_PIN9_INT_TYPE    0x00000007U
#define LP_GPIO_REG_GPIO_PIN9_INT_TYPE_M  (LP_GPIO_REG_GPIO_PIN9_INT_TYPE_V << LP_GPIO_REG_GPIO_PIN9_INT_TYPE_S)
#define LP_GPIO_REG_GPIO_PIN9_INT_TYPE_V  0x00000007U
#define LP_GPIO_REG_GPIO_PIN9_INT_TYPE_S  1
/** LP_GPIO_REG_GPIO_PIN9_PAD_DRIVER : R/W; bitpos: [4]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_PIN9_PAD_DRIVER    (BIT(4))
#define LP_GPIO_REG_GPIO_PIN9_PAD_DRIVER_M  (LP_GPIO_REG_GPIO_PIN9_PAD_DRIVER_V << LP_GPIO_REG_GPIO_PIN9_PAD_DRIVER_S)
#define LP_GPIO_REG_GPIO_PIN9_PAD_DRIVER_V  0x00000001U
#define LP_GPIO_REG_GPIO_PIN9_PAD_DRIVER_S  4
/** LP_GPIO_REG_GPI9_PIN0_EDGE_WAKEUP_CLR : WT; bitpos: [5]; default: 0;
 *  need des
 */
#define LP_GPIO_REG_GPI9_PIN0_EDGE_WAKEUP_CLR    (BIT(5))
#define LP_GPIO_REG_GPI9_PIN0_EDGE_WAKEUP_CLR_M  (LP_GPIO_REG_GPI9_PIN0_EDGE_WAKEUP_CLR_V << LP_GPIO_REG_GPI9_PIN0_EDGE_WAKEUP_CLR_S)
#define LP_GPIO_REG_GPI9_PIN0_EDGE_WAKEUP_CLR_V  0x00000001U
#define LP_GPIO_REG_GPI9_PIN0_EDGE_WAKEUP_CLR_S  5

/** LP_GPIO_PIN10_REG register
 *  Reserved
 */
#define LP_GPIO_PIN10_REG (DR_REG_LP_GPIO_BASE + 0x5c)
/** LP_GPIO_REG_GPIO_PIN10_WAKEUP_ENABLE : R/W; bitpos: [0]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_PIN10_WAKEUP_ENABLE    (BIT(0))
#define LP_GPIO_REG_GPIO_PIN10_WAKEUP_ENABLE_M  (LP_GPIO_REG_GPIO_PIN10_WAKEUP_ENABLE_V << LP_GPIO_REG_GPIO_PIN10_WAKEUP_ENABLE_S)
#define LP_GPIO_REG_GPIO_PIN10_WAKEUP_ENABLE_V  0x00000001U
#define LP_GPIO_REG_GPIO_PIN10_WAKEUP_ENABLE_S  0
/** LP_GPIO_REG_GPIO_PIN10_INT_TYPE : R/W; bitpos: [3:1]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_PIN10_INT_TYPE    0x00000007U
#define LP_GPIO_REG_GPIO_PIN10_INT_TYPE_M  (LP_GPIO_REG_GPIO_PIN10_INT_TYPE_V << LP_GPIO_REG_GPIO_PIN10_INT_TYPE_S)
#define LP_GPIO_REG_GPIO_PIN10_INT_TYPE_V  0x00000007U
#define LP_GPIO_REG_GPIO_PIN10_INT_TYPE_S  1
/** LP_GPIO_REG_GPIO_PIN10_PAD_DRIVER : R/W; bitpos: [4]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_PIN10_PAD_DRIVER    (BIT(4))
#define LP_GPIO_REG_GPIO_PIN10_PAD_DRIVER_M  (LP_GPIO_REG_GPIO_PIN10_PAD_DRIVER_V << LP_GPIO_REG_GPIO_PIN10_PAD_DRIVER_S)
#define LP_GPIO_REG_GPIO_PIN10_PAD_DRIVER_V  0x00000001U
#define LP_GPIO_REG_GPIO_PIN10_PAD_DRIVER_S  4
/** LP_GPIO_REG_GPI10_PIN0_EDGE_WAKEUP_CLR : WT; bitpos: [5]; default: 0;
 *  need des
 */
#define LP_GPIO_REG_GPI10_PIN0_EDGE_WAKEUP_CLR    (BIT(5))
#define LP_GPIO_REG_GPI10_PIN0_EDGE_WAKEUP_CLR_M  (LP_GPIO_REG_GPI10_PIN0_EDGE_WAKEUP_CLR_V << LP_GPIO_REG_GPI10_PIN0_EDGE_WAKEUP_CLR_S)
#define LP_GPIO_REG_GPI10_PIN0_EDGE_WAKEUP_CLR_V  0x00000001U
#define LP_GPIO_REG_GPI10_PIN0_EDGE_WAKEUP_CLR_S  5

/** LP_GPIO_PIN11_REG register
 *  Reserved
 */
#define LP_GPIO_PIN11_REG (DR_REG_LP_GPIO_BASE + 0x60)
/** LP_GPIO_REG_GPIO_PIN11_WAKEUP_ENABLE : R/W; bitpos: [0]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_PIN11_WAKEUP_ENABLE    (BIT(0))
#define LP_GPIO_REG_GPIO_PIN11_WAKEUP_ENABLE_M  (LP_GPIO_REG_GPIO_PIN11_WAKEUP_ENABLE_V << LP_GPIO_REG_GPIO_PIN11_WAKEUP_ENABLE_S)
#define LP_GPIO_REG_GPIO_PIN11_WAKEUP_ENABLE_V  0x00000001U
#define LP_GPIO_REG_GPIO_PIN11_WAKEUP_ENABLE_S  0
/** LP_GPIO_REG_GPIO_PIN11_INT_TYPE : R/W; bitpos: [3:1]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_PIN11_INT_TYPE    0x00000007U
#define LP_GPIO_REG_GPIO_PIN11_INT_TYPE_M  (LP_GPIO_REG_GPIO_PIN11_INT_TYPE_V << LP_GPIO_REG_GPIO_PIN11_INT_TYPE_S)
#define LP_GPIO_REG_GPIO_PIN11_INT_TYPE_V  0x00000007U
#define LP_GPIO_REG_GPIO_PIN11_INT_TYPE_S  1
/** LP_GPIO_REG_GPIO_PIN11_PAD_DRIVER : R/W; bitpos: [4]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_PIN11_PAD_DRIVER    (BIT(4))
#define LP_GPIO_REG_GPIO_PIN11_PAD_DRIVER_M  (LP_GPIO_REG_GPIO_PIN11_PAD_DRIVER_V << LP_GPIO_REG_GPIO_PIN11_PAD_DRIVER_S)
#define LP_GPIO_REG_GPIO_PIN11_PAD_DRIVER_V  0x00000001U
#define LP_GPIO_REG_GPIO_PIN11_PAD_DRIVER_S  4
/** LP_GPIO_REG_GPI11_PIN0_EDGE_WAKEUP_CLR : WT; bitpos: [5]; default: 0;
 *  need des
 */
#define LP_GPIO_REG_GPI11_PIN0_EDGE_WAKEUP_CLR    (BIT(5))
#define LP_GPIO_REG_GPI11_PIN0_EDGE_WAKEUP_CLR_M  (LP_GPIO_REG_GPI11_PIN0_EDGE_WAKEUP_CLR_V << LP_GPIO_REG_GPI11_PIN0_EDGE_WAKEUP_CLR_S)
#define LP_GPIO_REG_GPI11_PIN0_EDGE_WAKEUP_CLR_V  0x00000001U
#define LP_GPIO_REG_GPI11_PIN0_EDGE_WAKEUP_CLR_S  5

/** LP_GPIO_PIN12_REG register
 *  Reserved
 */
#define LP_GPIO_PIN12_REG (DR_REG_LP_GPIO_BASE + 0x64)
/** LP_GPIO_REG_GPIO_PIN12_WAKEUP_ENABLE : R/W; bitpos: [0]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_PIN12_WAKEUP_ENABLE    (BIT(0))
#define LP_GPIO_REG_GPIO_PIN12_WAKEUP_ENABLE_M  (LP_GPIO_REG_GPIO_PIN12_WAKEUP_ENABLE_V << LP_GPIO_REG_GPIO_PIN12_WAKEUP_ENABLE_S)
#define LP_GPIO_REG_GPIO_PIN12_WAKEUP_ENABLE_V  0x00000001U
#define LP_GPIO_REG_GPIO_PIN12_WAKEUP_ENABLE_S  0
/** LP_GPIO_REG_GPIO_PIN12_INT_TYPE : R/W; bitpos: [3:1]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_PIN12_INT_TYPE    0x00000007U
#define LP_GPIO_REG_GPIO_PIN12_INT_TYPE_M  (LP_GPIO_REG_GPIO_PIN12_INT_TYPE_V << LP_GPIO_REG_GPIO_PIN12_INT_TYPE_S)
#define LP_GPIO_REG_GPIO_PIN12_INT_TYPE_V  0x00000007U
#define LP_GPIO_REG_GPIO_PIN12_INT_TYPE_S  1
/** LP_GPIO_REG_GPIO_PIN12_PAD_DRIVER : R/W; bitpos: [4]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_PIN12_PAD_DRIVER    (BIT(4))
#define LP_GPIO_REG_GPIO_PIN12_PAD_DRIVER_M  (LP_GPIO_REG_GPIO_PIN12_PAD_DRIVER_V << LP_GPIO_REG_GPIO_PIN12_PAD_DRIVER_S)
#define LP_GPIO_REG_GPIO_PIN12_PAD_DRIVER_V  0x00000001U
#define LP_GPIO_REG_GPIO_PIN12_PAD_DRIVER_S  4
/** LP_GPIO_REG_GPI12_PIN0_EDGE_WAKEUP_CLR : WT; bitpos: [5]; default: 0;
 *  need des
 */
#define LP_GPIO_REG_GPI12_PIN0_EDGE_WAKEUP_CLR    (BIT(5))
#define LP_GPIO_REG_GPI12_PIN0_EDGE_WAKEUP_CLR_M  (LP_GPIO_REG_GPI12_PIN0_EDGE_WAKEUP_CLR_V << LP_GPIO_REG_GPI12_PIN0_EDGE_WAKEUP_CLR_S)
#define LP_GPIO_REG_GPI12_PIN0_EDGE_WAKEUP_CLR_V  0x00000001U
#define LP_GPIO_REG_GPI12_PIN0_EDGE_WAKEUP_CLR_S  5

/** LP_GPIO_PIN13_REG register
 *  Reserved
 */
#define LP_GPIO_PIN13_REG (DR_REG_LP_GPIO_BASE + 0x68)
/** LP_GPIO_REG_GPIO_PIN13_WAKEUP_ENABLE : R/W; bitpos: [0]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_PIN13_WAKEUP_ENABLE    (BIT(0))
#define LP_GPIO_REG_GPIO_PIN13_WAKEUP_ENABLE_M  (LP_GPIO_REG_GPIO_PIN13_WAKEUP_ENABLE_V << LP_GPIO_REG_GPIO_PIN13_WAKEUP_ENABLE_S)
#define LP_GPIO_REG_GPIO_PIN13_WAKEUP_ENABLE_V  0x00000001U
#define LP_GPIO_REG_GPIO_PIN13_WAKEUP_ENABLE_S  0
/** LP_GPIO_REG_GPIO_PIN13_INT_TYPE : R/W; bitpos: [3:1]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_PIN13_INT_TYPE    0x00000007U
#define LP_GPIO_REG_GPIO_PIN13_INT_TYPE_M  (LP_GPIO_REG_GPIO_PIN13_INT_TYPE_V << LP_GPIO_REG_GPIO_PIN13_INT_TYPE_S)
#define LP_GPIO_REG_GPIO_PIN13_INT_TYPE_V  0x00000007U
#define LP_GPIO_REG_GPIO_PIN13_INT_TYPE_S  1
/** LP_GPIO_REG_GPIO_PIN13_PAD_DRIVER : R/W; bitpos: [4]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_PIN13_PAD_DRIVER    (BIT(4))
#define LP_GPIO_REG_GPIO_PIN13_PAD_DRIVER_M  (LP_GPIO_REG_GPIO_PIN13_PAD_DRIVER_V << LP_GPIO_REG_GPIO_PIN13_PAD_DRIVER_S)
#define LP_GPIO_REG_GPIO_PIN13_PAD_DRIVER_V  0x00000001U
#define LP_GPIO_REG_GPIO_PIN13_PAD_DRIVER_S  4
/** LP_GPIO_REG_GPI13_PIN0_EDGE_WAKEUP_CLR : WT; bitpos: [5]; default: 0;
 *  need des
 */
#define LP_GPIO_REG_GPI13_PIN0_EDGE_WAKEUP_CLR    (BIT(5))
#define LP_GPIO_REG_GPI13_PIN0_EDGE_WAKEUP_CLR_M  (LP_GPIO_REG_GPI13_PIN0_EDGE_WAKEUP_CLR_V << LP_GPIO_REG_GPI13_PIN0_EDGE_WAKEUP_CLR_S)
#define LP_GPIO_REG_GPI13_PIN0_EDGE_WAKEUP_CLR_V  0x00000001U
#define LP_GPIO_REG_GPI13_PIN0_EDGE_WAKEUP_CLR_S  5

/** LP_GPIO_PIN14_REG register
 *  Reserved
 */
#define LP_GPIO_PIN14_REG (DR_REG_LP_GPIO_BASE + 0x6c)
/** LP_GPIO_REG_GPIO_PIN14_WAKEUP_ENABLE : R/W; bitpos: [0]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_PIN14_WAKEUP_ENABLE    (BIT(0))
#define LP_GPIO_REG_GPIO_PIN14_WAKEUP_ENABLE_M  (LP_GPIO_REG_GPIO_PIN14_WAKEUP_ENABLE_V << LP_GPIO_REG_GPIO_PIN14_WAKEUP_ENABLE_S)
#define LP_GPIO_REG_GPIO_PIN14_WAKEUP_ENABLE_V  0x00000001U
#define LP_GPIO_REG_GPIO_PIN14_WAKEUP_ENABLE_S  0
/** LP_GPIO_REG_GPIO_PIN14_INT_TYPE : R/W; bitpos: [3:1]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_PIN14_INT_TYPE    0x00000007U
#define LP_GPIO_REG_GPIO_PIN14_INT_TYPE_M  (LP_GPIO_REG_GPIO_PIN14_INT_TYPE_V << LP_GPIO_REG_GPIO_PIN14_INT_TYPE_S)
#define LP_GPIO_REG_GPIO_PIN14_INT_TYPE_V  0x00000007U
#define LP_GPIO_REG_GPIO_PIN14_INT_TYPE_S  1
/** LP_GPIO_REG_GPIO_PIN14_PAD_DRIVER : R/W; bitpos: [4]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_PIN14_PAD_DRIVER    (BIT(4))
#define LP_GPIO_REG_GPIO_PIN14_PAD_DRIVER_M  (LP_GPIO_REG_GPIO_PIN14_PAD_DRIVER_V << LP_GPIO_REG_GPIO_PIN14_PAD_DRIVER_S)
#define LP_GPIO_REG_GPIO_PIN14_PAD_DRIVER_V  0x00000001U
#define LP_GPIO_REG_GPIO_PIN14_PAD_DRIVER_S  4
/** LP_GPIO_REG_GPI14_PIN0_EDGE_WAKEUP_CLR : WT; bitpos: [5]; default: 0;
 *  need des
 */
#define LP_GPIO_REG_GPI14_PIN0_EDGE_WAKEUP_CLR    (BIT(5))
#define LP_GPIO_REG_GPI14_PIN0_EDGE_WAKEUP_CLR_M  (LP_GPIO_REG_GPI14_PIN0_EDGE_WAKEUP_CLR_V << LP_GPIO_REG_GPI14_PIN0_EDGE_WAKEUP_CLR_S)
#define LP_GPIO_REG_GPI14_PIN0_EDGE_WAKEUP_CLR_V  0x00000001U
#define LP_GPIO_REG_GPI14_PIN0_EDGE_WAKEUP_CLR_S  5

/** LP_GPIO_PIN15_REG register
 *  Reserved
 */
#define LP_GPIO_PIN15_REG (DR_REG_LP_GPIO_BASE + 0x70)
/** LP_GPIO_REG_GPIO_PIN15_WAKEUP_ENABLE : R/W; bitpos: [0]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_PIN15_WAKEUP_ENABLE    (BIT(0))
#define LP_GPIO_REG_GPIO_PIN15_WAKEUP_ENABLE_M  (LP_GPIO_REG_GPIO_PIN15_WAKEUP_ENABLE_V << LP_GPIO_REG_GPIO_PIN15_WAKEUP_ENABLE_S)
#define LP_GPIO_REG_GPIO_PIN15_WAKEUP_ENABLE_V  0x00000001U
#define LP_GPIO_REG_GPIO_PIN15_WAKEUP_ENABLE_S  0
/** LP_GPIO_REG_GPIO_PIN15_INT_TYPE : R/W; bitpos: [3:1]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_PIN15_INT_TYPE    0x00000007U
#define LP_GPIO_REG_GPIO_PIN15_INT_TYPE_M  (LP_GPIO_REG_GPIO_PIN15_INT_TYPE_V << LP_GPIO_REG_GPIO_PIN15_INT_TYPE_S)
#define LP_GPIO_REG_GPIO_PIN15_INT_TYPE_V  0x00000007U
#define LP_GPIO_REG_GPIO_PIN15_INT_TYPE_S  1
/** LP_GPIO_REG_GPIO_PIN15_PAD_DRIVER : R/W; bitpos: [4]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_PIN15_PAD_DRIVER    (BIT(4))
#define LP_GPIO_REG_GPIO_PIN15_PAD_DRIVER_M  (LP_GPIO_REG_GPIO_PIN15_PAD_DRIVER_V << LP_GPIO_REG_GPIO_PIN15_PAD_DRIVER_S)
#define LP_GPIO_REG_GPIO_PIN15_PAD_DRIVER_V  0x00000001U
#define LP_GPIO_REG_GPIO_PIN15_PAD_DRIVER_S  4
/** LP_GPIO_REG_GPI15_PIN0_EDGE_WAKEUP_CLR : WT; bitpos: [5]; default: 0;
 *  need des
 */
#define LP_GPIO_REG_GPI15_PIN0_EDGE_WAKEUP_CLR    (BIT(5))
#define LP_GPIO_REG_GPI15_PIN0_EDGE_WAKEUP_CLR_M  (LP_GPIO_REG_GPI15_PIN0_EDGE_WAKEUP_CLR_V << LP_GPIO_REG_GPI15_PIN0_EDGE_WAKEUP_CLR_S)
#define LP_GPIO_REG_GPI15_PIN0_EDGE_WAKEUP_CLR_V  0x00000001U
#define LP_GPIO_REG_GPI15_PIN0_EDGE_WAKEUP_CLR_S  5

/** LP_GPIO_FUNC0_IN_SEL_CFG_REG register
 *  Reserved
 */
#define LP_GPIO_FUNC0_IN_SEL_CFG_REG (DR_REG_LP_GPIO_BASE + 0x74)
/** LP_GPIO_REG_GPIO_FUNC0_IN_INV_SEL : R/W; bitpos: [0]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC0_IN_INV_SEL    (BIT(0))
#define LP_GPIO_REG_GPIO_FUNC0_IN_INV_SEL_M  (LP_GPIO_REG_GPIO_FUNC0_IN_INV_SEL_V << LP_GPIO_REG_GPIO_FUNC0_IN_INV_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC0_IN_INV_SEL_V  0x00000001U
#define LP_GPIO_REG_GPIO_FUNC0_IN_INV_SEL_S  0
/** LP_GPIO_REG_GPIO_SIG0_IN_SEL : R/W; bitpos: [1]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_SIG0_IN_SEL    (BIT(1))
#define LP_GPIO_REG_GPIO_SIG0_IN_SEL_M  (LP_GPIO_REG_GPIO_SIG0_IN_SEL_V << LP_GPIO_REG_GPIO_SIG0_IN_SEL_S)
#define LP_GPIO_REG_GPIO_SIG0_IN_SEL_V  0x00000001U
#define LP_GPIO_REG_GPIO_SIG0_IN_SEL_S  1
/** LP_GPIO_REG_GPIO_FUNC0_IN_SEL : R/W; bitpos: [7:2]; default: 48;
 *  reg_gpio_func0_in_sel[5:4]==2'b11->constant
 *  1,reg_gpio_func0_in_sel[5:4]==2'b10->constant 0
 */
#define LP_GPIO_REG_GPIO_FUNC0_IN_SEL    0x0000003FU
#define LP_GPIO_REG_GPIO_FUNC0_IN_SEL_M  (LP_GPIO_REG_GPIO_FUNC0_IN_SEL_V << LP_GPIO_REG_GPIO_FUNC0_IN_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC0_IN_SEL_V  0x0000003FU
#define LP_GPIO_REG_GPIO_FUNC0_IN_SEL_S  2

/** LP_GPIO_FUNC1_IN_SEL_CFG_REG register
 *  Reserved
 */
#define LP_GPIO_FUNC1_IN_SEL_CFG_REG (DR_REG_LP_GPIO_BASE + 0x78)
/** LP_GPIO_REG_GPIO_FUNC1_IN_INV_SEL : R/W; bitpos: [0]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC1_IN_INV_SEL    (BIT(0))
#define LP_GPIO_REG_GPIO_FUNC1_IN_INV_SEL_M  (LP_GPIO_REG_GPIO_FUNC1_IN_INV_SEL_V << LP_GPIO_REG_GPIO_FUNC1_IN_INV_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC1_IN_INV_SEL_V  0x00000001U
#define LP_GPIO_REG_GPIO_FUNC1_IN_INV_SEL_S  0
/** LP_GPIO_REG_GPIO_SIG1_IN_SEL : R/W; bitpos: [1]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_SIG1_IN_SEL    (BIT(1))
#define LP_GPIO_REG_GPIO_SIG1_IN_SEL_M  (LP_GPIO_REG_GPIO_SIG1_IN_SEL_V << LP_GPIO_REG_GPIO_SIG1_IN_SEL_S)
#define LP_GPIO_REG_GPIO_SIG1_IN_SEL_V  0x00000001U
#define LP_GPIO_REG_GPIO_SIG1_IN_SEL_S  1
/** LP_GPIO_REG_GPIO_FUNC1_IN_SEL : R/W; bitpos: [7:2]; default: 48;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC1_IN_SEL    0x0000003FU
#define LP_GPIO_REG_GPIO_FUNC1_IN_SEL_M  (LP_GPIO_REG_GPIO_FUNC1_IN_SEL_V << LP_GPIO_REG_GPIO_FUNC1_IN_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC1_IN_SEL_V  0x0000003FU
#define LP_GPIO_REG_GPIO_FUNC1_IN_SEL_S  2

/** LP_GPIO_FUNC2_IN_SEL_CFG_REG register
 *  Reserved
 */
#define LP_GPIO_FUNC2_IN_SEL_CFG_REG (DR_REG_LP_GPIO_BASE + 0x7c)
/** LP_GPIO_REG_GPIO_FUNC2_IN_INV_SEL : R/W; bitpos: [0]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC2_IN_INV_SEL    (BIT(0))
#define LP_GPIO_REG_GPIO_FUNC2_IN_INV_SEL_M  (LP_GPIO_REG_GPIO_FUNC2_IN_INV_SEL_V << LP_GPIO_REG_GPIO_FUNC2_IN_INV_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC2_IN_INV_SEL_V  0x00000001U
#define LP_GPIO_REG_GPIO_FUNC2_IN_INV_SEL_S  0
/** LP_GPIO_REG_GPIO_SIG2_IN_SEL : R/W; bitpos: [1]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_SIG2_IN_SEL    (BIT(1))
#define LP_GPIO_REG_GPIO_SIG2_IN_SEL_M  (LP_GPIO_REG_GPIO_SIG2_IN_SEL_V << LP_GPIO_REG_GPIO_SIG2_IN_SEL_S)
#define LP_GPIO_REG_GPIO_SIG2_IN_SEL_V  0x00000001U
#define LP_GPIO_REG_GPIO_SIG2_IN_SEL_S  1
/** LP_GPIO_REG_GPIO_FUNC2_IN_SEL : R/W; bitpos: [7:2]; default: 32;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC2_IN_SEL    0x0000003FU
#define LP_GPIO_REG_GPIO_FUNC2_IN_SEL_M  (LP_GPIO_REG_GPIO_FUNC2_IN_SEL_V << LP_GPIO_REG_GPIO_FUNC2_IN_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC2_IN_SEL_V  0x0000003FU
#define LP_GPIO_REG_GPIO_FUNC2_IN_SEL_S  2

/** LP_GPIO_FUNC3_IN_SEL_CFG_REG register
 *  Reserved
 */
#define LP_GPIO_FUNC3_IN_SEL_CFG_REG (DR_REG_LP_GPIO_BASE + 0x80)
/** LP_GPIO_REG_GPIO_FUNC3_IN_INV_SEL : R/W; bitpos: [0]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC3_IN_INV_SEL    (BIT(0))
#define LP_GPIO_REG_GPIO_FUNC3_IN_INV_SEL_M  (LP_GPIO_REG_GPIO_FUNC3_IN_INV_SEL_V << LP_GPIO_REG_GPIO_FUNC3_IN_INV_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC3_IN_INV_SEL_V  0x00000001U
#define LP_GPIO_REG_GPIO_FUNC3_IN_INV_SEL_S  0
/** LP_GPIO_REG_GPIO_SIG3_IN_SEL : R/W; bitpos: [1]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_SIG3_IN_SEL    (BIT(1))
#define LP_GPIO_REG_GPIO_SIG3_IN_SEL_M  (LP_GPIO_REG_GPIO_SIG3_IN_SEL_V << LP_GPIO_REG_GPIO_SIG3_IN_SEL_S)
#define LP_GPIO_REG_GPIO_SIG3_IN_SEL_V  0x00000001U
#define LP_GPIO_REG_GPIO_SIG3_IN_SEL_S  1
/** LP_GPIO_REG_GPIO_FUNC3_IN_SEL : R/W; bitpos: [7:2]; default: 48;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC3_IN_SEL    0x0000003FU
#define LP_GPIO_REG_GPIO_FUNC3_IN_SEL_M  (LP_GPIO_REG_GPIO_FUNC3_IN_SEL_V << LP_GPIO_REG_GPIO_FUNC3_IN_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC3_IN_SEL_V  0x0000003FU
#define LP_GPIO_REG_GPIO_FUNC3_IN_SEL_S  2

/** LP_GPIO_FUNC4_IN_SEL_CFG_REG register
 *  Reserved
 */
#define LP_GPIO_FUNC4_IN_SEL_CFG_REG (DR_REG_LP_GPIO_BASE + 0x84)
/** LP_GPIO_REG_GPIO_FUNC4_IN_INV_SEL : R/W; bitpos: [0]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC4_IN_INV_SEL    (BIT(0))
#define LP_GPIO_REG_GPIO_FUNC4_IN_INV_SEL_M  (LP_GPIO_REG_GPIO_FUNC4_IN_INV_SEL_V << LP_GPIO_REG_GPIO_FUNC4_IN_INV_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC4_IN_INV_SEL_V  0x00000001U
#define LP_GPIO_REG_GPIO_FUNC4_IN_INV_SEL_S  0
/** LP_GPIO_REG_GPIO_SIG4_IN_SEL : R/W; bitpos: [1]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_SIG4_IN_SEL    (BIT(1))
#define LP_GPIO_REG_GPIO_SIG4_IN_SEL_M  (LP_GPIO_REG_GPIO_SIG4_IN_SEL_V << LP_GPIO_REG_GPIO_SIG4_IN_SEL_S)
#define LP_GPIO_REG_GPIO_SIG4_IN_SEL_V  0x00000001U
#define LP_GPIO_REG_GPIO_SIG4_IN_SEL_S  1
/** LP_GPIO_REG_GPIO_FUNC4_IN_SEL : R/W; bitpos: [7:2]; default: 48;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC4_IN_SEL    0x0000003FU
#define LP_GPIO_REG_GPIO_FUNC4_IN_SEL_M  (LP_GPIO_REG_GPIO_FUNC4_IN_SEL_V << LP_GPIO_REG_GPIO_FUNC4_IN_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC4_IN_SEL_V  0x0000003FU
#define LP_GPIO_REG_GPIO_FUNC4_IN_SEL_S  2

/** LP_GPIO_FUNC5_IN_SEL_CFG_REG register
 *  Reserved
 */
#define LP_GPIO_FUNC5_IN_SEL_CFG_REG (DR_REG_LP_GPIO_BASE + 0x88)
/** LP_GPIO_REG_GPIO_FUNC5_IN_INV_SEL : R/W; bitpos: [0]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC5_IN_INV_SEL    (BIT(0))
#define LP_GPIO_REG_GPIO_FUNC5_IN_INV_SEL_M  (LP_GPIO_REG_GPIO_FUNC5_IN_INV_SEL_V << LP_GPIO_REG_GPIO_FUNC5_IN_INV_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC5_IN_INV_SEL_V  0x00000001U
#define LP_GPIO_REG_GPIO_FUNC5_IN_INV_SEL_S  0
/** LP_GPIO_REG_GPIO_SIG5_IN_SEL : R/W; bitpos: [1]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_SIG5_IN_SEL    (BIT(1))
#define LP_GPIO_REG_GPIO_SIG5_IN_SEL_M  (LP_GPIO_REG_GPIO_SIG5_IN_SEL_V << LP_GPIO_REG_GPIO_SIG5_IN_SEL_S)
#define LP_GPIO_REG_GPIO_SIG5_IN_SEL_V  0x00000001U
#define LP_GPIO_REG_GPIO_SIG5_IN_SEL_S  1
/** LP_GPIO_REG_GPIO_FUNC5_IN_SEL : R/W; bitpos: [7:2]; default: 32;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC5_IN_SEL    0x0000003FU
#define LP_GPIO_REG_GPIO_FUNC5_IN_SEL_M  (LP_GPIO_REG_GPIO_FUNC5_IN_SEL_V << LP_GPIO_REG_GPIO_FUNC5_IN_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC5_IN_SEL_V  0x0000003FU
#define LP_GPIO_REG_GPIO_FUNC5_IN_SEL_S  2

/** LP_GPIO_FUNC6_IN_SEL_CFG_REG register
 *  Reserved
 */
#define LP_GPIO_FUNC6_IN_SEL_CFG_REG (DR_REG_LP_GPIO_BASE + 0x8c)
/** LP_GPIO_REG_GPIO_FUNC6_IN_INV_SEL : R/W; bitpos: [0]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC6_IN_INV_SEL    (BIT(0))
#define LP_GPIO_REG_GPIO_FUNC6_IN_INV_SEL_M  (LP_GPIO_REG_GPIO_FUNC6_IN_INV_SEL_V << LP_GPIO_REG_GPIO_FUNC6_IN_INV_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC6_IN_INV_SEL_V  0x00000001U
#define LP_GPIO_REG_GPIO_FUNC6_IN_INV_SEL_S  0
/** LP_GPIO_REG_GPIO_SIG6_IN_SEL : R/W; bitpos: [1]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_SIG6_IN_SEL    (BIT(1))
#define LP_GPIO_REG_GPIO_SIG6_IN_SEL_M  (LP_GPIO_REG_GPIO_SIG6_IN_SEL_V << LP_GPIO_REG_GPIO_SIG6_IN_SEL_S)
#define LP_GPIO_REG_GPIO_SIG6_IN_SEL_V  0x00000001U
#define LP_GPIO_REG_GPIO_SIG6_IN_SEL_S  1
/** LP_GPIO_REG_GPIO_FUNC6_IN_SEL : R/W; bitpos: [7:2]; default: 32;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC6_IN_SEL    0x0000003FU
#define LP_GPIO_REG_GPIO_FUNC6_IN_SEL_M  (LP_GPIO_REG_GPIO_FUNC6_IN_SEL_V << LP_GPIO_REG_GPIO_FUNC6_IN_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC6_IN_SEL_V  0x0000003FU
#define LP_GPIO_REG_GPIO_FUNC6_IN_SEL_S  2

/** LP_GPIO_FUNC7_IN_SEL_CFG_REG register
 *  Reserved
 */
#define LP_GPIO_FUNC7_IN_SEL_CFG_REG (DR_REG_LP_GPIO_BASE + 0x90)
/** LP_GPIO_REG_GPIO_FUNC7_IN_INV_SEL : R/W; bitpos: [0]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC7_IN_INV_SEL    (BIT(0))
#define LP_GPIO_REG_GPIO_FUNC7_IN_INV_SEL_M  (LP_GPIO_REG_GPIO_FUNC7_IN_INV_SEL_V << LP_GPIO_REG_GPIO_FUNC7_IN_INV_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC7_IN_INV_SEL_V  0x00000001U
#define LP_GPIO_REG_GPIO_FUNC7_IN_INV_SEL_S  0
/** LP_GPIO_REG_GPIO_SIG7_IN_SEL : R/W; bitpos: [1]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_SIG7_IN_SEL    (BIT(1))
#define LP_GPIO_REG_GPIO_SIG7_IN_SEL_M  (LP_GPIO_REG_GPIO_SIG7_IN_SEL_V << LP_GPIO_REG_GPIO_SIG7_IN_SEL_S)
#define LP_GPIO_REG_GPIO_SIG7_IN_SEL_V  0x00000001U
#define LP_GPIO_REG_GPIO_SIG7_IN_SEL_S  1
/** LP_GPIO_REG_GPIO_FUNC7_IN_SEL : R/W; bitpos: [7:2]; default: 32;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC7_IN_SEL    0x0000003FU
#define LP_GPIO_REG_GPIO_FUNC7_IN_SEL_M  (LP_GPIO_REG_GPIO_FUNC7_IN_SEL_V << LP_GPIO_REG_GPIO_FUNC7_IN_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC7_IN_SEL_V  0x0000003FU
#define LP_GPIO_REG_GPIO_FUNC7_IN_SEL_S  2

/** LP_GPIO_FUNC8_IN_SEL_CFG_REG register
 *  Reserved
 */
#define LP_GPIO_FUNC8_IN_SEL_CFG_REG (DR_REG_LP_GPIO_BASE + 0x94)
/** LP_GPIO_REG_GPIO_FUNC8_IN_INV_SEL : R/W; bitpos: [0]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC8_IN_INV_SEL    (BIT(0))
#define LP_GPIO_REG_GPIO_FUNC8_IN_INV_SEL_M  (LP_GPIO_REG_GPIO_FUNC8_IN_INV_SEL_V << LP_GPIO_REG_GPIO_FUNC8_IN_INV_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC8_IN_INV_SEL_V  0x00000001U
#define LP_GPIO_REG_GPIO_FUNC8_IN_INV_SEL_S  0
/** LP_GPIO_REG_GPIO_SIG8_IN_SEL : R/W; bitpos: [1]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_SIG8_IN_SEL    (BIT(1))
#define LP_GPIO_REG_GPIO_SIG8_IN_SEL_M  (LP_GPIO_REG_GPIO_SIG8_IN_SEL_V << LP_GPIO_REG_GPIO_SIG8_IN_SEL_S)
#define LP_GPIO_REG_GPIO_SIG8_IN_SEL_V  0x00000001U
#define LP_GPIO_REG_GPIO_SIG8_IN_SEL_S  1
/** LP_GPIO_REG_GPIO_FUNC8_IN_SEL : R/W; bitpos: [7:2]; default: 32;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC8_IN_SEL    0x0000003FU
#define LP_GPIO_REG_GPIO_FUNC8_IN_SEL_M  (LP_GPIO_REG_GPIO_FUNC8_IN_SEL_V << LP_GPIO_REG_GPIO_FUNC8_IN_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC8_IN_SEL_V  0x0000003FU
#define LP_GPIO_REG_GPIO_FUNC8_IN_SEL_S  2

/** LP_GPIO_FUNC9_IN_SEL_CFG_REG register
 *  Reserved
 */
#define LP_GPIO_FUNC9_IN_SEL_CFG_REG (DR_REG_LP_GPIO_BASE + 0x98)
/** LP_GPIO_REG_GPIO_FUNC9_IN_INV_SEL : R/W; bitpos: [0]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC9_IN_INV_SEL    (BIT(0))
#define LP_GPIO_REG_GPIO_FUNC9_IN_INV_SEL_M  (LP_GPIO_REG_GPIO_FUNC9_IN_INV_SEL_V << LP_GPIO_REG_GPIO_FUNC9_IN_INV_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC9_IN_INV_SEL_V  0x00000001U
#define LP_GPIO_REG_GPIO_FUNC9_IN_INV_SEL_S  0
/** LP_GPIO_REG_GPIO_SIG9_IN_SEL : R/W; bitpos: [1]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_SIG9_IN_SEL    (BIT(1))
#define LP_GPIO_REG_GPIO_SIG9_IN_SEL_M  (LP_GPIO_REG_GPIO_SIG9_IN_SEL_V << LP_GPIO_REG_GPIO_SIG9_IN_SEL_S)
#define LP_GPIO_REG_GPIO_SIG9_IN_SEL_V  0x00000001U
#define LP_GPIO_REG_GPIO_SIG9_IN_SEL_S  1
/** LP_GPIO_REG_GPIO_FUNC9_IN_SEL : R/W; bitpos: [7:2]; default: 32;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC9_IN_SEL    0x0000003FU
#define LP_GPIO_REG_GPIO_FUNC9_IN_SEL_M  (LP_GPIO_REG_GPIO_FUNC9_IN_SEL_V << LP_GPIO_REG_GPIO_FUNC9_IN_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC9_IN_SEL_V  0x0000003FU
#define LP_GPIO_REG_GPIO_FUNC9_IN_SEL_S  2

/** LP_GPIO_FUNC10_IN_SEL_CFG_REG register
 *  Reserved
 */
#define LP_GPIO_FUNC10_IN_SEL_CFG_REG (DR_REG_LP_GPIO_BASE + 0x9c)
/** LP_GPIO_REG_GPIO_FUNC10_IN_INV_SEL : R/W; bitpos: [0]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC10_IN_INV_SEL    (BIT(0))
#define LP_GPIO_REG_GPIO_FUNC10_IN_INV_SEL_M  (LP_GPIO_REG_GPIO_FUNC10_IN_INV_SEL_V << LP_GPIO_REG_GPIO_FUNC10_IN_INV_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC10_IN_INV_SEL_V  0x00000001U
#define LP_GPIO_REG_GPIO_FUNC10_IN_INV_SEL_S  0
/** LP_GPIO_REG_GPIO_SIG10_IN_SEL : R/W; bitpos: [1]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_SIG10_IN_SEL    (BIT(1))
#define LP_GPIO_REG_GPIO_SIG10_IN_SEL_M  (LP_GPIO_REG_GPIO_SIG10_IN_SEL_V << LP_GPIO_REG_GPIO_SIG10_IN_SEL_S)
#define LP_GPIO_REG_GPIO_SIG10_IN_SEL_V  0x00000001U
#define LP_GPIO_REG_GPIO_SIG10_IN_SEL_S  1
/** LP_GPIO_REG_GPIO_FUNC10_IN_SEL : R/W; bitpos: [7:2]; default: 32;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC10_IN_SEL    0x0000003FU
#define LP_GPIO_REG_GPIO_FUNC10_IN_SEL_M  (LP_GPIO_REG_GPIO_FUNC10_IN_SEL_V << LP_GPIO_REG_GPIO_FUNC10_IN_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC10_IN_SEL_V  0x0000003FU
#define LP_GPIO_REG_GPIO_FUNC10_IN_SEL_S  2

/** LP_GPIO_FUNC11_IN_SEL_CFG_REG register
 *  Reserved
 */
#define LP_GPIO_FUNC11_IN_SEL_CFG_REG (DR_REG_LP_GPIO_BASE + 0xa0)
/** LP_GPIO_REG_GPIO_FUNC11_IN_INV_SEL : R/W; bitpos: [0]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC11_IN_INV_SEL    (BIT(0))
#define LP_GPIO_REG_GPIO_FUNC11_IN_INV_SEL_M  (LP_GPIO_REG_GPIO_FUNC11_IN_INV_SEL_V << LP_GPIO_REG_GPIO_FUNC11_IN_INV_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC11_IN_INV_SEL_V  0x00000001U
#define LP_GPIO_REG_GPIO_FUNC11_IN_INV_SEL_S  0
/** LP_GPIO_REG_GPIO_SIG11_IN_SEL : R/W; bitpos: [1]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_SIG11_IN_SEL    (BIT(1))
#define LP_GPIO_REG_GPIO_SIG11_IN_SEL_M  (LP_GPIO_REG_GPIO_SIG11_IN_SEL_V << LP_GPIO_REG_GPIO_SIG11_IN_SEL_S)
#define LP_GPIO_REG_GPIO_SIG11_IN_SEL_V  0x00000001U
#define LP_GPIO_REG_GPIO_SIG11_IN_SEL_S  1
/** LP_GPIO_REG_GPIO_FUNC11_IN_SEL : R/W; bitpos: [7:2]; default: 32;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC11_IN_SEL    0x0000003FU
#define LP_GPIO_REG_GPIO_FUNC11_IN_SEL_M  (LP_GPIO_REG_GPIO_FUNC11_IN_SEL_V << LP_GPIO_REG_GPIO_FUNC11_IN_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC11_IN_SEL_V  0x0000003FU
#define LP_GPIO_REG_GPIO_FUNC11_IN_SEL_S  2

/** LP_GPIO_FUNC12_IN_SEL_CFG_REG register
 *  Reserved
 */
#define LP_GPIO_FUNC12_IN_SEL_CFG_REG (DR_REG_LP_GPIO_BASE + 0xa4)
/** LP_GPIO_REG_GPIO_FUNC12_IN_INV_SEL : R/W; bitpos: [0]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC12_IN_INV_SEL    (BIT(0))
#define LP_GPIO_REG_GPIO_FUNC12_IN_INV_SEL_M  (LP_GPIO_REG_GPIO_FUNC12_IN_INV_SEL_V << LP_GPIO_REG_GPIO_FUNC12_IN_INV_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC12_IN_INV_SEL_V  0x00000001U
#define LP_GPIO_REG_GPIO_FUNC12_IN_INV_SEL_S  0
/** LP_GPIO_REG_GPIO_SIG12_IN_SEL : R/W; bitpos: [1]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_SIG12_IN_SEL    (BIT(1))
#define LP_GPIO_REG_GPIO_SIG12_IN_SEL_M  (LP_GPIO_REG_GPIO_SIG12_IN_SEL_V << LP_GPIO_REG_GPIO_SIG12_IN_SEL_S)
#define LP_GPIO_REG_GPIO_SIG12_IN_SEL_V  0x00000001U
#define LP_GPIO_REG_GPIO_SIG12_IN_SEL_S  1
/** LP_GPIO_REG_GPIO_FUNC12_IN_SEL : R/W; bitpos: [7:2]; default: 32;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC12_IN_SEL    0x0000003FU
#define LP_GPIO_REG_GPIO_FUNC12_IN_SEL_M  (LP_GPIO_REG_GPIO_FUNC12_IN_SEL_V << LP_GPIO_REG_GPIO_FUNC12_IN_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC12_IN_SEL_V  0x0000003FU
#define LP_GPIO_REG_GPIO_FUNC12_IN_SEL_S  2

/** LP_GPIO_FUNC13_IN_SEL_CFG_REG register
 *  Reserved
 */
#define LP_GPIO_FUNC13_IN_SEL_CFG_REG (DR_REG_LP_GPIO_BASE + 0xa8)
/** LP_GPIO_REG_GPIO_FUNC13_IN_INV_SEL : R/W; bitpos: [0]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC13_IN_INV_SEL    (BIT(0))
#define LP_GPIO_REG_GPIO_FUNC13_IN_INV_SEL_M  (LP_GPIO_REG_GPIO_FUNC13_IN_INV_SEL_V << LP_GPIO_REG_GPIO_FUNC13_IN_INV_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC13_IN_INV_SEL_V  0x00000001U
#define LP_GPIO_REG_GPIO_FUNC13_IN_INV_SEL_S  0
/** LP_GPIO_REG_GPIO_SIG13_IN_SEL : R/W; bitpos: [1]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_SIG13_IN_SEL    (BIT(1))
#define LP_GPIO_REG_GPIO_SIG13_IN_SEL_M  (LP_GPIO_REG_GPIO_SIG13_IN_SEL_V << LP_GPIO_REG_GPIO_SIG13_IN_SEL_S)
#define LP_GPIO_REG_GPIO_SIG13_IN_SEL_V  0x00000001U
#define LP_GPIO_REG_GPIO_SIG13_IN_SEL_S  1
/** LP_GPIO_REG_GPIO_FUNC13_IN_SEL : R/W; bitpos: [7:2]; default: 32;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC13_IN_SEL    0x0000003FU
#define LP_GPIO_REG_GPIO_FUNC13_IN_SEL_M  (LP_GPIO_REG_GPIO_FUNC13_IN_SEL_V << LP_GPIO_REG_GPIO_FUNC13_IN_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC13_IN_SEL_V  0x0000003FU
#define LP_GPIO_REG_GPIO_FUNC13_IN_SEL_S  2

/** LP_GPIO_FUNC0_OUT_SEL_CFG_REG register
 *  Reserved
 */
#define LP_GPIO_FUNC0_OUT_SEL_CFG_REG (DR_REG_LP_GPIO_BASE + 0xf4)
/** LP_GPIO_REG_GPIO_FUNC0_OE_INV_SEL : R/W; bitpos: [0]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC0_OE_INV_SEL    (BIT(0))
#define LP_GPIO_REG_GPIO_FUNC0_OE_INV_SEL_M  (LP_GPIO_REG_GPIO_FUNC0_OE_INV_SEL_V << LP_GPIO_REG_GPIO_FUNC0_OE_INV_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC0_OE_INV_SEL_V  0x00000001U
#define LP_GPIO_REG_GPIO_FUNC0_OE_INV_SEL_S  0
/** LP_GPIO_REG_GPIO_FUNC0_OE_SEL : R/W; bitpos: [1]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC0_OE_SEL    (BIT(1))
#define LP_GPIO_REG_GPIO_FUNC0_OE_SEL_M  (LP_GPIO_REG_GPIO_FUNC0_OE_SEL_V << LP_GPIO_REG_GPIO_FUNC0_OE_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC0_OE_SEL_V  0x00000001U
#define LP_GPIO_REG_GPIO_FUNC0_OE_SEL_S  1
/** LP_GPIO_REG_GPIO_FUNC0_OUT_INV_SEL : R/W; bitpos: [2]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC0_OUT_INV_SEL    (BIT(2))
#define LP_GPIO_REG_GPIO_FUNC0_OUT_INV_SEL_M  (LP_GPIO_REG_GPIO_FUNC0_OUT_INV_SEL_V << LP_GPIO_REG_GPIO_FUNC0_OUT_INV_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC0_OUT_INV_SEL_V  0x00000001U
#define LP_GPIO_REG_GPIO_FUNC0_OUT_INV_SEL_S  2
/** LP_GPIO_REG_GPIO_FUNC0_OUT_SEL : R/W; bitpos: [8:3]; default: 32;
 *  reg_gpio_func0_out_sel[5:1]==16 -> output gpio register value to pad
 */
#define LP_GPIO_REG_GPIO_FUNC0_OUT_SEL    0x0000003FU
#define LP_GPIO_REG_GPIO_FUNC0_OUT_SEL_M  (LP_GPIO_REG_GPIO_FUNC0_OUT_SEL_V << LP_GPIO_REG_GPIO_FUNC0_OUT_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC0_OUT_SEL_V  0x0000003FU
#define LP_GPIO_REG_GPIO_FUNC0_OUT_SEL_S  3

/** LP_GPIO_FUNC1_OUT_SEL_CFG_REG register
 *  Reserved
 */
#define LP_GPIO_FUNC1_OUT_SEL_CFG_REG (DR_REG_LP_GPIO_BASE + 0xf8)
/** LP_GPIO_REG_GPIO_FUNC1_OE_INV_SEL : R/W; bitpos: [0]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC1_OE_INV_SEL    (BIT(0))
#define LP_GPIO_REG_GPIO_FUNC1_OE_INV_SEL_M  (LP_GPIO_REG_GPIO_FUNC1_OE_INV_SEL_V << LP_GPIO_REG_GPIO_FUNC1_OE_INV_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC1_OE_INV_SEL_V  0x00000001U
#define LP_GPIO_REG_GPIO_FUNC1_OE_INV_SEL_S  0
/** LP_GPIO_REG_GPIO_FUNC1_OE_SEL : R/W; bitpos: [1]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC1_OE_SEL    (BIT(1))
#define LP_GPIO_REG_GPIO_FUNC1_OE_SEL_M  (LP_GPIO_REG_GPIO_FUNC1_OE_SEL_V << LP_GPIO_REG_GPIO_FUNC1_OE_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC1_OE_SEL_V  0x00000001U
#define LP_GPIO_REG_GPIO_FUNC1_OE_SEL_S  1
/** LP_GPIO_REG_GPIO_FUNC1_OUT_INV_SEL : R/W; bitpos: [2]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC1_OUT_INV_SEL    (BIT(2))
#define LP_GPIO_REG_GPIO_FUNC1_OUT_INV_SEL_M  (LP_GPIO_REG_GPIO_FUNC1_OUT_INV_SEL_V << LP_GPIO_REG_GPIO_FUNC1_OUT_INV_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC1_OUT_INV_SEL_V  0x00000001U
#define LP_GPIO_REG_GPIO_FUNC1_OUT_INV_SEL_S  2
/** LP_GPIO_REG_GPIO_FUNC1_OUT_SEL : R/W; bitpos: [8:3]; default: 32;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC1_OUT_SEL    0x0000003FU
#define LP_GPIO_REG_GPIO_FUNC1_OUT_SEL_M  (LP_GPIO_REG_GPIO_FUNC1_OUT_SEL_V << LP_GPIO_REG_GPIO_FUNC1_OUT_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC1_OUT_SEL_V  0x0000003FU
#define LP_GPIO_REG_GPIO_FUNC1_OUT_SEL_S  3

/** LP_GPIO_FUNC2_OUT_SEL_CFG_REG register
 *  Reserved
 */
#define LP_GPIO_FUNC2_OUT_SEL_CFG_REG (DR_REG_LP_GPIO_BASE + 0xfc)
/** LP_GPIO_REG_GPIO_FUNC2_OE_INV_SEL : R/W; bitpos: [0]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC2_OE_INV_SEL    (BIT(0))
#define LP_GPIO_REG_GPIO_FUNC2_OE_INV_SEL_M  (LP_GPIO_REG_GPIO_FUNC2_OE_INV_SEL_V << LP_GPIO_REG_GPIO_FUNC2_OE_INV_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC2_OE_INV_SEL_V  0x00000001U
#define LP_GPIO_REG_GPIO_FUNC2_OE_INV_SEL_S  0
/** LP_GPIO_REG_GPIO_FUNC2_OE_SEL : R/W; bitpos: [1]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC2_OE_SEL    (BIT(1))
#define LP_GPIO_REG_GPIO_FUNC2_OE_SEL_M  (LP_GPIO_REG_GPIO_FUNC2_OE_SEL_V << LP_GPIO_REG_GPIO_FUNC2_OE_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC2_OE_SEL_V  0x00000001U
#define LP_GPIO_REG_GPIO_FUNC2_OE_SEL_S  1
/** LP_GPIO_REG_GPIO_FUNC2_OUT_INV_SEL : R/W; bitpos: [2]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC2_OUT_INV_SEL    (BIT(2))
#define LP_GPIO_REG_GPIO_FUNC2_OUT_INV_SEL_M  (LP_GPIO_REG_GPIO_FUNC2_OUT_INV_SEL_V << LP_GPIO_REG_GPIO_FUNC2_OUT_INV_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC2_OUT_INV_SEL_V  0x00000001U
#define LP_GPIO_REG_GPIO_FUNC2_OUT_INV_SEL_S  2
/** LP_GPIO_REG_GPIO_FUNC2_OUT_SEL : R/W; bitpos: [8:3]; default: 32;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC2_OUT_SEL    0x0000003FU
#define LP_GPIO_REG_GPIO_FUNC2_OUT_SEL_M  (LP_GPIO_REG_GPIO_FUNC2_OUT_SEL_V << LP_GPIO_REG_GPIO_FUNC2_OUT_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC2_OUT_SEL_V  0x0000003FU
#define LP_GPIO_REG_GPIO_FUNC2_OUT_SEL_S  3

/** LP_GPIO_FUNC3_OUT_SEL_CFG_REG register
 *  Reserved
 */
#define LP_GPIO_FUNC3_OUT_SEL_CFG_REG (DR_REG_LP_GPIO_BASE + 0x100)
/** LP_GPIO_REG_GPIO_FUNC3_OE_INV_SEL : R/W; bitpos: [0]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC3_OE_INV_SEL    (BIT(0))
#define LP_GPIO_REG_GPIO_FUNC3_OE_INV_SEL_M  (LP_GPIO_REG_GPIO_FUNC3_OE_INV_SEL_V << LP_GPIO_REG_GPIO_FUNC3_OE_INV_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC3_OE_INV_SEL_V  0x00000001U
#define LP_GPIO_REG_GPIO_FUNC3_OE_INV_SEL_S  0
/** LP_GPIO_REG_GPIO_FUNC3_OE_SEL : R/W; bitpos: [1]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC3_OE_SEL    (BIT(1))
#define LP_GPIO_REG_GPIO_FUNC3_OE_SEL_M  (LP_GPIO_REG_GPIO_FUNC3_OE_SEL_V << LP_GPIO_REG_GPIO_FUNC3_OE_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC3_OE_SEL_V  0x00000001U
#define LP_GPIO_REG_GPIO_FUNC3_OE_SEL_S  1
/** LP_GPIO_REG_GPIO_FUNC3_OUT_INV_SEL : R/W; bitpos: [2]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC3_OUT_INV_SEL    (BIT(2))
#define LP_GPIO_REG_GPIO_FUNC3_OUT_INV_SEL_M  (LP_GPIO_REG_GPIO_FUNC3_OUT_INV_SEL_V << LP_GPIO_REG_GPIO_FUNC3_OUT_INV_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC3_OUT_INV_SEL_V  0x00000001U
#define LP_GPIO_REG_GPIO_FUNC3_OUT_INV_SEL_S  2
/** LP_GPIO_REG_GPIO_FUNC3_OUT_SEL : R/W; bitpos: [8:3]; default: 32;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC3_OUT_SEL    0x0000003FU
#define LP_GPIO_REG_GPIO_FUNC3_OUT_SEL_M  (LP_GPIO_REG_GPIO_FUNC3_OUT_SEL_V << LP_GPIO_REG_GPIO_FUNC3_OUT_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC3_OUT_SEL_V  0x0000003FU
#define LP_GPIO_REG_GPIO_FUNC3_OUT_SEL_S  3

/** LP_GPIO_FUNC4_OUT_SEL_CFG_REG register
 *  Reserved
 */
#define LP_GPIO_FUNC4_OUT_SEL_CFG_REG (DR_REG_LP_GPIO_BASE + 0x104)
/** LP_GPIO_REG_GPIO_FUNC4_OE_INV_SEL : R/W; bitpos: [0]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC4_OE_INV_SEL    (BIT(0))
#define LP_GPIO_REG_GPIO_FUNC4_OE_INV_SEL_M  (LP_GPIO_REG_GPIO_FUNC4_OE_INV_SEL_V << LP_GPIO_REG_GPIO_FUNC4_OE_INV_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC4_OE_INV_SEL_V  0x00000001U
#define LP_GPIO_REG_GPIO_FUNC4_OE_INV_SEL_S  0
/** LP_GPIO_REG_GPIO_FUNC4_OE_SEL : R/W; bitpos: [1]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC4_OE_SEL    (BIT(1))
#define LP_GPIO_REG_GPIO_FUNC4_OE_SEL_M  (LP_GPIO_REG_GPIO_FUNC4_OE_SEL_V << LP_GPIO_REG_GPIO_FUNC4_OE_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC4_OE_SEL_V  0x00000001U
#define LP_GPIO_REG_GPIO_FUNC4_OE_SEL_S  1
/** LP_GPIO_REG_GPIO_FUNC4_OUT_INV_SEL : R/W; bitpos: [2]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC4_OUT_INV_SEL    (BIT(2))
#define LP_GPIO_REG_GPIO_FUNC4_OUT_INV_SEL_M  (LP_GPIO_REG_GPIO_FUNC4_OUT_INV_SEL_V << LP_GPIO_REG_GPIO_FUNC4_OUT_INV_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC4_OUT_INV_SEL_V  0x00000001U
#define LP_GPIO_REG_GPIO_FUNC4_OUT_INV_SEL_S  2
/** LP_GPIO_REG_GPIO_FUNC4_OUT_SEL : R/W; bitpos: [8:3]; default: 32;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC4_OUT_SEL    0x0000003FU
#define LP_GPIO_REG_GPIO_FUNC4_OUT_SEL_M  (LP_GPIO_REG_GPIO_FUNC4_OUT_SEL_V << LP_GPIO_REG_GPIO_FUNC4_OUT_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC4_OUT_SEL_V  0x0000003FU
#define LP_GPIO_REG_GPIO_FUNC4_OUT_SEL_S  3

/** LP_GPIO_FUNC5_OUT_SEL_CFG_REG register
 *  Reserved
 */
#define LP_GPIO_FUNC5_OUT_SEL_CFG_REG (DR_REG_LP_GPIO_BASE + 0x108)
/** LP_GPIO_REG_GPIO_FUNC5_OE_INV_SEL : R/W; bitpos: [0]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC5_OE_INV_SEL    (BIT(0))
#define LP_GPIO_REG_GPIO_FUNC5_OE_INV_SEL_M  (LP_GPIO_REG_GPIO_FUNC5_OE_INV_SEL_V << LP_GPIO_REG_GPIO_FUNC5_OE_INV_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC5_OE_INV_SEL_V  0x00000001U
#define LP_GPIO_REG_GPIO_FUNC5_OE_INV_SEL_S  0
/** LP_GPIO_REG_GPIO_FUNC5_OE_SEL : R/W; bitpos: [1]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC5_OE_SEL    (BIT(1))
#define LP_GPIO_REG_GPIO_FUNC5_OE_SEL_M  (LP_GPIO_REG_GPIO_FUNC5_OE_SEL_V << LP_GPIO_REG_GPIO_FUNC5_OE_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC5_OE_SEL_V  0x00000001U
#define LP_GPIO_REG_GPIO_FUNC5_OE_SEL_S  1
/** LP_GPIO_REG_GPIO_FUNC5_OUT_INV_SEL : R/W; bitpos: [2]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC5_OUT_INV_SEL    (BIT(2))
#define LP_GPIO_REG_GPIO_FUNC5_OUT_INV_SEL_M  (LP_GPIO_REG_GPIO_FUNC5_OUT_INV_SEL_V << LP_GPIO_REG_GPIO_FUNC5_OUT_INV_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC5_OUT_INV_SEL_V  0x00000001U
#define LP_GPIO_REG_GPIO_FUNC5_OUT_INV_SEL_S  2
/** LP_GPIO_REG_GPIO_FUNC5_OUT_SEL : R/W; bitpos: [8:3]; default: 32;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC5_OUT_SEL    0x0000003FU
#define LP_GPIO_REG_GPIO_FUNC5_OUT_SEL_M  (LP_GPIO_REG_GPIO_FUNC5_OUT_SEL_V << LP_GPIO_REG_GPIO_FUNC5_OUT_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC5_OUT_SEL_V  0x0000003FU
#define LP_GPIO_REG_GPIO_FUNC5_OUT_SEL_S  3

/** LP_GPIO_FUNC6_OUT_SEL_CFG_REG register
 *  Reserved
 */
#define LP_GPIO_FUNC6_OUT_SEL_CFG_REG (DR_REG_LP_GPIO_BASE + 0x10c)
/** LP_GPIO_REG_GPIO_FUNC6_OE_INV_SEL : R/W; bitpos: [0]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC6_OE_INV_SEL    (BIT(0))
#define LP_GPIO_REG_GPIO_FUNC6_OE_INV_SEL_M  (LP_GPIO_REG_GPIO_FUNC6_OE_INV_SEL_V << LP_GPIO_REG_GPIO_FUNC6_OE_INV_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC6_OE_INV_SEL_V  0x00000001U
#define LP_GPIO_REG_GPIO_FUNC6_OE_INV_SEL_S  0
/** LP_GPIO_REG_GPIO_FUNC6_OE_SEL : R/W; bitpos: [1]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC6_OE_SEL    (BIT(1))
#define LP_GPIO_REG_GPIO_FUNC6_OE_SEL_M  (LP_GPIO_REG_GPIO_FUNC6_OE_SEL_V << LP_GPIO_REG_GPIO_FUNC6_OE_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC6_OE_SEL_V  0x00000001U
#define LP_GPIO_REG_GPIO_FUNC6_OE_SEL_S  1
/** LP_GPIO_REG_GPIO_FUNC6_OUT_INV_SEL : R/W; bitpos: [2]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC6_OUT_INV_SEL    (BIT(2))
#define LP_GPIO_REG_GPIO_FUNC6_OUT_INV_SEL_M  (LP_GPIO_REG_GPIO_FUNC6_OUT_INV_SEL_V << LP_GPIO_REG_GPIO_FUNC6_OUT_INV_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC6_OUT_INV_SEL_V  0x00000001U
#define LP_GPIO_REG_GPIO_FUNC6_OUT_INV_SEL_S  2
/** LP_GPIO_REG_GPIO_FUNC6_OUT_SEL : R/W; bitpos: [8:3]; default: 32;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC6_OUT_SEL    0x0000003FU
#define LP_GPIO_REG_GPIO_FUNC6_OUT_SEL_M  (LP_GPIO_REG_GPIO_FUNC6_OUT_SEL_V << LP_GPIO_REG_GPIO_FUNC6_OUT_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC6_OUT_SEL_V  0x0000003FU
#define LP_GPIO_REG_GPIO_FUNC6_OUT_SEL_S  3

/** LP_GPIO_FUNC7_OUT_SEL_CFG_REG register
 *  Reserved
 */
#define LP_GPIO_FUNC7_OUT_SEL_CFG_REG (DR_REG_LP_GPIO_BASE + 0x110)
/** LP_GPIO_REG_GPIO_FUNC7_OE_INV_SEL : R/W; bitpos: [0]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC7_OE_INV_SEL    (BIT(0))
#define LP_GPIO_REG_GPIO_FUNC7_OE_INV_SEL_M  (LP_GPIO_REG_GPIO_FUNC7_OE_INV_SEL_V << LP_GPIO_REG_GPIO_FUNC7_OE_INV_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC7_OE_INV_SEL_V  0x00000001U
#define LP_GPIO_REG_GPIO_FUNC7_OE_INV_SEL_S  0
/** LP_GPIO_REG_GPIO_FUNC7_OE_SEL : R/W; bitpos: [1]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC7_OE_SEL    (BIT(1))
#define LP_GPIO_REG_GPIO_FUNC7_OE_SEL_M  (LP_GPIO_REG_GPIO_FUNC7_OE_SEL_V << LP_GPIO_REG_GPIO_FUNC7_OE_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC7_OE_SEL_V  0x00000001U
#define LP_GPIO_REG_GPIO_FUNC7_OE_SEL_S  1
/** LP_GPIO_REG_GPIO_FUNC7_OUT_INV_SEL : R/W; bitpos: [2]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC7_OUT_INV_SEL    (BIT(2))
#define LP_GPIO_REG_GPIO_FUNC7_OUT_INV_SEL_M  (LP_GPIO_REG_GPIO_FUNC7_OUT_INV_SEL_V << LP_GPIO_REG_GPIO_FUNC7_OUT_INV_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC7_OUT_INV_SEL_V  0x00000001U
#define LP_GPIO_REG_GPIO_FUNC7_OUT_INV_SEL_S  2
/** LP_GPIO_REG_GPIO_FUNC7_OUT_SEL : R/W; bitpos: [8:3]; default: 32;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC7_OUT_SEL    0x0000003FU
#define LP_GPIO_REG_GPIO_FUNC7_OUT_SEL_M  (LP_GPIO_REG_GPIO_FUNC7_OUT_SEL_V << LP_GPIO_REG_GPIO_FUNC7_OUT_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC7_OUT_SEL_V  0x0000003FU
#define LP_GPIO_REG_GPIO_FUNC7_OUT_SEL_S  3

/** LP_GPIO_FUNC8_OUT_SEL_CFG_REG register
 *  Reserved
 */
#define LP_GPIO_FUNC8_OUT_SEL_CFG_REG (DR_REG_LP_GPIO_BASE + 0x114)
/** LP_GPIO_REG_GPIO_FUNC8_OE_INV_SEL : R/W; bitpos: [0]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC8_OE_INV_SEL    (BIT(0))
#define LP_GPIO_REG_GPIO_FUNC8_OE_INV_SEL_M  (LP_GPIO_REG_GPIO_FUNC8_OE_INV_SEL_V << LP_GPIO_REG_GPIO_FUNC8_OE_INV_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC8_OE_INV_SEL_V  0x00000001U
#define LP_GPIO_REG_GPIO_FUNC8_OE_INV_SEL_S  0
/** LP_GPIO_REG_GPIO_FUNC8_OE_SEL : R/W; bitpos: [1]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC8_OE_SEL    (BIT(1))
#define LP_GPIO_REG_GPIO_FUNC8_OE_SEL_M  (LP_GPIO_REG_GPIO_FUNC8_OE_SEL_V << LP_GPIO_REG_GPIO_FUNC8_OE_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC8_OE_SEL_V  0x00000001U
#define LP_GPIO_REG_GPIO_FUNC8_OE_SEL_S  1
/** LP_GPIO_REG_GPIO_FUNC8_OUT_INV_SEL : R/W; bitpos: [2]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC8_OUT_INV_SEL    (BIT(2))
#define LP_GPIO_REG_GPIO_FUNC8_OUT_INV_SEL_M  (LP_GPIO_REG_GPIO_FUNC8_OUT_INV_SEL_V << LP_GPIO_REG_GPIO_FUNC8_OUT_INV_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC8_OUT_INV_SEL_V  0x00000001U
#define LP_GPIO_REG_GPIO_FUNC8_OUT_INV_SEL_S  2
/** LP_GPIO_REG_GPIO_FUNC8_OUT_SEL : R/W; bitpos: [8:3]; default: 32;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC8_OUT_SEL    0x0000003FU
#define LP_GPIO_REG_GPIO_FUNC8_OUT_SEL_M  (LP_GPIO_REG_GPIO_FUNC8_OUT_SEL_V << LP_GPIO_REG_GPIO_FUNC8_OUT_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC8_OUT_SEL_V  0x0000003FU
#define LP_GPIO_REG_GPIO_FUNC8_OUT_SEL_S  3

/** LP_GPIO_FUNC9_OUT_SEL_CFG_REG register
 *  Reserved
 */
#define LP_GPIO_FUNC9_OUT_SEL_CFG_REG (DR_REG_LP_GPIO_BASE + 0x118)
/** LP_GPIO_REG_GPIO_FUNC9_OE_INV_SEL : R/W; bitpos: [0]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC9_OE_INV_SEL    (BIT(0))
#define LP_GPIO_REG_GPIO_FUNC9_OE_INV_SEL_M  (LP_GPIO_REG_GPIO_FUNC9_OE_INV_SEL_V << LP_GPIO_REG_GPIO_FUNC9_OE_INV_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC9_OE_INV_SEL_V  0x00000001U
#define LP_GPIO_REG_GPIO_FUNC9_OE_INV_SEL_S  0
/** LP_GPIO_REG_GPIO_FUNC9_OE_SEL : R/W; bitpos: [1]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC9_OE_SEL    (BIT(1))
#define LP_GPIO_REG_GPIO_FUNC9_OE_SEL_M  (LP_GPIO_REG_GPIO_FUNC9_OE_SEL_V << LP_GPIO_REG_GPIO_FUNC9_OE_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC9_OE_SEL_V  0x00000001U
#define LP_GPIO_REG_GPIO_FUNC9_OE_SEL_S  1
/** LP_GPIO_REG_GPIO_FUNC9_OUT_INV_SEL : R/W; bitpos: [2]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC9_OUT_INV_SEL    (BIT(2))
#define LP_GPIO_REG_GPIO_FUNC9_OUT_INV_SEL_M  (LP_GPIO_REG_GPIO_FUNC9_OUT_INV_SEL_V << LP_GPIO_REG_GPIO_FUNC9_OUT_INV_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC9_OUT_INV_SEL_V  0x00000001U
#define LP_GPIO_REG_GPIO_FUNC9_OUT_INV_SEL_S  2
/** LP_GPIO_REG_GPIO_FUNC9_OUT_SEL : R/W; bitpos: [8:3]; default: 32;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC9_OUT_SEL    0x0000003FU
#define LP_GPIO_REG_GPIO_FUNC9_OUT_SEL_M  (LP_GPIO_REG_GPIO_FUNC9_OUT_SEL_V << LP_GPIO_REG_GPIO_FUNC9_OUT_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC9_OUT_SEL_V  0x0000003FU
#define LP_GPIO_REG_GPIO_FUNC9_OUT_SEL_S  3

/** LP_GPIO_FUNC10_OUT_SEL_CFG_REG register
 *  Reserved
 */
#define LP_GPIO_FUNC10_OUT_SEL_CFG_REG (DR_REG_LP_GPIO_BASE + 0x11c)
/** LP_GPIO_REG_GPIO_FUNC10_OE_INV_SEL : R/W; bitpos: [0]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC10_OE_INV_SEL    (BIT(0))
#define LP_GPIO_REG_GPIO_FUNC10_OE_INV_SEL_M  (LP_GPIO_REG_GPIO_FUNC10_OE_INV_SEL_V << LP_GPIO_REG_GPIO_FUNC10_OE_INV_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC10_OE_INV_SEL_V  0x00000001U
#define LP_GPIO_REG_GPIO_FUNC10_OE_INV_SEL_S  0
/** LP_GPIO_REG_GPIO_FUNC10_OE_SEL : R/W; bitpos: [1]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC10_OE_SEL    (BIT(1))
#define LP_GPIO_REG_GPIO_FUNC10_OE_SEL_M  (LP_GPIO_REG_GPIO_FUNC10_OE_SEL_V << LP_GPIO_REG_GPIO_FUNC10_OE_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC10_OE_SEL_V  0x00000001U
#define LP_GPIO_REG_GPIO_FUNC10_OE_SEL_S  1
/** LP_GPIO_REG_GPIO_FUNC10_OUT_INV_SEL : R/W; bitpos: [2]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC10_OUT_INV_SEL    (BIT(2))
#define LP_GPIO_REG_GPIO_FUNC10_OUT_INV_SEL_M  (LP_GPIO_REG_GPIO_FUNC10_OUT_INV_SEL_V << LP_GPIO_REG_GPIO_FUNC10_OUT_INV_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC10_OUT_INV_SEL_V  0x00000001U
#define LP_GPIO_REG_GPIO_FUNC10_OUT_INV_SEL_S  2
/** LP_GPIO_REG_GPIO_FUNC10_OUT_SEL : R/W; bitpos: [8:3]; default: 32;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC10_OUT_SEL    0x0000003FU
#define LP_GPIO_REG_GPIO_FUNC10_OUT_SEL_M  (LP_GPIO_REG_GPIO_FUNC10_OUT_SEL_V << LP_GPIO_REG_GPIO_FUNC10_OUT_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC10_OUT_SEL_V  0x0000003FU
#define LP_GPIO_REG_GPIO_FUNC10_OUT_SEL_S  3

/** LP_GPIO_FUNC11_OUT_SEL_CFG_REG register
 *  Reserved
 */
#define LP_GPIO_FUNC11_OUT_SEL_CFG_REG (DR_REG_LP_GPIO_BASE + 0x120)
/** LP_GPIO_REG_GPIO_FUNC11_OE_INV_SEL : R/W; bitpos: [0]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC11_OE_INV_SEL    (BIT(0))
#define LP_GPIO_REG_GPIO_FUNC11_OE_INV_SEL_M  (LP_GPIO_REG_GPIO_FUNC11_OE_INV_SEL_V << LP_GPIO_REG_GPIO_FUNC11_OE_INV_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC11_OE_INV_SEL_V  0x00000001U
#define LP_GPIO_REG_GPIO_FUNC11_OE_INV_SEL_S  0
/** LP_GPIO_REG_GPIO_FUNC11_OE_SEL : R/W; bitpos: [1]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC11_OE_SEL    (BIT(1))
#define LP_GPIO_REG_GPIO_FUNC11_OE_SEL_M  (LP_GPIO_REG_GPIO_FUNC11_OE_SEL_V << LP_GPIO_REG_GPIO_FUNC11_OE_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC11_OE_SEL_V  0x00000001U
#define LP_GPIO_REG_GPIO_FUNC11_OE_SEL_S  1
/** LP_GPIO_REG_GPIO_FUNC11_OUT_INV_SEL : R/W; bitpos: [2]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC11_OUT_INV_SEL    (BIT(2))
#define LP_GPIO_REG_GPIO_FUNC11_OUT_INV_SEL_M  (LP_GPIO_REG_GPIO_FUNC11_OUT_INV_SEL_V << LP_GPIO_REG_GPIO_FUNC11_OUT_INV_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC11_OUT_INV_SEL_V  0x00000001U
#define LP_GPIO_REG_GPIO_FUNC11_OUT_INV_SEL_S  2
/** LP_GPIO_REG_GPIO_FUNC11_OUT_SEL : R/W; bitpos: [8:3]; default: 32;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC11_OUT_SEL    0x0000003FU
#define LP_GPIO_REG_GPIO_FUNC11_OUT_SEL_M  (LP_GPIO_REG_GPIO_FUNC11_OUT_SEL_V << LP_GPIO_REG_GPIO_FUNC11_OUT_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC11_OUT_SEL_V  0x0000003FU
#define LP_GPIO_REG_GPIO_FUNC11_OUT_SEL_S  3

/** LP_GPIO_FUNC12_OUT_SEL_CFG_REG register
 *  Reserved
 */
#define LP_GPIO_FUNC12_OUT_SEL_CFG_REG (DR_REG_LP_GPIO_BASE + 0x124)
/** LP_GPIO_REG_GPIO_FUNC12_OE_INV_SEL : R/W; bitpos: [0]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC12_OE_INV_SEL    (BIT(0))
#define LP_GPIO_REG_GPIO_FUNC12_OE_INV_SEL_M  (LP_GPIO_REG_GPIO_FUNC12_OE_INV_SEL_V << LP_GPIO_REG_GPIO_FUNC12_OE_INV_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC12_OE_INV_SEL_V  0x00000001U
#define LP_GPIO_REG_GPIO_FUNC12_OE_INV_SEL_S  0
/** LP_GPIO_REG_GPIO_FUNC12_OE_SEL : R/W; bitpos: [1]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC12_OE_SEL    (BIT(1))
#define LP_GPIO_REG_GPIO_FUNC12_OE_SEL_M  (LP_GPIO_REG_GPIO_FUNC12_OE_SEL_V << LP_GPIO_REG_GPIO_FUNC12_OE_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC12_OE_SEL_V  0x00000001U
#define LP_GPIO_REG_GPIO_FUNC12_OE_SEL_S  1
/** LP_GPIO_REG_GPIO_FUNC12_OUT_INV_SEL : R/W; bitpos: [2]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC12_OUT_INV_SEL    (BIT(2))
#define LP_GPIO_REG_GPIO_FUNC12_OUT_INV_SEL_M  (LP_GPIO_REG_GPIO_FUNC12_OUT_INV_SEL_V << LP_GPIO_REG_GPIO_FUNC12_OUT_INV_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC12_OUT_INV_SEL_V  0x00000001U
#define LP_GPIO_REG_GPIO_FUNC12_OUT_INV_SEL_S  2
/** LP_GPIO_REG_GPIO_FUNC12_OUT_SEL : R/W; bitpos: [8:3]; default: 32;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC12_OUT_SEL    0x0000003FU
#define LP_GPIO_REG_GPIO_FUNC12_OUT_SEL_M  (LP_GPIO_REG_GPIO_FUNC12_OUT_SEL_V << LP_GPIO_REG_GPIO_FUNC12_OUT_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC12_OUT_SEL_V  0x0000003FU
#define LP_GPIO_REG_GPIO_FUNC12_OUT_SEL_S  3

/** LP_GPIO_FUNC13_OUT_SEL_CFG_REG register
 *  Reserved
 */
#define LP_GPIO_FUNC13_OUT_SEL_CFG_REG (DR_REG_LP_GPIO_BASE + 0x128)
/** LP_GPIO_REG_GPIO_FUNC13_OE_INV_SEL : R/W; bitpos: [0]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC13_OE_INV_SEL    (BIT(0))
#define LP_GPIO_REG_GPIO_FUNC13_OE_INV_SEL_M  (LP_GPIO_REG_GPIO_FUNC13_OE_INV_SEL_V << LP_GPIO_REG_GPIO_FUNC13_OE_INV_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC13_OE_INV_SEL_V  0x00000001U
#define LP_GPIO_REG_GPIO_FUNC13_OE_INV_SEL_S  0
/** LP_GPIO_REG_GPIO_FUNC13_OE_SEL : R/W; bitpos: [1]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC13_OE_SEL    (BIT(1))
#define LP_GPIO_REG_GPIO_FUNC13_OE_SEL_M  (LP_GPIO_REG_GPIO_FUNC13_OE_SEL_V << LP_GPIO_REG_GPIO_FUNC13_OE_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC13_OE_SEL_V  0x00000001U
#define LP_GPIO_REG_GPIO_FUNC13_OE_SEL_S  1
/** LP_GPIO_REG_GPIO_FUNC13_OUT_INV_SEL : R/W; bitpos: [2]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC13_OUT_INV_SEL    (BIT(2))
#define LP_GPIO_REG_GPIO_FUNC13_OUT_INV_SEL_M  (LP_GPIO_REG_GPIO_FUNC13_OUT_INV_SEL_V << LP_GPIO_REG_GPIO_FUNC13_OUT_INV_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC13_OUT_INV_SEL_V  0x00000001U
#define LP_GPIO_REG_GPIO_FUNC13_OUT_INV_SEL_S  2
/** LP_GPIO_REG_GPIO_FUNC13_OUT_SEL : R/W; bitpos: [8:3]; default: 32;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC13_OUT_SEL    0x0000003FU
#define LP_GPIO_REG_GPIO_FUNC13_OUT_SEL_M  (LP_GPIO_REG_GPIO_FUNC13_OUT_SEL_V << LP_GPIO_REG_GPIO_FUNC13_OUT_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC13_OUT_SEL_V  0x0000003FU
#define LP_GPIO_REG_GPIO_FUNC13_OUT_SEL_S  3

/** LP_GPIO_FUNC14_OUT_SEL_CFG_REG register
 *  Reserved
 */
#define LP_GPIO_FUNC14_OUT_SEL_CFG_REG (DR_REG_LP_GPIO_BASE + 0x12c)
/** LP_GPIO_REG_GPIO_FUNC14_OE_INV_SEL : R/W; bitpos: [0]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC14_OE_INV_SEL    (BIT(0))
#define LP_GPIO_REG_GPIO_FUNC14_OE_INV_SEL_M  (LP_GPIO_REG_GPIO_FUNC14_OE_INV_SEL_V << LP_GPIO_REG_GPIO_FUNC14_OE_INV_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC14_OE_INV_SEL_V  0x00000001U
#define LP_GPIO_REG_GPIO_FUNC14_OE_INV_SEL_S  0
/** LP_GPIO_REG_GPIO_FUNC14_OE_SEL : R/W; bitpos: [1]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC14_OE_SEL    (BIT(1))
#define LP_GPIO_REG_GPIO_FUNC14_OE_SEL_M  (LP_GPIO_REG_GPIO_FUNC14_OE_SEL_V << LP_GPIO_REG_GPIO_FUNC14_OE_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC14_OE_SEL_V  0x00000001U
#define LP_GPIO_REG_GPIO_FUNC14_OE_SEL_S  1
/** LP_GPIO_REG_GPIO_FUNC14_OUT_INV_SEL : R/W; bitpos: [2]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC14_OUT_INV_SEL    (BIT(2))
#define LP_GPIO_REG_GPIO_FUNC14_OUT_INV_SEL_M  (LP_GPIO_REG_GPIO_FUNC14_OUT_INV_SEL_V << LP_GPIO_REG_GPIO_FUNC14_OUT_INV_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC14_OUT_INV_SEL_V  0x00000001U
#define LP_GPIO_REG_GPIO_FUNC14_OUT_INV_SEL_S  2
/** LP_GPIO_REG_GPIO_FUNC14_OUT_SEL : R/W; bitpos: [8:3]; default: 32;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC14_OUT_SEL    0x0000003FU
#define LP_GPIO_REG_GPIO_FUNC14_OUT_SEL_M  (LP_GPIO_REG_GPIO_FUNC14_OUT_SEL_V << LP_GPIO_REG_GPIO_FUNC14_OUT_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC14_OUT_SEL_V  0x0000003FU
#define LP_GPIO_REG_GPIO_FUNC14_OUT_SEL_S  3

/** LP_GPIO_FUNC15_OUT_SEL_CFG_REG register
 *  Reserved
 */
#define LP_GPIO_FUNC15_OUT_SEL_CFG_REG (DR_REG_LP_GPIO_BASE + 0x130)
/** LP_GPIO_REG_GPIO_FUNC15_OE_INV_SEL : R/W; bitpos: [0]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC15_OE_INV_SEL    (BIT(0))
#define LP_GPIO_REG_GPIO_FUNC15_OE_INV_SEL_M  (LP_GPIO_REG_GPIO_FUNC15_OE_INV_SEL_V << LP_GPIO_REG_GPIO_FUNC15_OE_INV_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC15_OE_INV_SEL_V  0x00000001U
#define LP_GPIO_REG_GPIO_FUNC15_OE_INV_SEL_S  0
/** LP_GPIO_REG_GPIO_FUNC15_OE_SEL : R/W; bitpos: [1]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC15_OE_SEL    (BIT(1))
#define LP_GPIO_REG_GPIO_FUNC15_OE_SEL_M  (LP_GPIO_REG_GPIO_FUNC15_OE_SEL_V << LP_GPIO_REG_GPIO_FUNC15_OE_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC15_OE_SEL_V  0x00000001U
#define LP_GPIO_REG_GPIO_FUNC15_OE_SEL_S  1
/** LP_GPIO_REG_GPIO_FUNC15_OUT_INV_SEL : R/W; bitpos: [2]; default: 0;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC15_OUT_INV_SEL    (BIT(2))
#define LP_GPIO_REG_GPIO_FUNC15_OUT_INV_SEL_M  (LP_GPIO_REG_GPIO_FUNC15_OUT_INV_SEL_V << LP_GPIO_REG_GPIO_FUNC15_OUT_INV_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC15_OUT_INV_SEL_V  0x00000001U
#define LP_GPIO_REG_GPIO_FUNC15_OUT_INV_SEL_S  2
/** LP_GPIO_REG_GPIO_FUNC15_OUT_SEL : R/W; bitpos: [8:3]; default: 32;
 *  Reserved
 */
#define LP_GPIO_REG_GPIO_FUNC15_OUT_SEL    0x0000003FU
#define LP_GPIO_REG_GPIO_FUNC15_OUT_SEL_M  (LP_GPIO_REG_GPIO_FUNC15_OUT_SEL_V << LP_GPIO_REG_GPIO_FUNC15_OUT_SEL_S)
#define LP_GPIO_REG_GPIO_FUNC15_OUT_SEL_V  0x0000003FU
#define LP_GPIO_REG_GPIO_FUNC15_OUT_SEL_S  3

#ifdef __cplusplus
}
#endif
