/**
 * SPDX-FileCopyrightText: 2025 Espressif Systems (Shanghai) CO LTD
 *
 *  SPDX-License-Identifier: Apache-2.0
 */
#pragma once

#include <stdint.h>
#include "soc/soc.h"
#ifdef __cplusplus
extern "C" {
#endif

/** ECDSA_CONF_REG register
 *  ECDSA configuration register
 */
#define ECDSA_CONF_REG (DR_REG_ECDSA_BASE + 0x4)
/** ECDSA_WORK_MODE : R/W; bitpos: [1:0]; default: 0;
 *  Configures the working mode of ECDSA accelerator.
 *  0: Signature Verification Mode
 *  1: Signature Generation Mode
 *  2: Public Key Export Mode
 *  3: Invalid
 */
#define ECDSA_WORK_MODE    0x00000003U
#define ECDSA_WORK_MODE_M  (ECDSA_WORK_MODE_V << ECDSA_WORK_MODE_S)
#define ECDSA_WORK_MODE_V  0x00000003U
#define ECDSA_WORK_MODE_S  0
/** ECDSA_ECC_CURVE : R/W; bitpos: [2]; default: 0;
 *  Configures the elliptic curve used.
 *  0: P-192
 *  1: P-256
 */
#define ECDSA_ECC_CURVE    (BIT(2))
#define ECDSA_ECC_CURVE_M  (ECDSA_ECC_CURVE_V << ECDSA_ECC_CURVE_S)
#define ECDSA_ECC_CURVE_V  0x00000001U
#define ECDSA_ECC_CURVE_S  2
/** ECDSA_SOFTWARE_SET_K : R/W; bitpos: [3]; default: 0;
 *  Configures the generation source of k.
 *  0: k is automatically generated by hardware
 *  1: k is written by software
 */
#define ECDSA_SOFTWARE_SET_K    (BIT(3))
#define ECDSA_SOFTWARE_SET_K_M  (ECDSA_SOFTWARE_SET_K_V << ECDSA_SOFTWARE_SET_K_S)
#define ECDSA_SOFTWARE_SET_K_V  0x00000001U
#define ECDSA_SOFTWARE_SET_K_S  3
/** ECDSA_SOFTWARE_SET_Z : R/W; bitpos: [4]; default: 0;
 *  Configures how the parameter $z$ is set.
 *  0: Generated from SHA result
 *  1: Written by software
 */
#define ECDSA_SOFTWARE_SET_Z    (BIT(4))
#define ECDSA_SOFTWARE_SET_Z_M  (ECDSA_SOFTWARE_SET_Z_V << ECDSA_SOFTWARE_SET_Z_S)
#define ECDSA_SOFTWARE_SET_Z_V  0x00000001U
#define ECDSA_SOFTWARE_SET_Z_S  4
/** ECDSA_DETERMINISTIC_K : R/W; bitpos: [5]; default: 0;
 *
 *  Configures how the parameter $k$ is set.
 *  0: Automatically generated by TRNG
 *  1: Generated by the deterministic derivation algorithm
 */
#define ECDSA_DETERMINISTIC_K    (BIT(5))
#define ECDSA_DETERMINISTIC_K_M  (ECDSA_DETERMINISTIC_K_V << ECDSA_DETERMINISTIC_K_S)
#define ECDSA_DETERMINISTIC_K_V  0x00000001U
#define ECDSA_DETERMINISTIC_K_S  5

/** ECDSA_CLK_REG register
 *  ECDSA clock gate register
 */
#define ECDSA_CLK_REG (DR_REG_ECDSA_BASE + 0x8)
/** ECDSA_CLK_GATE_FORCE_ON : R/W; bitpos: [0]; default: 0;
 *  Configures whether to force on ECDSA memory clock gate.
 *  0: No effect
 *  1: Force on
 */
#define ECDSA_CLK_GATE_FORCE_ON    (BIT(0))
#define ECDSA_CLK_GATE_FORCE_ON_M  (ECDSA_CLK_GATE_FORCE_ON_V << ECDSA_CLK_GATE_FORCE_ON_S)
#define ECDSA_CLK_GATE_FORCE_ON_V  0x00000001U
#define ECDSA_CLK_GATE_FORCE_ON_S  0

/** ECDSA_INT_RAW_REG register
 *  ECDSA interrupt raw register
 */
#define ECDSA_INT_RAW_REG (DR_REG_ECDSA_BASE + 0xc)
/** ECDSA_PREP_DONE_INT_RAW : R/SS/WTC; bitpos: [0]; default: 0;
 *  The raw interrupt status of the ECDSA_PREP_DONE_INT interrupt.
 */
#define ECDSA_PREP_DONE_INT_RAW    (BIT(0))
#define ECDSA_PREP_DONE_INT_RAW_M  (ECDSA_PREP_DONE_INT_RAW_V << ECDSA_PREP_DONE_INT_RAW_S)
#define ECDSA_PREP_DONE_INT_RAW_V  0x00000001U
#define ECDSA_PREP_DONE_INT_RAW_S  0
/** ECDSA_PROC_DONE_INT_RAW : R/SS/WTC; bitpos: [1]; default: 0;
 *  The raw interrupt status of the ECDSA_PROC_DONE_INT interrupt.
 */
#define ECDSA_PROC_DONE_INT_RAW    (BIT(1))
#define ECDSA_PROC_DONE_INT_RAW_M  (ECDSA_PROC_DONE_INT_RAW_V << ECDSA_PROC_DONE_INT_RAW_S)
#define ECDSA_PROC_DONE_INT_RAW_V  0x00000001U
#define ECDSA_PROC_DONE_INT_RAW_S  1
/** ECDSA_POST_DONE_INT_RAW : R/SS/WTC; bitpos: [2]; default: 0;
 *  The raw interrupt status of the ECDSA_POST_DONE_INT interrupt.
 */
#define ECDSA_POST_DONE_INT_RAW    (BIT(2))
#define ECDSA_POST_DONE_INT_RAW_M  (ECDSA_POST_DONE_INT_RAW_V << ECDSA_POST_DONE_INT_RAW_S)
#define ECDSA_POST_DONE_INT_RAW_V  0x00000001U
#define ECDSA_POST_DONE_INT_RAW_S  2
/** ECDSA_SHA_RELEASE_INT_RAW : R/SS/WTC; bitpos: [3]; default: 0;
 *  The raw interrupt status of the ECDSA_SHA_RELEASE_INT interrupt.
 */
#define ECDSA_SHA_RELEASE_INT_RAW    (BIT(3))
#define ECDSA_SHA_RELEASE_INT_RAW_M  (ECDSA_SHA_RELEASE_INT_RAW_V << ECDSA_SHA_RELEASE_INT_RAW_S)
#define ECDSA_SHA_RELEASE_INT_RAW_V  0x00000001U
#define ECDSA_SHA_RELEASE_INT_RAW_S  3

/** ECDSA_INT_ST_REG register
 *  ECDSA interrupt status register
 */
#define ECDSA_INT_ST_REG (DR_REG_ECDSA_BASE + 0x10)
/** ECDSA_PREP_DONE_INT_ST : RO; bitpos: [0]; default: 0;
 *  The masked interrupt status of the ECDSA_PREP_DONE_INT interrupt.
 */
#define ECDSA_PREP_DONE_INT_ST    (BIT(0))
#define ECDSA_PREP_DONE_INT_ST_M  (ECDSA_PREP_DONE_INT_ST_V << ECDSA_PREP_DONE_INT_ST_S)
#define ECDSA_PREP_DONE_INT_ST_V  0x00000001U
#define ECDSA_PREP_DONE_INT_ST_S  0
/** ECDSA_PROC_DONE_INT_ST : RO; bitpos: [1]; default: 0;
 *  The masked interrupt status of the ECDSA_PROC_DONE_INT interrupt.
 */
#define ECDSA_PROC_DONE_INT_ST    (BIT(1))
#define ECDSA_PROC_DONE_INT_ST_M  (ECDSA_PROC_DONE_INT_ST_V << ECDSA_PROC_DONE_INT_ST_S)
#define ECDSA_PROC_DONE_INT_ST_V  0x00000001U
#define ECDSA_PROC_DONE_INT_ST_S  1
/** ECDSA_POST_DONE_INT_ST : RO; bitpos: [2]; default: 0;
 *  The masked interrupt status of the ECDSA_POST_DONE_INT interrupt.
 */
#define ECDSA_POST_DONE_INT_ST    (BIT(2))
#define ECDSA_POST_DONE_INT_ST_M  (ECDSA_POST_DONE_INT_ST_V << ECDSA_POST_DONE_INT_ST_S)
#define ECDSA_POST_DONE_INT_ST_V  0x00000001U
#define ECDSA_POST_DONE_INT_ST_S  2
/** ECDSA_SHA_RELEASE_INT_ST : RO; bitpos: [3]; default: 0;
 *  The masked interrupt status of the ECDSA_SHA_RELEASE_INT interrupt.
 */
#define ECDSA_SHA_RELEASE_INT_ST    (BIT(3))
#define ECDSA_SHA_RELEASE_INT_ST_M  (ECDSA_SHA_RELEASE_INT_ST_V << ECDSA_SHA_RELEASE_INT_ST_S)
#define ECDSA_SHA_RELEASE_INT_ST_V  0x00000001U
#define ECDSA_SHA_RELEASE_INT_ST_S  3

/** ECDSA_INT_ENA_REG register
 *  ECDSA interrupt enable register
 */
#define ECDSA_INT_ENA_REG (DR_REG_ECDSA_BASE + 0x14)
/** ECDSA_PREP_DONE_INT_ENA : R/W; bitpos: [0]; default: 0;
 *  Write 1 to enable the ECDSA_PREP_DONE_INT interrupt.
 */
#define ECDSA_PREP_DONE_INT_ENA    (BIT(0))
#define ECDSA_PREP_DONE_INT_ENA_M  (ECDSA_PREP_DONE_INT_ENA_V << ECDSA_PREP_DONE_INT_ENA_S)
#define ECDSA_PREP_DONE_INT_ENA_V  0x00000001U
#define ECDSA_PREP_DONE_INT_ENA_S  0
/** ECDSA_PROC_DONE_INT_ENA : R/W; bitpos: [1]; default: 0;
 *  Write 1 to enable the ECDSA_PROC_DONE_INT interrupt.
 */
#define ECDSA_PROC_DONE_INT_ENA    (BIT(1))
#define ECDSA_PROC_DONE_INT_ENA_M  (ECDSA_PROC_DONE_INT_ENA_V << ECDSA_PROC_DONE_INT_ENA_S)
#define ECDSA_PROC_DONE_INT_ENA_V  0x00000001U
#define ECDSA_PROC_DONE_INT_ENA_S  1
/** ECDSA_POST_DONE_INT_ENA : R/W; bitpos: [2]; default: 0;
 *  Write 1 to enable the ECDSA_POST_DONE_INT interrupt.
 */
#define ECDSA_POST_DONE_INT_ENA    (BIT(2))
#define ECDSA_POST_DONE_INT_ENA_M  (ECDSA_POST_DONE_INT_ENA_V << ECDSA_POST_DONE_INT_ENA_S)
#define ECDSA_POST_DONE_INT_ENA_V  0x00000001U
#define ECDSA_POST_DONE_INT_ENA_S  2
/** ECDSA_SHA_RELEASE_INT_ENA : R/W; bitpos: [3]; default: 0;
 *  Write 1 to enable the ECDSA_SHA_RELEASE_INT interrupt.
 */
#define ECDSA_SHA_RELEASE_INT_ENA    (BIT(3))
#define ECDSA_SHA_RELEASE_INT_ENA_M  (ECDSA_SHA_RELEASE_INT_ENA_V << ECDSA_SHA_RELEASE_INT_ENA_S)
#define ECDSA_SHA_RELEASE_INT_ENA_V  0x00000001U
#define ECDSA_SHA_RELEASE_INT_ENA_S  3

/** ECDSA_INT_CLR_REG register
 *  ECDSA interrupt clear register
 */
#define ECDSA_INT_CLR_REG (DR_REG_ECDSA_BASE + 0x18)
/** ECDSA_PREP_DONE_INT_CLR : WT; bitpos: [0]; default: 0;
 *  Write 1 to clear the ECDSA_PREP_DONE_INT interrupt.
 */
#define ECDSA_PREP_DONE_INT_CLR    (BIT(0))
#define ECDSA_PREP_DONE_INT_CLR_M  (ECDSA_PREP_DONE_INT_CLR_V << ECDSA_PREP_DONE_INT_CLR_S)
#define ECDSA_PREP_DONE_INT_CLR_V  0x00000001U
#define ECDSA_PREP_DONE_INT_CLR_S  0
/** ECDSA_PROC_DONE_INT_CLR : WT; bitpos: [1]; default: 0;
 *  Write 1 to clear the ECDSA_PROC_DONE_INT interrupt.
 */
#define ECDSA_PROC_DONE_INT_CLR    (BIT(1))
#define ECDSA_PROC_DONE_INT_CLR_M  (ECDSA_PROC_DONE_INT_CLR_V << ECDSA_PROC_DONE_INT_CLR_S)
#define ECDSA_PROC_DONE_INT_CLR_V  0x00000001U
#define ECDSA_PROC_DONE_INT_CLR_S  1
/** ECDSA_POST_DONE_INT_CLR : WT; bitpos: [2]; default: 0;
 *  Write 1 to clear the ECDSA_POST_DONE_INT interrupt.
 */
#define ECDSA_POST_DONE_INT_CLR    (BIT(2))
#define ECDSA_POST_DONE_INT_CLR_M  (ECDSA_POST_DONE_INT_CLR_V << ECDSA_POST_DONE_INT_CLR_S)
#define ECDSA_POST_DONE_INT_CLR_V  0x00000001U
#define ECDSA_POST_DONE_INT_CLR_S  2
/** ECDSA_SHA_RELEASE_INT_CLR : WT; bitpos: [3]; default: 0;
 *  Write 1 to clear the ECDSA_SHA_RELEASE_INT interrupt.
 */
#define ECDSA_SHA_RELEASE_INT_CLR    (BIT(3))
#define ECDSA_SHA_RELEASE_INT_CLR_M  (ECDSA_SHA_RELEASE_INT_CLR_V << ECDSA_SHA_RELEASE_INT_CLR_S)
#define ECDSA_SHA_RELEASE_INT_CLR_V  0x00000001U
#define ECDSA_SHA_RELEASE_INT_CLR_S  3

/** ECDSA_START_REG register
 *  ECDSA start register
 */
#define ECDSA_START_REG (DR_REG_ECDSA_BASE + 0x1c)
/** ECDSA_START : WT; bitpos: [0]; default: 0;
 *  Configures whether to start the ECDSA operation. This bit will be self-cleared
 *  after configuration.
 *  0: No effect
 *  1: Start the ECDSA operation
 */
#define ECDSA_START    (BIT(0))
#define ECDSA_START_M  (ECDSA_START_V << ECDSA_START_S)
#define ECDSA_START_V  0x00000001U
#define ECDSA_START_S  0
/** ECDSA_LOAD_DONE : WT; bitpos: [1]; default: 0;
 *  Write 1 to generate a signal indicating the ECDSA accelerator's LOAD operation is
 *  done. This bit will be self-cleared after configuration.
 */
#define ECDSA_LOAD_DONE    (BIT(1))
#define ECDSA_LOAD_DONE_M  (ECDSA_LOAD_DONE_V << ECDSA_LOAD_DONE_S)
#define ECDSA_LOAD_DONE_V  0x00000001U
#define ECDSA_LOAD_DONE_S  1
/** ECDSA_GET_DONE : WT; bitpos: [2]; default: 0;
 *  Write 1 to generate a signal indicating the ECDSA accelerator's GAIN operation is
 *  done. This bit will be self-cleared after configuration.
 */
#define ECDSA_GET_DONE    (BIT(2))
#define ECDSA_GET_DONE_M  (ECDSA_GET_DONE_V << ECDSA_GET_DONE_S)
#define ECDSA_GET_DONE_V  0x00000001U
#define ECDSA_GET_DONE_S  2

/** ECDSA_STATE_REG register
 *  ECDSA status register
 */
#define ECDSA_STATE_REG (DR_REG_ECDSA_BASE + 0x20)
/** ECDSA_BUSY : RO; bitpos: [1:0]; default: 0;
 *  Represents the working status of the ECDSA accelerator.
 *  0: IDLE
 *  1: LOAD
 *  2: GAIN
 *  3: BUSY
 */
#define ECDSA_BUSY    0x00000003U
#define ECDSA_BUSY_M  (ECDSA_BUSY_V << ECDSA_BUSY_S)
#define ECDSA_BUSY_V  0x00000003U
#define ECDSA_BUSY_S  0

/** ECDSA_RESULT_REG register
 *  ECDSA result register
 */
#define ECDSA_RESULT_REG (DR_REG_ECDSA_BASE + 0x24)
/** ECDSA_OPERATION_RESULT : RO/SS; bitpos: [0]; default: 0;
 *  Indicates if the ECDSA operation is successful.
 *  0: Not successful
 *  1: Successful
 *  Only valid when the ECDSA operation is done.
 */
#define ECDSA_OPERATION_RESULT    (BIT(0))
#define ECDSA_OPERATION_RESULT_M  (ECDSA_OPERATION_RESULT_V << ECDSA_OPERATION_RESULT_S)
#define ECDSA_OPERATION_RESULT_V  0x00000001U
#define ECDSA_OPERATION_RESULT_S  0

/** ECDSA_DATE_REG register
 *  Version control register
 */
#define ECDSA_DATE_REG (DR_REG_ECDSA_BASE + 0xfc)
/** ECDSA_DATE : R/W; bitpos: [27:0]; default: 37761312;
 *  The ECDSA version control register.
 */
#define ECDSA_DATE    0x0FFFFFFFU
#define ECDSA_DATE_M  (ECDSA_DATE_V << ECDSA_DATE_S)
#define ECDSA_DATE_V  0x0FFFFFFFU
#define ECDSA_DATE_S  0

/** ECDSA_SHA_MODE_REG register
 *  ECDSA SHA-control register (Hash algrithm)
 */
#define ECDSA_SHA_MODE_REG (DR_REG_ECDSA_BASE + 0x200)
/** ECDSA_SHA_MODE : R/W; bitpos: [2:0]; default: 0;
 *  Configures SHA algorithms for message hash.
 *  1: SHA-224
 *  2: SHA-256
 *  Others: invalid
 */
#define ECDSA_SHA_MODE    0x00000007U
#define ECDSA_SHA_MODE_M  (ECDSA_SHA_MODE_V << ECDSA_SHA_MODE_S)
#define ECDSA_SHA_MODE_V  0x00000007U
#define ECDSA_SHA_MODE_S  0

/** ECDSA_SHA_START_REG register
 *  ECDSA SHA-control register (operation)
 */
#define ECDSA_SHA_START_REG (DR_REG_ECDSA_BASE + 0x210)
/** ECDSA_SHA_START : WT; bitpos: [0]; default: 0;
 *  Write 1 to start the first SHA operation in the ECDSA process. This bit will be
 *  self-cleared after configuration.
 */
#define ECDSA_SHA_START    (BIT(0))
#define ECDSA_SHA_START_M  (ECDSA_SHA_START_V << ECDSA_SHA_START_S)
#define ECDSA_SHA_START_V  0x00000001U
#define ECDSA_SHA_START_S  0

/** ECDSA_SHA_CONTINUE_REG register
 *  ECDSA SHA-control register (operation)
 */
#define ECDSA_SHA_CONTINUE_REG (DR_REG_ECDSA_BASE + 0x214)
/** ECDSA_SHA_CONTINUE : WT; bitpos: [0]; default: 0;
 *  Write 1 to start the latter SHA operation in the ECDSA process. This bit will be
 *  self-cleared after configuration.
 */
#define ECDSA_SHA_CONTINUE    (BIT(0))
#define ECDSA_SHA_CONTINUE_M  (ECDSA_SHA_CONTINUE_V << ECDSA_SHA_CONTINUE_S)
#define ECDSA_SHA_CONTINUE_V  0x00000001U
#define ECDSA_SHA_CONTINUE_S  0

/** ECDSA_SHA_BUSY_REG register
 *  ECDSA SHA-control status register
 */
#define ECDSA_SHA_BUSY_REG (DR_REG_ECDSA_BASE + 0x218)
/** ECDSA_SHA_BUSY : RO; bitpos: [0]; default: 0;
 *  Represents the working status of the SHA accelerator in the ECDSA process.
 *  0: IDLE
 *  1: BUSY
 */
#define ECDSA_SHA_BUSY    (BIT(0))
#define ECDSA_SHA_BUSY_M  (ECDSA_SHA_BUSY_V << ECDSA_SHA_BUSY_S)
#define ECDSA_SHA_BUSY_V  0x00000001U
#define ECDSA_SHA_BUSY_S  0

/** ECDSA_MESSAGE_MEM register
 *  The memory that stores message.
 */
#define ECDSA_MESSAGE_MEM (DR_REG_ECDSA_BASE + 0x280)
#define ECDSA_MESSAGE_MEM_SIZE_BYTES 32

/** ECDSA_R_MEM register
 *  The memory that stores r.
 */
#define ECDSA_R_MEM (DR_REG_ECDSA_BASE + 0x340)
#define ECDSA_R_MEM_SIZE_BYTES 32

/** ECDSA_S_MEM register
 *  The memory that stores s.
 */
#define ECDSA_S_MEM (DR_REG_ECDSA_BASE + 0x360)
#define ECDSA_S_MEM_SIZE_BYTES 32

/** ECDSA_Z_MEM register
 *  The memory that stores software written z.
 */
#define ECDSA_Z_MEM (DR_REG_ECDSA_BASE + 0x380)
#define ECDSA_Z_MEM_SIZE_BYTES 32

/** ECDSA_QAX_MEM register
 *  The memory that stores x coordinates of QA or software written k.
 */
#define ECDSA_QAX_MEM (DR_REG_ECDSA_BASE + 0x3a0)
#define ECDSA_QAX_MEM_SIZE_BYTES 32

/** ECDSA_QAY_MEM register
 *  The memory that stores y coordinates of QA.
 */
#define ECDSA_QAY_MEM (DR_REG_ECDSA_BASE + 0x3c0)
#define ECDSA_QAY_MEM_SIZE_BYTES 32

#ifdef __cplusplus
}
#endif
