/*
 * SPDX-FileCopyrightText: 2023 Espressif Systems (Shanghai) CO LTD
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 */

static const uint8_t ecc_p192_point_x[] = {
    0x18, 0x8D, 0xA8, 0x0E, 0xB0, 0x30, 0x90, 0xF6,
    0x7C, 0xBF, 0x20, 0xEB, 0x43, 0xA1, 0x88, 0x00,
    0xF4, 0xFF, 0x0A, 0xFD, 0x82, 0xFF, 0x10, 0x12
};

static const uint8_t ecc_p192_point_y[] = {
    0x07, 0x19, 0x2B, 0x95, 0xFF, 0xC8, 0xDA, 0x78,
    0x63, 0x10, 0x11, 0xED, 0x6B, 0x24, 0xCD, 0xD5,
    0x73, 0xF9, 0x77, 0xA1, 0x1E, 0x79, 0x48, 0x11
};

static const uint8_t ecc_p192_scalar[] = {
    0x6f, 0x18, 0x34, 0xeb, 0x16, 0xb7, 0xac, 0x9f,
    0x3c, 0x77, 0x71, 0xb3, 0x02, 0x30, 0x70, 0x48,
    0x75, 0x87, 0xbb, 0x6f, 0x80, 0x34, 0x8d, 0x5e
};

static const uint8_t ecc_p192_mul_res_x[] = {
    0x3F, 0xEE, 0x6F, 0x1F, 0x99, 0xDC, 0xCB, 0x78,
    0xB7, 0x47, 0x1C, 0x2A, 0xF5, 0xA0, 0xAC, 0xE6,
    0xEC, 0x24, 0x82, 0x37, 0x6C, 0xC0, 0x27, 0xC5,
};

static const uint8_t ecc_p192_mul_res_y[] = {
    0xDF, 0xF3, 0x9E, 0x76, 0x24, 0xF4, 0xF6, 0xB4,
    0xF0, 0x0A, 0x18, 0xE1, 0x0B, 0xD2, 0xD9, 0x83,
    0xE8, 0x29, 0x5E, 0xD9, 0x46, 0x54, 0xC3, 0xE1
};

static const uint8_t ecc_p256_point_x[] = {
    0x6B, 0x17, 0xD1, 0xF2, 0xE1, 0x2C, 0x42, 0x47,
    0xF8, 0xBC, 0xE6, 0xE5, 0x63, 0xA4, 0x40, 0xF2,
    0x77, 0x03, 0x7D, 0x81, 0x2D, 0xEB, 0x33, 0xA0,
    0xF4, 0xA1, 0x39, 0x45, 0xD8, 0x98, 0xC2, 0x96
};

static const uint8_t ecc_p256_point_y[] = {
    0x4F, 0xE3, 0x42, 0xE2, 0xFE, 0x1A, 0x7F, 0x9B,
    0x8E, 0xE7, 0xEB, 0x4A, 0x7C, 0x0F, 0x9E, 0x16,
    0x2B, 0xCE, 0x33, 0x57, 0x6B, 0x31, 0x5E, 0xCE,
    0xCB, 0xB6, 0x40, 0x68, 0x37, 0xBF, 0x51, 0xF5
};

static const uint8_t ecc_p256_scalar[] = {
   0xB2, 0xC5, 0x9E, 0x92, 0x64, 0xCD, 0x5F, 0x66,
   0x9E, 0xC8, 0x83, 0x6D, 0x99, 0x61, 0x18, 0x72,
   0xC8, 0x60, 0x83, 0x1E, 0xE5, 0x79, 0xCC, 0x73,
   0xA9, 0xB4, 0x74, 0x85, 0x70, 0x11, 0x2D, 0xA2,
};

static const uint8_t ecc_p256_mul_res_x[] = {
    0x26, 0x1A, 0x0F, 0xBD, 0xA5, 0xE5, 0x1E, 0xE7,
    0xB3, 0xC3, 0xB7, 0x09, 0xD1, 0x4A, 0x7A, 0x2A,
    0x16, 0x69, 0x4B, 0xAF, 0x76, 0x5C, 0xD4, 0x0E,
    0x93, 0x57, 0xB8, 0x67, 0xF9, 0xA1, 0xE5, 0xE8
};

static const uint8_t ecc_p256_mul_res_y[] = {
    0xA0, 0xF4, 0x2E, 0x62, 0x36, 0x25, 0x9F, 0xE0,
    0xF2, 0xA0, 0x41, 0x42, 0xD2, 0x95, 0x89, 0x41,
    0x38, 0xF0, 0xEB, 0x6E, 0xA7, 0x96, 0x29, 0x24,
    0xC7, 0xD4, 0x0C, 0x90, 0xA1, 0xC9, 0xD3, 0x3A
};

static const uint8_t ecc_p256_jacob_mul_res_x_le[] = {
    0x9C, 0x79, 0x11, 0x19, 0x1B, 0x49, 0xAB, 0x51,
    0x5C, 0x57, 0x71, 0x7B, 0x14, 0x4A, 0xD4, 0xA8,
    0x70, 0xEA, 0x0E, 0x7D, 0x3A, 0x20, 0x94, 0x03,
    0xA3, 0x9E, 0x2D, 0x95, 0xAD, 0xC1, 0xD0, 0xB4
};

static const uint8_t ecc_p256_jacob_mul_res_y_le[] = {
    0xA4, 0x46, 0xBA, 0x75, 0x20, 0x19, 0xF2, 0xDB,
    0x5D, 0x99, 0x3F, 0xE3, 0x8C, 0xDF, 0xFE, 0x6E,
    0xD9, 0x1F, 0x63, 0x63, 0xDB, 0x6F, 0xD6, 0xAF,
    0xE8, 0x5E, 0xED, 0x4F, 0x99, 0x05, 0x3C, 0x5A
};

static const uint8_t ecc_p256_jacob_mul_res_z_le[] = {
    0x7C, 0x7A, 0xB4, 0xBA, 0xD4, 0xB7, 0x86, 0xEB,
    0xDA, 0x79, 0x0F, 0xA1, 0xA8, 0xAB, 0x6A, 0xAB,
    0xCB, 0xF9, 0x05, 0xBE, 0x5C, 0x90, 0x15, 0x0E,
    0xA7, 0x2D, 0x6F, 0x0C, 0xAE, 0x68, 0xBB, 0x4A
};

static const uint8_t ecc_p192_jacob_mul_res_x_le[] = {
    0xE1, 0xB5, 0x3E, 0xB2, 0x85, 0xCA, 0x93, 0x25,
    0xCA, 0xB1, 0x6B, 0xCF, 0xC3, 0x6E, 0xB7, 0x66,
    0x9C, 0xB4, 0x83, 0x98, 0x8E, 0x7A, 0xA1, 0x55
};

static const uint8_t ecc_p192_jacob_mul_res_y_le[] = {
    0xC7, 0xD3, 0xEA, 0x97, 0x87, 0x92, 0x98, 0xE5,
    0xA5, 0x30, 0xB1, 0xE4, 0x92, 0xD9, 0x71, 0x11,
    0x16, 0x63, 0x37, 0x56, 0x8D, 0xB1, 0xD4, 0xB8
};

static const uint8_t ecc_p192_jacob_mul_res_z_le[] = {
    0xD1, 0xA5, 0x8D, 0x76, 0x17, 0x7B, 0xB3, 0x9F,
    0x0D, 0x78, 0x1B, 0x36, 0x59, 0x18, 0xD0, 0xF1,
    0x38, 0x8C, 0xD7, 0x13, 0xCB, 0x7A, 0x9B, 0xBF
};

/* Little endian */
static const uint8_t ecc256_num[] = {
    0x20, 0x56, 0x14, 0xB6, 0xAF, 0x94, 0xA0, 0xB6,
    0x0C, 0xDF, 0x13, 0x1A, 0xE6, 0xBF, 0x57, 0x87,
    0xF1, 0x02, 0x73, 0x96, 0x53, 0x1A, 0xBC, 0xA9,
    0x0F, 0x5E, 0xA1, 0xFC, 0x0E, 0xFC, 0x9D, 0x9B
};

/* Little endian */
static const uint8_t ecc256_den[] = {
    0x54, 0x3B, 0x11, 0x78, 0xC4, 0xCA, 0x52, 0xFD,
    0xCC, 0x89, 0x51, 0x0F, 0xFE, 0x7D, 0x37, 0x83,
    0x81, 0xD5, 0x2E, 0x58, 0x42, 0xF9, 0x4F, 0x19,
    0x9A, 0x79, 0x78, 0x98, 0xFA, 0x95, 0x40, 0x2E
};

/* Little endian */
static const uint8_t ecc256_inv_mul_res[] = {
    0x33, 0xF3, 0x55, 0x3B, 0x46, 0x8A, 0x13, 0xC0,
    0x1D, 0x7E, 0x41, 0xA6, 0xFF, 0x53, 0xFD, 0x78,
    0xD5, 0xC0, 0xE5, 0x9F, 0x78, 0xD1, 0x86, 0x66,
    0x77, 0x3C, 0x6E, 0xEF, 0x58, 0xF6, 0x29, 0x34
};

static const uint8_t ecc192_num[] = {
    0xBA, 0x0F, 0x2C, 0xD8, 0xBE, 0xCC, 0x2D, 0xD3,
    0xD5, 0x74, 0xBD, 0x8C, 0xF3, 0x3E, 0x3B, 0x7A,
    0xA4, 0xD0, 0x71, 0xEC, 0x85, 0xF6, 0x70, 0x00
};

static const uint8_t ecc192_den[] = {
    0x15, 0xF9, 0x20, 0xD8, 0x46, 0x5C, 0x03, 0x97,
    0x4A, 0x10, 0xEF, 0x8A, 0xFB, 0x12, 0x2E, 0x65,
    0x6E, 0xD6, 0x79, 0x1E, 0x65, 0x6F, 0x3E, 0x64
};

static const uint8_t ecc192_inv_mul_res[] = {
    0x6B, 0xB3, 0x6B, 0x2B, 0x56, 0x6A, 0xE5, 0xF7,
    0x75, 0x82, 0xF0, 0xCC, 0x93, 0x63, 0x40, 0xF8,
    0xEF, 0x35, 0x2A, 0xAF, 0xBD, 0x56, 0xE9, 0x29
};

/* Little endian */
static const uint8_t ecc256_x[] = {
    0x96, 0xC2, 0x98, 0xD8, 0x45, 0x39, 0xA1, 0xF4,
    0xA0, 0x33, 0xEB, 0x2D, 0x81, 0x7D, 0x03, 0x77,
    0xF2, 0x40, 0xA4, 0x63, 0xE5, 0xE6, 0xBC, 0xF8,
    0x47, 0x42, 0x2C, 0xE1, 0xF2, 0xD1, 0x17, 0x6B
};

/* Little endian */
static const uint8_t ecc256_y[] = {
    0xF5, 0x51, 0xBF, 0x37, 0x68, 0x40, 0xB6, 0xCB,
    0xCE, 0x5E, 0x31, 0x6B, 0x57, 0x33, 0xCE, 0x2B,
    0x16, 0x9E, 0x0F, 0x7C, 0x4A, 0xEB, 0xE7, 0x8E,
    0x9B, 0x7F, 0x1A, 0xFE, 0xE2, 0x42, 0xE3, 0x4F
};

/* Little endian */
static const uint8_t ecc256_add_res[] = {
    0x8B, 0x14, 0x58, 0x10, 0xAE, 0x79, 0x57, 0xC0,
    0x6F, 0x92, 0x1C, 0x99, 0xD8, 0xB0, 0xD1, 0xA2,
    0x08, 0xDF, 0xB3, 0xDF, 0x2F, 0xD2, 0xA4, 0x87,
    0xE3, 0xC1, 0x46, 0xDF, 0xD5, 0x14, 0xFB, 0xBA
};

/* Little endian */
static const uint8_t ecc256_sub_res[] = {
    0xA1, 0x70, 0xD9, 0xA0, 0xDD, 0xF8, 0xEA, 0x28,
    0xD2, 0xD4, 0xB9, 0xC2, 0x29, 0x4A, 0x35, 0x4B,
    0xDC, 0xA2, 0x94, 0xE7, 0x9A, 0xFB, 0xD4, 0x69,
    0xAC, 0xC2, 0x11, 0xE3, 0x0F, 0x8F, 0x34, 0x1B
};

/* Little endian */
static const uint8_t ecc256_mul_res[] = {
    0x18, 0x4D, 0xCE, 0xCC, 0x1A, 0xA8, 0xEC, 0x72,
    0xD7, 0x31, 0xDA, 0x41, 0x8C, 0x75, 0x6B, 0xF1,
    0x2A, 0x2E, 0x5B, 0x53, 0x8D, 0xCA, 0x79, 0x61,
    0x6B, 0x46, 0xF9, 0x2E, 0x27, 0xB5, 0x43, 0x15
};

static const uint8_t ecc192_x[] = {
    0x1A, 0x80, 0xA1, 0x5F, 0x1F, 0xB7, 0x59, 0x1B,
    0x9F, 0xD7, 0xFB, 0xAE, 0xA9, 0xF9, 0x1E, 0xBA,
    0x67, 0xAE, 0x57, 0xB7, 0x27, 0x80, 0x9E, 0x1A
};

static const uint8_t ecc192_y[] = {
    0x59, 0xC6, 0x3D, 0xD3, 0xD7, 0xDF, 0xA3, 0x44,
    0x7C, 0x75, 0x52, 0xB4, 0x42, 0xF3, 0xFC, 0xA6,
    0x0F, 0xA8, 0x8A, 0x8D, 0x1F, 0xA3, 0xDF, 0x54
};

static const uint8_t ecc192_add_res[] = {
    0x73, 0x46, 0xDF, 0x32, 0xF7, 0x96, 0xFD, 0x5F,
    0x1B, 0x4D, 0x4E, 0x63, 0xEC, 0xEC, 0x1B, 0x61,
    0x77, 0x56, 0xE2, 0x44, 0x47, 0x23, 0x7E, 0x6F
};

static const uint8_t ecc192_sub_res[] = {
    0xF2, 0xE1, 0x35, 0x41, 0xF9, 0xA0, 0x21, 0xEB,
    0x58, 0x5A, 0x88, 0x94, 0x66, 0x06, 0x22, 0x13,
    0x58, 0x06, 0xCD, 0x29, 0x08, 0xDD, 0xBE, 0xC5
};

static const uint8_t ecc192_mul_res[] = {
    0xB5, 0xB9, 0xFF, 0xBC, 0x52, 0xC8, 0xB8, 0x36,
    0x8C, 0xFB, 0xA5, 0xCE, 0x1E, 0x7B, 0xE6, 0xF3,
    0x8F, 0x79, 0x71, 0xCF, 0xD6, 0xF3, 0x41, 0xE6
};
