/*
 * SPDX-FileCopyrightText: 2025 Espressif Systems (Shanghai) CO LTD
 *
 * SPDX-License-Identifier: Apache-2.0
 */
#include "soc/soc_caps.h"
#include "sdkconfig.h"

#if SOC_CPU_HAS_FPU || SOC_CPU_HAS_PIE
const char target_xml[] =
"<?xml version=\"1.0\"?>"
"<!DOCTYPE target SYSTEM \"gdb-target.dtd\">"
"<target>"
"<architecture>riscv</architecture>"
"<feature name=\"org.gnu.gdb.riscv.cpu\">"
"<reg name=\"zero\" bitsize=\"32\"/>"
"<reg name=\"ra\" bitsize=\"32\" type=\"code_ptr\"/>"
"<reg name=\"sp\" bitsize=\"32\" type=\"data_ptr\"/>"
"<reg name=\"gp\" bitsize=\"32\" type=\"data_ptr\"/>"
"<reg name=\"tp\" bitsize=\"32\" type=\"data_ptr\"/>"
"<reg name=\"t0\" bitsize=\"32\"/>"
"<reg name=\"t1\" bitsize=\"32\"/>"
"<reg name=\"t2\" bitsize=\"32\"/>"
"<reg name=\"fp\" bitsize=\"32\" type=\"data_ptr\"/>"
"<reg name=\"s1\" bitsize=\"32\"/>"
"<reg name=\"a0\" bitsize=\"32\"/>"
"<reg name=\"a1\" bitsize=\"32\"/>"
"<reg name=\"a2\" bitsize=\"32\"/>"
"<reg name=\"a3\" bitsize=\"32\"/>"
"<reg name=\"a4\" bitsize=\"32\"/>"
"<reg name=\"a5\" bitsize=\"32\"/>"
"<reg name=\"a6\" bitsize=\"32\"/>"
"<reg name=\"a7\" bitsize=\"32\"/>"
"<reg name=\"s2\" bitsize=\"32\"/>"
"<reg name=\"s3\" bitsize=\"32\"/>"
"<reg name=\"s4\" bitsize=\"32\"/>"
"<reg name=\"s5\" bitsize=\"32\"/>"
"<reg name=\"s6\" bitsize=\"32\"/>"
"<reg name=\"s7\" bitsize=\"32\"/>"
"<reg name=\"s8\" bitsize=\"32\"/>"
"<reg name=\"s9\" bitsize=\"32\"/>"
"<reg name=\"s10\" bitsize=\"32\"/>"
"<reg name=\"s11\" bitsize=\"32\"/>"
"<reg name=\"t3\" bitsize=\"32\"/>"
"<reg name=\"t4\" bitsize=\"32\"/>"
"<reg name=\"t5\" bitsize=\"32\"/>"
"<reg name=\"t6\" bitsize=\"32\"/>"
"<reg name=\"pc\" bitsize=\"32\" type=\"code_ptr\"/>"
"</feature>"
#if SOC_CPU_HAS_FPU
"<feature name=\"org.gnu.gdb.riscv.fpu\">"
"<reg name=\"ft0\" bitsize=\"32\" type=\"float\"/>"
"<reg name=\"ft1\" bitsize=\"32\" type=\"float\"/>"
"<reg name=\"ft2\" bitsize=\"32\" type=\"float\"/>"
"<reg name=\"ft3\" bitsize=\"32\" type=\"float\"/>"
"<reg name=\"ft4\" bitsize=\"32\" type=\"float\"/>"
"<reg name=\"ft5\" bitsize=\"32\" type=\"float\"/>"
"<reg name=\"ft6\" bitsize=\"32\" type=\"float\"/>"
"<reg name=\"ft7\" bitsize=\"32\" type=\"float\"/>"
"<reg name=\"fs0\" bitsize=\"32\" type=\"float\"/>"
"<reg name=\"fs1\" bitsize=\"32\" type=\"float\"/>"
"<reg name=\"fa0\" bitsize=\"32\" type=\"float\"/>"
"<reg name=\"fa1\" bitsize=\"32\" type=\"float\"/>"
"<reg name=\"fa2\" bitsize=\"32\" type=\"float\"/>"
"<reg name=\"fa3\" bitsize=\"32\" type=\"float\"/>"
"<reg name=\"fa4\" bitsize=\"32\" type=\"float\"/>"
"<reg name=\"fa5\" bitsize=\"32\" type=\"float\"/>"
"<reg name=\"fa6\" bitsize=\"32\" type=\"float\"/>"
"<reg name=\"fa7\" bitsize=\"32\" type=\"float\"/>"
"<reg name=\"fs2\" bitsize=\"32\" type=\"float\"/>"
"<reg name=\"fs3\" bitsize=\"32\" type=\"float\"/>"
"<reg name=\"fs4\" bitsize=\"32\" type=\"float\"/>"
"<reg name=\"fs5\" bitsize=\"32\" type=\"float\"/>"
"<reg name=\"fs6\" bitsize=\"32\" type=\"float\"/>"
"<reg name=\"fs7\" bitsize=\"32\" type=\"float\"/>"
"<reg name=\"fs8\" bitsize=\"32\" type=\"float\"/>"
"<reg name=\"fs9\" bitsize=\"32\" type=\"float\"/>"
"<reg name=\"fs10\" bitsize=\"32\" type=\"float\"/>"
"<reg name=\"fs11\" bitsize=\"32\" type=\"float\"/>"
"<reg name=\"ft8\" bitsize=\"32\" type=\"float\"/>"
"<reg name=\"ft9\" bitsize=\"32\" type=\"float\"/>"
"<reg name=\"ft10\" bitsize=\"32\" type=\"float\"/>"
"<reg name=\"ft11\" bitsize=\"32\" type=\"float\"/>"
"<reg name=\"fcsr\" bitsize=\"32\" regnum=\"68\"/>"
"</feature>"
#endif /* SOC_CPU_HAS_FPU */
#if SOC_CPU_HAS_PIE
"<feature name=\"org.gnu.gdb.riscv.xesppie\">"
"<vector id=\"v5i8\" type=\"int8\" count=\"5\"/>"
"<vector id=\"v3i8\" type=\"int8\" count=\"3\"/>"
"<vector id=\"v4i32\" type=\"int32\" count=\"4\"/>"
"<vector id=\"v2i64\" type=\"int64\" count=\"2\"/>"
"<union id=\"vec128\">"
"<field name=\"v4_int32\" type=\"v4i32\"/>"
"<field name=\"v2_int64\" type=\"v2i64\"/>"
"<field name=\"uint128\" type=\"uint128\"/>"
"</union>"
"<reg name=\"q0\" bitsize=\"128\" type=\"vec128\" group=\"vector\" regnum=\"4211\"/>"
"<reg name=\"q1\" bitsize=\"128\" type=\"vec128\" group=\"vector\"/>"
"<reg name=\"q2\" bitsize=\"128\" type=\"vec128\" group=\"vector\"/>"
"<reg name=\"q3\" bitsize=\"128\" type=\"vec128\" group=\"vector\"/>"
"<reg name=\"q4\" bitsize=\"128\" type=\"vec128\" group=\"vector\"/>"
"<reg name=\"q5\" bitsize=\"128\" type=\"vec128\" group=\"vector\"/>"
"<reg name=\"q6\" bitsize=\"128\" type=\"vec128\" group=\"vector\"/>"
"<reg name=\"q7\" bitsize=\"128\" type=\"vec128\" group=\"vector\"/>"
"<reg name=\"qacc_l_l\" bitsize=\"128\" type=\"vec128\" group=\"vector\"/>"
"<reg name=\"qacc_l_h\" bitsize=\"128\" type=\"vec128\" group=\"vector\"/>"
"<reg name=\"qacc_h_l\" bitsize=\"128\" type=\"vec128\" group=\"vector\"/>"
"<reg name=\"qacc_h_h\" bitsize=\"128\" type=\"vec128\" group=\"vector\"/>"
"<reg name=\"ua_state\" bitsize=\"128\" type=\"vec128\" group=\"vector\"/>"
"<reg name=\"xacc\" bitsize=\"40\" type=\"v5i8\" group=\"vector\"/>"
"<reg name=\"misc\" bitsize=\"24\" type=\"v3i8\" group=\"vector\"/>" /* make GDB happy about "Truncated register 4207 in remote 'g' packet" */
"</feature>"
#endif /* SOC_CPU_HAS_PIE */
"</target>";
#endif
