# SPDX-FileCopyrightText: 2025 Espressif Systems (Shanghai) CO LTD
# SPDX-License-Identifier: Apache-2.0
"""
用于适配标准化打印
file_path: /usr/include/inttypes.h
"""

__PRI64_PREFIX = 'll'
__PRIPTR_PREFIX = ''

TYPES_MACRO_MAP = {
    'PRId8': 'd',
    'PRId16': 'd',
    'PRId32': 'd',
    'PRId64': __PRI64_PREFIX + 'd',
    'PRIdLEAST8': 'd',
    'PRIdLEAST16': 'd',
    'PRIdLEAST32': 'd',
    'PRIdLEAST64': __PRI64_PREFIX + 'd',
    'PRIdFAST8': 'd',
    'PRIdFAST16': __PRIPTR_PREFIX + 'd',
    'PRIdFAST32': __PRIPTR_PREFIX + 'd',
    'PRIdFAST64': __PRI64_PREFIX + 'd',
    'PRIi8': 'i',
    'PRIi16': 'i',
    'PRIi32': 'i',
    'PRIi64': __PRI64_PREFIX + 'i',
    'PRIiLEAST8': 'i',
    'PRIiLEAST16': 'i',
    'PRIiLEAST32': 'i',
    'PRIiLEAST64': __PRI64_PREFIX + 'i',
    'PRIiFAST8': 'i',
    'PRIiFAST16': __PRIPTR_PREFIX + 'i',
    'PRIiFAST32': __PRIPTR_PREFIX + 'i',
    'PRIiFAST64': __PRI64_PREFIX + 'i',
    'PRIo8': 'o',
    'PRIo16': 'o',
    'PRIo32': 'o',
    'PRIo64': __PRI64_PREFIX + 'o',
    'PRIoLEAST8': 'o',
    'PRIoLEAST16': 'o',
    'PRIoLEAST32': 'o',
    'PRIoLEAST64': __PRI64_PREFIX + 'o',
    'PRIoFAST8': 'o',
    'PRIoFAST16': __PRIPTR_PREFIX + 'o',
    'PRIoFAST32': __PRIPTR_PREFIX + 'o',
    'PRIoFAST64': __PRI64_PREFIX + 'o',
    'PRIu8': 'u',
    'PRIu16': 'u',
    'PRIu32': 'u',
    'PRIu64': __PRI64_PREFIX + 'u',
    'PRIuLEAST8': 'u',
    'PRIuLEAST16': 'u',
    'PRIuLEAST32': 'u',
    'PRIuLEAST64': __PRI64_PREFIX + 'u',
    'PRIuFAST8': 'u',
    'PRIuFAST16': __PRIPTR_PREFIX + 'u',
    'PRIuFAST32': __PRIPTR_PREFIX + 'u',
    'PRIuFAST64': __PRI64_PREFIX + 'u',
    'PRIx8': 'x',
    'PRIx16': 'x',
    'PRIx32': 'x',
    'PRIx64': __PRI64_PREFIX + 'x',
    'PRIxLEAST8': 'x',
    'PRIxLEAST16': 'x',
    'PRIxLEAST32': 'x',
    'PRIxLEAST64': __PRI64_PREFIX + 'x',
    'PRIxFAST8': 'x',
    'PRIxFAST16': __PRIPTR_PREFIX + 'x',
    'PRIxFAST32': __PRIPTR_PREFIX + 'x',
    'PRIxFAST64': __PRI64_PREFIX + 'x',
    'PRIX8': 'X',
    'PRIX16': 'X',
    'PRIX32': 'X',
    'PRIX64': __PRI64_PREFIX + 'X',
    'PRIXLEAST8': 'X',
    'PRIXLEAST16': 'X',
    'PRIXLEAST32': 'X',
    'PRIXLEAST64': __PRI64_PREFIX + 'X',
    'PRIXFAST8': 'X',
    'PRIXFAST16': __PRIPTR_PREFIX + 'X',
    'PRIXFAST32': __PRIPTR_PREFIX + 'X',
    'PRIXFAST64': __PRI64_PREFIX + 'X',
    'PRIdMAX': __PRI64_PREFIX + 'd',
    'PRIiMAX': __PRI64_PREFIX + 'i',
    'PRIoMAX': __PRI64_PREFIX + 'o',
    'PRIuMAX': __PRI64_PREFIX + 'u',
    'PRIxMAX': __PRI64_PREFIX + 'x',
    'PRIXMAX': __PRI64_PREFIX + 'X',
    'PRIdPTR': __PRIPTR_PREFIX + 'd',
    'PRIiPTR': __PRIPTR_PREFIX + 'i',
    'PRIoPTR': __PRIPTR_PREFIX + 'o',
    'PRIuPTR': __PRIPTR_PREFIX + 'u',
    'PRIxPTR': __PRIPTR_PREFIX + 'x',
    'PRIXPTR': __PRIPTR_PREFIX + 'X',
    'SCNd8': 'hhd',
    'SCNd16': 'hd',
    'SCNd32': 'd',
    'SCNd64': __PRI64_PREFIX + 'd',
    'SCNdLEAST8': 'hhd',
    'SCNdLEAST16': 'hd',
    'SCNdLEAST32': 'd',
    'SCNdLEAST64': __PRI64_PREFIX + 'd',
    'SCNdFAST8': 'hhd',
    'SCNdFAST16': __PRIPTR_PREFIX + 'd',
    'SCNdFAST32': __PRIPTR_PREFIX + 'd',
    'SCNdFAST64': __PRI64_PREFIX + 'd',
    'SCNi8': 'hhi',
    'SCNi16': 'hi',
    'SCNi32': 'i',
    'SCNi64': __PRI64_PREFIX + 'i',
    'SCNiLEAST8': 'hhi',
    'SCNiLEAST16': 'hi',
    'SCNiLEAST32': 'i',
    'SCNiLEAST64': __PRI64_PREFIX + 'i',
    'SCNiFAST8': 'hhi',
    'SCNiFAST16': __PRIPTR_PREFIX + 'i',
    'SCNiFAST32': __PRIPTR_PREFIX + 'i',
    'SCNiFAST64': __PRI64_PREFIX + 'i',
    'SCNu8': 'hhu',
    'SCNu16': 'hu',
    'SCNu32': 'u',
    'SCNu64': __PRI64_PREFIX + 'u',
    'SCNuLEAST8': 'hhu',
    'SCNuLEAST16': 'hu',
    'SCNuLEAST32': 'u',
    'SCNuLEAST64': __PRI64_PREFIX + 'u',
    'SCNuFAST8': 'hhu',
    'SCNuFAST16': __PRIPTR_PREFIX + 'u',
    'SCNuFAST32': __PRIPTR_PREFIX + 'u',
    'SCNuFAST64': __PRI64_PREFIX + 'u',
    'SCNo8': 'hho',
    'SCNo16': 'ho',
    'SCNo32': 'o',
    'SCNo64': __PRI64_PREFIX + 'o',
    'SCNoLEAST8': 'hho',
    'SCNoLEAST16': 'ho',
    'SCNoLEAST32': 'o',
    'SCNoLEAST64': __PRI64_PREFIX + 'o',
    'SCNoFAST8': 'hho',
    'SCNoFAST16': __PRIPTR_PREFIX + 'o',
    'SCNoFAST32': __PRIPTR_PREFIX + 'o',
    'SCNoFAST64': __PRI64_PREFIX + 'o',
    'SCNx8': 'hhx',
    'SCNx16': 'hx',
    'SCNx32': 'x',
    'SCNx64': __PRI64_PREFIX + 'x',
    'SCNxLEAST8': 'hhx',
    'SCNxLEAST16': 'hx',
    'SCNxLEAST32': 'x',
    'SCNxLEAST64': __PRI64_PREFIX + 'x',
    'SCNxFAST8': 'hhx',
    'SCNxFAST16': __PRIPTR_PREFIX + 'x',
    'SCNxFAST32': __PRIPTR_PREFIX + 'x',
    'SCNxFAST64': __PRI64_PREFIX + 'x',
    'SCNdMAX': __PRI64_PREFIX + 'd',
    'SCNiMAX': __PRI64_PREFIX + 'i',
    'SCNoMAX': __PRI64_PREFIX + 'o',
    'SCNuMAX': __PRI64_PREFIX + 'u',
    'SCNxMAX': __PRI64_PREFIX + 'x',
    'SCNdPTR': __PRIPTR_PREFIX + 'd',
    'SCNiPTR': __PRIPTR_PREFIX + 'i',
    'SCNoPTR': __PRIPTR_PREFIX + 'o',
    'SCNuPTR': __PRIPTR_PREFIX + 'u',
    'SCNxPTR': __PRIPTR_PREFIX + 'x',
}
