// English language pack
export default {
  // TabBar
  'tabBar.home': 'Home',
  'tabBar.deviceConfig': 'Network Config',
  'tabBar.settings': 'System',
  // Settings page title
  'settings.title': 'Settings',
  // Login page
  'login.pageTitle': 'Login',
  'login.navigationTitle': 'Login',
  'login.fetchConfigError': 'Failed to fetch configuration:',
  'login.selectLanguage': 'Select Language',
  'login.selectLanguageTip': '中文',
  'login.welcomeBack': 'Welcome Back',
  'login.pleaseLogin': 'Please log in to your account',
  'login.enterUsername': 'Please enter username',
  'login.enterPassword': 'Please enter password',
  'login.enterCaptcha': 'Please enter verification code',
  'login.loginButton': 'Login',
  'login.loggingIn': 'Logging in...',
  'login.noAccount': 'Sign Up',
  'login.enterPhone': 'Please enter phone number',
  'login.selectCountry': 'Select Country/Region',
  'login.confirm': 'Confirm',
  'login.serverSetting': 'Server Settings',
  'login.requiredUsername': 'Username cannot be empty',
  'login.requiredPassword': 'Password cannot be empty',
  'login.requiredCaptcha': 'Verification code cannot be empty',
  'login.requiredMobile': 'Please enter a valid phone number',
  'login.captchaError': 'Graphic verification code error',
  'login.forgotPassword': 'Forgot Password',

  // Register page
  'register.pageTitle': 'Register',
  'register.createAccount': 'Create Account',
  'register.enterUsername': 'Please enter username',
  'register.enterPassword': 'Please enter password',
  'register.confirmPassword': 'Please confirm password',
  'register.enterPhone': 'Please enter phone number',
  'register.enterCode': 'Please enter verification code',
  'register.getCode': 'Get Code',
  'register.agreeTerms': 'I have read and agree to the',
  'register.terms': 'User Agreement',
  'register.privacy': 'Privacy Policy',
  'register.registerButton': 'Register',
  'register.registering': 'Registering...',
  'register.haveAccount': 'Already have an account?',
  'register.loginNow': 'Login Now',
  'register.selectCountry': 'Select Country/Region',
  'register.confirm': 'Confirm',
  'register.captchaSendSuccess': 'Verification code sent successfully',

  // Home page
  'home.pageTitle': 'Home',
  'home.createAgent': 'Create Agent',
  'home.agentName': 'Agent',
  'home.modelInfo': 'Model Info',
  'home.lastActive': 'Last Active',
  'home.greeting': 'Hi Jarvis',
  'home.subtitle': 'Let\'s have',
  'home.wonderfulDay': 'a wonderful day!',
  'home.emptyState': 'No agents available',
  'home.deviceManagement': 'Device Management',
  'home.lastConversation': 'Last Conversation:',
  'home.delete': 'Delete',
  'home.createFirstAgent': 'Click the + button in the lower right corner to create your first agent',
  'home.dialogTitle': 'Create Agent',
  'home.inputPlaceholder': 'e.g. Customer Service Assistant, Voice Assistant, Knowledge Q&A',
  'home.createError': 'Please input agent name',
  'home.createNow': 'Create Now',
  'home.justNow': 'Just now',
  'home.minutesAgo': 'minutes ago',
  'home.hoursAgo': 'hours ago',
  'home.daysAgo': 'days ago',

  // Agent page
  'agent.pageTitle': 'Agent',
  'agent.roleConfig': 'Role Configuration',
  'agent.deviceManagement': 'Device Management',
  'agent.chatHistory': 'Chat History',
  'agent.voiceprintManagement': 'Voiceprint Management',
  'agent.editTitle': 'Edit Agent',
  'agent.toolsTitle': 'Edit Features',
  'agent.voiceActivityDetection': 'Voice Activity Detection',
  'agent.speechRecognition': 'Speech Recognition',
  'agent.largeLanguageModel': 'Large Language Model',
  'agent.save': 'Save',
  'agent.cancel': 'Cancel',
  // Agent Edit Page
  'agent.basicInfo': 'Basic Information',
  'agent.agentName': 'Agent Name',
  'agent.inputAgentName': 'Please input agent name',
  'agent.roleMode': 'Role Mode',
  'agent.roleDescription': 'Role Description',
  'agent.inputRoleDescription': 'Please input role description',
  'agent.modelConfig': 'Model Configuration',
  'agent.vad': 'Voice Activity Detection',
  'agent.asr': 'Speech Recognition',
  'agent.llm': 'Large Language Model',
  'agent.vllm': 'Vision Language Model',
  'agent.intent': 'Intent Recognition',
  'agent.memory': 'Memory',
  'agent.voiceSettings': 'Voice Settings',
  'agent.tts': 'Text-to-Speech',
  'agent.voiceprint': 'Agent Voice',
  'agent.plugins': 'Plugins',
  'agent.editFunctions': 'Edit Functions',
  'agent.historyMemory': 'History Memory',
  'agent.memoryContent': 'Memory content',
  'agent.saving': 'Saving...',
  'agent.saveSuccess': 'Save successful',
  'agent.saveFail': 'Save failed',
  'agent.loadFail': 'Load failed',
  'agent.pleaseInputAgentName': 'Please input agent name',
  'agent.pleaseInputRoleDescription': 'Please input role description',
  'agent.pleaseSelect': 'Please select',

  // Chat History Page
  'chatHistory.getChatSessions': 'Get chat session list',
  'chatHistory.noSelectedAgent': 'No agent selected',
  'chatHistory.getChatSessionsFailed': 'Failed to get chat session list:',
  'chatHistory.unknownTime': 'Unknown time',
  'chatHistory.justNow': 'Just now',
  'chatHistory.minutesAgo': '{minutes} minutes ago',
  'chatHistory.hoursAgo': '{hours} hours ago',
  'chatHistory.daysAgo': '{days} days ago',
  'chatHistory.conversationRecord': 'Conversation Record',
  'chatHistory.totalChats': '{count} chats in total',
  'chatHistory.loading': 'Loading...',
  'chatHistory.noMoreData': 'No more data',
  'chatHistory.noChatRecords': 'No chat records',
  'chatRecordsDescription': 'Conversation records with agents will be displayed here',
  // Chat History Detail Page
  'chatHistory.pageTitle': 'Chat Detail',
  'chatHistory.assistantName': 'Intelligent Assistant',
  'chatHistory.userName': 'User',
  'chatHistory.aiAssistantName': 'AI Assistant',
  'chatHistory.loadFailed': 'Failed to load chat history',
  'chatHistory.parameterError': 'Page parameter error',
  'chatHistory.invalidAudioId': 'Invalid audio ID',
  'chatHistory.audioPlayFailed': 'Audio playback failed',
  'chatHistory.playAudioFailed': 'Failed to play audio',

  // Device management page
  'device.pageTitle': 'Device Management',
  'device.noDevices': 'No devices available',
  'device.macAddress': 'MAC Address',
  'device.firmwareVersion': 'Firmware Version',
  'device.lastConnected': 'Last Conversation',
  'device.otaUpdate': 'OTA Update',
  'device.unbind': 'Unbind',
  'device.confirmUnbind': 'Sure',
  'device.bindDevice': 'Bind New Device',
  'device.deviceType': 'Device Type',
  'device.loading': 'Loading...',
  'device.neverConnected': 'Never connected',
  'device.justNow': 'Just now',
  'device.minutesAgo': '{minutes} minutes ago',
  'device.hoursAgo': '{hours} hours ago',
  'device.daysAgo': '{days} days ago',
  'device.otaAutoUpdateEnabled': 'OTA auto update enabled',
  'device.otaAutoUpdateDisabled': 'OTA auto update disabled',
  'device.operationFailed': 'Operation failed, please retry',
  'device.deviceUnbound': 'Device unbound',
  'device.unbindFailed': 'Unbind failed, please retry',
  'device.unbindDevice': 'Unbind Device',
  'device.confirmUnbindDevice': 'Are you sure you want to unbind device "{macAddress}"?',
  'device.cancel': 'Cancel',
  'device.noDevice': 'No Device',
  'device.pleaseSelectAgent': 'Please select an agent first',
  'device.deviceBindSuccess': 'Device bound successfully!',
  'device.bindFailed': 'Bind failed, please check if the verification code is correct',
  'device.enterDeviceCode': 'Please enter device verification code',
  'device.bindNow': 'Bind Now',
  'device.lastConnection': 'Last Connection',
  'device.clickToBindFirstDevice': 'Click the + button in the lower right corner to bind your first device',

  // Common
  'common.success': 'Success',
  'common.fail': 'Failed',
  'common.loading': 'Loading...',
  'common.confirm': 'Confirm',
  'common.cancel': 'Cancel',
  'common.delete': 'Delete',
  'common.edit': 'Edit',
  'common.add': 'Add',
  'common.pleaseSelect': 'Please select',
  'common.unknownError': 'Unknown error',
  'common.networkError': 'Network error',

  // Retrieve Password page
  'retrievePassword.title': 'Reset Password',
  'retrievePassword.subtitle': 'Recover your account password via mobile number',
  'retrievePassword.mobileRequired': 'Please enter mobile number',
  'retrievePassword.inputCorrectMobile': 'Please enter a valid mobile number',
  'retrievePassword.captchaRequired': 'Please enter graphic verification code',
  'retrievePassword.mobileCaptchaRequired': 'Please enter SMS verification code',
  'retrievePassword.newPasswordRequired': 'Please enter new password',
  'retrievePassword.confirmNewPasswordRequired': 'Please confirm new password',
  'retrievePassword.passwordsNotMatch': 'Passwords do not match',
  'retrievePassword.mobilePlaceholder': 'Please enter mobile number',
  'retrievePassword.captchaPlaceholder': 'Please enter graphic verification code',
  'retrievePassword.mobileCaptchaPlaceholder': 'Please enter SMS verification code',
  'retrievePassword.newPasswordPlaceholder': 'Please enter new password',
  'retrievePassword.confirmNewPasswordPlaceholder': 'Please confirm new password',
  'retrievePassword.getMobileCaptcha': 'Get Code',
  'retrievePassword.captchaSendSuccess': 'Verification code sent successfully',
  'retrievePassword.passwordUpdateSuccess': 'Password reset successfully',
  'retrievePassword.resetButton': 'Reset Password',
  'retrievePassword.goToLogin': 'Back to Login',

  // SM2 encryption related error messages
  'sm2.publicKeyNotConfigured': 'SM2 public key not configured, please contact administrator',
  'sm2.encryptionFailed': 'Password encryption failed',
  'sm2.keyGenerationFailed': 'Key pair generation failed',
  'sm2.invalidPublicKey': 'Invalid public key format',
  'sm2.encryptionError': 'Error occurred during encryption',
  'sm2.publicKeyRetry': 'Retrying to get public key...',
  'sm2.publicKeyRetryFailed': 'Public key retrieval retry failed',

  // Voiceprint page
  'voiceprint.noSelectedAgent': 'No agent selected',
  'voiceprint.pleaseSelectAgent': 'Please select an agent first',
  'voiceprint.fetchHistoryFailed': 'Failed to fetch chat history',
  'voiceprint.clickToSelectVector': 'Click to select voiceprint vector',
  'voiceprint.pleaseInputName': 'Please input name',
  'voiceprint.pleaseSelectVector': 'Please select voiceprint vector',
  'voiceprint.addSuccess': 'Add success',
  'voiceprint.addFailed': 'Failed to add speaker',
  'voiceprint.editSuccess': 'Edit success',
  'voiceprint.editFailed': 'Failed to edit speaker',
  'voiceprint.deleteConfirmMsg': 'Are you sure to delete this speaker?',
  'voiceprint.deleteConfirmTitle': 'Confirm Delete',
  'voiceprint.deleteSuccess': 'Delete success',
  'voiceprint.loading': 'Loading...',
  'voiceprint.delete': 'Delete',
  'voiceprint.emptyTitle': 'No voiceprint data',
  'voiceprint.emptyDesc': 'Click the + button at the bottom right to add your first speaker',
  'voiceprint.addSpeaker': 'Add Speaker',
  'voiceprint.voiceVector': 'Voiceprint Vector',
  'voiceprint.name': 'Name',
  'voiceprint.description': 'Description',
  'voiceprint.pleaseInputDescription': 'Please input description',
  'voiceprint.cancel': 'Cancel',
  'voiceprint.save': 'Save',
  'voiceprint.editSpeaker': 'Edit Speaker',
  'voiceprint.selectVector': 'Select Voiceprint Vector',
  'voiceprint.voiceprintInterfaceNotConfigured': 'Voiceprint interface not configured',

  // Settings page
  'settings.pageTitle': 'Settings',
  'settings.navigationTitle': 'Settings',
  'settings.networkSettings': 'Network Settings',
  'settings.serverApiUrl': 'Server API URL',
  'settings.validServerUrl': 'Please enter a valid server address (starting with http or https and ending with /xiaozhi)',
  'settings.saveSettings': 'Save Settings',
  'settings.resetDefault': 'Reset Default',
  'settings.restartApp': 'Restart App',
  'settings.restartNow': 'Restart Now',
  'settings.restartLater': 'Later',
  // About us
  'settings.aboutApp': 'About XiaoZhi Console',
  'settings.aboutContent': 'XiaoZhi Console\n\nA cross-platform mobile management app built with Vue.js 3 + uni-app, providing device management, agent configuration and other functions for xiaozhi ESP32 smart hardware.\n\n© 2025 xiaozhi-esp32-server {version}',
  'settings.restartSuccess': 'Saved, you can manually restart the app later',
  'settings.serverUrlSavedAndCacheCleared': 'Server URL saved and cache cleared',
  'settings.resetToDefaultAndCacheCleared': 'Reset to default and cache cleared',
  'settings.resetSuccess': 'Reset successful',
  'settings.enterServerUrl': 'Please enter server URL',
  'settings.clearCacheFailed': 'Failed to clear cache',
  'settings.cacheManagement': 'Cache Management',
  'settings.totalCacheSize': 'Total Cache Size',
  'settings.appDataSize': 'Total App Data Size',
  'settings.cacheClear': 'Cache Clear',
  'settings.clearAllCache': 'Clear all cache data',
  'settings.clearCache': 'Clear Cache',
  'settings.modifyWillClearCache': 'Modifications will clear cache',
  'settings.appInfo': 'App Info',
  'settings.aboutUs': 'About Us',
  'settings.appVersion': 'App Version & Team Info',
  'settings.confirmClear': 'Confirm Clear',
  'settings.confirmClearMessage': 'Are you sure you want to clear all cache? This will delete all data including login status and require re-login.',
  'settings.cacheCleared': 'Cache cleared successfully, redirecting to login page',
  'settings.languageSettings': 'Language Settings',
  'settings.language': 'Language',
  'settings.selectLanguage': 'Select Language',
  'settings.languageChanged': 'Language changed successfully',

  // Messages
  'message.loginSuccess': 'Login successful!',
  'message.loginFail': 'Login failed',
  'message.registerSuccess': 'Registration successful',
  'message.registerFail': 'Registration failed',
  'message.saveSuccess': 'Save successful',
  'message.saveFail': 'Save failed',
  'message.deleteSuccess': 'Delete successful',
  'message.deleteFail': 'Delete failed',
  'message.bindSuccess': 'Binding successful',
  'message.bindFail': 'Binding failed',
  'message.unbindSuccess': 'Unbinding successful',
  'message.unbindFail': 'Unbinding failed',
  'message.networkError': 'Network error, please check your connection',
  'message.serverError': 'Server error, please try again later',
  'message.invalidAddress': 'Invalid address, please check if the server is started or network connection is normal',
  'message.languageChanged': 'Language changed',
  'message.passwordError': 'Account or password error',
  'message.phoneRegistered': 'This phone number has been registered',

  // Agent Tools Page
  'agent.tools.pageTitle': 'Agent Tools',
  'agent.tools.unselected': 'Unselected',
  'agent.tools.selected': 'Selected',
  'agent.tools.noMorePlugins': 'No more plugins',
  'agent.tools.pleaseSelectPlugin': 'Please select plugin function',
  'agent.tools.builtInPlugins': 'Built-in Plugins',
  'agent.tools.mcpAccessPoint': 'MCP Access Point',
  'agent.tools.copy': 'Copy',
  'agent.tools.noTools': 'No tools available',
  'agent.tools.parameterConfig': 'Parameter Configuration',
  'agent.tools.noParamsNeeded': 'No parameters needed',
  'agent.tools.pleaseInput': 'Please input',
  'agent.tools.inputOneItemPerLine': 'Input one item per line',
  'agent.tools.pleaseInputValidJson': 'Please input valid JSON format',
  'agent.tools.enableFunction': 'Enable Function',
  'agent.tools.toggleFunction': 'Turn on or off this function',
  'agent.tools.jsonFormatError': 'JSON format error',
  'agent.tools.noMcpAddressToCopy': 'No MCP address to copy',
  'agent.tools.mcpAddressCopied': 'MCP address copied to clipboard',
  'agent.tools.copyFailed': 'Copy failed, please try again',
  'agent.tools.defaultValue': 'Default value',
  'agent.tools.notSelected': 'Unselected',
  'agent.tools.clickToConfigure': 'Click to configure',
  'agent.tools.mcpEndpoint': 'MCP Endpoint',
  'agent.tools.eachLineOneItem': 'Input one item per line',

  // Device Config page
  'deviceConfig.pageTitle': 'Device Configuration',
  'deviceConfig.wifiConfig': 'WiFi Configuration',
  'deviceConfig.ultrasonicConfig': 'Ultrasonic Configuration',
  'deviceConfig.selectConfigMethod': 'Select Configuration Method',
  'deviceConfig.networkConfig': 'Network Configuration',
  'deviceConfig.selectedNetwork': 'Selected Network',
  'deviceConfig.signal': 'Signal',
  'deviceConfig.openNetwork': 'Open Network',
  'deviceConfig.encryptedNetwork': 'Encrypted Network',
  'deviceConfig.password': 'Password',
  'deviceConfig.pleaseEnterPassword': 'Please enter WiFi password',
  'deviceConfig.startConfig': 'Start Configuration',
  'deviceConfig.connectToXiaozhiHotspot': 'Please connect to xiaozhi hotspot first',
  'deviceConfig.detecting': 'Detecting...',
  'deviceConfig.reDetect': 'Re-detect',
  'deviceConfig.alreadyConnected': 'Connected to xiaozhi hotspot',
  'deviceConfig.refreshStatus': 'Refresh Status',
  'deviceConfig.wifiNetworks': 'WiFi Networks',
  'deviceConfig.selectWifiNetwork': 'Select WiFi Network',
  'deviceConfig.refreshScan': 'Refresh Scan',
  'deviceConfig.noWifiNetworks': 'No WiFi networks available',
  'deviceConfig.clickToRefreshScan': 'Please click Refresh Scan',
  'deviceConfig.signalStrong': 'Strong Signal',
  'deviceConfig.signalGood': 'Good Signal',
  'deviceConfig.signalFair': 'Fair Signal',
  'deviceConfig.signalWeak': 'Weak Signal',
  'deviceConfig.channel': 'Channel',
  'deviceConfig.about': 'about',
  'deviceConfig.seconds': 'seconds',
  'deviceConfig.generating': 'Generating...',
  'deviceConfig.playing': 'Playing...',
  'deviceConfig.generateAndPlaySoundWave': 'Generate and Play Sound Wave',
  'deviceConfig.playSoundWave': 'Play Sound Wave',
  'deviceConfig.stopPlaying': 'Stop Playing',
  'deviceConfig.autoLoopPlaySoundWave': 'Auto Loop Play Sound Wave',
  'deviceConfig.configAudioFile': 'Configuration Audio File',
  'deviceConfig.duration': 'Duration',
  'deviceConfig.ultrasonicConfigInstructions': 'Ultrasonic Configuration Instructions',
  'deviceConfig.ensureWifiNetworkSelectedAndPasswordEntered': 'Ensure WiFi network is selected and password is entered',
  'deviceConfig.clickGenerateAndPlaySoundWave': 'Click Generate and Play Sound Wave, the system will encode configuration information into audio',
  'deviceConfig.bringPhoneCloseToXiaozhiDevice': 'Bring phone close to xiaozhi device (1-2 meters distance)',
  'deviceConfig.duringAudioPlaybackXiaozhiWillReceive': 'During audio playback, xiaozhi will receive and decode configuration information',
  'deviceConfig.afterConfigSuccessDeviceWillConnect': 'After successful configuration, the device will automatically connect to WiFi network',
  'deviceConfig.usesAfskModulation': 'Uses AFSK modulation technology, transmitting data through 1800Hz and 1500Hz frequencies',
  'deviceConfig.ensureModeratePhoneVolume': 'Please ensure phone volume is moderate to avoid environmental noise interference',
  'deviceConfig.generatingUltrasonicConfigAudio': 'Generating ultrasonic configuration audio',
  'deviceConfig.configData': 'Configuration data',
  'deviceConfig.dataBytesLength': 'Data bytes length',
  'deviceConfig.bitStreamLength': 'Bit stream length',
  'deviceConfig.base64Length': 'Base64 length',
  'deviceConfig.audioFileTooLarge': 'Audio file too large, please shorten SSID or password length',
  'deviceConfig.audioGenerationSuccess': 'Audio generation successful',
  'deviceConfig.samplePoints': 'Sample points',
  'deviceConfig.soundWaveGenerationSuccess': 'Sound wave generation successful',
  'deviceConfig.audioGenerationFailed': 'Audio generation failed',
  'deviceConfig.soundWaveGenerationFailed': 'Sound wave generation failed',
  'deviceConfig.pleaseGenerateAudioFirst': 'Please generate audio first',
  'deviceConfig.startPlayingUltrasonicConfigAudio': 'Starting to play ultrasonic configuration audio',
  'deviceConfig.ultrasonicAudioStartedPlaying': 'Ultrasonic audio started playing',
  'deviceConfig.startPlayingConfigSoundWave': 'Started playing configuration sound wave',
  'deviceConfig.ultrasonicAudioPlaybackEnded': 'Ultrasonic audio playback ended',
  'deviceConfig.audioPlaybackFailed': 'Audio playback failed',
  'deviceConfig.audioResourceBusy': 'Audio resource busy, please try again later',
  'deviceConfig.audioFormatNotSupported': 'Audio format not supported, may be a data URI issue',
  'deviceConfig.audioFileError': 'Audio file error',
  'deviceConfig.cleaningUpAudioContext': 'Cleaning up audio context',
  'deviceConfig.cleaningUpAudioContextFailed': 'Failed to clean up audio context',
  'deviceConfig.stoppedPlayingUltrasonicAudio': 'Stopped playing ultrasonic audio',
  'deviceConfig.stoppedPlaying': 'Stopped playing',
  'deviceConfig.configMethod': 'Configuration Method',
  'deviceConfig.enterWifiPassword': 'Please enter WiFi password',
  'deviceConfig.xiaozhi': 'xiaozhi',
  'deviceConfig.connectXiaozhiHotspot': 'Please connect to xiaozhi hotspot',
  'deviceConfig.wifiScanResponse': 'WiFi scan response',
  'deviceConfig.scanSuccess': 'Scan successful',
  'deviceConfig.networks': 'networks',
  'deviceConfig.wifiScanFailed': 'WiFi scan failed',
  'deviceConfig.scanFailedCheckConnection': 'Scan failed, please check connection',
  'deviceConfig.checking': 'Checking',
  'deviceConfig.reCheck': 'Re-check',
  'deviceConfig.connectedXiaozhiHotspot': 'Connected to xiaozhi hotspot',
  'deviceConfig.wifiNetwork': 'WiFi Network',
  'deviceConfig.scanning': 'Scanning',
  'deviceConfig.cancel': 'Cancel',
  'deviceConfig.clickRefreshScan': 'Please click Refresh Scan',
  'deviceConfig.esp32ConnectionCheckFailed': 'ESP32 connection check failed',
  'deviceConfig.startWifiConfig': 'Starting WiFi configuration',
  'deviceConfig.configSuccess': 'Configuration successful',
  'deviceConfig.deviceWillConnectTo': 'Device will connect to',
  'deviceConfig.deviceWillRestart': 'Device will restart',
  'deviceConfig.pleaseDisconnectXiaozhiHotspot': 'Please disconnect from xiaozhi hotspot',
  'deviceConfig.configFailed': 'Configuration failed',
  'deviceConfig.wifiConfigFailed': 'WiFi configuration failed',
  'deviceConfig.pleaseCheckNetworkConnection': 'Please check network connection',
  'deviceConfig.startWifiConfigButton': 'Start Configuration',
  'deviceConfig.wifiConfigInstructions': 'WiFi Configuration Instructions',
  'deviceConfig.phoneConnectXiaozhiHotspot': 'Phone connect to xiaozhi hotspot',
  'deviceConfig.selectTargetWifiNetwork': 'Select target WiFi network',
  'deviceConfig.enterWifiPasswordIfNeeded': 'Enter WiFi password if needed',
  'deviceConfig.clickStartConfigAndWait': 'Click Start Configuration and wait',
  'deviceConfig.afterConfigSuccessDeviceWillRestart': 'After successful configuration, device will automatically restart',
  'deviceConfig.audioPlaybackError': 'Audio playback error',
  'deviceConfig.playbackFailed': 'Playback failed',
}
