#ifndef _BOARD_CONFIG_H_
#define _BOARD_CONFIG_H_

#include <driver/gpio.h>

#include "t_display_p4_config.h"

#if defined CONFIG_SCREEN_PIXEL_FORMAT_RGB565
#define SCREEN_BITS_PER_PIXEL 16
#define SCREEN_COLOR_RGB_PIXEL_FORMAT LCD_COLOR_PIXEL_FORMAT_RGB565
#define LVGL_COLOR_FORMAT LV_COLOR_FORMAT_RGB565
#elif defined CONFIG_SCREEN_PIXEL_FORMAT_RGB888
#define SCREEN_BITS_PER_PIXEL 24
#define SCREEN_COLOR_RGB_PIXEL_FORMAT LCD_COLOR_PIXEL_FORMAT_RGB888
#define LVGL_COLOR_FORMAT LV_COLOR_FORMAT_RGB888
#else
#error "unknown macro definition, please select the correct macro definition."
#endif

// SCREEN
#if defined CONFIG_SCREEN_TYPE_HI8561
#define SCREEN_WIDTH HI8561_SCREEN_WIDTH
#define SCREEN_HEIGHT HI8561_SCREEN_HEIGHT
#define SCREEN_MIPI_DSI_DPI_CLK_MHZ HI8561_SCREEN_MIPI_DSI_DPI_CLK_MHZ
#define SCREEN_MIPI_DSI_HSYNC HI8561_SCREEN_MIPI_DSI_HSYNC
#define SCREEN_MIPI_DSI_HBP HI8561_SCREEN_MIPI_DSI_HBP
#define SCREEN_MIPI_DSI_HFP HI8561_SCREEN_MIPI_DSI_HFP
#define SCREEN_MIPI_DSI_VSYNC HI8561_SCREEN_MIPI_DSI_VSYNC
#define SCREEN_MIPI_DSI_VBP HI8561_SCREEN_MIPI_DSI_VBP
#define SCREEN_MIPI_DSI_VFP HI8561_SCREEN_MIPI_DSI_VFP
#define SCREEN_DATA_LANE_NUM HI8561_SCREEN_DATA_LANE_NUM
#define SCREEN_LANE_BIT_RATE_MBPS HI8561_SCREEN_LANE_BIT_RATE_MBPS

#elif defined CONFIG_SCREEN_TYPE_RM69A10
#define SCREEN_WIDTH RM69A10_SCREEN_WIDTH
#define SCREEN_HEIGHT RM69A10_SCREEN_HEIGHT
#define SCREEN_MIPI_DSI_DPI_CLK_MHZ RM69A10_SCREEN_MIPI_DSI_DPI_CLK_MHZ
#define SCREEN_MIPI_DSI_HSYNC RM69A10_SCREEN_MIPI_DSI_HSYNC
#define SCREEN_MIPI_DSI_HBP RM69A10_SCREEN_MIPI_DSI_HBP
#define SCREEN_MIPI_DSI_HFP RM69A10_SCREEN_MIPI_DSI_HFP
#define SCREEN_MIPI_DSI_VSYNC RM69A10_SCREEN_MIPI_DSI_VSYNC
#define SCREEN_MIPI_DSI_VBP RM69A10_SCREEN_MIPI_DSI_VBP
#define SCREEN_MIPI_DSI_VFP RM69A10_SCREEN_MIPI_DSI_VFP
#define SCREEN_DATA_LANE_NUM RM69A10_SCREEN_DATA_LANE_NUM
#define SCREEN_LANE_BIT_RATE_MBPS RM69A10_SCREEN_LANE_BIT_RATE_MBPS

#else
#error "unknown macro definition, please select the correct macro definition."
#endif

#define AUDIO_INPUT_SAMPLE_RATE 24000
#define AUDIO_OUTPUT_SAMPLE_RATE 24000

#define AUDIO_INPUT_REFERENCE true

#define AUDIO_I2S_GPIO_MCLK static_cast<gpio_num_t>(ES8311_MCLK)
#define AUDIO_I2S_GPIO_WS static_cast<gpio_num_t>(ES8311_WS_LRCK)
#define AUDIO_I2S_GPIO_BCLK static_cast<gpio_num_t>(ES8311_BCLK)
#define AUDIO_I2S_GPIO_DIN static_cast<gpio_num_t>(ES8311_ADC_DATA)
#define AUDIO_I2S_GPIO_DOUT static_cast<gpio_num_t>(ES8311_DAC_DATA)

#define AUDIO_CODEC_PA_PIN GPIO_NUM_NC
#define AUDIO_CODEC_I2C_SDA_PIN static_cast<gpio_num_t>(ES8311_SDA)
#define AUDIO_CODEC_I2C_SCL_PIN static_cast<gpio_num_t>(ES8311_SCL)
#define AUDIO_CODEC_ES8311_ADDR ES8311_CODEC_DEFAULT_ADDR

#define BOOT_BUTTON_GPIO GPIO_NUM_35

#define SCREEN_SWAP_XY false
#define SCREEN_MIRROR_X false
#define SCREEN_MIRROR_Y false

#define SCREEN_OFFSET_X 0
#define SCREEN_OFFSET_Y 0

#endif // _BOARD_CONFIG_H_
