# SPDX-FileCopyrightText: 2025 Espressif Systems (Shanghai) CO LTD
# SPDX-License-Identifier: CC0-1.0
import time

import pytest
from pytest_embedded import Dut
from pytest_embedded_idf.utils import idf_parametrize


@pytest.mark.generic
@idf_parametrize('target', ['esp32s2', 'esp32s3'], indirect=['target'])
def test_ulp_riscv_pulse_counter(dut: Dut) -> None:
    # Wait for the start of pulse generation
    dut.expect_exact('Start generating pulses')
    # Wait for pulses to be generated
    time.sleep(3)
    # Wait for the end of pulse generation
    dut.expect_exact('Stop generating pulses')
    # Wait for ULP to finish counting
    time.sleep(1)
    # Check the pulse count summary output
    dut.expect(r'Number of pulses generated by HP Core: (\d+)')
    # Check for SUCCESS message
    result = dut.expect_exact(['SUCCESS', 'FAILURE'], timeout=5)
    assert result == b'SUCCESS', 'ULP pulse counter did not report SUCCESS'
    # Wait for deep sleep entry
    dut.expect_exact('Entering deep sleep')
    pass
