| Supported Targets | ESP32 | ESP32-C3 | ESP32-C5 | ESP32-C6 | ESP32-H2 | ESP32-H21 | ESP32-H4 | ESP32-P4 | ESP32-S2 | ESP32-S3 |
| ----------------- | ----- | -------- | -------- | -------- | -------- | --------- | -------- | -------- | -------- | -------- |
# RMT Transmit Example -- LED Strip

(See the README.md file in the upper level 'examples' directory for more information about examples.)

Almost any waveform can be generated by RMT peripheral, as long as a proper encoder is implemented. In this example, the simple callback RMT encoder is used to convert RGB pixels into format that can be recognized by hardware.

This example shows how to drive an addressable LED strip [WS2812](https://cdn-shop.adafruit.com/datasheets/WS2812B.pdf) by implementing a callback that can be used by the simple callback RMT encoder.

## How to Use Example

### Hardware Required

* A development board with any supported Espressif SOC chip (see `Supported Targets` table above)
* A USB cable for Power supply and programming
* A WS2812 LED strip

Connection :

```
                              --- 5V
                               |
                               +
RMT_LED_STRIP_GPIO_NUM +------ +---|>| (WS2812 LED strip)
                        DI     +
                               |
                              --- GND
```

The GPIO number used in this example can be changed according to your board, by the macro `RMT_LED_STRIP_GPIO_NUM` defined in the [source file](main/led_strip_example_main.c). The number of LEDs can be changed as well by `EXAMPLE_LED_NUMBERS`.

### Build and Flash

Run `idf.py -p PORT flash monitor` to build, flash and monitor the project.

(To exit the serial monitor, type ``Ctrl-]``.)

See the [Getting Started Guide](https://docs.espressif.com/projects/esp-idf/en/latest/get-started/index.html) for full steps to configure and use ESP-IDF to build projects.

## Console Output

```
I (302) cpu_start: Starting scheduler on PRO CPU.
I (0) cpu_start: Starting scheduler on APP CPU.
I (323) example: Create RMT TX channel
I (343) example: Create simple callback-based encoder
I (353) example: Start LED rainbow chase
```


After you seeing this log, you should see a rainbow chasing demonstration pattern. To change the chasing speed, you can update the `EXAMPLE_ANGLE_INC_FRAME` value in [source file](main/led_strip_example_main.c). To change the density of colors, you can change `EXAMPLE_ANGLE_INC_LED` in the same file.

## Troubleshooting

For any technical queries, please open an [issue](https://github.com/espressif/esp-idf/issues) on GitHub. We will get back to you soon.
