/*
 * SPDX-FileCopyrightText: 2025 Espressif Systems (Shanghai) CO LTD
 *
 * SPDX-License-Identifier: Apache-2.0
 */

#pragma once

#include <stdint.h>

#ifdef __cplusplus
extern "C"
{
#endif

//Interrupt hardware source table
//This table is decided by hardware, don't touch this.
typedef enum {
    ETS_LP_RTC_INT_SOURCE,
    ETS_LP_WDT_INT_SOURCE,
    ETS_LP_TIMER_REG_0_INT_SOURCE,
    ETS_LP_TIMER_REG_1_INT_SOURCE,
    ETS_MB_HP_INT_SOURCE,
    ETS_MB_LP_INT_SOURCE,
    ETS_PMU_REG_0_INT_SOURCE,
    ETS_PMU_REG_1_INT_SOURCE,
    ETS_LP_ANAPERI_INT_SOURCE,
    ETS_LP_ADC_INT_SOURCE,
    ETS_LP_GPIO_INT_SOURCE,
    ETS_LP_I2C_INT_SOURCE,
    ETS_LP_I2S_INT_SOURCE,
    ETS_LP_SPI_INT_SOURCE,
    ETS_LP_TOUCH_INT_SOURCE,
    ETS_LP_TSENS_INT_SOURCE,
    ETS_LP_UART_INT_SOURCE,
    ETS_LP_EFUSE_INT_SOURCE,
    ETS_LP_SW_INT_SOURCE,
    ETS_LP_SYSREG_INT_SOURCE,
    ETS_LP_HUK_INT_SOURCE,
    ETS_SYS_ICM_INT_SOURCE,
    ETS_USB_DEVICE_INT_SOURCE,
    ETS_SDIO_HOST_INT_SOURCE,
    ETS_GDMA_INT_SOURCE,
    ETS_SPI2_INT_SOURCE,
    ETS_SPI3_INT_SOURCE,
    ETS_I2S0_INT_SOURCE,
    ETS_I2S1_INT_SOURCE,
    ETS_I2S2_INT_SOURCE,
    ETS_UHCI0_INT_SOURCE,
    ETS_UART0_INT_SOURCE,
    ETS_UART1_INT_SOURCE,
    ETS_UART2_INT_SOURCE,
    ETS_UART3_INT_SOURCE,
    ETS_UART4_INT_SOURCE,
    ETS_LCD_CAM_INT_SOURCE,
    ETS_ADC_INT_SOURCE,
    ETS_PWM0_INT_SOURCE,
    ETS_PWM1_INT_SOURCE,
    ETS_TWAI0_INT_SOURCE,
    ETS_TWAI1_INT_SOURCE,
    ETS_TWAI2_INT_SOURCE,
    ETS_RMT_INT_SOURCE,
    ETS_I2C0_INT_SOURCE,
    ETS_I2C1_INT_SOURCE,
    ETS_TIMERGRP0_T0_INT_SOURCE,
    ETS_TIMERGRP0_T1_INT_SOURCE,
    ETS_TIMERGRP0_WDT_INT_SOURCE,
    ETS_TIMERGRP1_T0_INT_SOURCE,
    ETS_TIMERGRP1_T1_INT_SOURCE,
    ETS_TIMERGRP1_WDT_INT_SOURCE,
    ETS_LEDC_INT_SOURCE,
    ETS_SYSTIMER_TARGET0_INT_SOURCE,
    ETS_SYSTIMER_TARGET1_INT_SOURCE,
    ETS_SYSTIMER_TARGET2_INT_SOURCE,
    ETS_AHB_PDMA_IN_CH0_INT_SOURCE,
    ETS_AHB_PDMA_IN_CH1_INT_SOURCE,
    ETS_AHB_PDMA_IN_CH2_INT_SOURCE,
    ETS_AHB_PDMA_OUT_CH0_INT_SOURCE,
    ETS_AHB_PDMA_OUT_CH1_INT_SOURCE,
    ETS_AHB_PDMA_OUT_CH2_INT_SOURCE,
    ETS_AXI_PDMA_IN_CH0_INT_SOURCE,
    ETS_AXI_PDMA_IN_CH1_INT_SOURCE,
    ETS_AXI_PDMA_IN_CH2_INT_SOURCE,
    ETS_AXI_PDMA_OUT_CH0_INT_SOURCE,
    ETS_AXI_PDMA_OUT_CH1_INT_SOURCE,
    ETS_AXI_PDMA_OUT_CH2_INT_SOURCE,
    ETS_RSA_INT_SOURCE,
    ETS_AES_INT_SOURCE,
    ETS_SHA_INT_SOURCE,
    ETS_ECC_INT_SOURCE,
    ETS_ECDSA_INT_SOURCE,
    ETS_KM_INT_SOURCE,
    ETS_GPIO_INT0_SOURCE,
    ETS_GPIO_INT1_SOURCE,
    ETS_GPIO_INT2_SOURCE,
    ETS_GPIO_INT3_SOURCE,
    ETS_GPIO_PAD_COMP_INT_SOURCE,
    ETS_CPU_INT_FROM_CPU_0_SOURCE,
    ETS_CPU_INT_FROM_CPU_1_SOURCE,
    ETS_CPU_INT_FROM_CPU_2_SOURCE,
    ETS_CPU_INT_FROM_CPU_3_SOURCE,
    ETS_CACHE_INT_SOURCE,
    ETS_FLASH_MSPI_INT_SOURCE,
    ETS_CSI_BRIDGE_INT_SOURCE,
    ETS_DSI_BRIDGE_INT_SOURCE,
    ETS_CSI_INT_SOURCE,
    ETS_DSI_INT_SOURCE,
    ETS_GMII_PHY_INT_SOURCE,
    ETS_LPI_INT_SOURCE,
    ETS_PMT_INT_SOURCE,
    ETS_SBD_INT_SOURCE,
    ETS_USB_OTG_INT_SOURCE,
    ETS_USB_OTG_ENDP_MULTI_PROC_INT_SOURCE,
    ETS_JPEG_INT_SOURCE,
    ETS_PPA_INT_SOURCE,
    ETS_CORE0_TRACE_INT_SOURCE,
    ETS_CORE1_TRACE_INT_SOURCE,
    ETS_HP_CORE_CTRL_INT_SOURCE,
    ETS_ISP_INT_SOURCE,
    ETS_I3C_MST_INT_SOURCE,
    ETS_I3C_SLV_INT_SOURCE,
    ETS_USB_OTG11_INT_SOURCE,
    ETS_DMA2D_IN_CH0_INT_SOURCE,
    ETS_DMA2D_IN_CH1_INT_SOURCE,
    ETS_DMA2D_OUT_CH0_INT_SOURCE,
    ETS_DMA2D_OUT_CH1_INT_SOURCE,
    ETS_DMA2D_OUT_CH2_INT_SOURCE,
    ETS_PSRAM_MSPI_INT_SOURCE,
    ETS_HP_SYSREG_INT_SOURCE,
    ETS_PCNT_INT_SOURCE,
    ETS_HP_PAU_INT_SOURCE,
    ETS_HP_PARLIO_RX_INT_SOURCE,
    ETS_HP_PARLIO_TX_INT_SOURCE,
    ETS_H264_DMA2D_OUT_CH0_INT_SOURCE,
    ETS_H264_DMA2D_OUT_CH1_INT_SOURCE,
    ETS_H264_DMA2D_OUT_CH2_INT_SOURCE,
    ETS_H264_DMA2D_OUT_CH3_INT_SOURCE,
    ETS_H264_DMA2D_OUT_CH4_INT_SOURCE,
    ETS_H264_DMA2D_IN_CH0_INT_SOURCE,
    ETS_H264_DMA2D_IN_CH1_INT_SOURCE,
    ETS_H264_DMA2D_IN_CH2_INT_SOURCE,
    ETS_H264_DMA2D_IN_CH3_INT_SOURCE,
    ETS_H264_DMA2D_IN_CH4_INT_SOURCE,
    ETS_H264_DMA2D_IN_CH5_INT_SOURCE,
    ETS_H264_REG_INT_SOURCE,
    ETS_ASSIST_DEBUG_INT_SOURCE,
    ETS_DMA2D_IN_CH2_INT_SOURCE,
    ETS_DMA2D_OUT_CH3_INT_SOURCE,
    ETS_AXI_PERF_MON_INT_SOURCE,
    ETS_MAX_INTR_SOURCE,
} periph_interrupt_t;

extern const char * const esp_isr_names[ETS_MAX_INTR_SOURCE];

#ifdef __cplusplus
}
#endif
