/**
 * SPDX-FileCopyrightText: 2025 Espressif Systems (Shanghai) CO LTD
 *
 *  SPDX-License-Identifier: Apache-2.0
 */
#pragma once

#include <stdint.h>
#include "soc/soc.h"
#ifdef __cplusplus
extern "C" {
#endif

/** CORE1_LP_RTC_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_LP_RTC_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x0)
/** CORE1_CORE1_LP_RTC_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_LP_RTC_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_LP_RTC_INT_MAP_M  (CORE1_CORE1_LP_RTC_INT_MAP_V << CORE1_CORE1_LP_RTC_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_LP_RTC_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_LP_RTC_INT_MAP_S  0
/** CORE1_CORE1_LP_RTC_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_LP_RTC_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_LP_RTC_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_LP_RTC_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_LP_RTC_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_LP_RTC_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_LP_RTC_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_LP_RTC_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_LP_RTC_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_LP_RTC_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_LP_RTC_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_LP_RTC_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_LP_RTC_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_LP_RTC_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_LP_WDT_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_LP_WDT_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x4)
/** CORE1_CORE1_LP_WDT_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_LP_WDT_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_LP_WDT_INT_MAP_M  (CORE1_CORE1_LP_WDT_INT_MAP_V << CORE1_CORE1_LP_WDT_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_LP_WDT_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_LP_WDT_INT_MAP_S  0
/** CORE1_CORE1_LP_WDT_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_LP_WDT_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_LP_WDT_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_LP_WDT_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_LP_WDT_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_LP_WDT_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_LP_WDT_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_LP_WDT_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_LP_WDT_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_LP_WDT_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_LP_WDT_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_LP_WDT_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_LP_WDT_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_LP_WDT_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_LP_TIMER_REG_0_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_LP_TIMER_REG_0_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x8)
/** CORE1_CORE1_LP_TIMER_REG_0_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_LP_TIMER_REG_0_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_LP_TIMER_REG_0_INT_MAP_M  (CORE1_CORE1_LP_TIMER_REG_0_INT_MAP_V << CORE1_CORE1_LP_TIMER_REG_0_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_LP_TIMER_REG_0_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_LP_TIMER_REG_0_INT_MAP_S  0
/** CORE1_CORE1_LP_TIMER_REG_0_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_LP_TIMER_REG_0_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_LP_TIMER_REG_0_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_LP_TIMER_REG_0_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_LP_TIMER_REG_0_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_LP_TIMER_REG_0_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_LP_TIMER_REG_0_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_LP_TIMER_REG_0_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_LP_TIMER_REG_0_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_LP_TIMER_REG_0_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_LP_TIMER_REG_0_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_LP_TIMER_REG_0_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_LP_TIMER_REG_0_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_LP_TIMER_REG_0_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_LP_TIMER_REG_1_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_LP_TIMER_REG_1_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0xc)
/** CORE1_CORE1_LP_TIMER_REG_1_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_LP_TIMER_REG_1_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_LP_TIMER_REG_1_INT_MAP_M  (CORE1_CORE1_LP_TIMER_REG_1_INT_MAP_V << CORE1_CORE1_LP_TIMER_REG_1_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_LP_TIMER_REG_1_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_LP_TIMER_REG_1_INT_MAP_S  0
/** CORE1_CORE1_LP_TIMER_REG_1_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_LP_TIMER_REG_1_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_LP_TIMER_REG_1_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_LP_TIMER_REG_1_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_LP_TIMER_REG_1_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_LP_TIMER_REG_1_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_LP_TIMER_REG_1_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_LP_TIMER_REG_1_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_LP_TIMER_REG_1_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_LP_TIMER_REG_1_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_LP_TIMER_REG_1_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_LP_TIMER_REG_1_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_LP_TIMER_REG_1_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_LP_TIMER_REG_1_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_MB_HP_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_MB_HP_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x10)
/** CORE1_CORE1_MB_HP_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_MB_HP_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_MB_HP_INT_MAP_M  (CORE1_CORE1_MB_HP_INT_MAP_V << CORE1_CORE1_MB_HP_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_MB_HP_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_MB_HP_INT_MAP_S  0
/** CORE1_CORE1_MB_HP_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_MB_HP_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_MB_HP_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_MB_HP_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_MB_HP_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_MB_HP_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_MB_HP_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_MB_HP_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_MB_HP_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_MB_HP_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_MB_HP_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_MB_HP_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_MB_HP_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_MB_HP_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_MB_LP_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_MB_LP_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x14)
/** CORE1_CORE1_MB_LP_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_MB_LP_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_MB_LP_INT_MAP_M  (CORE1_CORE1_MB_LP_INT_MAP_V << CORE1_CORE1_MB_LP_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_MB_LP_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_MB_LP_INT_MAP_S  0
/** CORE1_CORE1_MB_LP_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_MB_LP_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_MB_LP_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_MB_LP_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_MB_LP_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_MB_LP_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_MB_LP_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_MB_LP_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_MB_LP_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_MB_LP_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_MB_LP_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_MB_LP_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_MB_LP_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_MB_LP_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_PMU_REG_0_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_PMU_REG_0_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x18)
/** CORE1_CORE1_PMU_REG_0_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_PMU_REG_0_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_PMU_REG_0_INT_MAP_M  (CORE1_CORE1_PMU_REG_0_INT_MAP_V << CORE1_CORE1_PMU_REG_0_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_PMU_REG_0_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_PMU_REG_0_INT_MAP_S  0
/** CORE1_CORE1_PMU_REG_0_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_PMU_REG_0_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_PMU_REG_0_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_PMU_REG_0_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_PMU_REG_0_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_PMU_REG_0_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_PMU_REG_0_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_PMU_REG_0_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_PMU_REG_0_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_PMU_REG_0_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_PMU_REG_0_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_PMU_REG_0_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_PMU_REG_0_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_PMU_REG_0_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_PMU_REG_1_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_PMU_REG_1_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x1c)
/** CORE1_CORE1_PMU_REG_1_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_PMU_REG_1_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_PMU_REG_1_INT_MAP_M  (CORE1_CORE1_PMU_REG_1_INT_MAP_V << CORE1_CORE1_PMU_REG_1_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_PMU_REG_1_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_PMU_REG_1_INT_MAP_S  0
/** CORE1_CORE1_PMU_REG_1_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_PMU_REG_1_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_PMU_REG_1_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_PMU_REG_1_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_PMU_REG_1_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_PMU_REG_1_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_PMU_REG_1_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_PMU_REG_1_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_PMU_REG_1_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_PMU_REG_1_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_PMU_REG_1_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_PMU_REG_1_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_PMU_REG_1_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_PMU_REG_1_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_LP_ANAPERI_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_LP_ANAPERI_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x20)
/** CORE1_CORE1_LP_ANAPERI_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_LP_ANAPERI_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_LP_ANAPERI_INT_MAP_M  (CORE1_CORE1_LP_ANAPERI_INT_MAP_V << CORE1_CORE1_LP_ANAPERI_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_LP_ANAPERI_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_LP_ANAPERI_INT_MAP_S  0
/** CORE1_CORE1_LP_ANAPERI_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_LP_ANAPERI_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_LP_ANAPERI_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_LP_ANAPERI_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_LP_ANAPERI_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_LP_ANAPERI_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_LP_ANAPERI_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_LP_ANAPERI_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_LP_ANAPERI_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_LP_ANAPERI_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_LP_ANAPERI_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_LP_ANAPERI_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_LP_ANAPERI_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_LP_ANAPERI_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_LP_ADC_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_LP_ADC_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x24)
/** CORE1_CORE1_LP_ADC_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_LP_ADC_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_LP_ADC_INT_MAP_M  (CORE1_CORE1_LP_ADC_INT_MAP_V << CORE1_CORE1_LP_ADC_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_LP_ADC_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_LP_ADC_INT_MAP_S  0
/** CORE1_CORE1_LP_ADC_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_LP_ADC_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_LP_ADC_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_LP_ADC_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_LP_ADC_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_LP_ADC_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_LP_ADC_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_LP_ADC_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_LP_ADC_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_LP_ADC_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_LP_ADC_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_LP_ADC_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_LP_ADC_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_LP_ADC_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_LP_GPIO_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_LP_GPIO_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x28)
/** CORE1_CORE1_LP_GPIO_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_LP_GPIO_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_LP_GPIO_INT_MAP_M  (CORE1_CORE1_LP_GPIO_INT_MAP_V << CORE1_CORE1_LP_GPIO_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_LP_GPIO_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_LP_GPIO_INT_MAP_S  0
/** CORE1_CORE1_LP_GPIO_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_LP_GPIO_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_LP_GPIO_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_LP_GPIO_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_LP_GPIO_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_LP_GPIO_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_LP_GPIO_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_LP_GPIO_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_LP_GPIO_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_LP_GPIO_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_LP_GPIO_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_LP_GPIO_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_LP_GPIO_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_LP_GPIO_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_LP_I2C_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_LP_I2C_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x2c)
/** CORE1_CORE1_LP_I2C_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_LP_I2C_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_LP_I2C_INT_MAP_M  (CORE1_CORE1_LP_I2C_INT_MAP_V << CORE1_CORE1_LP_I2C_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_LP_I2C_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_LP_I2C_INT_MAP_S  0
/** CORE1_CORE1_LP_I2C_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_LP_I2C_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_LP_I2C_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_LP_I2C_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_LP_I2C_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_LP_I2C_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_LP_I2C_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_LP_I2C_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_LP_I2C_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_LP_I2C_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_LP_I2C_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_LP_I2C_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_LP_I2C_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_LP_I2C_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_LP_I2S_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_LP_I2S_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x30)
/** CORE1_CORE1_LP_I2S_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_LP_I2S_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_LP_I2S_INT_MAP_M  (CORE1_CORE1_LP_I2S_INT_MAP_V << CORE1_CORE1_LP_I2S_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_LP_I2S_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_LP_I2S_INT_MAP_S  0
/** CORE1_CORE1_LP_I2S_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_LP_I2S_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_LP_I2S_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_LP_I2S_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_LP_I2S_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_LP_I2S_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_LP_I2S_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_LP_I2S_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_LP_I2S_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_LP_I2S_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_LP_I2S_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_LP_I2S_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_LP_I2S_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_LP_I2S_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_LP_SPI_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_LP_SPI_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x34)
/** CORE1_CORE1_LP_SPI_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_LP_SPI_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_LP_SPI_INT_MAP_M  (CORE1_CORE1_LP_SPI_INT_MAP_V << CORE1_CORE1_LP_SPI_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_LP_SPI_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_LP_SPI_INT_MAP_S  0
/** CORE1_CORE1_LP_SPI_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_LP_SPI_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_LP_SPI_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_LP_SPI_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_LP_SPI_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_LP_SPI_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_LP_SPI_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_LP_SPI_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_LP_SPI_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_LP_SPI_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_LP_SPI_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_LP_SPI_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_LP_SPI_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_LP_SPI_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_LP_TOUCH_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_LP_TOUCH_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x38)
/** CORE1_CORE1_LP_TOUCH_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_LP_TOUCH_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_LP_TOUCH_INT_MAP_M  (CORE1_CORE1_LP_TOUCH_INT_MAP_V << CORE1_CORE1_LP_TOUCH_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_LP_TOUCH_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_LP_TOUCH_INT_MAP_S  0
/** CORE1_CORE1_LP_TOUCH_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_LP_TOUCH_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_LP_TOUCH_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_LP_TOUCH_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_LP_TOUCH_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_LP_TOUCH_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_LP_TOUCH_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_LP_TOUCH_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_LP_TOUCH_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_LP_TOUCH_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_LP_TOUCH_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_LP_TOUCH_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_LP_TOUCH_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_LP_TOUCH_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_LP_TSENS_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_LP_TSENS_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x3c)
/** CORE1_CORE1_LP_TSENS_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_LP_TSENS_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_LP_TSENS_INT_MAP_M  (CORE1_CORE1_LP_TSENS_INT_MAP_V << CORE1_CORE1_LP_TSENS_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_LP_TSENS_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_LP_TSENS_INT_MAP_S  0
/** CORE1_CORE1_LP_TSENS_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_LP_TSENS_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_LP_TSENS_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_LP_TSENS_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_LP_TSENS_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_LP_TSENS_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_LP_TSENS_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_LP_TSENS_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_LP_TSENS_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_LP_TSENS_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_LP_TSENS_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_LP_TSENS_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_LP_TSENS_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_LP_TSENS_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_LP_UART_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_LP_UART_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x40)
/** CORE1_CORE1_LP_UART_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_LP_UART_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_LP_UART_INT_MAP_M  (CORE1_CORE1_LP_UART_INT_MAP_V << CORE1_CORE1_LP_UART_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_LP_UART_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_LP_UART_INT_MAP_S  0
/** CORE1_CORE1_LP_UART_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_LP_UART_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_LP_UART_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_LP_UART_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_LP_UART_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_LP_UART_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_LP_UART_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_LP_UART_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_LP_UART_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_LP_UART_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_LP_UART_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_LP_UART_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_LP_UART_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_LP_UART_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_LP_EFUSE_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_LP_EFUSE_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x44)
/** CORE1_CORE1_LP_EFUSE_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_LP_EFUSE_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_LP_EFUSE_INT_MAP_M  (CORE1_CORE1_LP_EFUSE_INT_MAP_V << CORE1_CORE1_LP_EFUSE_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_LP_EFUSE_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_LP_EFUSE_INT_MAP_S  0
/** CORE1_CORE1_LP_EFUSE_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_LP_EFUSE_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_LP_EFUSE_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_LP_EFUSE_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_LP_EFUSE_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_LP_EFUSE_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_LP_EFUSE_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_LP_EFUSE_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_LP_EFUSE_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_LP_EFUSE_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_LP_EFUSE_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_LP_EFUSE_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_LP_EFUSE_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_LP_EFUSE_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_LP_SW_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_LP_SW_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x48)
/** CORE1_CORE1_LP_SW_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_LP_SW_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_LP_SW_INT_MAP_M  (CORE1_CORE1_LP_SW_INT_MAP_V << CORE1_CORE1_LP_SW_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_LP_SW_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_LP_SW_INT_MAP_S  0
/** CORE1_CORE1_LP_SW_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_LP_SW_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_LP_SW_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_LP_SW_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_LP_SW_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_LP_SW_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_LP_SW_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_LP_SW_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_LP_SW_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_LP_SW_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_LP_SW_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_LP_SW_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_LP_SW_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_LP_SW_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_LP_SYSREG_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_LP_SYSREG_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x4c)
/** CORE1_CORE1_LP_SYSREG_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_LP_SYSREG_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_LP_SYSREG_INT_MAP_M  (CORE1_CORE1_LP_SYSREG_INT_MAP_V << CORE1_CORE1_LP_SYSREG_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_LP_SYSREG_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_LP_SYSREG_INT_MAP_S  0
/** CORE1_CORE1_LP_SYSREG_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_LP_SYSREG_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_LP_SYSREG_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_LP_SYSREG_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_LP_SYSREG_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_LP_SYSREG_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_LP_SYSREG_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_LP_SYSREG_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_LP_SYSREG_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_LP_SYSREG_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_LP_SYSREG_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_LP_SYSREG_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_LP_SYSREG_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_LP_SYSREG_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_LP_HUK_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_LP_HUK_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x50)
/** CORE1_CORE1_LP_HUK_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_LP_HUK_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_LP_HUK_INT_MAP_M  (CORE1_CORE1_LP_HUK_INT_MAP_V << CORE1_CORE1_LP_HUK_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_LP_HUK_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_LP_HUK_INT_MAP_S  0
/** CORE1_CORE1_LP_HUK_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_LP_HUK_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_LP_HUK_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_LP_HUK_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_LP_HUK_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_LP_HUK_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_LP_HUK_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_LP_HUK_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_LP_HUK_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_LP_HUK_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_LP_HUK_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_LP_HUK_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_LP_HUK_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_LP_HUK_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_SYS_ICM_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_SYS_ICM_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x54)
/** CORE1_CORE1_SYS_ICM_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_SYS_ICM_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_SYS_ICM_INT_MAP_M  (CORE1_CORE1_SYS_ICM_INT_MAP_V << CORE1_CORE1_SYS_ICM_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_SYS_ICM_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_SYS_ICM_INT_MAP_S  0
/** CORE1_CORE1_SYS_ICM_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_SYS_ICM_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_SYS_ICM_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_SYS_ICM_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_SYS_ICM_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_SYS_ICM_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_SYS_ICM_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_SYS_ICM_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_SYS_ICM_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_SYS_ICM_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_SYS_ICM_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_SYS_ICM_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_SYS_ICM_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_SYS_ICM_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_USB_DEVICE_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_USB_DEVICE_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x58)
/** CORE1_CORE1_USB_DEVICE_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_USB_DEVICE_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_USB_DEVICE_INT_MAP_M  (CORE1_CORE1_USB_DEVICE_INT_MAP_V << CORE1_CORE1_USB_DEVICE_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_USB_DEVICE_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_USB_DEVICE_INT_MAP_S  0
/** CORE1_CORE1_USB_DEVICE_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_USB_DEVICE_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_USB_DEVICE_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_USB_DEVICE_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_USB_DEVICE_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_USB_DEVICE_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_USB_DEVICE_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_USB_DEVICE_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_USB_DEVICE_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_USB_DEVICE_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_USB_DEVICE_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_USB_DEVICE_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_USB_DEVICE_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_USB_DEVICE_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_SDIO_HOST_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_SDIO_HOST_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x5c)
/** CORE1_CORE1_SDIO_HOST_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_SDIO_HOST_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_SDIO_HOST_INT_MAP_M  (CORE1_CORE1_SDIO_HOST_INT_MAP_V << CORE1_CORE1_SDIO_HOST_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_SDIO_HOST_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_SDIO_HOST_INT_MAP_S  0
/** CORE1_CORE1_SDIO_HOST_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_SDIO_HOST_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_SDIO_HOST_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_SDIO_HOST_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_SDIO_HOST_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_SDIO_HOST_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_SDIO_HOST_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_SDIO_HOST_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_SDIO_HOST_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_SDIO_HOST_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_SDIO_HOST_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_SDIO_HOST_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_SDIO_HOST_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_SDIO_HOST_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_GDMA_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_GDMA_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x60)
/** CORE1_CORE1_GDMA_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_GDMA_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_GDMA_INT_MAP_M  (CORE1_CORE1_GDMA_INT_MAP_V << CORE1_CORE1_GDMA_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_GDMA_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_GDMA_INT_MAP_S  0
/** CORE1_CORE1_GDMA_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_GDMA_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_GDMA_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_GDMA_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_GDMA_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_GDMA_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_GDMA_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_GDMA_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_GDMA_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_GDMA_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_GDMA_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_GDMA_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_GDMA_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_GDMA_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_SPI2_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_SPI2_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x64)
/** CORE1_CORE1_SPI2_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_SPI2_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_SPI2_INT_MAP_M  (CORE1_CORE1_SPI2_INT_MAP_V << CORE1_CORE1_SPI2_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_SPI2_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_SPI2_INT_MAP_S  0
/** CORE1_CORE1_SPI2_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_SPI2_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_SPI2_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_SPI2_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_SPI2_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_SPI2_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_SPI2_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_SPI2_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_SPI2_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_SPI2_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_SPI2_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_SPI2_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_SPI2_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_SPI2_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_SPI3_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_SPI3_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x68)
/** CORE1_CORE1_SPI3_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_SPI3_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_SPI3_INT_MAP_M  (CORE1_CORE1_SPI3_INT_MAP_V << CORE1_CORE1_SPI3_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_SPI3_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_SPI3_INT_MAP_S  0
/** CORE1_CORE1_SPI3_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_SPI3_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_SPI3_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_SPI3_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_SPI3_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_SPI3_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_SPI3_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_SPI3_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_SPI3_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_SPI3_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_SPI3_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_SPI3_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_SPI3_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_SPI3_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_I2S0_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_I2S0_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x6c)
/** CORE1_CORE1_I2S0_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_I2S0_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_I2S0_INT_MAP_M  (CORE1_CORE1_I2S0_INT_MAP_V << CORE1_CORE1_I2S0_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_I2S0_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_I2S0_INT_MAP_S  0
/** CORE1_CORE1_I2S0_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_I2S0_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_I2S0_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_I2S0_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_I2S0_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_I2S0_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_I2S0_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_I2S0_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_I2S0_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_I2S0_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_I2S0_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_I2S0_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_I2S0_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_I2S0_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_I2S1_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_I2S1_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x70)
/** CORE1_CORE1_I2S1_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_I2S1_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_I2S1_INT_MAP_M  (CORE1_CORE1_I2S1_INT_MAP_V << CORE1_CORE1_I2S1_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_I2S1_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_I2S1_INT_MAP_S  0
/** CORE1_CORE1_I2S1_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_I2S1_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_I2S1_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_I2S1_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_I2S1_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_I2S1_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_I2S1_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_I2S1_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_I2S1_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_I2S1_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_I2S1_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_I2S1_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_I2S1_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_I2S1_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_I2S2_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_I2S2_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x74)
/** CORE1_CORE1_I2S2_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_I2S2_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_I2S2_INT_MAP_M  (CORE1_CORE1_I2S2_INT_MAP_V << CORE1_CORE1_I2S2_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_I2S2_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_I2S2_INT_MAP_S  0
/** CORE1_CORE1_I2S2_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_I2S2_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_I2S2_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_I2S2_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_I2S2_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_I2S2_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_I2S2_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_I2S2_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_I2S2_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_I2S2_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_I2S2_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_I2S2_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_I2S2_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_I2S2_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_UHCI0_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_UHCI0_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x78)
/** CORE1_CORE1_UHCI0_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_UHCI0_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_UHCI0_INT_MAP_M  (CORE1_CORE1_UHCI0_INT_MAP_V << CORE1_CORE1_UHCI0_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_UHCI0_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_UHCI0_INT_MAP_S  0
/** CORE1_CORE1_UHCI0_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_UHCI0_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_UHCI0_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_UHCI0_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_UHCI0_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_UHCI0_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_UHCI0_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_UHCI0_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_UHCI0_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_UHCI0_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_UHCI0_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_UHCI0_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_UHCI0_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_UHCI0_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_UART0_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_UART0_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x7c)
/** CORE1_CORE1_UART0_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_UART0_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_UART0_INT_MAP_M  (CORE1_CORE1_UART0_INT_MAP_V << CORE1_CORE1_UART0_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_UART0_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_UART0_INT_MAP_S  0
/** CORE1_CORE1_UART0_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_UART0_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_UART0_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_UART0_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_UART0_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_UART0_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_UART0_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_UART0_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_UART0_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_UART0_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_UART0_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_UART0_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_UART0_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_UART0_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_UART1_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_UART1_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x80)
/** CORE1_CORE1_UART1_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_UART1_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_UART1_INT_MAP_M  (CORE1_CORE1_UART1_INT_MAP_V << CORE1_CORE1_UART1_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_UART1_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_UART1_INT_MAP_S  0
/** CORE1_CORE1_UART1_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_UART1_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_UART1_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_UART1_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_UART1_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_UART1_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_UART1_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_UART1_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_UART1_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_UART1_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_UART1_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_UART1_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_UART1_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_UART1_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_UART2_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_UART2_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x84)
/** CORE1_CORE1_UART2_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_UART2_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_UART2_INT_MAP_M  (CORE1_CORE1_UART2_INT_MAP_V << CORE1_CORE1_UART2_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_UART2_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_UART2_INT_MAP_S  0
/** CORE1_CORE1_UART2_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_UART2_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_UART2_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_UART2_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_UART2_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_UART2_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_UART2_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_UART2_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_UART2_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_UART2_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_UART2_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_UART2_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_UART2_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_UART2_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_UART3_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_UART3_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x88)
/** CORE1_CORE1_UART3_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_UART3_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_UART3_INT_MAP_M  (CORE1_CORE1_UART3_INT_MAP_V << CORE1_CORE1_UART3_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_UART3_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_UART3_INT_MAP_S  0
/** CORE1_CORE1_UART3_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_UART3_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_UART3_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_UART3_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_UART3_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_UART3_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_UART3_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_UART3_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_UART3_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_UART3_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_UART3_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_UART3_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_UART3_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_UART3_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_UART4_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_UART4_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x8c)
/** CORE1_CORE1_UART4_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_UART4_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_UART4_INT_MAP_M  (CORE1_CORE1_UART4_INT_MAP_V << CORE1_CORE1_UART4_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_UART4_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_UART4_INT_MAP_S  0
/** CORE1_CORE1_UART4_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_UART4_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_UART4_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_UART4_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_UART4_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_UART4_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_UART4_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_UART4_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_UART4_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_UART4_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_UART4_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_UART4_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_UART4_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_UART4_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_LCD_CAM_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_LCD_CAM_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x90)
/** CORE1_CORE1_LCD_CAM_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_LCD_CAM_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_LCD_CAM_INT_MAP_M  (CORE1_CORE1_LCD_CAM_INT_MAP_V << CORE1_CORE1_LCD_CAM_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_LCD_CAM_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_LCD_CAM_INT_MAP_S  0
/** CORE1_CORE1_LCD_CAM_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_LCD_CAM_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_LCD_CAM_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_LCD_CAM_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_LCD_CAM_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_LCD_CAM_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_LCD_CAM_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_LCD_CAM_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_LCD_CAM_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_LCD_CAM_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_LCD_CAM_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_LCD_CAM_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_LCD_CAM_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_LCD_CAM_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_ADC_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_ADC_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x94)
/** CORE1_CORE1_ADC_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_ADC_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_ADC_INT_MAP_M  (CORE1_CORE1_ADC_INT_MAP_V << CORE1_CORE1_ADC_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_ADC_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_ADC_INT_MAP_S  0
/** CORE1_CORE1_ADC_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_ADC_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_ADC_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_ADC_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_ADC_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_ADC_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_ADC_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_ADC_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_ADC_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_ADC_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_ADC_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_ADC_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_ADC_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_ADC_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_PWM0_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_PWM0_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x98)
/** CORE1_CORE1_PWM0_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_PWM0_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_PWM0_INT_MAP_M  (CORE1_CORE1_PWM0_INT_MAP_V << CORE1_CORE1_PWM0_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_PWM0_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_PWM0_INT_MAP_S  0
/** CORE1_CORE1_PWM0_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_PWM0_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_PWM0_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_PWM0_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_PWM0_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_PWM0_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_PWM0_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_PWM0_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_PWM0_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_PWM0_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_PWM0_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_PWM0_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_PWM0_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_PWM0_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_PWM1_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_PWM1_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x9c)
/** CORE1_CORE1_PWM1_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_PWM1_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_PWM1_INT_MAP_M  (CORE1_CORE1_PWM1_INT_MAP_V << CORE1_CORE1_PWM1_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_PWM1_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_PWM1_INT_MAP_S  0
/** CORE1_CORE1_PWM1_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_PWM1_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_PWM1_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_PWM1_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_PWM1_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_PWM1_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_PWM1_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_PWM1_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_PWM1_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_PWM1_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_PWM1_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_PWM1_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_PWM1_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_PWM1_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_CAN0_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_CAN0_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0xa0)
/** CORE1_CORE1_CAN0_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_CAN0_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_CAN0_INT_MAP_M  (CORE1_CORE1_CAN0_INT_MAP_V << CORE1_CORE1_CAN0_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_CAN0_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_CAN0_INT_MAP_S  0
/** CORE1_CORE1_CAN0_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_CAN0_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_CAN0_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_CAN0_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_CAN0_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_CAN0_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_CAN0_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_CAN0_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_CAN0_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_CAN0_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_CAN0_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_CAN0_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_CAN0_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_CAN0_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_CAN1_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_CAN1_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0xa4)
/** CORE1_CORE1_CAN1_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_CAN1_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_CAN1_INT_MAP_M  (CORE1_CORE1_CAN1_INT_MAP_V << CORE1_CORE1_CAN1_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_CAN1_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_CAN1_INT_MAP_S  0
/** CORE1_CORE1_CAN1_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_CAN1_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_CAN1_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_CAN1_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_CAN1_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_CAN1_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_CAN1_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_CAN1_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_CAN1_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_CAN1_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_CAN1_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_CAN1_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_CAN1_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_CAN1_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_CAN2_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_CAN2_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0xa8)
/** CORE1_CORE1_CAN2_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_CAN2_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_CAN2_INT_MAP_M  (CORE1_CORE1_CAN2_INT_MAP_V << CORE1_CORE1_CAN2_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_CAN2_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_CAN2_INT_MAP_S  0
/** CORE1_CORE1_CAN2_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_CAN2_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_CAN2_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_CAN2_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_CAN2_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_CAN2_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_CAN2_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_CAN2_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_CAN2_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_CAN2_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_CAN2_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_CAN2_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_CAN2_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_CAN2_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_RMT_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_RMT_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0xac)
/** CORE1_CORE1_RMT_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_RMT_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_RMT_INT_MAP_M  (CORE1_CORE1_RMT_INT_MAP_V << CORE1_CORE1_RMT_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_RMT_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_RMT_INT_MAP_S  0
/** CORE1_CORE1_RMT_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_RMT_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_RMT_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_RMT_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_RMT_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_RMT_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_RMT_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_RMT_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_RMT_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_RMT_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_RMT_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_RMT_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_RMT_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_RMT_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_I2C0_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_I2C0_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0xb0)
/** CORE1_CORE1_I2C0_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_I2C0_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_I2C0_INT_MAP_M  (CORE1_CORE1_I2C0_INT_MAP_V << CORE1_CORE1_I2C0_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_I2C0_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_I2C0_INT_MAP_S  0
/** CORE1_CORE1_I2C0_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_I2C0_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_I2C0_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_I2C0_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_I2C0_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_I2C0_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_I2C0_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_I2C0_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_I2C0_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_I2C0_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_I2C0_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_I2C0_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_I2C0_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_I2C0_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_I2C1_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_I2C1_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0xb4)
/** CORE1_CORE1_I2C1_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_I2C1_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_I2C1_INT_MAP_M  (CORE1_CORE1_I2C1_INT_MAP_V << CORE1_CORE1_I2C1_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_I2C1_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_I2C1_INT_MAP_S  0
/** CORE1_CORE1_I2C1_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_I2C1_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_I2C1_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_I2C1_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_I2C1_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_I2C1_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_I2C1_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_I2C1_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_I2C1_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_I2C1_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_I2C1_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_I2C1_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_I2C1_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_I2C1_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_TIMERGRP0_T0_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_TIMERGRP0_T0_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0xb8)
/** CORE1_CORE1_TIMERGRP0_T0_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_TIMERGRP0_T0_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_TIMERGRP0_T0_INT_MAP_M  (CORE1_CORE1_TIMERGRP0_T0_INT_MAP_V << CORE1_CORE1_TIMERGRP0_T0_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_TIMERGRP0_T0_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_TIMERGRP0_T0_INT_MAP_S  0
/** CORE1_CORE1_TIMERGRP0_T0_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_TIMERGRP0_T0_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_TIMERGRP0_T0_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_TIMERGRP0_T0_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_TIMERGRP0_T0_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_TIMERGRP0_T0_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_TIMERGRP0_T0_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_TIMERGRP0_T0_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_TIMERGRP0_T0_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_TIMERGRP0_T0_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_TIMERGRP0_T0_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_TIMERGRP0_T0_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_TIMERGRP0_T0_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_TIMERGRP0_T0_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_TIMERGRP0_T1_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_TIMERGRP0_T1_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0xbc)
/** CORE1_CORE1_TIMERGRP0_T1_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_TIMERGRP0_T1_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_TIMERGRP0_T1_INT_MAP_M  (CORE1_CORE1_TIMERGRP0_T1_INT_MAP_V << CORE1_CORE1_TIMERGRP0_T1_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_TIMERGRP0_T1_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_TIMERGRP0_T1_INT_MAP_S  0
/** CORE1_CORE1_TIMERGRP0_T1_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_TIMERGRP0_T1_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_TIMERGRP0_T1_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_TIMERGRP0_T1_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_TIMERGRP0_T1_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_TIMERGRP0_T1_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_TIMERGRP0_T1_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_TIMERGRP0_T1_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_TIMERGRP0_T1_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_TIMERGRP0_T1_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_TIMERGRP0_T1_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_TIMERGRP0_T1_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_TIMERGRP0_T1_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_TIMERGRP0_T1_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_TIMERGRP0_WDT_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_TIMERGRP0_WDT_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0xc0)
/** CORE1_CORE1_TIMERGRP0_WDT_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_TIMERGRP0_WDT_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_TIMERGRP0_WDT_INT_MAP_M  (CORE1_CORE1_TIMERGRP0_WDT_INT_MAP_V << CORE1_CORE1_TIMERGRP0_WDT_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_TIMERGRP0_WDT_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_TIMERGRP0_WDT_INT_MAP_S  0
/** CORE1_CORE1_TIMERGRP0_WDT_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_TIMERGRP0_WDT_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_TIMERGRP0_WDT_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_TIMERGRP0_WDT_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_TIMERGRP0_WDT_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_TIMERGRP0_WDT_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_TIMERGRP0_WDT_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_TIMERGRP0_WDT_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_TIMERGRP0_WDT_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_TIMERGRP0_WDT_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_TIMERGRP0_WDT_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_TIMERGRP0_WDT_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_TIMERGRP0_WDT_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_TIMERGRP0_WDT_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_TIMERGRP1_T0_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_TIMERGRP1_T0_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0xc4)
/** CORE1_CORE1_TIMERGRP1_T0_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_TIMERGRP1_T0_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_TIMERGRP1_T0_INT_MAP_M  (CORE1_CORE1_TIMERGRP1_T0_INT_MAP_V << CORE1_CORE1_TIMERGRP1_T0_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_TIMERGRP1_T0_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_TIMERGRP1_T0_INT_MAP_S  0
/** CORE1_CORE1_TIMERGRP1_T0_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_TIMERGRP1_T0_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_TIMERGRP1_T0_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_TIMERGRP1_T0_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_TIMERGRP1_T0_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_TIMERGRP1_T0_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_TIMERGRP1_T0_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_TIMERGRP1_T0_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_TIMERGRP1_T0_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_TIMERGRP1_T0_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_TIMERGRP1_T0_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_TIMERGRP1_T0_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_TIMERGRP1_T0_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_TIMERGRP1_T0_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_TIMERGRP1_T1_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_TIMERGRP1_T1_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0xc8)
/** CORE1_CORE1_TIMERGRP1_T1_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_TIMERGRP1_T1_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_TIMERGRP1_T1_INT_MAP_M  (CORE1_CORE1_TIMERGRP1_T1_INT_MAP_V << CORE1_CORE1_TIMERGRP1_T1_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_TIMERGRP1_T1_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_TIMERGRP1_T1_INT_MAP_S  0
/** CORE1_CORE1_TIMERGRP1_T1_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_TIMERGRP1_T1_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_TIMERGRP1_T1_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_TIMERGRP1_T1_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_TIMERGRP1_T1_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_TIMERGRP1_T1_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_TIMERGRP1_T1_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_TIMERGRP1_T1_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_TIMERGRP1_T1_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_TIMERGRP1_T1_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_TIMERGRP1_T1_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_TIMERGRP1_T1_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_TIMERGRP1_T1_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_TIMERGRP1_T1_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_TIMERGRP1_WDT_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_TIMERGRP1_WDT_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0xcc)
/** CORE1_CORE1_TIMERGRP1_WDT_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_TIMERGRP1_WDT_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_TIMERGRP1_WDT_INT_MAP_M  (CORE1_CORE1_TIMERGRP1_WDT_INT_MAP_V << CORE1_CORE1_TIMERGRP1_WDT_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_TIMERGRP1_WDT_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_TIMERGRP1_WDT_INT_MAP_S  0
/** CORE1_CORE1_TIMERGRP1_WDT_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_TIMERGRP1_WDT_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_TIMERGRP1_WDT_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_TIMERGRP1_WDT_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_TIMERGRP1_WDT_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_TIMERGRP1_WDT_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_TIMERGRP1_WDT_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_TIMERGRP1_WDT_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_TIMERGRP1_WDT_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_TIMERGRP1_WDT_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_TIMERGRP1_WDT_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_TIMERGRP1_WDT_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_TIMERGRP1_WDT_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_TIMERGRP1_WDT_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_LEDC_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_LEDC_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0xd0)
/** CORE1_CORE1_LEDC_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_LEDC_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_LEDC_INT_MAP_M  (CORE1_CORE1_LEDC_INT_MAP_V << CORE1_CORE1_LEDC_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_LEDC_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_LEDC_INT_MAP_S  0
/** CORE1_CORE1_LEDC_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_LEDC_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_LEDC_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_LEDC_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_LEDC_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_LEDC_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_LEDC_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_LEDC_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_LEDC_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_LEDC_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_LEDC_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_LEDC_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_LEDC_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_LEDC_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_SYSTIMER_TARGET0_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_SYSTIMER_TARGET0_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0xd4)
/** CORE1_CORE1_SYSTIMER_TARGET0_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_SYSTIMER_TARGET0_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_SYSTIMER_TARGET0_INT_MAP_M  (CORE1_CORE1_SYSTIMER_TARGET0_INT_MAP_V << CORE1_CORE1_SYSTIMER_TARGET0_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_SYSTIMER_TARGET0_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_SYSTIMER_TARGET0_INT_MAP_S  0
/** CORE1_CORE1_SYSTIMER_TARGET0_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_SYSTIMER_TARGET0_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_SYSTIMER_TARGET0_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_SYSTIMER_TARGET0_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_SYSTIMER_TARGET0_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_SYSTIMER_TARGET0_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_SYSTIMER_TARGET0_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_SYSTIMER_TARGET0_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_SYSTIMER_TARGET0_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_SYSTIMER_TARGET0_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_SYSTIMER_TARGET0_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_SYSTIMER_TARGET0_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_SYSTIMER_TARGET0_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_SYSTIMER_TARGET0_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_SYSTIMER_TARGET1_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_SYSTIMER_TARGET1_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0xd8)
/** CORE1_CORE1_SYSTIMER_TARGET1_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_SYSTIMER_TARGET1_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_SYSTIMER_TARGET1_INT_MAP_M  (CORE1_CORE1_SYSTIMER_TARGET1_INT_MAP_V << CORE1_CORE1_SYSTIMER_TARGET1_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_SYSTIMER_TARGET1_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_SYSTIMER_TARGET1_INT_MAP_S  0
/** CORE1_CORE1_SYSTIMER_TARGET1_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_SYSTIMER_TARGET1_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_SYSTIMER_TARGET1_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_SYSTIMER_TARGET1_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_SYSTIMER_TARGET1_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_SYSTIMER_TARGET1_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_SYSTIMER_TARGET1_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_SYSTIMER_TARGET1_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_SYSTIMER_TARGET1_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_SYSTIMER_TARGET1_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_SYSTIMER_TARGET1_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_SYSTIMER_TARGET1_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_SYSTIMER_TARGET1_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_SYSTIMER_TARGET1_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_SYSTIMER_TARGET2_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_SYSTIMER_TARGET2_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0xdc)
/** CORE1_CORE1_SYSTIMER_TARGET2_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_SYSTIMER_TARGET2_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_SYSTIMER_TARGET2_INT_MAP_M  (CORE1_CORE1_SYSTIMER_TARGET2_INT_MAP_V << CORE1_CORE1_SYSTIMER_TARGET2_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_SYSTIMER_TARGET2_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_SYSTIMER_TARGET2_INT_MAP_S  0
/** CORE1_CORE1_SYSTIMER_TARGET2_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_SYSTIMER_TARGET2_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_SYSTIMER_TARGET2_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_SYSTIMER_TARGET2_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_SYSTIMER_TARGET2_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_SYSTIMER_TARGET2_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_SYSTIMER_TARGET2_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_SYSTIMER_TARGET2_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_SYSTIMER_TARGET2_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_SYSTIMER_TARGET2_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_SYSTIMER_TARGET2_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_SYSTIMER_TARGET2_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_SYSTIMER_TARGET2_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_SYSTIMER_TARGET2_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_AHB_PDMA_IN_CH0_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_AHB_PDMA_IN_CH0_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0xe0)
/** CORE1_CORE1_AHB_PDMA_IN_CH0_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_AHB_PDMA_IN_CH0_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_AHB_PDMA_IN_CH0_INT_MAP_M  (CORE1_CORE1_AHB_PDMA_IN_CH0_INT_MAP_V << CORE1_CORE1_AHB_PDMA_IN_CH0_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_AHB_PDMA_IN_CH0_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_AHB_PDMA_IN_CH0_INT_MAP_S  0
/** CORE1_CORE1_AHB_PDMA_IN_CH0_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_AHB_PDMA_IN_CH0_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_AHB_PDMA_IN_CH0_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_AHB_PDMA_IN_CH0_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_AHB_PDMA_IN_CH0_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_AHB_PDMA_IN_CH0_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_AHB_PDMA_IN_CH0_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_AHB_PDMA_IN_CH0_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_AHB_PDMA_IN_CH0_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_AHB_PDMA_IN_CH0_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_AHB_PDMA_IN_CH0_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_AHB_PDMA_IN_CH0_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_AHB_PDMA_IN_CH0_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_AHB_PDMA_IN_CH0_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_AHB_PDMA_IN_CH1_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_AHB_PDMA_IN_CH1_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0xe4)
/** CORE1_CORE1_AHB_PDMA_IN_CH1_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_AHB_PDMA_IN_CH1_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_AHB_PDMA_IN_CH1_INT_MAP_M  (CORE1_CORE1_AHB_PDMA_IN_CH1_INT_MAP_V << CORE1_CORE1_AHB_PDMA_IN_CH1_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_AHB_PDMA_IN_CH1_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_AHB_PDMA_IN_CH1_INT_MAP_S  0
/** CORE1_CORE1_AHB_PDMA_IN_CH1_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_AHB_PDMA_IN_CH1_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_AHB_PDMA_IN_CH1_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_AHB_PDMA_IN_CH1_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_AHB_PDMA_IN_CH1_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_AHB_PDMA_IN_CH1_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_AHB_PDMA_IN_CH1_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_AHB_PDMA_IN_CH1_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_AHB_PDMA_IN_CH1_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_AHB_PDMA_IN_CH1_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_AHB_PDMA_IN_CH1_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_AHB_PDMA_IN_CH1_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_AHB_PDMA_IN_CH1_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_AHB_PDMA_IN_CH1_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_AHB_PDMA_IN_CH2_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_AHB_PDMA_IN_CH2_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0xe8)
/** CORE1_CORE1_AHB_PDMA_IN_CH2_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_AHB_PDMA_IN_CH2_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_AHB_PDMA_IN_CH2_INT_MAP_M  (CORE1_CORE1_AHB_PDMA_IN_CH2_INT_MAP_V << CORE1_CORE1_AHB_PDMA_IN_CH2_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_AHB_PDMA_IN_CH2_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_AHB_PDMA_IN_CH2_INT_MAP_S  0
/** CORE1_CORE1_AHB_PDMA_IN_CH2_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_AHB_PDMA_IN_CH2_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_AHB_PDMA_IN_CH2_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_AHB_PDMA_IN_CH2_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_AHB_PDMA_IN_CH2_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_AHB_PDMA_IN_CH2_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_AHB_PDMA_IN_CH2_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_AHB_PDMA_IN_CH2_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_AHB_PDMA_IN_CH2_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_AHB_PDMA_IN_CH2_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_AHB_PDMA_IN_CH2_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_AHB_PDMA_IN_CH2_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_AHB_PDMA_IN_CH2_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_AHB_PDMA_IN_CH2_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_AHB_PDMA_OUT_CH0_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_AHB_PDMA_OUT_CH0_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0xec)
/** CORE1_CORE1_AHB_PDMA_OUT_CH0_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_AHB_PDMA_OUT_CH0_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_AHB_PDMA_OUT_CH0_INT_MAP_M  (CORE1_CORE1_AHB_PDMA_OUT_CH0_INT_MAP_V << CORE1_CORE1_AHB_PDMA_OUT_CH0_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_AHB_PDMA_OUT_CH0_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_AHB_PDMA_OUT_CH0_INT_MAP_S  0
/** CORE1_CORE1_AHB_PDMA_OUT_CH0_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_AHB_PDMA_OUT_CH0_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_AHB_PDMA_OUT_CH0_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_AHB_PDMA_OUT_CH0_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_AHB_PDMA_OUT_CH0_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_AHB_PDMA_OUT_CH0_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_AHB_PDMA_OUT_CH0_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_AHB_PDMA_OUT_CH0_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_AHB_PDMA_OUT_CH0_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_AHB_PDMA_OUT_CH0_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_AHB_PDMA_OUT_CH0_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_AHB_PDMA_OUT_CH0_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_AHB_PDMA_OUT_CH0_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_AHB_PDMA_OUT_CH0_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_AHB_PDMA_OUT_CH1_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_AHB_PDMA_OUT_CH1_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0xf0)
/** CORE1_CORE1_AHB_PDMA_OUT_CH1_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_AHB_PDMA_OUT_CH1_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_AHB_PDMA_OUT_CH1_INT_MAP_M  (CORE1_CORE1_AHB_PDMA_OUT_CH1_INT_MAP_V << CORE1_CORE1_AHB_PDMA_OUT_CH1_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_AHB_PDMA_OUT_CH1_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_AHB_PDMA_OUT_CH1_INT_MAP_S  0
/** CORE1_CORE1_AHB_PDMA_OUT_CH1_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_AHB_PDMA_OUT_CH1_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_AHB_PDMA_OUT_CH1_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_AHB_PDMA_OUT_CH1_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_AHB_PDMA_OUT_CH1_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_AHB_PDMA_OUT_CH1_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_AHB_PDMA_OUT_CH1_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_AHB_PDMA_OUT_CH1_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_AHB_PDMA_OUT_CH1_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_AHB_PDMA_OUT_CH1_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_AHB_PDMA_OUT_CH1_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_AHB_PDMA_OUT_CH1_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_AHB_PDMA_OUT_CH1_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_AHB_PDMA_OUT_CH1_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_AHB_PDMA_OUT_CH2_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_AHB_PDMA_OUT_CH2_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0xf4)
/** CORE1_CORE1_AHB_PDMA_OUT_CH2_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_AHB_PDMA_OUT_CH2_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_AHB_PDMA_OUT_CH2_INT_MAP_M  (CORE1_CORE1_AHB_PDMA_OUT_CH2_INT_MAP_V << CORE1_CORE1_AHB_PDMA_OUT_CH2_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_AHB_PDMA_OUT_CH2_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_AHB_PDMA_OUT_CH2_INT_MAP_S  0
/** CORE1_CORE1_AHB_PDMA_OUT_CH2_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_AHB_PDMA_OUT_CH2_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_AHB_PDMA_OUT_CH2_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_AHB_PDMA_OUT_CH2_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_AHB_PDMA_OUT_CH2_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_AHB_PDMA_OUT_CH2_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_AHB_PDMA_OUT_CH2_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_AHB_PDMA_OUT_CH2_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_AHB_PDMA_OUT_CH2_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_AHB_PDMA_OUT_CH2_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_AHB_PDMA_OUT_CH2_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_AHB_PDMA_OUT_CH2_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_AHB_PDMA_OUT_CH2_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_AHB_PDMA_OUT_CH2_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_AXI_PDMA_IN_CH0_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_AXI_PDMA_IN_CH0_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0xf8)
/** CORE1_CORE1_AXI_PDMA_IN_CH0_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_AXI_PDMA_IN_CH0_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_AXI_PDMA_IN_CH0_INT_MAP_M  (CORE1_CORE1_AXI_PDMA_IN_CH0_INT_MAP_V << CORE1_CORE1_AXI_PDMA_IN_CH0_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_AXI_PDMA_IN_CH0_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_AXI_PDMA_IN_CH0_INT_MAP_S  0
/** CORE1_CORE1_AXI_PDMA_IN_CH0_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_AXI_PDMA_IN_CH0_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_AXI_PDMA_IN_CH0_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_AXI_PDMA_IN_CH0_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_AXI_PDMA_IN_CH0_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_AXI_PDMA_IN_CH0_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_AXI_PDMA_IN_CH0_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_AXI_PDMA_IN_CH0_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_AXI_PDMA_IN_CH0_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_AXI_PDMA_IN_CH0_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_AXI_PDMA_IN_CH0_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_AXI_PDMA_IN_CH0_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_AXI_PDMA_IN_CH0_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_AXI_PDMA_IN_CH0_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_AXI_PDMA_IN_CH1_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_AXI_PDMA_IN_CH1_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0xfc)
/** CORE1_CORE1_AXI_PDMA_IN_CH1_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_AXI_PDMA_IN_CH1_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_AXI_PDMA_IN_CH1_INT_MAP_M  (CORE1_CORE1_AXI_PDMA_IN_CH1_INT_MAP_V << CORE1_CORE1_AXI_PDMA_IN_CH1_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_AXI_PDMA_IN_CH1_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_AXI_PDMA_IN_CH1_INT_MAP_S  0
/** CORE1_CORE1_AXI_PDMA_IN_CH1_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_AXI_PDMA_IN_CH1_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_AXI_PDMA_IN_CH1_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_AXI_PDMA_IN_CH1_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_AXI_PDMA_IN_CH1_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_AXI_PDMA_IN_CH1_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_AXI_PDMA_IN_CH1_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_AXI_PDMA_IN_CH1_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_AXI_PDMA_IN_CH1_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_AXI_PDMA_IN_CH1_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_AXI_PDMA_IN_CH1_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_AXI_PDMA_IN_CH1_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_AXI_PDMA_IN_CH1_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_AXI_PDMA_IN_CH1_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_AXI_PDMA_IN_CH2_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_AXI_PDMA_IN_CH2_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x100)
/** CORE1_CORE1_AXI_PDMA_IN_CH2_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_AXI_PDMA_IN_CH2_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_AXI_PDMA_IN_CH2_INT_MAP_M  (CORE1_CORE1_AXI_PDMA_IN_CH2_INT_MAP_V << CORE1_CORE1_AXI_PDMA_IN_CH2_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_AXI_PDMA_IN_CH2_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_AXI_PDMA_IN_CH2_INT_MAP_S  0
/** CORE1_CORE1_AXI_PDMA_IN_CH2_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_AXI_PDMA_IN_CH2_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_AXI_PDMA_IN_CH2_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_AXI_PDMA_IN_CH2_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_AXI_PDMA_IN_CH2_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_AXI_PDMA_IN_CH2_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_AXI_PDMA_IN_CH2_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_AXI_PDMA_IN_CH2_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_AXI_PDMA_IN_CH2_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_AXI_PDMA_IN_CH2_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_AXI_PDMA_IN_CH2_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_AXI_PDMA_IN_CH2_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_AXI_PDMA_IN_CH2_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_AXI_PDMA_IN_CH2_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_AXI_PDMA_OUT_CH0_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_AXI_PDMA_OUT_CH0_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x104)
/** CORE1_CORE1_AXI_PDMA_OUT_CH0_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_AXI_PDMA_OUT_CH0_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_AXI_PDMA_OUT_CH0_INT_MAP_M  (CORE1_CORE1_AXI_PDMA_OUT_CH0_INT_MAP_V << CORE1_CORE1_AXI_PDMA_OUT_CH0_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_AXI_PDMA_OUT_CH0_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_AXI_PDMA_OUT_CH0_INT_MAP_S  0
/** CORE1_CORE1_AXI_PDMA_OUT_CH0_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_AXI_PDMA_OUT_CH0_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_AXI_PDMA_OUT_CH0_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_AXI_PDMA_OUT_CH0_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_AXI_PDMA_OUT_CH0_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_AXI_PDMA_OUT_CH0_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_AXI_PDMA_OUT_CH0_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_AXI_PDMA_OUT_CH0_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_AXI_PDMA_OUT_CH0_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_AXI_PDMA_OUT_CH0_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_AXI_PDMA_OUT_CH0_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_AXI_PDMA_OUT_CH0_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_AXI_PDMA_OUT_CH0_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_AXI_PDMA_OUT_CH0_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_AXI_PDMA_OUT_CH1_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_AXI_PDMA_OUT_CH1_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x108)
/** CORE1_CORE1_AXI_PDMA_OUT_CH1_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_AXI_PDMA_OUT_CH1_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_AXI_PDMA_OUT_CH1_INT_MAP_M  (CORE1_CORE1_AXI_PDMA_OUT_CH1_INT_MAP_V << CORE1_CORE1_AXI_PDMA_OUT_CH1_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_AXI_PDMA_OUT_CH1_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_AXI_PDMA_OUT_CH1_INT_MAP_S  0
/** CORE1_CORE1_AXI_PDMA_OUT_CH1_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_AXI_PDMA_OUT_CH1_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_AXI_PDMA_OUT_CH1_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_AXI_PDMA_OUT_CH1_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_AXI_PDMA_OUT_CH1_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_AXI_PDMA_OUT_CH1_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_AXI_PDMA_OUT_CH1_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_AXI_PDMA_OUT_CH1_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_AXI_PDMA_OUT_CH1_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_AXI_PDMA_OUT_CH1_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_AXI_PDMA_OUT_CH1_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_AXI_PDMA_OUT_CH1_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_AXI_PDMA_OUT_CH1_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_AXI_PDMA_OUT_CH1_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_AXI_PDMA_OUT_CH2_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_AXI_PDMA_OUT_CH2_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x10c)
/** CORE1_CORE1_AXI_PDMA_OUT_CH2_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_AXI_PDMA_OUT_CH2_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_AXI_PDMA_OUT_CH2_INT_MAP_M  (CORE1_CORE1_AXI_PDMA_OUT_CH2_INT_MAP_V << CORE1_CORE1_AXI_PDMA_OUT_CH2_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_AXI_PDMA_OUT_CH2_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_AXI_PDMA_OUT_CH2_INT_MAP_S  0
/** CORE1_CORE1_AXI_PDMA_OUT_CH2_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_AXI_PDMA_OUT_CH2_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_AXI_PDMA_OUT_CH2_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_AXI_PDMA_OUT_CH2_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_AXI_PDMA_OUT_CH2_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_AXI_PDMA_OUT_CH2_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_AXI_PDMA_OUT_CH2_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_AXI_PDMA_OUT_CH2_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_AXI_PDMA_OUT_CH2_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_AXI_PDMA_OUT_CH2_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_AXI_PDMA_OUT_CH2_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_AXI_PDMA_OUT_CH2_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_AXI_PDMA_OUT_CH2_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_AXI_PDMA_OUT_CH2_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_RSA_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_RSA_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x110)
/** CORE1_CORE1_RSA_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_RSA_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_RSA_INT_MAP_M  (CORE1_CORE1_RSA_INT_MAP_V << CORE1_CORE1_RSA_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_RSA_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_RSA_INT_MAP_S  0
/** CORE1_CORE1_RSA_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_RSA_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_RSA_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_RSA_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_RSA_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_RSA_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_RSA_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_RSA_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_RSA_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_RSA_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_RSA_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_RSA_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_RSA_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_RSA_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_AES_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_AES_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x114)
/** CORE1_CORE1_AES_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_AES_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_AES_INT_MAP_M  (CORE1_CORE1_AES_INT_MAP_V << CORE1_CORE1_AES_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_AES_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_AES_INT_MAP_S  0
/** CORE1_CORE1_AES_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_AES_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_AES_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_AES_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_AES_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_AES_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_AES_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_AES_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_AES_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_AES_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_AES_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_AES_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_AES_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_AES_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_SHA_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_SHA_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x118)
/** CORE1_CORE1_SHA_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_SHA_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_SHA_INT_MAP_M  (CORE1_CORE1_SHA_INT_MAP_V << CORE1_CORE1_SHA_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_SHA_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_SHA_INT_MAP_S  0
/** CORE1_CORE1_SHA_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_SHA_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_SHA_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_SHA_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_SHA_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_SHA_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_SHA_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_SHA_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_SHA_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_SHA_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_SHA_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_SHA_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_SHA_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_SHA_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_ECC_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_ECC_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x11c)
/** CORE1_CORE1_ECC_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_ECC_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_ECC_INT_MAP_M  (CORE1_CORE1_ECC_INT_MAP_V << CORE1_CORE1_ECC_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_ECC_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_ECC_INT_MAP_S  0
/** CORE1_CORE1_ECC_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_ECC_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_ECC_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_ECC_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_ECC_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_ECC_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_ECC_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_ECC_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_ECC_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_ECC_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_ECC_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_ECC_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_ECC_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_ECC_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_ECDSA_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_ECDSA_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x120)
/** CORE1_CORE1_ECDSA_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_ECDSA_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_ECDSA_INT_MAP_M  (CORE1_CORE1_ECDSA_INT_MAP_V << CORE1_CORE1_ECDSA_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_ECDSA_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_ECDSA_INT_MAP_S  0
/** CORE1_CORE1_ECDSA_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_ECDSA_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_ECDSA_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_ECDSA_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_ECDSA_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_ECDSA_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_ECDSA_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_ECDSA_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_ECDSA_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_ECDSA_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_ECDSA_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_ECDSA_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_ECDSA_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_ECDSA_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_KM_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_KM_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x124)
/** CORE1_CORE1_KM_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_KM_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_KM_INT_MAP_M  (CORE1_CORE1_KM_INT_MAP_V << CORE1_CORE1_KM_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_KM_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_KM_INT_MAP_S  0
/** CORE1_CORE1_KM_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_KM_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_KM_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_KM_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_KM_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_KM_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_KM_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_KM_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_KM_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_KM_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_KM_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_KM_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_KM_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_KM_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_GPIO_INT0_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_GPIO_INT0_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x128)
/** CORE1_CORE1_GPIO_INT0_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_GPIO_INT0_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_GPIO_INT0_MAP_M  (CORE1_CORE1_GPIO_INT0_MAP_V << CORE1_CORE1_GPIO_INT0_MAP_S)
#define INTERRUPT_CORE1_CORE1_GPIO_INT0_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_GPIO_INT0_MAP_S  0
/** CORE1_CORE1_GPIO_INT0_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_GPIO_INT0_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_GPIO_INT0_SRC_PASS_IN_SEC_M  (CORE1_CORE1_GPIO_INT0_SRC_PASS_IN_SEC_V << CORE1_CORE1_GPIO_INT0_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_GPIO_INT0_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_GPIO_INT0_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_GPIO_INT0_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_GPIO_INT0_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_GPIO_INT0_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_GPIO_INT0_SRC_IN_SEC_FLAG_V << CORE1_CORE1_GPIO_INT0_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_GPIO_INT0_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_GPIO_INT0_SRC_IN_SEC_FLAG_S  7

/** CORE1_GPIO_INT1_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_GPIO_INT1_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x12c)
/** CORE1_CORE1_GPIO_INT1_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_GPIO_INT1_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_GPIO_INT1_MAP_M  (CORE1_CORE1_GPIO_INT1_MAP_V << CORE1_CORE1_GPIO_INT1_MAP_S)
#define INTERRUPT_CORE1_CORE1_GPIO_INT1_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_GPIO_INT1_MAP_S  0
/** CORE1_CORE1_GPIO_INT1_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_GPIO_INT1_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_GPIO_INT1_SRC_PASS_IN_SEC_M  (CORE1_CORE1_GPIO_INT1_SRC_PASS_IN_SEC_V << CORE1_CORE1_GPIO_INT1_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_GPIO_INT1_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_GPIO_INT1_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_GPIO_INT1_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_GPIO_INT1_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_GPIO_INT1_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_GPIO_INT1_SRC_IN_SEC_FLAG_V << CORE1_CORE1_GPIO_INT1_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_GPIO_INT1_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_GPIO_INT1_SRC_IN_SEC_FLAG_S  7

/** CORE1_GPIO_INT2_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_GPIO_INT2_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x130)
/** CORE1_CORE1_GPIO_INT2_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_GPIO_INT2_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_GPIO_INT2_MAP_M  (CORE1_CORE1_GPIO_INT2_MAP_V << CORE1_CORE1_GPIO_INT2_MAP_S)
#define INTERRUPT_CORE1_CORE1_GPIO_INT2_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_GPIO_INT2_MAP_S  0
/** CORE1_CORE1_GPIO_INT2_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_GPIO_INT2_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_GPIO_INT2_SRC_PASS_IN_SEC_M  (CORE1_CORE1_GPIO_INT2_SRC_PASS_IN_SEC_V << CORE1_CORE1_GPIO_INT2_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_GPIO_INT2_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_GPIO_INT2_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_GPIO_INT2_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_GPIO_INT2_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_GPIO_INT2_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_GPIO_INT2_SRC_IN_SEC_FLAG_V << CORE1_CORE1_GPIO_INT2_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_GPIO_INT2_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_GPIO_INT2_SRC_IN_SEC_FLAG_S  7

/** CORE1_GPIO_INT3_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_GPIO_INT3_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x134)
/** CORE1_CORE1_GPIO_INT3_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_GPIO_INT3_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_GPIO_INT3_MAP_M  (CORE1_CORE1_GPIO_INT3_MAP_V << CORE1_CORE1_GPIO_INT3_MAP_S)
#define INTERRUPT_CORE1_CORE1_GPIO_INT3_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_GPIO_INT3_MAP_S  0
/** CORE1_CORE1_GPIO_INT3_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_GPIO_INT3_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_GPIO_INT3_SRC_PASS_IN_SEC_M  (CORE1_CORE1_GPIO_INT3_SRC_PASS_IN_SEC_V << CORE1_CORE1_GPIO_INT3_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_GPIO_INT3_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_GPIO_INT3_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_GPIO_INT3_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_GPIO_INT3_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_GPIO_INT3_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_GPIO_INT3_SRC_IN_SEC_FLAG_V << CORE1_CORE1_GPIO_INT3_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_GPIO_INT3_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_GPIO_INT3_SRC_IN_SEC_FLAG_S  7

/** CORE1_GPIO_PAD_COMP_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_GPIO_PAD_COMP_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x138)
/** CORE1_CORE1_GPIO_PAD_COMP_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_GPIO_PAD_COMP_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_GPIO_PAD_COMP_INT_MAP_M  (CORE1_CORE1_GPIO_PAD_COMP_INT_MAP_V << CORE1_CORE1_GPIO_PAD_COMP_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_GPIO_PAD_COMP_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_GPIO_PAD_COMP_INT_MAP_S  0
/** CORE1_CORE1_GPIO_PAD_COMP_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_GPIO_PAD_COMP_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_GPIO_PAD_COMP_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_GPIO_PAD_COMP_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_GPIO_PAD_COMP_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_GPIO_PAD_COMP_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_GPIO_PAD_COMP_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_GPIO_PAD_COMP_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_GPIO_PAD_COMP_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_GPIO_PAD_COMP_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_GPIO_PAD_COMP_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_GPIO_PAD_COMP_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_GPIO_PAD_COMP_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_GPIO_PAD_COMP_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_CPU_INT_FROM_CPU_0_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_CPU_INT_FROM_CPU_0_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x13c)
/** CORE1_CORE1_CPU_INT_FROM_CPU_0_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_CPU_INT_FROM_CPU_0_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_CPU_INT_FROM_CPU_0_MAP_M  (CORE1_CORE1_CPU_INT_FROM_CPU_0_MAP_V << CORE1_CORE1_CPU_INT_FROM_CPU_0_MAP_S)
#define INTERRUPT_CORE1_CORE1_CPU_INT_FROM_CPU_0_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_CPU_INT_FROM_CPU_0_MAP_S  0
/** CORE1_CORE1_CPU_INT_FROM_CPU_0_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_CPU_INT_FROM_CPU_0_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_CPU_INT_FROM_CPU_0_SRC_PASS_IN_SEC_M  (CORE1_CORE1_CPU_INT_FROM_CPU_0_SRC_PASS_IN_SEC_V << CORE1_CORE1_CPU_INT_FROM_CPU_0_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_CPU_INT_FROM_CPU_0_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_CPU_INT_FROM_CPU_0_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_CPU_INT_FROM_CPU_0_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_CPU_INT_FROM_CPU_0_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_CPU_INT_FROM_CPU_0_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_CPU_INT_FROM_CPU_0_SRC_IN_SEC_FLAG_V << CORE1_CORE1_CPU_INT_FROM_CPU_0_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_CPU_INT_FROM_CPU_0_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_CPU_INT_FROM_CPU_0_SRC_IN_SEC_FLAG_S  7

/** CORE1_CPU_INT_FROM_CPU_1_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_CPU_INT_FROM_CPU_1_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x140)
/** CORE1_CORE1_CPU_INT_FROM_CPU_1_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_CPU_INT_FROM_CPU_1_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_CPU_INT_FROM_CPU_1_MAP_M  (CORE1_CORE1_CPU_INT_FROM_CPU_1_MAP_V << CORE1_CORE1_CPU_INT_FROM_CPU_1_MAP_S)
#define INTERRUPT_CORE1_CORE1_CPU_INT_FROM_CPU_1_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_CPU_INT_FROM_CPU_1_MAP_S  0
/** CORE1_CORE1_CPU_INT_FROM_CPU_1_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_CPU_INT_FROM_CPU_1_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_CPU_INT_FROM_CPU_1_SRC_PASS_IN_SEC_M  (CORE1_CORE1_CPU_INT_FROM_CPU_1_SRC_PASS_IN_SEC_V << CORE1_CORE1_CPU_INT_FROM_CPU_1_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_CPU_INT_FROM_CPU_1_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_CPU_INT_FROM_CPU_1_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_CPU_INT_FROM_CPU_1_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_CPU_INT_FROM_CPU_1_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_CPU_INT_FROM_CPU_1_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_CPU_INT_FROM_CPU_1_SRC_IN_SEC_FLAG_V << CORE1_CORE1_CPU_INT_FROM_CPU_1_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_CPU_INT_FROM_CPU_1_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_CPU_INT_FROM_CPU_1_SRC_IN_SEC_FLAG_S  7

/** CORE1_CPU_INT_FROM_CPU_2_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_CPU_INT_FROM_CPU_2_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x144)
/** CORE1_CORE1_CPU_INT_FROM_CPU_2_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_CPU_INT_FROM_CPU_2_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_CPU_INT_FROM_CPU_2_MAP_M  (CORE1_CORE1_CPU_INT_FROM_CPU_2_MAP_V << CORE1_CORE1_CPU_INT_FROM_CPU_2_MAP_S)
#define INTERRUPT_CORE1_CORE1_CPU_INT_FROM_CPU_2_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_CPU_INT_FROM_CPU_2_MAP_S  0
/** CORE1_CORE1_CPU_INT_FROM_CPU_2_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_CPU_INT_FROM_CPU_2_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_CPU_INT_FROM_CPU_2_SRC_PASS_IN_SEC_M  (CORE1_CORE1_CPU_INT_FROM_CPU_2_SRC_PASS_IN_SEC_V << CORE1_CORE1_CPU_INT_FROM_CPU_2_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_CPU_INT_FROM_CPU_2_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_CPU_INT_FROM_CPU_2_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_CPU_INT_FROM_CPU_2_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_CPU_INT_FROM_CPU_2_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_CPU_INT_FROM_CPU_2_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_CPU_INT_FROM_CPU_2_SRC_IN_SEC_FLAG_V << CORE1_CORE1_CPU_INT_FROM_CPU_2_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_CPU_INT_FROM_CPU_2_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_CPU_INT_FROM_CPU_2_SRC_IN_SEC_FLAG_S  7

/** CORE1_CPU_INT_FROM_CPU_3_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_CPU_INT_FROM_CPU_3_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x148)
/** CORE1_CORE1_CPU_INT_FROM_CPU_3_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_CPU_INT_FROM_CPU_3_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_CPU_INT_FROM_CPU_3_MAP_M  (CORE1_CORE1_CPU_INT_FROM_CPU_3_MAP_V << CORE1_CORE1_CPU_INT_FROM_CPU_3_MAP_S)
#define INTERRUPT_CORE1_CORE1_CPU_INT_FROM_CPU_3_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_CPU_INT_FROM_CPU_3_MAP_S  0
/** CORE1_CORE1_CPU_INT_FROM_CPU_3_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_CPU_INT_FROM_CPU_3_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_CPU_INT_FROM_CPU_3_SRC_PASS_IN_SEC_M  (CORE1_CORE1_CPU_INT_FROM_CPU_3_SRC_PASS_IN_SEC_V << CORE1_CORE1_CPU_INT_FROM_CPU_3_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_CPU_INT_FROM_CPU_3_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_CPU_INT_FROM_CPU_3_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_CPU_INT_FROM_CPU_3_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_CPU_INT_FROM_CPU_3_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_CPU_INT_FROM_CPU_3_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_CPU_INT_FROM_CPU_3_SRC_IN_SEC_FLAG_V << CORE1_CORE1_CPU_INT_FROM_CPU_3_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_CPU_INT_FROM_CPU_3_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_CPU_INT_FROM_CPU_3_SRC_IN_SEC_FLAG_S  7

/** CORE1_CACHE_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_CACHE_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x14c)
/** CORE1_CORE1_CACHE_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_CACHE_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_CACHE_INT_MAP_M  (CORE1_CORE1_CACHE_INT_MAP_V << CORE1_CORE1_CACHE_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_CACHE_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_CACHE_INT_MAP_S  0
/** CORE1_CORE1_CACHE_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_CACHE_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_CACHE_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_CACHE_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_CACHE_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_CACHE_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_CACHE_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_CACHE_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_CACHE_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_CACHE_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_CACHE_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_CACHE_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_CACHE_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_CACHE_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_FLASH_MSPI_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_FLASH_MSPI_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x150)
/** CORE1_CORE1_FLASH_MSPI_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_FLASH_MSPI_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_FLASH_MSPI_INT_MAP_M  (CORE1_CORE1_FLASH_MSPI_INT_MAP_V << CORE1_CORE1_FLASH_MSPI_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_FLASH_MSPI_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_FLASH_MSPI_INT_MAP_S  0
/** CORE1_CORE1_FLASH_MSPI_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_FLASH_MSPI_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_FLASH_MSPI_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_FLASH_MSPI_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_FLASH_MSPI_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_FLASH_MSPI_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_FLASH_MSPI_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_FLASH_MSPI_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_FLASH_MSPI_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_FLASH_MSPI_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_FLASH_MSPI_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_FLASH_MSPI_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_FLASH_MSPI_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_FLASH_MSPI_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_CSI_BRIDGE_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_CSI_BRIDGE_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x154)
/** CORE1_CORE1_CSI_BRIDGE_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_CSI_BRIDGE_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_CSI_BRIDGE_INT_MAP_M  (CORE1_CORE1_CSI_BRIDGE_INT_MAP_V << CORE1_CORE1_CSI_BRIDGE_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_CSI_BRIDGE_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_CSI_BRIDGE_INT_MAP_S  0
/** CORE1_CORE1_CSI_BRIDGE_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_CSI_BRIDGE_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_CSI_BRIDGE_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_CSI_BRIDGE_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_CSI_BRIDGE_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_CSI_BRIDGE_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_CSI_BRIDGE_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_CSI_BRIDGE_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_CSI_BRIDGE_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_CSI_BRIDGE_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_CSI_BRIDGE_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_CSI_BRIDGE_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_CSI_BRIDGE_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_CSI_BRIDGE_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_DSI_BRIDGE_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_DSI_BRIDGE_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x158)
/** CORE1_CORE1_DSI_BRIDGE_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_DSI_BRIDGE_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_DSI_BRIDGE_INT_MAP_M  (CORE1_CORE1_DSI_BRIDGE_INT_MAP_V << CORE1_CORE1_DSI_BRIDGE_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_DSI_BRIDGE_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_DSI_BRIDGE_INT_MAP_S  0
/** CORE1_CORE1_DSI_BRIDGE_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_DSI_BRIDGE_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_DSI_BRIDGE_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_DSI_BRIDGE_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_DSI_BRIDGE_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_DSI_BRIDGE_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_DSI_BRIDGE_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_DSI_BRIDGE_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_DSI_BRIDGE_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_DSI_BRIDGE_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_DSI_BRIDGE_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_DSI_BRIDGE_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_DSI_BRIDGE_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_DSI_BRIDGE_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_CSI_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_CSI_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x15c)
/** CORE1_CORE1_CSI_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_CSI_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_CSI_INT_MAP_M  (CORE1_CORE1_CSI_INT_MAP_V << CORE1_CORE1_CSI_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_CSI_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_CSI_INT_MAP_S  0
/** CORE1_CORE1_CSI_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_CSI_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_CSI_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_CSI_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_CSI_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_CSI_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_CSI_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_CSI_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_CSI_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_CSI_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_CSI_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_CSI_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_CSI_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_CSI_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_DSI_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_DSI_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x160)
/** CORE1_CORE1_DSI_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_DSI_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_DSI_INT_MAP_M  (CORE1_CORE1_DSI_INT_MAP_V << CORE1_CORE1_DSI_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_DSI_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_DSI_INT_MAP_S  0
/** CORE1_CORE1_DSI_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_DSI_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_DSI_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_DSI_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_DSI_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_DSI_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_DSI_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_DSI_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_DSI_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_DSI_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_DSI_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_DSI_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_DSI_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_DSI_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_GMII_PHY_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_GMII_PHY_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x164)
/** CORE1_CORE1_GMII_PHY_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_GMII_PHY_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_GMII_PHY_INT_MAP_M  (CORE1_CORE1_GMII_PHY_INT_MAP_V << CORE1_CORE1_GMII_PHY_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_GMII_PHY_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_GMII_PHY_INT_MAP_S  0
/** CORE1_CORE1_GMII_PHY_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_GMII_PHY_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_GMII_PHY_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_GMII_PHY_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_GMII_PHY_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_GMII_PHY_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_GMII_PHY_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_GMII_PHY_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_GMII_PHY_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_GMII_PHY_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_GMII_PHY_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_GMII_PHY_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_GMII_PHY_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_GMII_PHY_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_LPI_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_LPI_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x168)
/** CORE1_CORE1_LPI_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_LPI_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_LPI_INT_MAP_M  (CORE1_CORE1_LPI_INT_MAP_V << CORE1_CORE1_LPI_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_LPI_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_LPI_INT_MAP_S  0
/** CORE1_CORE1_LPI_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_LPI_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_LPI_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_LPI_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_LPI_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_LPI_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_LPI_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_LPI_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_LPI_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_LPI_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_LPI_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_LPI_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_LPI_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_LPI_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_PMT_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_PMT_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x16c)
/** CORE1_CORE1_PMT_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_PMT_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_PMT_INT_MAP_M  (CORE1_CORE1_PMT_INT_MAP_V << CORE1_CORE1_PMT_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_PMT_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_PMT_INT_MAP_S  0
/** CORE1_CORE1_PMT_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_PMT_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_PMT_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_PMT_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_PMT_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_PMT_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_PMT_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_PMT_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_PMT_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_PMT_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_PMT_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_PMT_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_PMT_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_PMT_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_SBD_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_SBD_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x170)
/** CORE1_CORE1_SBD_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_SBD_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_SBD_INT_MAP_M  (CORE1_CORE1_SBD_INT_MAP_V << CORE1_CORE1_SBD_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_SBD_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_SBD_INT_MAP_S  0
/** CORE1_CORE1_SBD_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_SBD_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_SBD_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_SBD_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_SBD_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_SBD_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_SBD_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_SBD_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_SBD_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_SBD_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_SBD_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_SBD_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_SBD_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_SBD_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_USB_OTG_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_USB_OTG_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x174)
/** CORE1_CORE1_USB_OTG_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_USB_OTG_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_USB_OTG_INT_MAP_M  (CORE1_CORE1_USB_OTG_INT_MAP_V << CORE1_CORE1_USB_OTG_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_USB_OTG_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_USB_OTG_INT_MAP_S  0
/** CORE1_CORE1_USB_OTG_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_USB_OTG_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_USB_OTG_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_USB_OTG_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_USB_OTG_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_USB_OTG_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_USB_OTG_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_USB_OTG_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_USB_OTG_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_USB_OTG_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_USB_OTG_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_USB_OTG_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_USB_OTG_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_USB_OTG_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_USB_OTG_ENDP_MULTI_PROC_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_USB_OTG_ENDP_MULTI_PROC_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x178)
/** CORE1_CORE1_USB_OTG_ENDP_MULTI_PROC_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_USB_OTG_ENDP_MULTI_PROC_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_USB_OTG_ENDP_MULTI_PROC_INT_MAP_M  (CORE1_CORE1_USB_OTG_ENDP_MULTI_PROC_INT_MAP_V << CORE1_CORE1_USB_OTG_ENDP_MULTI_PROC_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_USB_OTG_ENDP_MULTI_PROC_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_USB_OTG_ENDP_MULTI_PROC_INT_MAP_S  0
/** CORE1_CORE1_USB_OTG_ENDP_MULTI_PROC_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6];
 *  default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_USB_OTG_ENDP_MULTI_PROC_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_USB_OTG_ENDP_MULTI_PROC_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_USB_OTG_ENDP_MULTI_PROC_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_USB_OTG_ENDP_MULTI_PROC_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_USB_OTG_ENDP_MULTI_PROC_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_USB_OTG_ENDP_MULTI_PROC_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_USB_OTG_ENDP_MULTI_PROC_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7];
 *  default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_USB_OTG_ENDP_MULTI_PROC_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_USB_OTG_ENDP_MULTI_PROC_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_USB_OTG_ENDP_MULTI_PROC_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_USB_OTG_ENDP_MULTI_PROC_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_USB_OTG_ENDP_MULTI_PROC_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_USB_OTG_ENDP_MULTI_PROC_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_JPEG_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_JPEG_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x17c)
/** CORE1_CORE1_JPEG_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_JPEG_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_JPEG_INT_MAP_M  (CORE1_CORE1_JPEG_INT_MAP_V << CORE1_CORE1_JPEG_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_JPEG_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_JPEG_INT_MAP_S  0
/** CORE1_CORE1_JPEG_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_JPEG_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_JPEG_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_JPEG_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_JPEG_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_JPEG_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_JPEG_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_JPEG_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_JPEG_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_JPEG_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_JPEG_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_JPEG_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_JPEG_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_JPEG_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_PPA_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_PPA_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x180)
/** CORE1_CORE1_PPA_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_PPA_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_PPA_INT_MAP_M  (CORE1_CORE1_PPA_INT_MAP_V << CORE1_CORE1_PPA_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_PPA_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_PPA_INT_MAP_S  0
/** CORE1_CORE1_PPA_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_PPA_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_PPA_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_PPA_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_PPA_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_PPA_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_PPA_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_PPA_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_PPA_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_PPA_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_PPA_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_PPA_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_PPA_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_PPA_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_CORE0_TRACE_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_CORE0_TRACE_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x184)
/** CORE1_CORE1_CORE0_TRACE_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_CORE0_TRACE_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_CORE0_TRACE_INT_MAP_M  (CORE1_CORE1_CORE0_TRACE_INT_MAP_V << CORE1_CORE1_CORE0_TRACE_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_CORE0_TRACE_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_CORE0_TRACE_INT_MAP_S  0
/** CORE1_CORE1_CORE0_TRACE_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_CORE0_TRACE_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_CORE0_TRACE_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_CORE0_TRACE_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_CORE0_TRACE_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_CORE0_TRACE_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_CORE0_TRACE_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_CORE0_TRACE_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_CORE0_TRACE_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_CORE0_TRACE_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_CORE0_TRACE_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_CORE0_TRACE_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_CORE0_TRACE_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_CORE0_TRACE_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_CORE1_TRACE_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_TRACE_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x188)
/** CORE1_CORE1_CORE1_TRACE_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_CORE1_TRACE_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_CORE1_TRACE_INT_MAP_M  (CORE1_CORE1_CORE1_TRACE_INT_MAP_V << CORE1_CORE1_CORE1_TRACE_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_CORE1_TRACE_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_CORE1_TRACE_INT_MAP_S  0
/** CORE1_CORE1_CORE1_TRACE_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_CORE1_TRACE_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_CORE1_TRACE_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_CORE1_TRACE_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_CORE1_TRACE_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_CORE1_TRACE_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_CORE1_TRACE_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_CORE1_TRACE_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_CORE1_TRACE_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_CORE1_TRACE_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_CORE1_TRACE_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_CORE1_TRACE_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_CORE1_TRACE_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_CORE1_TRACE_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_HP_CORE_CTRL_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_HP_CORE_CTRL_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x18c)
/** CORE1_CORE1_HP_CORE_CTRL_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_HP_CORE_CTRL_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_HP_CORE_CTRL_INT_MAP_M  (CORE1_CORE1_HP_CORE_CTRL_INT_MAP_V << CORE1_CORE1_HP_CORE_CTRL_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_HP_CORE_CTRL_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_HP_CORE_CTRL_INT_MAP_S  0
/** CORE1_CORE1_HP_CORE_CTRL_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_HP_CORE_CTRL_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_HP_CORE_CTRL_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_HP_CORE_CTRL_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_HP_CORE_CTRL_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_HP_CORE_CTRL_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_HP_CORE_CTRL_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_HP_CORE_CTRL_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_HP_CORE_CTRL_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_HP_CORE_CTRL_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_HP_CORE_CTRL_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_HP_CORE_CTRL_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_HP_CORE_CTRL_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_HP_CORE_CTRL_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_ISP_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_ISP_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x190)
/** CORE1_CORE1_ISP_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_ISP_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_ISP_INT_MAP_M  (CORE1_CORE1_ISP_INT_MAP_V << CORE1_CORE1_ISP_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_ISP_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_ISP_INT_MAP_S  0
/** CORE1_CORE1_ISP_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_ISP_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_ISP_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_ISP_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_ISP_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_ISP_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_ISP_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_ISP_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_ISP_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_ISP_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_ISP_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_ISP_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_ISP_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_ISP_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_I3C_MST_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_I3C_MST_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x194)
/** CORE1_CORE1_I3C_MST_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_I3C_MST_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_I3C_MST_INT_MAP_M  (CORE1_CORE1_I3C_MST_INT_MAP_V << CORE1_CORE1_I3C_MST_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_I3C_MST_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_I3C_MST_INT_MAP_S  0
/** CORE1_CORE1_I3C_MST_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_I3C_MST_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_I3C_MST_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_I3C_MST_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_I3C_MST_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_I3C_MST_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_I3C_MST_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_I3C_MST_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_I3C_MST_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_I3C_MST_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_I3C_MST_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_I3C_MST_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_I3C_MST_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_I3C_MST_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_I3C_SLV_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_I3C_SLV_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x198)
/** CORE1_CORE1_I3C_SLV_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_I3C_SLV_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_I3C_SLV_INT_MAP_M  (CORE1_CORE1_I3C_SLV_INT_MAP_V << CORE1_CORE1_I3C_SLV_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_I3C_SLV_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_I3C_SLV_INT_MAP_S  0
/** CORE1_CORE1_I3C_SLV_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_I3C_SLV_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_I3C_SLV_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_I3C_SLV_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_I3C_SLV_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_I3C_SLV_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_I3C_SLV_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_I3C_SLV_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_I3C_SLV_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_I3C_SLV_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_I3C_SLV_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_I3C_SLV_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_I3C_SLV_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_I3C_SLV_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_USB_OTG11_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_USB_OTG11_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x19c)
/** CORE1_CORE1_USB_OTG11_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_USB_OTG11_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_USB_OTG11_INT_MAP_M  (CORE1_CORE1_USB_OTG11_INT_MAP_V << CORE1_CORE1_USB_OTG11_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_USB_OTG11_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_USB_OTG11_INT_MAP_S  0
/** CORE1_CORE1_USB_OTG11_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_USB_OTG11_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_USB_OTG11_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_USB_OTG11_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_USB_OTG11_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_USB_OTG11_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_USB_OTG11_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_USB_OTG11_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_USB_OTG11_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_USB_OTG11_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_USB_OTG11_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_USB_OTG11_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_USB_OTG11_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_USB_OTG11_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_DMA2D_IN_CH0_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_DMA2D_IN_CH0_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x1a0)
/** CORE1_CORE1_DMA2D_IN_CH0_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_DMA2D_IN_CH0_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_DMA2D_IN_CH0_INT_MAP_M  (CORE1_CORE1_DMA2D_IN_CH0_INT_MAP_V << CORE1_CORE1_DMA2D_IN_CH0_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_DMA2D_IN_CH0_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_DMA2D_IN_CH0_INT_MAP_S  0
/** CORE1_CORE1_DMA2D_IN_CH0_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_DMA2D_IN_CH0_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_DMA2D_IN_CH0_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_DMA2D_IN_CH0_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_DMA2D_IN_CH0_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_DMA2D_IN_CH0_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_DMA2D_IN_CH0_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_DMA2D_IN_CH0_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_DMA2D_IN_CH0_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_DMA2D_IN_CH0_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_DMA2D_IN_CH0_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_DMA2D_IN_CH0_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_DMA2D_IN_CH0_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_DMA2D_IN_CH0_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_DMA2D_IN_CH1_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_DMA2D_IN_CH1_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x1a4)
/** CORE1_CORE1_DMA2D_IN_CH1_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_DMA2D_IN_CH1_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_DMA2D_IN_CH1_INT_MAP_M  (CORE1_CORE1_DMA2D_IN_CH1_INT_MAP_V << CORE1_CORE1_DMA2D_IN_CH1_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_DMA2D_IN_CH1_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_DMA2D_IN_CH1_INT_MAP_S  0
/** CORE1_CORE1_DMA2D_IN_CH1_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_DMA2D_IN_CH1_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_DMA2D_IN_CH1_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_DMA2D_IN_CH1_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_DMA2D_IN_CH1_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_DMA2D_IN_CH1_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_DMA2D_IN_CH1_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_DMA2D_IN_CH1_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_DMA2D_IN_CH1_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_DMA2D_IN_CH1_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_DMA2D_IN_CH1_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_DMA2D_IN_CH1_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_DMA2D_IN_CH1_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_DMA2D_IN_CH1_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_DMA2D_OUT_CH0_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_DMA2D_OUT_CH0_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x1a8)
/** CORE1_CORE1_DMA2D_OUT_CH0_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_DMA2D_OUT_CH0_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_DMA2D_OUT_CH0_INT_MAP_M  (CORE1_CORE1_DMA2D_OUT_CH0_INT_MAP_V << CORE1_CORE1_DMA2D_OUT_CH0_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_DMA2D_OUT_CH0_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_DMA2D_OUT_CH0_INT_MAP_S  0
/** CORE1_CORE1_DMA2D_OUT_CH0_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_DMA2D_OUT_CH0_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_DMA2D_OUT_CH0_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_DMA2D_OUT_CH0_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_DMA2D_OUT_CH0_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_DMA2D_OUT_CH0_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_DMA2D_OUT_CH0_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_DMA2D_OUT_CH0_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_DMA2D_OUT_CH0_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_DMA2D_OUT_CH0_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_DMA2D_OUT_CH0_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_DMA2D_OUT_CH0_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_DMA2D_OUT_CH0_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_DMA2D_OUT_CH0_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_DMA2D_OUT_CH1_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_DMA2D_OUT_CH1_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x1ac)
/** CORE1_CORE1_DMA2D_OUT_CH1_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_DMA2D_OUT_CH1_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_DMA2D_OUT_CH1_INT_MAP_M  (CORE1_CORE1_DMA2D_OUT_CH1_INT_MAP_V << CORE1_CORE1_DMA2D_OUT_CH1_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_DMA2D_OUT_CH1_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_DMA2D_OUT_CH1_INT_MAP_S  0
/** CORE1_CORE1_DMA2D_OUT_CH1_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_DMA2D_OUT_CH1_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_DMA2D_OUT_CH1_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_DMA2D_OUT_CH1_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_DMA2D_OUT_CH1_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_DMA2D_OUT_CH1_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_DMA2D_OUT_CH1_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_DMA2D_OUT_CH1_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_DMA2D_OUT_CH1_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_DMA2D_OUT_CH1_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_DMA2D_OUT_CH1_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_DMA2D_OUT_CH1_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_DMA2D_OUT_CH1_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_DMA2D_OUT_CH1_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_DMA2D_OUT_CH2_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_DMA2D_OUT_CH2_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x1b0)
/** CORE1_CORE1_DMA2D_OUT_CH2_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_DMA2D_OUT_CH2_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_DMA2D_OUT_CH2_INT_MAP_M  (CORE1_CORE1_DMA2D_OUT_CH2_INT_MAP_V << CORE1_CORE1_DMA2D_OUT_CH2_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_DMA2D_OUT_CH2_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_DMA2D_OUT_CH2_INT_MAP_S  0
/** CORE1_CORE1_DMA2D_OUT_CH2_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_DMA2D_OUT_CH2_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_DMA2D_OUT_CH2_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_DMA2D_OUT_CH2_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_DMA2D_OUT_CH2_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_DMA2D_OUT_CH2_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_DMA2D_OUT_CH2_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_DMA2D_OUT_CH2_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_DMA2D_OUT_CH2_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_DMA2D_OUT_CH2_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_DMA2D_OUT_CH2_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_DMA2D_OUT_CH2_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_DMA2D_OUT_CH2_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_DMA2D_OUT_CH2_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_PSRAM_MSPI_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_PSRAM_MSPI_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x1b4)
/** CORE1_CORE1_PSRAM_MSPI_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_PSRAM_MSPI_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_PSRAM_MSPI_INT_MAP_M  (CORE1_CORE1_PSRAM_MSPI_INT_MAP_V << CORE1_CORE1_PSRAM_MSPI_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_PSRAM_MSPI_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_PSRAM_MSPI_INT_MAP_S  0
/** CORE1_CORE1_PSRAM_MSPI_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_PSRAM_MSPI_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_PSRAM_MSPI_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_PSRAM_MSPI_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_PSRAM_MSPI_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_PSRAM_MSPI_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_PSRAM_MSPI_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_PSRAM_MSPI_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_PSRAM_MSPI_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_PSRAM_MSPI_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_PSRAM_MSPI_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_PSRAM_MSPI_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_PSRAM_MSPI_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_PSRAM_MSPI_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_HP_SYSREG_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_HP_SYSREG_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x1b8)
/** CORE1_CORE1_HP_SYSREG_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_HP_SYSREG_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_HP_SYSREG_INT_MAP_M  (CORE1_CORE1_HP_SYSREG_INT_MAP_V << CORE1_CORE1_HP_SYSREG_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_HP_SYSREG_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_HP_SYSREG_INT_MAP_S  0
/** CORE1_CORE1_HP_SYSREG_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_HP_SYSREG_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_HP_SYSREG_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_HP_SYSREG_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_HP_SYSREG_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_HP_SYSREG_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_HP_SYSREG_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_HP_SYSREG_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_HP_SYSREG_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_HP_SYSREG_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_HP_SYSREG_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_HP_SYSREG_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_HP_SYSREG_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_HP_SYSREG_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_PCNT_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_PCNT_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x1bc)
/** CORE1_CORE1_PCNT_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_PCNT_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_PCNT_INT_MAP_M  (CORE1_CORE1_PCNT_INT_MAP_V << CORE1_CORE1_PCNT_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_PCNT_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_PCNT_INT_MAP_S  0
/** CORE1_CORE1_PCNT_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_PCNT_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_PCNT_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_PCNT_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_PCNT_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_PCNT_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_PCNT_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_PCNT_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_PCNT_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_PCNT_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_PCNT_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_PCNT_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_PCNT_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_PCNT_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_HP_PAU_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_HP_PAU_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x1c0)
/** CORE1_CORE1_HP_PAU_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_HP_PAU_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_HP_PAU_INT_MAP_M  (CORE1_CORE1_HP_PAU_INT_MAP_V << CORE1_CORE1_HP_PAU_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_HP_PAU_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_HP_PAU_INT_MAP_S  0
/** CORE1_CORE1_HP_PAU_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_HP_PAU_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_HP_PAU_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_HP_PAU_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_HP_PAU_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_HP_PAU_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_HP_PAU_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_HP_PAU_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_HP_PAU_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_HP_PAU_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_HP_PAU_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_HP_PAU_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_HP_PAU_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_HP_PAU_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_HP_PARLIO_RX_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_HP_PARLIO_RX_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x1c4)
/** CORE1_CORE1_HP_PARLIO_RX_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_HP_PARLIO_RX_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_HP_PARLIO_RX_INT_MAP_M  (CORE1_CORE1_HP_PARLIO_RX_INT_MAP_V << CORE1_CORE1_HP_PARLIO_RX_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_HP_PARLIO_RX_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_HP_PARLIO_RX_INT_MAP_S  0
/** CORE1_CORE1_HP_PARLIO_RX_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_HP_PARLIO_RX_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_HP_PARLIO_RX_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_HP_PARLIO_RX_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_HP_PARLIO_RX_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_HP_PARLIO_RX_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_HP_PARLIO_RX_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_HP_PARLIO_RX_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_HP_PARLIO_RX_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_HP_PARLIO_RX_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_HP_PARLIO_RX_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_HP_PARLIO_RX_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_HP_PARLIO_RX_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_HP_PARLIO_RX_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_HP_PARLIO_TX_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_HP_PARLIO_TX_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x1c8)
/** CORE1_CORE1_HP_PARLIO_TX_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_HP_PARLIO_TX_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_HP_PARLIO_TX_INT_MAP_M  (CORE1_CORE1_HP_PARLIO_TX_INT_MAP_V << CORE1_CORE1_HP_PARLIO_TX_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_HP_PARLIO_TX_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_HP_PARLIO_TX_INT_MAP_S  0
/** CORE1_CORE1_HP_PARLIO_TX_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_HP_PARLIO_TX_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_HP_PARLIO_TX_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_HP_PARLIO_TX_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_HP_PARLIO_TX_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_HP_PARLIO_TX_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_HP_PARLIO_TX_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_HP_PARLIO_TX_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_HP_PARLIO_TX_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_HP_PARLIO_TX_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_HP_PARLIO_TX_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_HP_PARLIO_TX_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_HP_PARLIO_TX_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_HP_PARLIO_TX_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_H264_DMA2D_OUT_CH0_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_H264_DMA2D_OUT_CH0_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x1cc)
/** CORE1_CORE1_H264_DMA2D_OUT_CH0_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_OUT_CH0_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_OUT_CH0_INT_MAP_M  (CORE1_CORE1_H264_DMA2D_OUT_CH0_INT_MAP_V << CORE1_CORE1_H264_DMA2D_OUT_CH0_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_OUT_CH0_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_OUT_CH0_INT_MAP_S  0
/** CORE1_CORE1_H264_DMA2D_OUT_CH0_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_OUT_CH0_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_OUT_CH0_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_H264_DMA2D_OUT_CH0_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_H264_DMA2D_OUT_CH0_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_OUT_CH0_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_OUT_CH0_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_H264_DMA2D_OUT_CH0_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_OUT_CH0_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_OUT_CH0_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_H264_DMA2D_OUT_CH0_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_H264_DMA2D_OUT_CH0_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_OUT_CH0_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_OUT_CH0_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_H264_DMA2D_OUT_CH1_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_H264_DMA2D_OUT_CH1_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x1d0)
/** CORE1_CORE1_H264_DMA2D_OUT_CH1_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_OUT_CH1_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_OUT_CH1_INT_MAP_M  (CORE1_CORE1_H264_DMA2D_OUT_CH1_INT_MAP_V << CORE1_CORE1_H264_DMA2D_OUT_CH1_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_OUT_CH1_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_OUT_CH1_INT_MAP_S  0
/** CORE1_CORE1_H264_DMA2D_OUT_CH1_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_OUT_CH1_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_OUT_CH1_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_H264_DMA2D_OUT_CH1_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_H264_DMA2D_OUT_CH1_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_OUT_CH1_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_OUT_CH1_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_H264_DMA2D_OUT_CH1_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_OUT_CH1_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_OUT_CH1_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_H264_DMA2D_OUT_CH1_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_H264_DMA2D_OUT_CH1_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_OUT_CH1_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_OUT_CH1_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_H264_DMA2D_OUT_CH2_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_H264_DMA2D_OUT_CH2_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x1d4)
/** CORE1_CORE1_H264_DMA2D_OUT_CH2_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_OUT_CH2_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_OUT_CH2_INT_MAP_M  (CORE1_CORE1_H264_DMA2D_OUT_CH2_INT_MAP_V << CORE1_CORE1_H264_DMA2D_OUT_CH2_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_OUT_CH2_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_OUT_CH2_INT_MAP_S  0
/** CORE1_CORE1_H264_DMA2D_OUT_CH2_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_OUT_CH2_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_OUT_CH2_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_H264_DMA2D_OUT_CH2_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_H264_DMA2D_OUT_CH2_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_OUT_CH2_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_OUT_CH2_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_H264_DMA2D_OUT_CH2_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_OUT_CH2_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_OUT_CH2_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_H264_DMA2D_OUT_CH2_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_H264_DMA2D_OUT_CH2_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_OUT_CH2_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_OUT_CH2_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_H264_DMA2D_OUT_CH3_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_H264_DMA2D_OUT_CH3_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x1d8)
/** CORE1_CORE1_H264_DMA2D_OUT_CH3_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_OUT_CH3_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_OUT_CH3_INT_MAP_M  (CORE1_CORE1_H264_DMA2D_OUT_CH3_INT_MAP_V << CORE1_CORE1_H264_DMA2D_OUT_CH3_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_OUT_CH3_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_OUT_CH3_INT_MAP_S  0
/** CORE1_CORE1_H264_DMA2D_OUT_CH3_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_OUT_CH3_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_OUT_CH3_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_H264_DMA2D_OUT_CH3_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_H264_DMA2D_OUT_CH3_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_OUT_CH3_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_OUT_CH3_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_H264_DMA2D_OUT_CH3_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_OUT_CH3_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_OUT_CH3_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_H264_DMA2D_OUT_CH3_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_H264_DMA2D_OUT_CH3_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_OUT_CH3_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_OUT_CH3_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_H264_DMA2D_OUT_CH4_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_H264_DMA2D_OUT_CH4_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x1dc)
/** CORE1_CORE1_H264_DMA2D_OUT_CH4_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_OUT_CH4_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_OUT_CH4_INT_MAP_M  (CORE1_CORE1_H264_DMA2D_OUT_CH4_INT_MAP_V << CORE1_CORE1_H264_DMA2D_OUT_CH4_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_OUT_CH4_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_OUT_CH4_INT_MAP_S  0
/** CORE1_CORE1_H264_DMA2D_OUT_CH4_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_OUT_CH4_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_OUT_CH4_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_H264_DMA2D_OUT_CH4_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_H264_DMA2D_OUT_CH4_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_OUT_CH4_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_OUT_CH4_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_H264_DMA2D_OUT_CH4_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_OUT_CH4_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_OUT_CH4_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_H264_DMA2D_OUT_CH4_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_H264_DMA2D_OUT_CH4_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_OUT_CH4_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_OUT_CH4_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_H264_DMA2D_IN_CH0_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_H264_DMA2D_IN_CH0_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x1e0)
/** CORE1_CORE1_H264_DMA2D_IN_CH0_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_IN_CH0_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_IN_CH0_INT_MAP_M  (CORE1_CORE1_H264_DMA2D_IN_CH0_INT_MAP_V << CORE1_CORE1_H264_DMA2D_IN_CH0_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_IN_CH0_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_IN_CH0_INT_MAP_S  0
/** CORE1_CORE1_H264_DMA2D_IN_CH0_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_IN_CH0_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_IN_CH0_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_H264_DMA2D_IN_CH0_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_H264_DMA2D_IN_CH0_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_IN_CH0_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_IN_CH0_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_H264_DMA2D_IN_CH0_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_IN_CH0_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_IN_CH0_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_H264_DMA2D_IN_CH0_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_H264_DMA2D_IN_CH0_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_IN_CH0_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_IN_CH0_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_H264_DMA2D_IN_CH1_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_H264_DMA2D_IN_CH1_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x1e4)
/** CORE1_CORE1_H264_DMA2D_IN_CH1_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_IN_CH1_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_IN_CH1_INT_MAP_M  (CORE1_CORE1_H264_DMA2D_IN_CH1_INT_MAP_V << CORE1_CORE1_H264_DMA2D_IN_CH1_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_IN_CH1_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_IN_CH1_INT_MAP_S  0
/** CORE1_CORE1_H264_DMA2D_IN_CH1_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_IN_CH1_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_IN_CH1_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_H264_DMA2D_IN_CH1_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_H264_DMA2D_IN_CH1_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_IN_CH1_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_IN_CH1_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_H264_DMA2D_IN_CH1_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_IN_CH1_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_IN_CH1_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_H264_DMA2D_IN_CH1_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_H264_DMA2D_IN_CH1_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_IN_CH1_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_IN_CH1_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_H264_DMA2D_IN_CH2_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_H264_DMA2D_IN_CH2_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x1e8)
/** CORE1_CORE1_H264_DMA2D_IN_CH2_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_IN_CH2_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_IN_CH2_INT_MAP_M  (CORE1_CORE1_H264_DMA2D_IN_CH2_INT_MAP_V << CORE1_CORE1_H264_DMA2D_IN_CH2_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_IN_CH2_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_IN_CH2_INT_MAP_S  0
/** CORE1_CORE1_H264_DMA2D_IN_CH2_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_IN_CH2_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_IN_CH2_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_H264_DMA2D_IN_CH2_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_H264_DMA2D_IN_CH2_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_IN_CH2_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_IN_CH2_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_H264_DMA2D_IN_CH2_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_IN_CH2_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_IN_CH2_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_H264_DMA2D_IN_CH2_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_H264_DMA2D_IN_CH2_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_IN_CH2_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_IN_CH2_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_H264_DMA2D_IN_CH3_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_H264_DMA2D_IN_CH3_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x1ec)
/** CORE1_CORE1_H264_DMA2D_IN_CH3_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_IN_CH3_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_IN_CH3_INT_MAP_M  (CORE1_CORE1_H264_DMA2D_IN_CH3_INT_MAP_V << CORE1_CORE1_H264_DMA2D_IN_CH3_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_IN_CH3_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_IN_CH3_INT_MAP_S  0
/** CORE1_CORE1_H264_DMA2D_IN_CH3_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_IN_CH3_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_IN_CH3_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_H264_DMA2D_IN_CH3_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_H264_DMA2D_IN_CH3_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_IN_CH3_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_IN_CH3_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_H264_DMA2D_IN_CH3_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_IN_CH3_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_IN_CH3_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_H264_DMA2D_IN_CH3_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_H264_DMA2D_IN_CH3_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_IN_CH3_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_IN_CH3_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_H264_DMA2D_IN_CH4_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_H264_DMA2D_IN_CH4_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x1f0)
/** CORE1_CORE1_H264_DMA2D_IN_CH4_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_IN_CH4_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_IN_CH4_INT_MAP_M  (CORE1_CORE1_H264_DMA2D_IN_CH4_INT_MAP_V << CORE1_CORE1_H264_DMA2D_IN_CH4_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_IN_CH4_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_IN_CH4_INT_MAP_S  0
/** CORE1_CORE1_H264_DMA2D_IN_CH4_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_IN_CH4_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_IN_CH4_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_H264_DMA2D_IN_CH4_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_H264_DMA2D_IN_CH4_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_IN_CH4_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_IN_CH4_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_H264_DMA2D_IN_CH4_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_IN_CH4_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_IN_CH4_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_H264_DMA2D_IN_CH4_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_H264_DMA2D_IN_CH4_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_IN_CH4_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_IN_CH4_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_H264_DMA2D_IN_CH5_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_H264_DMA2D_IN_CH5_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x1f4)
/** CORE1_CORE1_H264_DMA2D_IN_CH5_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_IN_CH5_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_IN_CH5_INT_MAP_M  (CORE1_CORE1_H264_DMA2D_IN_CH5_INT_MAP_V << CORE1_CORE1_H264_DMA2D_IN_CH5_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_IN_CH5_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_IN_CH5_INT_MAP_S  0
/** CORE1_CORE1_H264_DMA2D_IN_CH5_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_IN_CH5_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_IN_CH5_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_H264_DMA2D_IN_CH5_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_H264_DMA2D_IN_CH5_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_IN_CH5_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_IN_CH5_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_H264_DMA2D_IN_CH5_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_IN_CH5_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_IN_CH5_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_H264_DMA2D_IN_CH5_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_H264_DMA2D_IN_CH5_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_IN_CH5_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_H264_DMA2D_IN_CH5_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_H264_REG_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_H264_REG_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x1f8)
/** CORE1_CORE1_H264_REG_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_H264_REG_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_H264_REG_INT_MAP_M  (CORE1_CORE1_H264_REG_INT_MAP_V << CORE1_CORE1_H264_REG_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_H264_REG_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_H264_REG_INT_MAP_S  0
/** CORE1_CORE1_H264_REG_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_H264_REG_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_H264_REG_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_H264_REG_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_H264_REG_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_H264_REG_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_H264_REG_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_H264_REG_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_H264_REG_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_H264_REG_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_H264_REG_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_H264_REG_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_H264_REG_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_H264_REG_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_ASSIST_DEBUG_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_ASSIST_DEBUG_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x1fc)
/** CORE1_CORE1_ASSIST_DEBUG_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_ASSIST_DEBUG_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_ASSIST_DEBUG_INT_MAP_M  (CORE1_CORE1_ASSIST_DEBUG_INT_MAP_V << CORE1_CORE1_ASSIST_DEBUG_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_ASSIST_DEBUG_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_ASSIST_DEBUG_INT_MAP_S  0
/** CORE1_CORE1_ASSIST_DEBUG_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_ASSIST_DEBUG_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_ASSIST_DEBUG_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_ASSIST_DEBUG_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_ASSIST_DEBUG_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_ASSIST_DEBUG_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_ASSIST_DEBUG_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_ASSIST_DEBUG_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_ASSIST_DEBUG_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_ASSIST_DEBUG_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_ASSIST_DEBUG_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_ASSIST_DEBUG_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_ASSIST_DEBUG_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_ASSIST_DEBUG_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_INTR_STATUS_REG_0_REG register
 *  NA
 */
#define INTERRUPT_CORE1_INTR_STATUS_REG_0_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x200)
/** CORE1_CORE1_INTR_STATUS_0 : RO; bitpos: [31:0]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_INTR_STATUS_0    0xFFFFFFFFU
#define INTERRUPT_CORE1_CORE1_INTR_STATUS_0_M  (CORE1_CORE1_INTR_STATUS_0_V << CORE1_CORE1_INTR_STATUS_0_S)
#define INTERRUPT_CORE1_CORE1_INTR_STATUS_0_V  0xFFFFFFFFU
#define INTERRUPT_CORE1_CORE1_INTR_STATUS_0_S  0

/** CORE1_INTR_STATUS_REG_1_REG register
 *  NA
 */
#define INTERRUPT_CORE1_INTR_STATUS_REG_1_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x204)
/** CORE1_CORE1_INTR_STATUS_1 : RO; bitpos: [31:0]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_INTR_STATUS_1    0xFFFFFFFFU
#define INTERRUPT_CORE1_CORE1_INTR_STATUS_1_M  (CORE1_CORE1_INTR_STATUS_1_V << CORE1_CORE1_INTR_STATUS_1_S)
#define INTERRUPT_CORE1_CORE1_INTR_STATUS_1_V  0xFFFFFFFFU
#define INTERRUPT_CORE1_CORE1_INTR_STATUS_1_S  0

/** CORE1_INTR_STATUS_REG_2_REG register
 *  NA
 */
#define INTERRUPT_CORE1_INTR_STATUS_REG_2_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x208)
/** CORE1_CORE1_INTR_STATUS_2 : RO; bitpos: [31:0]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_INTR_STATUS_2    0xFFFFFFFFU
#define INTERRUPT_CORE1_CORE1_INTR_STATUS_2_M  (CORE1_CORE1_INTR_STATUS_2_V << CORE1_CORE1_INTR_STATUS_2_S)
#define INTERRUPT_CORE1_CORE1_INTR_STATUS_2_V  0xFFFFFFFFU
#define INTERRUPT_CORE1_CORE1_INTR_STATUS_2_S  0

/** CORE1_INTR_STATUS_REG_3_REG register
 *  NA
 */
#define INTERRUPT_CORE1_INTR_STATUS_REG_3_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x20c)
/** CORE1_CORE1_INTR_STATUS_3 : RO; bitpos: [31:0]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_INTR_STATUS_3    0xFFFFFFFFU
#define INTERRUPT_CORE1_CORE1_INTR_STATUS_3_M  (CORE1_CORE1_INTR_STATUS_3_V << CORE1_CORE1_INTR_STATUS_3_S)
#define INTERRUPT_CORE1_CORE1_INTR_STATUS_3_V  0xFFFFFFFFU
#define INTERRUPT_CORE1_CORE1_INTR_STATUS_3_S  0

/** CORE1_CLOCK_GATE_REG register
 *  NA
 */
#define INTERRUPT_CORE1_CLOCK_GATE_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x210)
/** CORE1_CORE1_REG_CLK_EN : R/W; bitpos: [0]; default: 1;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_REG_CLK_EN    (BIT(0))
#define INTERRUPT_CORE1_CORE1_REG_CLK_EN_M  (CORE1_CORE1_REG_CLK_EN_V << CORE1_CORE1_REG_CLK_EN_S)
#define INTERRUPT_CORE1_CORE1_REG_CLK_EN_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_REG_CLK_EN_S  0

/** CORE1_DMA2D_IN_CH2_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_DMA2D_IN_CH2_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x214)
/** CORE1_CORE1_DMA2D_IN_CH2_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_DMA2D_IN_CH2_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_DMA2D_IN_CH2_INT_MAP_M  (CORE1_CORE1_DMA2D_IN_CH2_INT_MAP_V << CORE1_CORE1_DMA2D_IN_CH2_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_DMA2D_IN_CH2_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_DMA2D_IN_CH2_INT_MAP_S  0
/** CORE1_CORE1_DMA2D_IN_CH2_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_DMA2D_IN_CH2_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_DMA2D_IN_CH2_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_DMA2D_IN_CH2_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_DMA2D_IN_CH2_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_DMA2D_IN_CH2_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_DMA2D_IN_CH2_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_DMA2D_IN_CH2_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_DMA2D_IN_CH2_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_DMA2D_IN_CH2_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_DMA2D_IN_CH2_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_DMA2D_IN_CH2_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_DMA2D_IN_CH2_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_DMA2D_IN_CH2_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_DMA2D_OUT_CH3_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_DMA2D_OUT_CH3_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x218)
/** CORE1_CORE1_DMA2D_OUT_CH3_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_DMA2D_OUT_CH3_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_DMA2D_OUT_CH3_INT_MAP_M  (CORE1_CORE1_DMA2D_OUT_CH3_INT_MAP_V << CORE1_CORE1_DMA2D_OUT_CH3_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_DMA2D_OUT_CH3_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_DMA2D_OUT_CH3_INT_MAP_S  0
/** CORE1_CORE1_DMA2D_OUT_CH3_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_DMA2D_OUT_CH3_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_DMA2D_OUT_CH3_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_DMA2D_OUT_CH3_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_DMA2D_OUT_CH3_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_DMA2D_OUT_CH3_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_DMA2D_OUT_CH3_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_DMA2D_OUT_CH3_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_DMA2D_OUT_CH3_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_DMA2D_OUT_CH3_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_DMA2D_OUT_CH3_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_DMA2D_OUT_CH3_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_DMA2D_OUT_CH3_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_DMA2D_OUT_CH3_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_AXI_PERF_MON_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE1_AXI_PERF_MON_INT_MAP_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x21c)
/** CORE1_CORE1_AXI_PERF_MON_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE1_CORE1_AXI_PERF_MON_INT_MAP    0x0000003FU
#define INTERRUPT_CORE1_CORE1_AXI_PERF_MON_INT_MAP_M  (CORE1_CORE1_AXI_PERF_MON_INT_MAP_V << CORE1_CORE1_AXI_PERF_MON_INT_MAP_S)
#define INTERRUPT_CORE1_CORE1_AXI_PERF_MON_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_AXI_PERF_MON_INT_MAP_S  0
/** CORE1_CORE1_AXI_PERF_MON_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_AXI_PERF_MON_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE1_CORE1_AXI_PERF_MON_INT_SRC_PASS_IN_SEC_M  (CORE1_CORE1_AXI_PERF_MON_INT_SRC_PASS_IN_SEC_V << CORE1_CORE1_AXI_PERF_MON_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_AXI_PERF_MON_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_AXI_PERF_MON_INT_SRC_PASS_IN_SEC_S  6
/** CORE1_CORE1_AXI_PERF_MON_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_AXI_PERF_MON_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE1_CORE1_AXI_PERF_MON_INT_SRC_IN_SEC_FLAG_M  (CORE1_CORE1_AXI_PERF_MON_INT_SRC_IN_SEC_FLAG_V << CORE1_CORE1_AXI_PERF_MON_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE1_CORE1_AXI_PERF_MON_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE1_CORE1_AXI_PERF_MON_INT_SRC_IN_SEC_FLAG_S  7

/** CORE1_INTR_STATUS_REG_4_REG register
 *  NA
 */
#define INTERRUPT_CORE1_INTR_STATUS_REG_4_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x220)
/** CORE1_CORE1_INTR_STATUS_4 : RO; bitpos: [31:0]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_INTR_STATUS_4    0xFFFFFFFFU
#define INTERRUPT_CORE1_CORE1_INTR_STATUS_4_M  (CORE1_CORE1_INTR_STATUS_4_V << CORE1_CORE1_INTR_STATUS_4_S)
#define INTERRUPT_CORE1_CORE1_INTR_STATUS_4_V  0xFFFFFFFFU
#define INTERRUPT_CORE1_CORE1_INTR_STATUS_4_S  0

/** CORE1_INTR_SIG_IDX_ASSERT_IN_SEC_REG register
 *  NA
 */
#define INTERRUPT_CORE1_INTR_SIG_IDX_ASSERT_IN_SEC_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x228)
/** CORE1_CORE1_INTR_SIG_IDX_ASSERT_IN_SEC : R/W; bitpos: [5:0]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_INTR_SIG_IDX_ASSERT_IN_SEC    0x0000003FU
#define INTERRUPT_CORE1_CORE1_INTR_SIG_IDX_ASSERT_IN_SEC_M  (CORE1_CORE1_INTR_SIG_IDX_ASSERT_IN_SEC_V << CORE1_CORE1_INTR_SIG_IDX_ASSERT_IN_SEC_S)
#define INTERRUPT_CORE1_CORE1_INTR_SIG_IDX_ASSERT_IN_SEC_V  0x0000003FU
#define INTERRUPT_CORE1_CORE1_INTR_SIG_IDX_ASSERT_IN_SEC_S  0

/** CORE1_INTR_SEC_STATUS_REG register
 *  NA
 */
#define INTERRUPT_CORE1_INTR_SEC_STATUS_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x22c)
/** CORE1_CORE1_INTR_SEC_STATUS : RO; bitpos: [31:0]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_INTR_SEC_STATUS    0xFFFFFFFFU
#define INTERRUPT_CORE1_CORE1_INTR_SEC_STATUS_M  (CORE1_CORE1_INTR_SEC_STATUS_V << CORE1_CORE1_INTR_SEC_STATUS_S)
#define INTERRUPT_CORE1_CORE1_INTR_SEC_STATUS_V  0xFFFFFFFFU
#define INTERRUPT_CORE1_CORE1_INTR_SEC_STATUS_S  0

/** CORE1_INTR_SRC_PASS_IN_SEC_STATUS_0_REG register
 *  NA
 */
#define INTERRUPT_CORE1_INTR_SRC_PASS_IN_SEC_STATUS_0_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x230)
/** CORE1_CORE1_INTR_SRC_PASS_IN_SEC_STATUS_0 : RO; bitpos: [31:0]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_INTR_SRC_PASS_IN_SEC_STATUS_0    0xFFFFFFFFU
#define INTERRUPT_CORE1_CORE1_INTR_SRC_PASS_IN_SEC_STATUS_0_M  (CORE1_CORE1_INTR_SRC_PASS_IN_SEC_STATUS_0_V << CORE1_CORE1_INTR_SRC_PASS_IN_SEC_STATUS_0_S)
#define INTERRUPT_CORE1_CORE1_INTR_SRC_PASS_IN_SEC_STATUS_0_V  0xFFFFFFFFU
#define INTERRUPT_CORE1_CORE1_INTR_SRC_PASS_IN_SEC_STATUS_0_S  0

/** CORE1_INTR_SRC_PASS_IN_SEC_STATUS_1_REG register
 *  NA
 */
#define INTERRUPT_CORE1_INTR_SRC_PASS_IN_SEC_STATUS_1_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x234)
/** CORE1_CORE1_INTR_SRC_PASS_IN_SEC_STATUS_1 : RO; bitpos: [31:0]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_INTR_SRC_PASS_IN_SEC_STATUS_1    0xFFFFFFFFU
#define INTERRUPT_CORE1_CORE1_INTR_SRC_PASS_IN_SEC_STATUS_1_M  (CORE1_CORE1_INTR_SRC_PASS_IN_SEC_STATUS_1_V << CORE1_CORE1_INTR_SRC_PASS_IN_SEC_STATUS_1_S)
#define INTERRUPT_CORE1_CORE1_INTR_SRC_PASS_IN_SEC_STATUS_1_V  0xFFFFFFFFU
#define INTERRUPT_CORE1_CORE1_INTR_SRC_PASS_IN_SEC_STATUS_1_S  0

/** CORE1_INTR_SRC_PASS_IN_SEC_STATUS_2_REG register
 *  NA
 */
#define INTERRUPT_CORE1_INTR_SRC_PASS_IN_SEC_STATUS_2_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x238)
/** CORE1_CORE1_INTR_SRC_PASS_IN_SEC_STATUS_2 : RO; bitpos: [31:0]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_INTR_SRC_PASS_IN_SEC_STATUS_2    0xFFFFFFFFU
#define INTERRUPT_CORE1_CORE1_INTR_SRC_PASS_IN_SEC_STATUS_2_M  (CORE1_CORE1_INTR_SRC_PASS_IN_SEC_STATUS_2_V << CORE1_CORE1_INTR_SRC_PASS_IN_SEC_STATUS_2_S)
#define INTERRUPT_CORE1_CORE1_INTR_SRC_PASS_IN_SEC_STATUS_2_V  0xFFFFFFFFU
#define INTERRUPT_CORE1_CORE1_INTR_SRC_PASS_IN_SEC_STATUS_2_S  0

/** CORE1_INTR_SRC_PASS_IN_SEC_STATUS_3_REG register
 *  NA
 */
#define INTERRUPT_CORE1_INTR_SRC_PASS_IN_SEC_STATUS_3_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x23c)
/** CORE1_CORE1_INTR_SRC_PASS_IN_SEC_STATUS_3 : RO; bitpos: [31:0]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_INTR_SRC_PASS_IN_SEC_STATUS_3    0xFFFFFFFFU
#define INTERRUPT_CORE1_CORE1_INTR_SRC_PASS_IN_SEC_STATUS_3_M  (CORE1_CORE1_INTR_SRC_PASS_IN_SEC_STATUS_3_V << CORE1_CORE1_INTR_SRC_PASS_IN_SEC_STATUS_3_S)
#define INTERRUPT_CORE1_CORE1_INTR_SRC_PASS_IN_SEC_STATUS_3_V  0xFFFFFFFFU
#define INTERRUPT_CORE1_CORE1_INTR_SRC_PASS_IN_SEC_STATUS_3_S  0

/** CORE1_INTR_SRC_PASS_IN_SEC_STATUS_4_REG register
 *  NA
 */
#define INTERRUPT_CORE1_INTR_SRC_PASS_IN_SEC_STATUS_4_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x240)
/** CORE1_CORE1_INTR_SRC_PASS_IN_SEC_STATUS_4 : RO; bitpos: [31:0]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_INTR_SRC_PASS_IN_SEC_STATUS_4    0xFFFFFFFFU
#define INTERRUPT_CORE1_CORE1_INTR_SRC_PASS_IN_SEC_STATUS_4_M  (CORE1_CORE1_INTR_SRC_PASS_IN_SEC_STATUS_4_V << CORE1_CORE1_INTR_SRC_PASS_IN_SEC_STATUS_4_S)
#define INTERRUPT_CORE1_CORE1_INTR_SRC_PASS_IN_SEC_STATUS_4_V  0xFFFFFFFFU
#define INTERRUPT_CORE1_CORE1_INTR_SRC_PASS_IN_SEC_STATUS_4_S  0

/** CORE1_INTERRUPT_REG_DATE_REG register
 *  NA
 */
#define INTERRUPT_CORE1_INTERRUPT_REG_DATE_REG (DR_REG_INTERRUPT_CORE1_BASE + 0x3fc)
/** CORE1_CORE1_INTERRUPT_REG_DATE : R/W; bitpos: [27:0]; default: 38806144;
 *  NA
 */
#define INTERRUPT_CORE1_CORE1_INTERRUPT_REG_DATE    0x0FFFFFFFU
#define INTERRUPT_CORE1_CORE1_INTERRUPT_REG_DATE_M  (CORE1_CORE1_INTERRUPT_REG_DATE_V << CORE1_CORE1_INTERRUPT_REG_DATE_S)
#define INTERRUPT_CORE1_CORE1_INTERRUPT_REG_DATE_V  0x0FFFFFFFU
#define INTERRUPT_CORE1_CORE1_INTERRUPT_REG_DATE_S  0

#ifdef __cplusplus
}
#endif
