/**
 * SPDX-FileCopyrightText: 2025 Espressif Systems (Shanghai) CO LTD
 *
 *  SPDX-License-Identifier: Apache-2.0
 */
#pragma once

#include <stdint.h>
#include "soc/soc.h"
#ifdef __cplusplus
extern "C" {
#endif

/** CORE0_LP_RTC_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_LP_RTC_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x0)
/** CORE0_CORE0_LP_RTC_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_LP_RTC_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_LP_RTC_INT_MAP_M  (CORE0_CORE0_LP_RTC_INT_MAP_V << CORE0_CORE0_LP_RTC_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_LP_RTC_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_LP_RTC_INT_MAP_S  0
/** CORE0_CORE0_LP_RTC_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_LP_RTC_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_LP_RTC_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_LP_RTC_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_LP_RTC_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_LP_RTC_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_LP_RTC_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_LP_RTC_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_LP_RTC_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_LP_RTC_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_LP_RTC_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_LP_RTC_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_LP_RTC_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_LP_RTC_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_LP_WDT_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_LP_WDT_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x4)
/** CORE0_CORE0_LP_WDT_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_LP_WDT_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_LP_WDT_INT_MAP_M  (CORE0_CORE0_LP_WDT_INT_MAP_V << CORE0_CORE0_LP_WDT_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_LP_WDT_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_LP_WDT_INT_MAP_S  0
/** CORE0_CORE0_LP_WDT_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_LP_WDT_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_LP_WDT_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_LP_WDT_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_LP_WDT_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_LP_WDT_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_LP_WDT_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_LP_WDT_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_LP_WDT_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_LP_WDT_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_LP_WDT_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_LP_WDT_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_LP_WDT_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_LP_WDT_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_LP_TIMER_REG_0_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_LP_TIMER_REG_0_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x8)
/** CORE0_CORE0_LP_TIMER_REG_0_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_LP_TIMER_REG_0_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_LP_TIMER_REG_0_INT_MAP_M  (CORE0_CORE0_LP_TIMER_REG_0_INT_MAP_V << CORE0_CORE0_LP_TIMER_REG_0_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_LP_TIMER_REG_0_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_LP_TIMER_REG_0_INT_MAP_S  0
/** CORE0_CORE0_LP_TIMER_REG_0_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_LP_TIMER_REG_0_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_LP_TIMER_REG_0_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_LP_TIMER_REG_0_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_LP_TIMER_REG_0_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_LP_TIMER_REG_0_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_LP_TIMER_REG_0_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_LP_TIMER_REG_0_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_LP_TIMER_REG_0_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_LP_TIMER_REG_0_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_LP_TIMER_REG_0_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_LP_TIMER_REG_0_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_LP_TIMER_REG_0_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_LP_TIMER_REG_0_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_LP_TIMER_REG_1_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_LP_TIMER_REG_1_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0xc)
/** CORE0_CORE0_LP_TIMER_REG_1_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_LP_TIMER_REG_1_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_LP_TIMER_REG_1_INT_MAP_M  (CORE0_CORE0_LP_TIMER_REG_1_INT_MAP_V << CORE0_CORE0_LP_TIMER_REG_1_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_LP_TIMER_REG_1_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_LP_TIMER_REG_1_INT_MAP_S  0
/** CORE0_CORE0_LP_TIMER_REG_1_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_LP_TIMER_REG_1_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_LP_TIMER_REG_1_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_LP_TIMER_REG_1_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_LP_TIMER_REG_1_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_LP_TIMER_REG_1_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_LP_TIMER_REG_1_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_LP_TIMER_REG_1_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_LP_TIMER_REG_1_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_LP_TIMER_REG_1_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_LP_TIMER_REG_1_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_LP_TIMER_REG_1_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_LP_TIMER_REG_1_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_LP_TIMER_REG_1_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_MB_HP_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_MB_HP_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x10)
/** CORE0_CORE0_MB_HP_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_MB_HP_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_MB_HP_INT_MAP_M  (CORE0_CORE0_MB_HP_INT_MAP_V << CORE0_CORE0_MB_HP_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_MB_HP_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_MB_HP_INT_MAP_S  0
/** CORE0_CORE0_MB_HP_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_MB_HP_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_MB_HP_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_MB_HP_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_MB_HP_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_MB_HP_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_MB_HP_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_MB_HP_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_MB_HP_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_MB_HP_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_MB_HP_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_MB_HP_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_MB_HP_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_MB_HP_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_MB_LP_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_MB_LP_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x14)
/** CORE0_CORE0_MB_LP_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_MB_LP_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_MB_LP_INT_MAP_M  (CORE0_CORE0_MB_LP_INT_MAP_V << CORE0_CORE0_MB_LP_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_MB_LP_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_MB_LP_INT_MAP_S  0
/** CORE0_CORE0_MB_LP_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_MB_LP_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_MB_LP_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_MB_LP_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_MB_LP_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_MB_LP_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_MB_LP_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_MB_LP_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_MB_LP_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_MB_LP_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_MB_LP_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_MB_LP_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_MB_LP_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_MB_LP_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_PMU_REG_0_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_PMU_REG_0_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x18)
/** CORE0_CORE0_PMU_REG_0_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_PMU_REG_0_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_PMU_REG_0_INT_MAP_M  (CORE0_CORE0_PMU_REG_0_INT_MAP_V << CORE0_CORE0_PMU_REG_0_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_PMU_REG_0_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_PMU_REG_0_INT_MAP_S  0
/** CORE0_CORE0_PMU_REG_0_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_PMU_REG_0_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_PMU_REG_0_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_PMU_REG_0_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_PMU_REG_0_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_PMU_REG_0_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_PMU_REG_0_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_PMU_REG_0_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_PMU_REG_0_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_PMU_REG_0_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_PMU_REG_0_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_PMU_REG_0_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_PMU_REG_0_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_PMU_REG_0_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_PMU_REG_1_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_PMU_REG_1_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x1c)
/** CORE0_CORE0_PMU_REG_1_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_PMU_REG_1_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_PMU_REG_1_INT_MAP_M  (CORE0_CORE0_PMU_REG_1_INT_MAP_V << CORE0_CORE0_PMU_REG_1_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_PMU_REG_1_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_PMU_REG_1_INT_MAP_S  0
/** CORE0_CORE0_PMU_REG_1_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_PMU_REG_1_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_PMU_REG_1_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_PMU_REG_1_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_PMU_REG_1_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_PMU_REG_1_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_PMU_REG_1_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_PMU_REG_1_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_PMU_REG_1_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_PMU_REG_1_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_PMU_REG_1_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_PMU_REG_1_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_PMU_REG_1_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_PMU_REG_1_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_LP_ANAPERI_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_LP_ANAPERI_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x20)
/** CORE0_CORE0_LP_ANAPERI_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_LP_ANAPERI_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_LP_ANAPERI_INT_MAP_M  (CORE0_CORE0_LP_ANAPERI_INT_MAP_V << CORE0_CORE0_LP_ANAPERI_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_LP_ANAPERI_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_LP_ANAPERI_INT_MAP_S  0
/** CORE0_CORE0_LP_ANAPERI_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_LP_ANAPERI_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_LP_ANAPERI_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_LP_ANAPERI_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_LP_ANAPERI_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_LP_ANAPERI_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_LP_ANAPERI_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_LP_ANAPERI_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_LP_ANAPERI_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_LP_ANAPERI_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_LP_ANAPERI_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_LP_ANAPERI_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_LP_ANAPERI_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_LP_ANAPERI_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_LP_ADC_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_LP_ADC_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x24)
/** CORE0_CORE0_LP_ADC_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_LP_ADC_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_LP_ADC_INT_MAP_M  (CORE0_CORE0_LP_ADC_INT_MAP_V << CORE0_CORE0_LP_ADC_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_LP_ADC_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_LP_ADC_INT_MAP_S  0
/** CORE0_CORE0_LP_ADC_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_LP_ADC_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_LP_ADC_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_LP_ADC_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_LP_ADC_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_LP_ADC_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_LP_ADC_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_LP_ADC_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_LP_ADC_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_LP_ADC_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_LP_ADC_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_LP_ADC_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_LP_ADC_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_LP_ADC_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_LP_GPIO_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_LP_GPIO_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x28)
/** CORE0_CORE0_LP_GPIO_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_LP_GPIO_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_LP_GPIO_INT_MAP_M  (CORE0_CORE0_LP_GPIO_INT_MAP_V << CORE0_CORE0_LP_GPIO_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_LP_GPIO_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_LP_GPIO_INT_MAP_S  0
/** CORE0_CORE0_LP_GPIO_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_LP_GPIO_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_LP_GPIO_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_LP_GPIO_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_LP_GPIO_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_LP_GPIO_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_LP_GPIO_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_LP_GPIO_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_LP_GPIO_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_LP_GPIO_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_LP_GPIO_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_LP_GPIO_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_LP_GPIO_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_LP_GPIO_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_LP_I2C_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_LP_I2C_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x2c)
/** CORE0_CORE0_LP_I2C_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_LP_I2C_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_LP_I2C_INT_MAP_M  (CORE0_CORE0_LP_I2C_INT_MAP_V << CORE0_CORE0_LP_I2C_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_LP_I2C_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_LP_I2C_INT_MAP_S  0
/** CORE0_CORE0_LP_I2C_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_LP_I2C_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_LP_I2C_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_LP_I2C_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_LP_I2C_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_LP_I2C_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_LP_I2C_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_LP_I2C_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_LP_I2C_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_LP_I2C_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_LP_I2C_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_LP_I2C_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_LP_I2C_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_LP_I2C_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_LP_I2S_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_LP_I2S_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x30)
/** CORE0_CORE0_LP_I2S_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_LP_I2S_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_LP_I2S_INT_MAP_M  (CORE0_CORE0_LP_I2S_INT_MAP_V << CORE0_CORE0_LP_I2S_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_LP_I2S_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_LP_I2S_INT_MAP_S  0
/** CORE0_CORE0_LP_I2S_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_LP_I2S_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_LP_I2S_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_LP_I2S_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_LP_I2S_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_LP_I2S_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_LP_I2S_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_LP_I2S_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_LP_I2S_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_LP_I2S_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_LP_I2S_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_LP_I2S_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_LP_I2S_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_LP_I2S_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_LP_SPI_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_LP_SPI_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x34)
/** CORE0_CORE0_LP_SPI_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_LP_SPI_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_LP_SPI_INT_MAP_M  (CORE0_CORE0_LP_SPI_INT_MAP_V << CORE0_CORE0_LP_SPI_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_LP_SPI_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_LP_SPI_INT_MAP_S  0
/** CORE0_CORE0_LP_SPI_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_LP_SPI_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_LP_SPI_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_LP_SPI_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_LP_SPI_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_LP_SPI_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_LP_SPI_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_LP_SPI_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_LP_SPI_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_LP_SPI_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_LP_SPI_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_LP_SPI_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_LP_SPI_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_LP_SPI_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_LP_TOUCH_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_LP_TOUCH_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x38)
/** CORE0_CORE0_LP_TOUCH_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_LP_TOUCH_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_LP_TOUCH_INT_MAP_M  (CORE0_CORE0_LP_TOUCH_INT_MAP_V << CORE0_CORE0_LP_TOUCH_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_LP_TOUCH_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_LP_TOUCH_INT_MAP_S  0
/** CORE0_CORE0_LP_TOUCH_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_LP_TOUCH_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_LP_TOUCH_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_LP_TOUCH_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_LP_TOUCH_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_LP_TOUCH_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_LP_TOUCH_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_LP_TOUCH_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_LP_TOUCH_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_LP_TOUCH_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_LP_TOUCH_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_LP_TOUCH_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_LP_TOUCH_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_LP_TOUCH_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_LP_TSENS_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_LP_TSENS_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x3c)
/** CORE0_CORE0_LP_TSENS_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_LP_TSENS_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_LP_TSENS_INT_MAP_M  (CORE0_CORE0_LP_TSENS_INT_MAP_V << CORE0_CORE0_LP_TSENS_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_LP_TSENS_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_LP_TSENS_INT_MAP_S  0
/** CORE0_CORE0_LP_TSENS_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_LP_TSENS_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_LP_TSENS_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_LP_TSENS_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_LP_TSENS_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_LP_TSENS_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_LP_TSENS_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_LP_TSENS_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_LP_TSENS_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_LP_TSENS_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_LP_TSENS_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_LP_TSENS_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_LP_TSENS_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_LP_TSENS_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_LP_UART_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_LP_UART_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x40)
/** CORE0_CORE0_LP_UART_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_LP_UART_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_LP_UART_INT_MAP_M  (CORE0_CORE0_LP_UART_INT_MAP_V << CORE0_CORE0_LP_UART_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_LP_UART_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_LP_UART_INT_MAP_S  0
/** CORE0_CORE0_LP_UART_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_LP_UART_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_LP_UART_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_LP_UART_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_LP_UART_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_LP_UART_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_LP_UART_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_LP_UART_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_LP_UART_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_LP_UART_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_LP_UART_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_LP_UART_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_LP_UART_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_LP_UART_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_LP_EFUSE_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_LP_EFUSE_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x44)
/** CORE0_CORE0_LP_EFUSE_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_LP_EFUSE_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_LP_EFUSE_INT_MAP_M  (CORE0_CORE0_LP_EFUSE_INT_MAP_V << CORE0_CORE0_LP_EFUSE_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_LP_EFUSE_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_LP_EFUSE_INT_MAP_S  0
/** CORE0_CORE0_LP_EFUSE_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_LP_EFUSE_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_LP_EFUSE_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_LP_EFUSE_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_LP_EFUSE_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_LP_EFUSE_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_LP_EFUSE_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_LP_EFUSE_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_LP_EFUSE_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_LP_EFUSE_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_LP_EFUSE_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_LP_EFUSE_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_LP_EFUSE_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_LP_EFUSE_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_LP_SW_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_LP_SW_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x48)
/** CORE0_CORE0_LP_SW_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_LP_SW_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_LP_SW_INT_MAP_M  (CORE0_CORE0_LP_SW_INT_MAP_V << CORE0_CORE0_LP_SW_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_LP_SW_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_LP_SW_INT_MAP_S  0
/** CORE0_CORE0_LP_SW_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_LP_SW_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_LP_SW_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_LP_SW_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_LP_SW_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_LP_SW_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_LP_SW_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_LP_SW_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_LP_SW_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_LP_SW_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_LP_SW_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_LP_SW_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_LP_SW_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_LP_SW_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_LP_SYSREG_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_LP_SYSREG_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x4c)
/** CORE0_CORE0_LP_SYSREG_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_LP_SYSREG_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_LP_SYSREG_INT_MAP_M  (CORE0_CORE0_LP_SYSREG_INT_MAP_V << CORE0_CORE0_LP_SYSREG_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_LP_SYSREG_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_LP_SYSREG_INT_MAP_S  0
/** CORE0_CORE0_LP_SYSREG_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_LP_SYSREG_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_LP_SYSREG_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_LP_SYSREG_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_LP_SYSREG_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_LP_SYSREG_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_LP_SYSREG_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_LP_SYSREG_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_LP_SYSREG_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_LP_SYSREG_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_LP_SYSREG_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_LP_SYSREG_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_LP_SYSREG_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_LP_SYSREG_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_LP_HUK_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_LP_HUK_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x50)
/** CORE0_CORE0_LP_HUK_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_LP_HUK_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_LP_HUK_INT_MAP_M  (CORE0_CORE0_LP_HUK_INT_MAP_V << CORE0_CORE0_LP_HUK_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_LP_HUK_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_LP_HUK_INT_MAP_S  0
/** CORE0_CORE0_LP_HUK_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_LP_HUK_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_LP_HUK_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_LP_HUK_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_LP_HUK_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_LP_HUK_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_LP_HUK_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_LP_HUK_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_LP_HUK_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_LP_HUK_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_LP_HUK_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_LP_HUK_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_LP_HUK_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_LP_HUK_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_SYS_ICM_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_SYS_ICM_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x54)
/** CORE0_CORE0_SYS_ICM_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_SYS_ICM_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_SYS_ICM_INT_MAP_M  (CORE0_CORE0_SYS_ICM_INT_MAP_V << CORE0_CORE0_SYS_ICM_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_SYS_ICM_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_SYS_ICM_INT_MAP_S  0
/** CORE0_CORE0_SYS_ICM_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_SYS_ICM_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_SYS_ICM_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_SYS_ICM_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_SYS_ICM_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_SYS_ICM_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_SYS_ICM_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_SYS_ICM_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_SYS_ICM_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_SYS_ICM_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_SYS_ICM_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_SYS_ICM_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_SYS_ICM_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_SYS_ICM_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_USB_DEVICE_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_USB_DEVICE_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x58)
/** CORE0_CORE0_USB_DEVICE_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_USB_DEVICE_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_USB_DEVICE_INT_MAP_M  (CORE0_CORE0_USB_DEVICE_INT_MAP_V << CORE0_CORE0_USB_DEVICE_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_USB_DEVICE_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_USB_DEVICE_INT_MAP_S  0
/** CORE0_CORE0_USB_DEVICE_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_USB_DEVICE_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_USB_DEVICE_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_USB_DEVICE_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_USB_DEVICE_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_USB_DEVICE_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_USB_DEVICE_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_USB_DEVICE_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_USB_DEVICE_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_USB_DEVICE_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_USB_DEVICE_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_USB_DEVICE_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_USB_DEVICE_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_USB_DEVICE_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_SDIO_HOST_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_SDIO_HOST_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x5c)
/** CORE0_CORE0_SDIO_HOST_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_SDIO_HOST_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_SDIO_HOST_INT_MAP_M  (CORE0_CORE0_SDIO_HOST_INT_MAP_V << CORE0_CORE0_SDIO_HOST_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_SDIO_HOST_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_SDIO_HOST_INT_MAP_S  0
/** CORE0_CORE0_SDIO_HOST_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_SDIO_HOST_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_SDIO_HOST_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_SDIO_HOST_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_SDIO_HOST_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_SDIO_HOST_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_SDIO_HOST_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_SDIO_HOST_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_SDIO_HOST_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_SDIO_HOST_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_SDIO_HOST_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_SDIO_HOST_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_SDIO_HOST_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_SDIO_HOST_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_GDMA_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_GDMA_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x60)
/** CORE0_CORE0_GDMA_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_GDMA_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_GDMA_INT_MAP_M  (CORE0_CORE0_GDMA_INT_MAP_V << CORE0_CORE0_GDMA_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_GDMA_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_GDMA_INT_MAP_S  0
/** CORE0_CORE0_GDMA_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_GDMA_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_GDMA_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_GDMA_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_GDMA_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_GDMA_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_GDMA_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_GDMA_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_GDMA_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_GDMA_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_GDMA_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_GDMA_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_GDMA_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_GDMA_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_SPI2_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_SPI2_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x64)
/** CORE0_CORE0_SPI2_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_SPI2_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_SPI2_INT_MAP_M  (CORE0_CORE0_SPI2_INT_MAP_V << CORE0_CORE0_SPI2_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_SPI2_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_SPI2_INT_MAP_S  0
/** CORE0_CORE0_SPI2_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_SPI2_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_SPI2_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_SPI2_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_SPI2_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_SPI2_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_SPI2_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_SPI2_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_SPI2_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_SPI2_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_SPI2_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_SPI2_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_SPI2_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_SPI2_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_SPI3_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_SPI3_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x68)
/** CORE0_CORE0_SPI3_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_SPI3_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_SPI3_INT_MAP_M  (CORE0_CORE0_SPI3_INT_MAP_V << CORE0_CORE0_SPI3_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_SPI3_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_SPI3_INT_MAP_S  0
/** CORE0_CORE0_SPI3_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_SPI3_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_SPI3_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_SPI3_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_SPI3_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_SPI3_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_SPI3_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_SPI3_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_SPI3_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_SPI3_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_SPI3_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_SPI3_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_SPI3_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_SPI3_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_I2S0_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_I2S0_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x6c)
/** CORE0_CORE0_I2S0_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_I2S0_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_I2S0_INT_MAP_M  (CORE0_CORE0_I2S0_INT_MAP_V << CORE0_CORE0_I2S0_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_I2S0_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_I2S0_INT_MAP_S  0
/** CORE0_CORE0_I2S0_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_I2S0_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_I2S0_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_I2S0_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_I2S0_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_I2S0_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_I2S0_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_I2S0_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_I2S0_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_I2S0_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_I2S0_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_I2S0_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_I2S0_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_I2S0_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_I2S1_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_I2S1_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x70)
/** CORE0_CORE0_I2S1_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_I2S1_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_I2S1_INT_MAP_M  (CORE0_CORE0_I2S1_INT_MAP_V << CORE0_CORE0_I2S1_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_I2S1_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_I2S1_INT_MAP_S  0
/** CORE0_CORE0_I2S1_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_I2S1_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_I2S1_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_I2S1_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_I2S1_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_I2S1_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_I2S1_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_I2S1_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_I2S1_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_I2S1_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_I2S1_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_I2S1_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_I2S1_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_I2S1_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_I2S2_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_I2S2_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x74)
/** CORE0_CORE0_I2S2_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_I2S2_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_I2S2_INT_MAP_M  (CORE0_CORE0_I2S2_INT_MAP_V << CORE0_CORE0_I2S2_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_I2S2_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_I2S2_INT_MAP_S  0
/** CORE0_CORE0_I2S2_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_I2S2_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_I2S2_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_I2S2_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_I2S2_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_I2S2_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_I2S2_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_I2S2_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_I2S2_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_I2S2_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_I2S2_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_I2S2_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_I2S2_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_I2S2_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_UHCI0_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_UHCI0_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x78)
/** CORE0_CORE0_UHCI0_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_UHCI0_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_UHCI0_INT_MAP_M  (CORE0_CORE0_UHCI0_INT_MAP_V << CORE0_CORE0_UHCI0_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_UHCI0_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_UHCI0_INT_MAP_S  0
/** CORE0_CORE0_UHCI0_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_UHCI0_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_UHCI0_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_UHCI0_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_UHCI0_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_UHCI0_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_UHCI0_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_UHCI0_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_UHCI0_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_UHCI0_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_UHCI0_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_UHCI0_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_UHCI0_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_UHCI0_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_UART0_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_UART0_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x7c)
/** CORE0_CORE0_UART0_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_UART0_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_UART0_INT_MAP_M  (CORE0_CORE0_UART0_INT_MAP_V << CORE0_CORE0_UART0_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_UART0_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_UART0_INT_MAP_S  0
/** CORE0_CORE0_UART0_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_UART0_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_UART0_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_UART0_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_UART0_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_UART0_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_UART0_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_UART0_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_UART0_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_UART0_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_UART0_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_UART0_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_UART0_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_UART0_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_UART1_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_UART1_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x80)
/** CORE0_CORE0_UART1_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_UART1_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_UART1_INT_MAP_M  (CORE0_CORE0_UART1_INT_MAP_V << CORE0_CORE0_UART1_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_UART1_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_UART1_INT_MAP_S  0
/** CORE0_CORE0_UART1_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_UART1_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_UART1_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_UART1_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_UART1_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_UART1_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_UART1_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_UART1_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_UART1_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_UART1_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_UART1_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_UART1_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_UART1_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_UART1_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_UART2_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_UART2_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x84)
/** CORE0_CORE0_UART2_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_UART2_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_UART2_INT_MAP_M  (CORE0_CORE0_UART2_INT_MAP_V << CORE0_CORE0_UART2_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_UART2_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_UART2_INT_MAP_S  0
/** CORE0_CORE0_UART2_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_UART2_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_UART2_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_UART2_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_UART2_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_UART2_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_UART2_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_UART2_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_UART2_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_UART2_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_UART2_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_UART2_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_UART2_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_UART2_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_UART3_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_UART3_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x88)
/** CORE0_CORE0_UART3_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_UART3_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_UART3_INT_MAP_M  (CORE0_CORE0_UART3_INT_MAP_V << CORE0_CORE0_UART3_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_UART3_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_UART3_INT_MAP_S  0
/** CORE0_CORE0_UART3_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_UART3_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_UART3_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_UART3_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_UART3_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_UART3_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_UART3_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_UART3_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_UART3_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_UART3_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_UART3_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_UART3_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_UART3_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_UART3_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_UART4_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_UART4_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x8c)
/** CORE0_CORE0_UART4_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_UART4_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_UART4_INT_MAP_M  (CORE0_CORE0_UART4_INT_MAP_V << CORE0_CORE0_UART4_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_UART4_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_UART4_INT_MAP_S  0
/** CORE0_CORE0_UART4_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_UART4_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_UART4_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_UART4_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_UART4_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_UART4_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_UART4_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_UART4_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_UART4_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_UART4_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_UART4_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_UART4_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_UART4_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_UART4_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_LCD_CAM_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_LCD_CAM_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x90)
/** CORE0_CORE0_LCD_CAM_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_LCD_CAM_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_LCD_CAM_INT_MAP_M  (CORE0_CORE0_LCD_CAM_INT_MAP_V << CORE0_CORE0_LCD_CAM_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_LCD_CAM_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_LCD_CAM_INT_MAP_S  0
/** CORE0_CORE0_LCD_CAM_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_LCD_CAM_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_LCD_CAM_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_LCD_CAM_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_LCD_CAM_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_LCD_CAM_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_LCD_CAM_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_LCD_CAM_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_LCD_CAM_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_LCD_CAM_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_LCD_CAM_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_LCD_CAM_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_LCD_CAM_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_LCD_CAM_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_ADC_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_ADC_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x94)
/** CORE0_CORE0_ADC_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_ADC_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_ADC_INT_MAP_M  (CORE0_CORE0_ADC_INT_MAP_V << CORE0_CORE0_ADC_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_ADC_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_ADC_INT_MAP_S  0
/** CORE0_CORE0_ADC_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_ADC_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_ADC_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_ADC_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_ADC_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_ADC_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_ADC_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_ADC_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_ADC_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_ADC_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_ADC_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_ADC_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_ADC_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_ADC_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_PWM0_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_PWM0_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x98)
/** CORE0_CORE0_PWM0_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_PWM0_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_PWM0_INT_MAP_M  (CORE0_CORE0_PWM0_INT_MAP_V << CORE0_CORE0_PWM0_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_PWM0_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_PWM0_INT_MAP_S  0
/** CORE0_CORE0_PWM0_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_PWM0_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_PWM0_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_PWM0_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_PWM0_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_PWM0_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_PWM0_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_PWM0_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_PWM0_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_PWM0_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_PWM0_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_PWM0_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_PWM0_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_PWM0_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_PWM1_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_PWM1_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x9c)
/** CORE0_CORE0_PWM1_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_PWM1_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_PWM1_INT_MAP_M  (CORE0_CORE0_PWM1_INT_MAP_V << CORE0_CORE0_PWM1_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_PWM1_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_PWM1_INT_MAP_S  0
/** CORE0_CORE0_PWM1_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_PWM1_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_PWM1_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_PWM1_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_PWM1_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_PWM1_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_PWM1_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_PWM1_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_PWM1_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_PWM1_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_PWM1_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_PWM1_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_PWM1_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_PWM1_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_CAN0_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_CAN0_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0xa0)
/** CORE0_CORE0_CAN0_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_CAN0_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_CAN0_INT_MAP_M  (CORE0_CORE0_CAN0_INT_MAP_V << CORE0_CORE0_CAN0_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_CAN0_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_CAN0_INT_MAP_S  0
/** CORE0_CORE0_CAN0_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_CAN0_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_CAN0_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_CAN0_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_CAN0_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_CAN0_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_CAN0_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_CAN0_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_CAN0_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_CAN0_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_CAN0_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_CAN0_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_CAN0_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_CAN0_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_CAN1_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_CAN1_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0xa4)
/** CORE0_CORE0_CAN1_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_CAN1_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_CAN1_INT_MAP_M  (CORE0_CORE0_CAN1_INT_MAP_V << CORE0_CORE0_CAN1_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_CAN1_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_CAN1_INT_MAP_S  0
/** CORE0_CORE0_CAN1_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_CAN1_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_CAN1_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_CAN1_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_CAN1_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_CAN1_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_CAN1_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_CAN1_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_CAN1_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_CAN1_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_CAN1_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_CAN1_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_CAN1_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_CAN1_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_CAN2_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_CAN2_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0xa8)
/** CORE0_CORE0_CAN2_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_CAN2_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_CAN2_INT_MAP_M  (CORE0_CORE0_CAN2_INT_MAP_V << CORE0_CORE0_CAN2_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_CAN2_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_CAN2_INT_MAP_S  0
/** CORE0_CORE0_CAN2_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_CAN2_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_CAN2_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_CAN2_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_CAN2_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_CAN2_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_CAN2_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_CAN2_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_CAN2_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_CAN2_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_CAN2_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_CAN2_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_CAN2_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_CAN2_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_RMT_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_RMT_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0xac)
/** CORE0_CORE0_RMT_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_RMT_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_RMT_INT_MAP_M  (CORE0_CORE0_RMT_INT_MAP_V << CORE0_CORE0_RMT_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_RMT_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_RMT_INT_MAP_S  0
/** CORE0_CORE0_RMT_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_RMT_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_RMT_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_RMT_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_RMT_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_RMT_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_RMT_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_RMT_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_RMT_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_RMT_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_RMT_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_RMT_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_RMT_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_RMT_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_I2C0_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_I2C0_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0xb0)
/** CORE0_CORE0_I2C0_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_I2C0_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_I2C0_INT_MAP_M  (CORE0_CORE0_I2C0_INT_MAP_V << CORE0_CORE0_I2C0_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_I2C0_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_I2C0_INT_MAP_S  0
/** CORE0_CORE0_I2C0_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_I2C0_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_I2C0_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_I2C0_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_I2C0_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_I2C0_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_I2C0_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_I2C0_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_I2C0_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_I2C0_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_I2C0_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_I2C0_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_I2C0_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_I2C0_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_I2C1_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_I2C1_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0xb4)
/** CORE0_CORE0_I2C1_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_I2C1_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_I2C1_INT_MAP_M  (CORE0_CORE0_I2C1_INT_MAP_V << CORE0_CORE0_I2C1_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_I2C1_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_I2C1_INT_MAP_S  0
/** CORE0_CORE0_I2C1_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_I2C1_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_I2C1_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_I2C1_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_I2C1_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_I2C1_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_I2C1_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_I2C1_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_I2C1_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_I2C1_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_I2C1_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_I2C1_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_I2C1_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_I2C1_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_TIMERGRP0_T0_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_TIMERGRP0_T0_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0xb8)
/** CORE0_CORE0_TIMERGRP0_T0_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_TIMERGRP0_T0_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_TIMERGRP0_T0_INT_MAP_M  (CORE0_CORE0_TIMERGRP0_T0_INT_MAP_V << CORE0_CORE0_TIMERGRP0_T0_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_TIMERGRP0_T0_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_TIMERGRP0_T0_INT_MAP_S  0
/** CORE0_CORE0_TIMERGRP0_T0_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_TIMERGRP0_T0_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_TIMERGRP0_T0_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_TIMERGRP0_T0_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_TIMERGRP0_T0_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_TIMERGRP0_T0_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_TIMERGRP0_T0_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_TIMERGRP0_T0_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_TIMERGRP0_T0_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_TIMERGRP0_T0_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_TIMERGRP0_T0_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_TIMERGRP0_T0_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_TIMERGRP0_T0_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_TIMERGRP0_T0_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_TIMERGRP0_T1_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_TIMERGRP0_T1_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0xbc)
/** CORE0_CORE0_TIMERGRP0_T1_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_TIMERGRP0_T1_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_TIMERGRP0_T1_INT_MAP_M  (CORE0_CORE0_TIMERGRP0_T1_INT_MAP_V << CORE0_CORE0_TIMERGRP0_T1_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_TIMERGRP0_T1_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_TIMERGRP0_T1_INT_MAP_S  0
/** CORE0_CORE0_TIMERGRP0_T1_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_TIMERGRP0_T1_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_TIMERGRP0_T1_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_TIMERGRP0_T1_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_TIMERGRP0_T1_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_TIMERGRP0_T1_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_TIMERGRP0_T1_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_TIMERGRP0_T1_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_TIMERGRP0_T1_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_TIMERGRP0_T1_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_TIMERGRP0_T1_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_TIMERGRP0_T1_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_TIMERGRP0_T1_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_TIMERGRP0_T1_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_TIMERGRP0_WDT_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_TIMERGRP0_WDT_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0xc0)
/** CORE0_CORE0_TIMERGRP0_WDT_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_TIMERGRP0_WDT_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_TIMERGRP0_WDT_INT_MAP_M  (CORE0_CORE0_TIMERGRP0_WDT_INT_MAP_V << CORE0_CORE0_TIMERGRP0_WDT_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_TIMERGRP0_WDT_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_TIMERGRP0_WDT_INT_MAP_S  0
/** CORE0_CORE0_TIMERGRP0_WDT_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_TIMERGRP0_WDT_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_TIMERGRP0_WDT_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_TIMERGRP0_WDT_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_TIMERGRP0_WDT_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_TIMERGRP0_WDT_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_TIMERGRP0_WDT_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_TIMERGRP0_WDT_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_TIMERGRP0_WDT_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_TIMERGRP0_WDT_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_TIMERGRP0_WDT_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_TIMERGRP0_WDT_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_TIMERGRP0_WDT_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_TIMERGRP0_WDT_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_TIMERGRP1_T0_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_TIMERGRP1_T0_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0xc4)
/** CORE0_CORE0_TIMERGRP1_T0_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_TIMERGRP1_T0_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_TIMERGRP1_T0_INT_MAP_M  (CORE0_CORE0_TIMERGRP1_T0_INT_MAP_V << CORE0_CORE0_TIMERGRP1_T0_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_TIMERGRP1_T0_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_TIMERGRP1_T0_INT_MAP_S  0
/** CORE0_CORE0_TIMERGRP1_T0_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_TIMERGRP1_T0_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_TIMERGRP1_T0_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_TIMERGRP1_T0_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_TIMERGRP1_T0_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_TIMERGRP1_T0_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_TIMERGRP1_T0_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_TIMERGRP1_T0_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_TIMERGRP1_T0_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_TIMERGRP1_T0_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_TIMERGRP1_T0_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_TIMERGRP1_T0_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_TIMERGRP1_T0_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_TIMERGRP1_T0_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_TIMERGRP1_T1_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_TIMERGRP1_T1_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0xc8)
/** CORE0_CORE0_TIMERGRP1_T1_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_TIMERGRP1_T1_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_TIMERGRP1_T1_INT_MAP_M  (CORE0_CORE0_TIMERGRP1_T1_INT_MAP_V << CORE0_CORE0_TIMERGRP1_T1_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_TIMERGRP1_T1_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_TIMERGRP1_T1_INT_MAP_S  0
/** CORE0_CORE0_TIMERGRP1_T1_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_TIMERGRP1_T1_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_TIMERGRP1_T1_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_TIMERGRP1_T1_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_TIMERGRP1_T1_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_TIMERGRP1_T1_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_TIMERGRP1_T1_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_TIMERGRP1_T1_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_TIMERGRP1_T1_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_TIMERGRP1_T1_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_TIMERGRP1_T1_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_TIMERGRP1_T1_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_TIMERGRP1_T1_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_TIMERGRP1_T1_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_TIMERGRP1_WDT_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_TIMERGRP1_WDT_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0xcc)
/** CORE0_CORE0_TIMERGRP1_WDT_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_TIMERGRP1_WDT_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_TIMERGRP1_WDT_INT_MAP_M  (CORE0_CORE0_TIMERGRP1_WDT_INT_MAP_V << CORE0_CORE0_TIMERGRP1_WDT_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_TIMERGRP1_WDT_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_TIMERGRP1_WDT_INT_MAP_S  0
/** CORE0_CORE0_TIMERGRP1_WDT_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_TIMERGRP1_WDT_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_TIMERGRP1_WDT_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_TIMERGRP1_WDT_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_TIMERGRP1_WDT_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_TIMERGRP1_WDT_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_TIMERGRP1_WDT_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_TIMERGRP1_WDT_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_TIMERGRP1_WDT_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_TIMERGRP1_WDT_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_TIMERGRP1_WDT_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_TIMERGRP1_WDT_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_TIMERGRP1_WDT_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_TIMERGRP1_WDT_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_LEDC_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_LEDC_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0xd0)
/** CORE0_CORE0_LEDC_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_LEDC_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_LEDC_INT_MAP_M  (CORE0_CORE0_LEDC_INT_MAP_V << CORE0_CORE0_LEDC_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_LEDC_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_LEDC_INT_MAP_S  0
/** CORE0_CORE0_LEDC_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_LEDC_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_LEDC_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_LEDC_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_LEDC_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_LEDC_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_LEDC_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_LEDC_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_LEDC_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_LEDC_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_LEDC_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_LEDC_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_LEDC_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_LEDC_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_SYSTIMER_TARGET0_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_SYSTIMER_TARGET0_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0xd4)
/** CORE0_CORE0_SYSTIMER_TARGET0_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_SYSTIMER_TARGET0_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_SYSTIMER_TARGET0_INT_MAP_M  (CORE0_CORE0_SYSTIMER_TARGET0_INT_MAP_V << CORE0_CORE0_SYSTIMER_TARGET0_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_SYSTIMER_TARGET0_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_SYSTIMER_TARGET0_INT_MAP_S  0
/** CORE0_CORE0_SYSTIMER_TARGET0_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_SYSTIMER_TARGET0_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_SYSTIMER_TARGET0_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_SYSTIMER_TARGET0_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_SYSTIMER_TARGET0_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_SYSTIMER_TARGET0_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_SYSTIMER_TARGET0_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_SYSTIMER_TARGET0_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_SYSTIMER_TARGET0_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_SYSTIMER_TARGET0_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_SYSTIMER_TARGET0_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_SYSTIMER_TARGET0_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_SYSTIMER_TARGET0_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_SYSTIMER_TARGET0_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_SYSTIMER_TARGET1_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_SYSTIMER_TARGET1_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0xd8)
/** CORE0_CORE0_SYSTIMER_TARGET1_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_SYSTIMER_TARGET1_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_SYSTIMER_TARGET1_INT_MAP_M  (CORE0_CORE0_SYSTIMER_TARGET1_INT_MAP_V << CORE0_CORE0_SYSTIMER_TARGET1_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_SYSTIMER_TARGET1_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_SYSTIMER_TARGET1_INT_MAP_S  0
/** CORE0_CORE0_SYSTIMER_TARGET1_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_SYSTIMER_TARGET1_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_SYSTIMER_TARGET1_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_SYSTIMER_TARGET1_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_SYSTIMER_TARGET1_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_SYSTIMER_TARGET1_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_SYSTIMER_TARGET1_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_SYSTIMER_TARGET1_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_SYSTIMER_TARGET1_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_SYSTIMER_TARGET1_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_SYSTIMER_TARGET1_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_SYSTIMER_TARGET1_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_SYSTIMER_TARGET1_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_SYSTIMER_TARGET1_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_SYSTIMER_TARGET2_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_SYSTIMER_TARGET2_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0xdc)
/** CORE0_CORE0_SYSTIMER_TARGET2_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_SYSTIMER_TARGET2_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_SYSTIMER_TARGET2_INT_MAP_M  (CORE0_CORE0_SYSTIMER_TARGET2_INT_MAP_V << CORE0_CORE0_SYSTIMER_TARGET2_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_SYSTIMER_TARGET2_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_SYSTIMER_TARGET2_INT_MAP_S  0
/** CORE0_CORE0_SYSTIMER_TARGET2_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_SYSTIMER_TARGET2_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_SYSTIMER_TARGET2_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_SYSTIMER_TARGET2_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_SYSTIMER_TARGET2_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_SYSTIMER_TARGET2_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_SYSTIMER_TARGET2_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_SYSTIMER_TARGET2_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_SYSTIMER_TARGET2_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_SYSTIMER_TARGET2_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_SYSTIMER_TARGET2_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_SYSTIMER_TARGET2_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_SYSTIMER_TARGET2_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_SYSTIMER_TARGET2_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_AHB_PDMA_IN_CH0_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_AHB_PDMA_IN_CH0_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0xe0)
/** CORE0_CORE0_AHB_PDMA_IN_CH0_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_AHB_PDMA_IN_CH0_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_AHB_PDMA_IN_CH0_INT_MAP_M  (CORE0_CORE0_AHB_PDMA_IN_CH0_INT_MAP_V << CORE0_CORE0_AHB_PDMA_IN_CH0_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_AHB_PDMA_IN_CH0_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_AHB_PDMA_IN_CH0_INT_MAP_S  0
/** CORE0_CORE0_AHB_PDMA_IN_CH0_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_AHB_PDMA_IN_CH0_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_AHB_PDMA_IN_CH0_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_AHB_PDMA_IN_CH0_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_AHB_PDMA_IN_CH0_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_AHB_PDMA_IN_CH0_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_AHB_PDMA_IN_CH0_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_AHB_PDMA_IN_CH0_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_AHB_PDMA_IN_CH0_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_AHB_PDMA_IN_CH0_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_AHB_PDMA_IN_CH0_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_AHB_PDMA_IN_CH0_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_AHB_PDMA_IN_CH0_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_AHB_PDMA_IN_CH0_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_AHB_PDMA_IN_CH1_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_AHB_PDMA_IN_CH1_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0xe4)
/** CORE0_CORE0_AHB_PDMA_IN_CH1_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_AHB_PDMA_IN_CH1_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_AHB_PDMA_IN_CH1_INT_MAP_M  (CORE0_CORE0_AHB_PDMA_IN_CH1_INT_MAP_V << CORE0_CORE0_AHB_PDMA_IN_CH1_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_AHB_PDMA_IN_CH1_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_AHB_PDMA_IN_CH1_INT_MAP_S  0
/** CORE0_CORE0_AHB_PDMA_IN_CH1_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_AHB_PDMA_IN_CH1_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_AHB_PDMA_IN_CH1_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_AHB_PDMA_IN_CH1_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_AHB_PDMA_IN_CH1_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_AHB_PDMA_IN_CH1_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_AHB_PDMA_IN_CH1_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_AHB_PDMA_IN_CH1_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_AHB_PDMA_IN_CH1_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_AHB_PDMA_IN_CH1_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_AHB_PDMA_IN_CH1_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_AHB_PDMA_IN_CH1_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_AHB_PDMA_IN_CH1_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_AHB_PDMA_IN_CH1_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_AHB_PDMA_IN_CH2_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_AHB_PDMA_IN_CH2_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0xe8)
/** CORE0_CORE0_AHB_PDMA_IN_CH2_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_AHB_PDMA_IN_CH2_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_AHB_PDMA_IN_CH2_INT_MAP_M  (CORE0_CORE0_AHB_PDMA_IN_CH2_INT_MAP_V << CORE0_CORE0_AHB_PDMA_IN_CH2_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_AHB_PDMA_IN_CH2_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_AHB_PDMA_IN_CH2_INT_MAP_S  0
/** CORE0_CORE0_AHB_PDMA_IN_CH2_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_AHB_PDMA_IN_CH2_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_AHB_PDMA_IN_CH2_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_AHB_PDMA_IN_CH2_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_AHB_PDMA_IN_CH2_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_AHB_PDMA_IN_CH2_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_AHB_PDMA_IN_CH2_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_AHB_PDMA_IN_CH2_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_AHB_PDMA_IN_CH2_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_AHB_PDMA_IN_CH2_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_AHB_PDMA_IN_CH2_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_AHB_PDMA_IN_CH2_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_AHB_PDMA_IN_CH2_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_AHB_PDMA_IN_CH2_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_AHB_PDMA_OUT_CH0_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_AHB_PDMA_OUT_CH0_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0xec)
/** CORE0_CORE0_AHB_PDMA_OUT_CH0_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_AHB_PDMA_OUT_CH0_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_AHB_PDMA_OUT_CH0_INT_MAP_M  (CORE0_CORE0_AHB_PDMA_OUT_CH0_INT_MAP_V << CORE0_CORE0_AHB_PDMA_OUT_CH0_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_AHB_PDMA_OUT_CH0_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_AHB_PDMA_OUT_CH0_INT_MAP_S  0
/** CORE0_CORE0_AHB_PDMA_OUT_CH0_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_AHB_PDMA_OUT_CH0_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_AHB_PDMA_OUT_CH0_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_AHB_PDMA_OUT_CH0_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_AHB_PDMA_OUT_CH0_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_AHB_PDMA_OUT_CH0_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_AHB_PDMA_OUT_CH0_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_AHB_PDMA_OUT_CH0_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_AHB_PDMA_OUT_CH0_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_AHB_PDMA_OUT_CH0_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_AHB_PDMA_OUT_CH0_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_AHB_PDMA_OUT_CH0_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_AHB_PDMA_OUT_CH0_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_AHB_PDMA_OUT_CH0_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_AHB_PDMA_OUT_CH1_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_AHB_PDMA_OUT_CH1_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0xf0)
/** CORE0_CORE0_AHB_PDMA_OUT_CH1_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_AHB_PDMA_OUT_CH1_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_AHB_PDMA_OUT_CH1_INT_MAP_M  (CORE0_CORE0_AHB_PDMA_OUT_CH1_INT_MAP_V << CORE0_CORE0_AHB_PDMA_OUT_CH1_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_AHB_PDMA_OUT_CH1_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_AHB_PDMA_OUT_CH1_INT_MAP_S  0
/** CORE0_CORE0_AHB_PDMA_OUT_CH1_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_AHB_PDMA_OUT_CH1_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_AHB_PDMA_OUT_CH1_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_AHB_PDMA_OUT_CH1_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_AHB_PDMA_OUT_CH1_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_AHB_PDMA_OUT_CH1_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_AHB_PDMA_OUT_CH1_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_AHB_PDMA_OUT_CH1_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_AHB_PDMA_OUT_CH1_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_AHB_PDMA_OUT_CH1_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_AHB_PDMA_OUT_CH1_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_AHB_PDMA_OUT_CH1_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_AHB_PDMA_OUT_CH1_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_AHB_PDMA_OUT_CH1_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_AHB_PDMA_OUT_CH2_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_AHB_PDMA_OUT_CH2_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0xf4)
/** CORE0_CORE0_AHB_PDMA_OUT_CH2_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_AHB_PDMA_OUT_CH2_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_AHB_PDMA_OUT_CH2_INT_MAP_M  (CORE0_CORE0_AHB_PDMA_OUT_CH2_INT_MAP_V << CORE0_CORE0_AHB_PDMA_OUT_CH2_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_AHB_PDMA_OUT_CH2_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_AHB_PDMA_OUT_CH2_INT_MAP_S  0
/** CORE0_CORE0_AHB_PDMA_OUT_CH2_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_AHB_PDMA_OUT_CH2_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_AHB_PDMA_OUT_CH2_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_AHB_PDMA_OUT_CH2_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_AHB_PDMA_OUT_CH2_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_AHB_PDMA_OUT_CH2_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_AHB_PDMA_OUT_CH2_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_AHB_PDMA_OUT_CH2_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_AHB_PDMA_OUT_CH2_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_AHB_PDMA_OUT_CH2_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_AHB_PDMA_OUT_CH2_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_AHB_PDMA_OUT_CH2_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_AHB_PDMA_OUT_CH2_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_AHB_PDMA_OUT_CH2_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_AXI_PDMA_IN_CH0_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_AXI_PDMA_IN_CH0_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0xf8)
/** CORE0_CORE0_AXI_PDMA_IN_CH0_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_AXI_PDMA_IN_CH0_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_AXI_PDMA_IN_CH0_INT_MAP_M  (CORE0_CORE0_AXI_PDMA_IN_CH0_INT_MAP_V << CORE0_CORE0_AXI_PDMA_IN_CH0_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_AXI_PDMA_IN_CH0_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_AXI_PDMA_IN_CH0_INT_MAP_S  0
/** CORE0_CORE0_AXI_PDMA_IN_CH0_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_AXI_PDMA_IN_CH0_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_AXI_PDMA_IN_CH0_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_AXI_PDMA_IN_CH0_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_AXI_PDMA_IN_CH0_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_AXI_PDMA_IN_CH0_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_AXI_PDMA_IN_CH0_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_AXI_PDMA_IN_CH0_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_AXI_PDMA_IN_CH0_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_AXI_PDMA_IN_CH0_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_AXI_PDMA_IN_CH0_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_AXI_PDMA_IN_CH0_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_AXI_PDMA_IN_CH0_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_AXI_PDMA_IN_CH0_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_AXI_PDMA_IN_CH1_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_AXI_PDMA_IN_CH1_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0xfc)
/** CORE0_CORE0_AXI_PDMA_IN_CH1_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_AXI_PDMA_IN_CH1_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_AXI_PDMA_IN_CH1_INT_MAP_M  (CORE0_CORE0_AXI_PDMA_IN_CH1_INT_MAP_V << CORE0_CORE0_AXI_PDMA_IN_CH1_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_AXI_PDMA_IN_CH1_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_AXI_PDMA_IN_CH1_INT_MAP_S  0
/** CORE0_CORE0_AXI_PDMA_IN_CH1_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_AXI_PDMA_IN_CH1_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_AXI_PDMA_IN_CH1_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_AXI_PDMA_IN_CH1_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_AXI_PDMA_IN_CH1_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_AXI_PDMA_IN_CH1_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_AXI_PDMA_IN_CH1_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_AXI_PDMA_IN_CH1_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_AXI_PDMA_IN_CH1_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_AXI_PDMA_IN_CH1_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_AXI_PDMA_IN_CH1_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_AXI_PDMA_IN_CH1_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_AXI_PDMA_IN_CH1_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_AXI_PDMA_IN_CH1_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_AXI_PDMA_IN_CH2_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_AXI_PDMA_IN_CH2_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x100)
/** CORE0_CORE0_AXI_PDMA_IN_CH2_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_AXI_PDMA_IN_CH2_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_AXI_PDMA_IN_CH2_INT_MAP_M  (CORE0_CORE0_AXI_PDMA_IN_CH2_INT_MAP_V << CORE0_CORE0_AXI_PDMA_IN_CH2_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_AXI_PDMA_IN_CH2_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_AXI_PDMA_IN_CH2_INT_MAP_S  0
/** CORE0_CORE0_AXI_PDMA_IN_CH2_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_AXI_PDMA_IN_CH2_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_AXI_PDMA_IN_CH2_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_AXI_PDMA_IN_CH2_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_AXI_PDMA_IN_CH2_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_AXI_PDMA_IN_CH2_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_AXI_PDMA_IN_CH2_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_AXI_PDMA_IN_CH2_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_AXI_PDMA_IN_CH2_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_AXI_PDMA_IN_CH2_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_AXI_PDMA_IN_CH2_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_AXI_PDMA_IN_CH2_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_AXI_PDMA_IN_CH2_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_AXI_PDMA_IN_CH2_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_AXI_PDMA_OUT_CH0_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_AXI_PDMA_OUT_CH0_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x104)
/** CORE0_CORE0_AXI_PDMA_OUT_CH0_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_AXI_PDMA_OUT_CH0_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_AXI_PDMA_OUT_CH0_INT_MAP_M  (CORE0_CORE0_AXI_PDMA_OUT_CH0_INT_MAP_V << CORE0_CORE0_AXI_PDMA_OUT_CH0_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_AXI_PDMA_OUT_CH0_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_AXI_PDMA_OUT_CH0_INT_MAP_S  0
/** CORE0_CORE0_AXI_PDMA_OUT_CH0_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_AXI_PDMA_OUT_CH0_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_AXI_PDMA_OUT_CH0_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_AXI_PDMA_OUT_CH0_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_AXI_PDMA_OUT_CH0_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_AXI_PDMA_OUT_CH0_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_AXI_PDMA_OUT_CH0_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_AXI_PDMA_OUT_CH0_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_AXI_PDMA_OUT_CH0_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_AXI_PDMA_OUT_CH0_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_AXI_PDMA_OUT_CH0_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_AXI_PDMA_OUT_CH0_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_AXI_PDMA_OUT_CH0_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_AXI_PDMA_OUT_CH0_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_AXI_PDMA_OUT_CH1_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_AXI_PDMA_OUT_CH1_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x108)
/** CORE0_CORE0_AXI_PDMA_OUT_CH1_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_AXI_PDMA_OUT_CH1_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_AXI_PDMA_OUT_CH1_INT_MAP_M  (CORE0_CORE0_AXI_PDMA_OUT_CH1_INT_MAP_V << CORE0_CORE0_AXI_PDMA_OUT_CH1_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_AXI_PDMA_OUT_CH1_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_AXI_PDMA_OUT_CH1_INT_MAP_S  0
/** CORE0_CORE0_AXI_PDMA_OUT_CH1_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_AXI_PDMA_OUT_CH1_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_AXI_PDMA_OUT_CH1_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_AXI_PDMA_OUT_CH1_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_AXI_PDMA_OUT_CH1_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_AXI_PDMA_OUT_CH1_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_AXI_PDMA_OUT_CH1_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_AXI_PDMA_OUT_CH1_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_AXI_PDMA_OUT_CH1_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_AXI_PDMA_OUT_CH1_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_AXI_PDMA_OUT_CH1_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_AXI_PDMA_OUT_CH1_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_AXI_PDMA_OUT_CH1_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_AXI_PDMA_OUT_CH1_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_AXI_PDMA_OUT_CH2_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_AXI_PDMA_OUT_CH2_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x10c)
/** CORE0_CORE0_AXI_PDMA_OUT_CH2_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_AXI_PDMA_OUT_CH2_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_AXI_PDMA_OUT_CH2_INT_MAP_M  (CORE0_CORE0_AXI_PDMA_OUT_CH2_INT_MAP_V << CORE0_CORE0_AXI_PDMA_OUT_CH2_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_AXI_PDMA_OUT_CH2_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_AXI_PDMA_OUT_CH2_INT_MAP_S  0
/** CORE0_CORE0_AXI_PDMA_OUT_CH2_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_AXI_PDMA_OUT_CH2_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_AXI_PDMA_OUT_CH2_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_AXI_PDMA_OUT_CH2_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_AXI_PDMA_OUT_CH2_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_AXI_PDMA_OUT_CH2_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_AXI_PDMA_OUT_CH2_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_AXI_PDMA_OUT_CH2_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_AXI_PDMA_OUT_CH2_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_AXI_PDMA_OUT_CH2_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_AXI_PDMA_OUT_CH2_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_AXI_PDMA_OUT_CH2_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_AXI_PDMA_OUT_CH2_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_AXI_PDMA_OUT_CH2_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_RSA_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_RSA_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x110)
/** CORE0_CORE0_RSA_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_RSA_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_RSA_INT_MAP_M  (CORE0_CORE0_RSA_INT_MAP_V << CORE0_CORE0_RSA_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_RSA_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_RSA_INT_MAP_S  0
/** CORE0_CORE0_RSA_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_RSA_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_RSA_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_RSA_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_RSA_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_RSA_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_RSA_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_RSA_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_RSA_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_RSA_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_RSA_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_RSA_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_RSA_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_RSA_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_AES_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_AES_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x114)
/** CORE0_CORE0_AES_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_AES_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_AES_INT_MAP_M  (CORE0_CORE0_AES_INT_MAP_V << CORE0_CORE0_AES_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_AES_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_AES_INT_MAP_S  0
/** CORE0_CORE0_AES_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_AES_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_AES_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_AES_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_AES_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_AES_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_AES_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_AES_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_AES_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_AES_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_AES_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_AES_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_AES_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_AES_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_SHA_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_SHA_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x118)
/** CORE0_CORE0_SHA_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_SHA_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_SHA_INT_MAP_M  (CORE0_CORE0_SHA_INT_MAP_V << CORE0_CORE0_SHA_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_SHA_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_SHA_INT_MAP_S  0
/** CORE0_CORE0_SHA_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_SHA_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_SHA_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_SHA_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_SHA_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_SHA_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_SHA_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_SHA_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_SHA_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_SHA_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_SHA_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_SHA_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_SHA_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_SHA_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_ECC_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_ECC_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x11c)
/** CORE0_CORE0_ECC_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_ECC_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_ECC_INT_MAP_M  (CORE0_CORE0_ECC_INT_MAP_V << CORE0_CORE0_ECC_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_ECC_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_ECC_INT_MAP_S  0
/** CORE0_CORE0_ECC_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_ECC_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_ECC_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_ECC_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_ECC_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_ECC_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_ECC_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_ECC_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_ECC_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_ECC_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_ECC_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_ECC_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_ECC_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_ECC_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_ECDSA_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_ECDSA_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x120)
/** CORE0_CORE0_ECDSA_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_ECDSA_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_ECDSA_INT_MAP_M  (CORE0_CORE0_ECDSA_INT_MAP_V << CORE0_CORE0_ECDSA_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_ECDSA_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_ECDSA_INT_MAP_S  0
/** CORE0_CORE0_ECDSA_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_ECDSA_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_ECDSA_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_ECDSA_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_ECDSA_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_ECDSA_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_ECDSA_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_ECDSA_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_ECDSA_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_ECDSA_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_ECDSA_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_ECDSA_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_ECDSA_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_ECDSA_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_KM_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_KM_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x124)
/** CORE0_CORE0_KM_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_KM_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_KM_INT_MAP_M  (CORE0_CORE0_KM_INT_MAP_V << CORE0_CORE0_KM_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_KM_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_KM_INT_MAP_S  0
/** CORE0_CORE0_KM_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_KM_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_KM_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_KM_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_KM_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_KM_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_KM_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_KM_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_KM_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_KM_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_KM_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_KM_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_KM_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_KM_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_GPIO_INT0_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_GPIO_INT0_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x128)
/** CORE0_CORE0_GPIO_INT0_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_GPIO_INT0_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_GPIO_INT0_MAP_M  (CORE0_CORE0_GPIO_INT0_MAP_V << CORE0_CORE0_GPIO_INT0_MAP_S)
#define INTERRUPT_CORE0_CORE0_GPIO_INT0_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_GPIO_INT0_MAP_S  0
/** CORE0_CORE0_GPIO_INT0_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_GPIO_INT0_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_GPIO_INT0_SRC_PASS_IN_SEC_M  (CORE0_CORE0_GPIO_INT0_SRC_PASS_IN_SEC_V << CORE0_CORE0_GPIO_INT0_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_GPIO_INT0_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_GPIO_INT0_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_GPIO_INT0_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_GPIO_INT0_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_GPIO_INT0_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_GPIO_INT0_SRC_IN_SEC_FLAG_V << CORE0_CORE0_GPIO_INT0_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_GPIO_INT0_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_GPIO_INT0_SRC_IN_SEC_FLAG_S  7

/** CORE0_GPIO_INT1_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_GPIO_INT1_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x12c)
/** CORE0_CORE0_GPIO_INT1_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_GPIO_INT1_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_GPIO_INT1_MAP_M  (CORE0_CORE0_GPIO_INT1_MAP_V << CORE0_CORE0_GPIO_INT1_MAP_S)
#define INTERRUPT_CORE0_CORE0_GPIO_INT1_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_GPIO_INT1_MAP_S  0
/** CORE0_CORE0_GPIO_INT1_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_GPIO_INT1_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_GPIO_INT1_SRC_PASS_IN_SEC_M  (CORE0_CORE0_GPIO_INT1_SRC_PASS_IN_SEC_V << CORE0_CORE0_GPIO_INT1_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_GPIO_INT1_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_GPIO_INT1_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_GPIO_INT1_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_GPIO_INT1_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_GPIO_INT1_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_GPIO_INT1_SRC_IN_SEC_FLAG_V << CORE0_CORE0_GPIO_INT1_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_GPIO_INT1_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_GPIO_INT1_SRC_IN_SEC_FLAG_S  7

/** CORE0_GPIO_INT2_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_GPIO_INT2_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x130)
/** CORE0_CORE0_GPIO_INT2_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_GPIO_INT2_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_GPIO_INT2_MAP_M  (CORE0_CORE0_GPIO_INT2_MAP_V << CORE0_CORE0_GPIO_INT2_MAP_S)
#define INTERRUPT_CORE0_CORE0_GPIO_INT2_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_GPIO_INT2_MAP_S  0
/** CORE0_CORE0_GPIO_INT2_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_GPIO_INT2_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_GPIO_INT2_SRC_PASS_IN_SEC_M  (CORE0_CORE0_GPIO_INT2_SRC_PASS_IN_SEC_V << CORE0_CORE0_GPIO_INT2_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_GPIO_INT2_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_GPIO_INT2_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_GPIO_INT2_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_GPIO_INT2_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_GPIO_INT2_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_GPIO_INT2_SRC_IN_SEC_FLAG_V << CORE0_CORE0_GPIO_INT2_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_GPIO_INT2_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_GPIO_INT2_SRC_IN_SEC_FLAG_S  7

/** CORE0_GPIO_INT3_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_GPIO_INT3_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x134)
/** CORE0_CORE0_GPIO_INT3_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_GPIO_INT3_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_GPIO_INT3_MAP_M  (CORE0_CORE0_GPIO_INT3_MAP_V << CORE0_CORE0_GPIO_INT3_MAP_S)
#define INTERRUPT_CORE0_CORE0_GPIO_INT3_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_GPIO_INT3_MAP_S  0
/** CORE0_CORE0_GPIO_INT3_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_GPIO_INT3_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_GPIO_INT3_SRC_PASS_IN_SEC_M  (CORE0_CORE0_GPIO_INT3_SRC_PASS_IN_SEC_V << CORE0_CORE0_GPIO_INT3_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_GPIO_INT3_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_GPIO_INT3_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_GPIO_INT3_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_GPIO_INT3_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_GPIO_INT3_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_GPIO_INT3_SRC_IN_SEC_FLAG_V << CORE0_CORE0_GPIO_INT3_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_GPIO_INT3_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_GPIO_INT3_SRC_IN_SEC_FLAG_S  7

/** CORE0_GPIO_PAD_COMP_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_GPIO_PAD_COMP_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x138)
/** CORE0_CORE0_GPIO_PAD_COMP_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_GPIO_PAD_COMP_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_GPIO_PAD_COMP_INT_MAP_M  (CORE0_CORE0_GPIO_PAD_COMP_INT_MAP_V << CORE0_CORE0_GPIO_PAD_COMP_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_GPIO_PAD_COMP_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_GPIO_PAD_COMP_INT_MAP_S  0
/** CORE0_CORE0_GPIO_PAD_COMP_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_GPIO_PAD_COMP_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_GPIO_PAD_COMP_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_GPIO_PAD_COMP_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_GPIO_PAD_COMP_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_GPIO_PAD_COMP_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_GPIO_PAD_COMP_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_GPIO_PAD_COMP_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_GPIO_PAD_COMP_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_GPIO_PAD_COMP_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_GPIO_PAD_COMP_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_GPIO_PAD_COMP_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_GPIO_PAD_COMP_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_GPIO_PAD_COMP_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_CPU_INT_FROM_CPU_0_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_CPU_INT_FROM_CPU_0_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x13c)
/** CORE0_CORE0_CPU_INT_FROM_CPU_0_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_CPU_INT_FROM_CPU_0_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_CPU_INT_FROM_CPU_0_MAP_M  (CORE0_CORE0_CPU_INT_FROM_CPU_0_MAP_V << CORE0_CORE0_CPU_INT_FROM_CPU_0_MAP_S)
#define INTERRUPT_CORE0_CORE0_CPU_INT_FROM_CPU_0_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_CPU_INT_FROM_CPU_0_MAP_S  0
/** CORE0_CORE0_CPU_INT_FROM_CPU_0_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_CPU_INT_FROM_CPU_0_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_CPU_INT_FROM_CPU_0_SRC_PASS_IN_SEC_M  (CORE0_CORE0_CPU_INT_FROM_CPU_0_SRC_PASS_IN_SEC_V << CORE0_CORE0_CPU_INT_FROM_CPU_0_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_CPU_INT_FROM_CPU_0_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_CPU_INT_FROM_CPU_0_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_CPU_INT_FROM_CPU_0_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_CPU_INT_FROM_CPU_0_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_CPU_INT_FROM_CPU_0_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_CPU_INT_FROM_CPU_0_SRC_IN_SEC_FLAG_V << CORE0_CORE0_CPU_INT_FROM_CPU_0_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_CPU_INT_FROM_CPU_0_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_CPU_INT_FROM_CPU_0_SRC_IN_SEC_FLAG_S  7

/** CORE0_CPU_INT_FROM_CPU_1_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_CPU_INT_FROM_CPU_1_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x140)
/** CORE0_CORE0_CPU_INT_FROM_CPU_1_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_CPU_INT_FROM_CPU_1_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_CPU_INT_FROM_CPU_1_MAP_M  (CORE0_CORE0_CPU_INT_FROM_CPU_1_MAP_V << CORE0_CORE0_CPU_INT_FROM_CPU_1_MAP_S)
#define INTERRUPT_CORE0_CORE0_CPU_INT_FROM_CPU_1_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_CPU_INT_FROM_CPU_1_MAP_S  0
/** CORE0_CORE0_CPU_INT_FROM_CPU_1_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_CPU_INT_FROM_CPU_1_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_CPU_INT_FROM_CPU_1_SRC_PASS_IN_SEC_M  (CORE0_CORE0_CPU_INT_FROM_CPU_1_SRC_PASS_IN_SEC_V << CORE0_CORE0_CPU_INT_FROM_CPU_1_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_CPU_INT_FROM_CPU_1_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_CPU_INT_FROM_CPU_1_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_CPU_INT_FROM_CPU_1_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_CPU_INT_FROM_CPU_1_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_CPU_INT_FROM_CPU_1_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_CPU_INT_FROM_CPU_1_SRC_IN_SEC_FLAG_V << CORE0_CORE0_CPU_INT_FROM_CPU_1_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_CPU_INT_FROM_CPU_1_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_CPU_INT_FROM_CPU_1_SRC_IN_SEC_FLAG_S  7

/** CORE0_CPU_INT_FROM_CPU_2_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_CPU_INT_FROM_CPU_2_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x144)
/** CORE0_CORE0_CPU_INT_FROM_CPU_2_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_CPU_INT_FROM_CPU_2_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_CPU_INT_FROM_CPU_2_MAP_M  (CORE0_CORE0_CPU_INT_FROM_CPU_2_MAP_V << CORE0_CORE0_CPU_INT_FROM_CPU_2_MAP_S)
#define INTERRUPT_CORE0_CORE0_CPU_INT_FROM_CPU_2_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_CPU_INT_FROM_CPU_2_MAP_S  0
/** CORE0_CORE0_CPU_INT_FROM_CPU_2_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_CPU_INT_FROM_CPU_2_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_CPU_INT_FROM_CPU_2_SRC_PASS_IN_SEC_M  (CORE0_CORE0_CPU_INT_FROM_CPU_2_SRC_PASS_IN_SEC_V << CORE0_CORE0_CPU_INT_FROM_CPU_2_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_CPU_INT_FROM_CPU_2_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_CPU_INT_FROM_CPU_2_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_CPU_INT_FROM_CPU_2_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_CPU_INT_FROM_CPU_2_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_CPU_INT_FROM_CPU_2_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_CPU_INT_FROM_CPU_2_SRC_IN_SEC_FLAG_V << CORE0_CORE0_CPU_INT_FROM_CPU_2_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_CPU_INT_FROM_CPU_2_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_CPU_INT_FROM_CPU_2_SRC_IN_SEC_FLAG_S  7

/** CORE0_CPU_INT_FROM_CPU_3_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_CPU_INT_FROM_CPU_3_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x148)
/** CORE0_CORE0_CPU_INT_FROM_CPU_3_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_CPU_INT_FROM_CPU_3_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_CPU_INT_FROM_CPU_3_MAP_M  (CORE0_CORE0_CPU_INT_FROM_CPU_3_MAP_V << CORE0_CORE0_CPU_INT_FROM_CPU_3_MAP_S)
#define INTERRUPT_CORE0_CORE0_CPU_INT_FROM_CPU_3_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_CPU_INT_FROM_CPU_3_MAP_S  0
/** CORE0_CORE0_CPU_INT_FROM_CPU_3_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_CPU_INT_FROM_CPU_3_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_CPU_INT_FROM_CPU_3_SRC_PASS_IN_SEC_M  (CORE0_CORE0_CPU_INT_FROM_CPU_3_SRC_PASS_IN_SEC_V << CORE0_CORE0_CPU_INT_FROM_CPU_3_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_CPU_INT_FROM_CPU_3_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_CPU_INT_FROM_CPU_3_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_CPU_INT_FROM_CPU_3_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_CPU_INT_FROM_CPU_3_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_CPU_INT_FROM_CPU_3_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_CPU_INT_FROM_CPU_3_SRC_IN_SEC_FLAG_V << CORE0_CORE0_CPU_INT_FROM_CPU_3_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_CPU_INT_FROM_CPU_3_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_CPU_INT_FROM_CPU_3_SRC_IN_SEC_FLAG_S  7

/** CORE0_CACHE_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_CACHE_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x14c)
/** CORE0_CORE0_CACHE_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_CACHE_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_CACHE_INT_MAP_M  (CORE0_CORE0_CACHE_INT_MAP_V << CORE0_CORE0_CACHE_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_CACHE_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_CACHE_INT_MAP_S  0
/** CORE0_CORE0_CACHE_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_CACHE_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_CACHE_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_CACHE_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_CACHE_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_CACHE_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_CACHE_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_CACHE_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_CACHE_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_CACHE_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_CACHE_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_CACHE_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_CACHE_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_CACHE_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_FLASH_MSPI_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_FLASH_MSPI_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x150)
/** CORE0_CORE0_FLASH_MSPI_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_FLASH_MSPI_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_FLASH_MSPI_INT_MAP_M  (CORE0_CORE0_FLASH_MSPI_INT_MAP_V << CORE0_CORE0_FLASH_MSPI_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_FLASH_MSPI_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_FLASH_MSPI_INT_MAP_S  0
/** CORE0_CORE0_FLASH_MSPI_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_FLASH_MSPI_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_FLASH_MSPI_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_FLASH_MSPI_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_FLASH_MSPI_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_FLASH_MSPI_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_FLASH_MSPI_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_FLASH_MSPI_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_FLASH_MSPI_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_FLASH_MSPI_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_FLASH_MSPI_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_FLASH_MSPI_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_FLASH_MSPI_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_FLASH_MSPI_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_CSI_BRIDGE_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_CSI_BRIDGE_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x154)
/** CORE0_CORE0_CSI_BRIDGE_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_CSI_BRIDGE_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_CSI_BRIDGE_INT_MAP_M  (CORE0_CORE0_CSI_BRIDGE_INT_MAP_V << CORE0_CORE0_CSI_BRIDGE_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_CSI_BRIDGE_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_CSI_BRIDGE_INT_MAP_S  0
/** CORE0_CORE0_CSI_BRIDGE_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_CSI_BRIDGE_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_CSI_BRIDGE_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_CSI_BRIDGE_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_CSI_BRIDGE_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_CSI_BRIDGE_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_CSI_BRIDGE_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_CSI_BRIDGE_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_CSI_BRIDGE_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_CSI_BRIDGE_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_CSI_BRIDGE_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_CSI_BRIDGE_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_CSI_BRIDGE_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_CSI_BRIDGE_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_DSI_BRIDGE_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_DSI_BRIDGE_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x158)
/** CORE0_CORE0_DSI_BRIDGE_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_DSI_BRIDGE_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_DSI_BRIDGE_INT_MAP_M  (CORE0_CORE0_DSI_BRIDGE_INT_MAP_V << CORE0_CORE0_DSI_BRIDGE_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_DSI_BRIDGE_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_DSI_BRIDGE_INT_MAP_S  0
/** CORE0_CORE0_DSI_BRIDGE_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_DSI_BRIDGE_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_DSI_BRIDGE_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_DSI_BRIDGE_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_DSI_BRIDGE_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_DSI_BRIDGE_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_DSI_BRIDGE_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_DSI_BRIDGE_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_DSI_BRIDGE_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_DSI_BRIDGE_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_DSI_BRIDGE_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_DSI_BRIDGE_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_DSI_BRIDGE_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_DSI_BRIDGE_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_CSI_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_CSI_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x15c)
/** CORE0_CORE0_CSI_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_CSI_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_CSI_INT_MAP_M  (CORE0_CORE0_CSI_INT_MAP_V << CORE0_CORE0_CSI_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_CSI_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_CSI_INT_MAP_S  0
/** CORE0_CORE0_CSI_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_CSI_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_CSI_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_CSI_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_CSI_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_CSI_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_CSI_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_CSI_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_CSI_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_CSI_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_CSI_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_CSI_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_CSI_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_CSI_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_DSI_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_DSI_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x160)
/** CORE0_CORE0_DSI_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_DSI_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_DSI_INT_MAP_M  (CORE0_CORE0_DSI_INT_MAP_V << CORE0_CORE0_DSI_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_DSI_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_DSI_INT_MAP_S  0
/** CORE0_CORE0_DSI_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_DSI_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_DSI_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_DSI_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_DSI_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_DSI_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_DSI_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_DSI_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_DSI_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_DSI_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_DSI_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_DSI_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_DSI_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_DSI_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_GMII_PHY_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_GMII_PHY_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x164)
/** CORE0_CORE0_GMII_PHY_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_GMII_PHY_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_GMII_PHY_INT_MAP_M  (CORE0_CORE0_GMII_PHY_INT_MAP_V << CORE0_CORE0_GMII_PHY_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_GMII_PHY_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_GMII_PHY_INT_MAP_S  0
/** CORE0_CORE0_GMII_PHY_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_GMII_PHY_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_GMII_PHY_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_GMII_PHY_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_GMII_PHY_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_GMII_PHY_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_GMII_PHY_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_GMII_PHY_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_GMII_PHY_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_GMII_PHY_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_GMII_PHY_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_GMII_PHY_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_GMII_PHY_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_GMII_PHY_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_LPI_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_LPI_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x168)
/** CORE0_CORE0_LPI_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_LPI_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_LPI_INT_MAP_M  (CORE0_CORE0_LPI_INT_MAP_V << CORE0_CORE0_LPI_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_LPI_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_LPI_INT_MAP_S  0
/** CORE0_CORE0_LPI_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_LPI_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_LPI_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_LPI_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_LPI_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_LPI_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_LPI_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_LPI_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_LPI_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_LPI_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_LPI_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_LPI_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_LPI_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_LPI_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_PMT_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_PMT_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x16c)
/** CORE0_CORE0_PMT_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_PMT_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_PMT_INT_MAP_M  (CORE0_CORE0_PMT_INT_MAP_V << CORE0_CORE0_PMT_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_PMT_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_PMT_INT_MAP_S  0
/** CORE0_CORE0_PMT_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_PMT_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_PMT_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_PMT_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_PMT_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_PMT_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_PMT_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_PMT_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_PMT_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_PMT_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_PMT_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_PMT_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_PMT_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_PMT_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_SBD_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_SBD_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x170)
/** CORE0_CORE0_SBD_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_SBD_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_SBD_INT_MAP_M  (CORE0_CORE0_SBD_INT_MAP_V << CORE0_CORE0_SBD_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_SBD_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_SBD_INT_MAP_S  0
/** CORE0_CORE0_SBD_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_SBD_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_SBD_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_SBD_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_SBD_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_SBD_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_SBD_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_SBD_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_SBD_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_SBD_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_SBD_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_SBD_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_SBD_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_SBD_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_USB_OTG_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_USB_OTG_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x174)
/** CORE0_CORE0_USB_OTG_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_USB_OTG_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_USB_OTG_INT_MAP_M  (CORE0_CORE0_USB_OTG_INT_MAP_V << CORE0_CORE0_USB_OTG_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_USB_OTG_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_USB_OTG_INT_MAP_S  0
/** CORE0_CORE0_USB_OTG_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_USB_OTG_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_USB_OTG_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_USB_OTG_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_USB_OTG_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_USB_OTG_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_USB_OTG_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_USB_OTG_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_USB_OTG_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_USB_OTG_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_USB_OTG_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_USB_OTG_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_USB_OTG_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_USB_OTG_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_USB_OTG_ENDP_MULTI_PROC_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_USB_OTG_ENDP_MULTI_PROC_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x178)
/** CORE0_CORE0_USB_OTG_ENDP_MULTI_PROC_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_USB_OTG_ENDP_MULTI_PROC_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_USB_OTG_ENDP_MULTI_PROC_INT_MAP_M  (CORE0_CORE0_USB_OTG_ENDP_MULTI_PROC_INT_MAP_V << CORE0_CORE0_USB_OTG_ENDP_MULTI_PROC_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_USB_OTG_ENDP_MULTI_PROC_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_USB_OTG_ENDP_MULTI_PROC_INT_MAP_S  0
/** CORE0_CORE0_USB_OTG_ENDP_MULTI_PROC_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6];
 *  default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_USB_OTG_ENDP_MULTI_PROC_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_USB_OTG_ENDP_MULTI_PROC_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_USB_OTG_ENDP_MULTI_PROC_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_USB_OTG_ENDP_MULTI_PROC_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_USB_OTG_ENDP_MULTI_PROC_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_USB_OTG_ENDP_MULTI_PROC_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_USB_OTG_ENDP_MULTI_PROC_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7];
 *  default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_USB_OTG_ENDP_MULTI_PROC_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_USB_OTG_ENDP_MULTI_PROC_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_USB_OTG_ENDP_MULTI_PROC_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_USB_OTG_ENDP_MULTI_PROC_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_USB_OTG_ENDP_MULTI_PROC_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_USB_OTG_ENDP_MULTI_PROC_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_JPEG_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_JPEG_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x17c)
/** CORE0_CORE0_JPEG_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_JPEG_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_JPEG_INT_MAP_M  (CORE0_CORE0_JPEG_INT_MAP_V << CORE0_CORE0_JPEG_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_JPEG_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_JPEG_INT_MAP_S  0
/** CORE0_CORE0_JPEG_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_JPEG_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_JPEG_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_JPEG_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_JPEG_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_JPEG_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_JPEG_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_JPEG_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_JPEG_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_JPEG_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_JPEG_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_JPEG_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_JPEG_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_JPEG_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_PPA_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_PPA_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x180)
/** CORE0_CORE0_PPA_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_PPA_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_PPA_INT_MAP_M  (CORE0_CORE0_PPA_INT_MAP_V << CORE0_CORE0_PPA_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_PPA_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_PPA_INT_MAP_S  0
/** CORE0_CORE0_PPA_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_PPA_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_PPA_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_PPA_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_PPA_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_PPA_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_PPA_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_PPA_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_PPA_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_PPA_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_PPA_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_PPA_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_PPA_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_PPA_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_CORE0_TRACE_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_TRACE_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x184)
/** CORE0_CORE0_CORE0_TRACE_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_CORE0_TRACE_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_CORE0_TRACE_INT_MAP_M  (CORE0_CORE0_CORE0_TRACE_INT_MAP_V << CORE0_CORE0_CORE0_TRACE_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_CORE0_TRACE_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_CORE0_TRACE_INT_MAP_S  0
/** CORE0_CORE0_CORE0_TRACE_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_CORE0_TRACE_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_CORE0_TRACE_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_CORE0_TRACE_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_CORE0_TRACE_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_CORE0_TRACE_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_CORE0_TRACE_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_CORE0_TRACE_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_CORE0_TRACE_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_CORE0_TRACE_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_CORE0_TRACE_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_CORE0_TRACE_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_CORE0_TRACE_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_CORE0_TRACE_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_CORE1_TRACE_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_CORE1_TRACE_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x188)
/** CORE0_CORE0_CORE1_TRACE_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_CORE1_TRACE_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_CORE1_TRACE_INT_MAP_M  (CORE0_CORE0_CORE1_TRACE_INT_MAP_V << CORE0_CORE0_CORE1_TRACE_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_CORE1_TRACE_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_CORE1_TRACE_INT_MAP_S  0
/** CORE0_CORE0_CORE1_TRACE_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_CORE1_TRACE_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_CORE1_TRACE_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_CORE1_TRACE_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_CORE1_TRACE_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_CORE1_TRACE_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_CORE1_TRACE_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_CORE1_TRACE_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_CORE1_TRACE_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_CORE1_TRACE_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_CORE1_TRACE_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_CORE1_TRACE_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_CORE1_TRACE_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_CORE1_TRACE_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_HP_CORE_CTRL_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_HP_CORE_CTRL_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x18c)
/** CORE0_CORE0_HP_CORE_CTRL_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_HP_CORE_CTRL_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_HP_CORE_CTRL_INT_MAP_M  (CORE0_CORE0_HP_CORE_CTRL_INT_MAP_V << CORE0_CORE0_HP_CORE_CTRL_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_HP_CORE_CTRL_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_HP_CORE_CTRL_INT_MAP_S  0
/** CORE0_CORE0_HP_CORE_CTRL_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_HP_CORE_CTRL_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_HP_CORE_CTRL_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_HP_CORE_CTRL_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_HP_CORE_CTRL_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_HP_CORE_CTRL_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_HP_CORE_CTRL_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_HP_CORE_CTRL_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_HP_CORE_CTRL_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_HP_CORE_CTRL_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_HP_CORE_CTRL_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_HP_CORE_CTRL_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_HP_CORE_CTRL_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_HP_CORE_CTRL_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_ISP_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_ISP_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x190)
/** CORE0_CORE0_ISP_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_ISP_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_ISP_INT_MAP_M  (CORE0_CORE0_ISP_INT_MAP_V << CORE0_CORE0_ISP_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_ISP_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_ISP_INT_MAP_S  0
/** CORE0_CORE0_ISP_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_ISP_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_ISP_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_ISP_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_ISP_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_ISP_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_ISP_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_ISP_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_ISP_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_ISP_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_ISP_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_ISP_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_ISP_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_ISP_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_I3C_MST_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_I3C_MST_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x194)
/** CORE0_CORE0_I3C_MST_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_I3C_MST_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_I3C_MST_INT_MAP_M  (CORE0_CORE0_I3C_MST_INT_MAP_V << CORE0_CORE0_I3C_MST_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_I3C_MST_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_I3C_MST_INT_MAP_S  0
/** CORE0_CORE0_I3C_MST_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_I3C_MST_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_I3C_MST_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_I3C_MST_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_I3C_MST_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_I3C_MST_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_I3C_MST_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_I3C_MST_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_I3C_MST_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_I3C_MST_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_I3C_MST_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_I3C_MST_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_I3C_MST_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_I3C_MST_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_I3C_SLV_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_I3C_SLV_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x198)
/** CORE0_CORE0_I3C_SLV_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_I3C_SLV_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_I3C_SLV_INT_MAP_M  (CORE0_CORE0_I3C_SLV_INT_MAP_V << CORE0_CORE0_I3C_SLV_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_I3C_SLV_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_I3C_SLV_INT_MAP_S  0
/** CORE0_CORE0_I3C_SLV_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_I3C_SLV_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_I3C_SLV_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_I3C_SLV_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_I3C_SLV_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_I3C_SLV_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_I3C_SLV_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_I3C_SLV_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_I3C_SLV_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_I3C_SLV_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_I3C_SLV_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_I3C_SLV_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_I3C_SLV_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_I3C_SLV_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_USB_OTG11_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_USB_OTG11_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x19c)
/** CORE0_CORE0_USB_OTG11_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_USB_OTG11_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_USB_OTG11_INT_MAP_M  (CORE0_CORE0_USB_OTG11_INT_MAP_V << CORE0_CORE0_USB_OTG11_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_USB_OTG11_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_USB_OTG11_INT_MAP_S  0
/** CORE0_CORE0_USB_OTG11_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_USB_OTG11_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_USB_OTG11_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_USB_OTG11_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_USB_OTG11_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_USB_OTG11_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_USB_OTG11_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_USB_OTG11_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_USB_OTG11_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_USB_OTG11_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_USB_OTG11_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_USB_OTG11_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_USB_OTG11_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_USB_OTG11_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_DMA2D_IN_CH0_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_DMA2D_IN_CH0_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x1a0)
/** CORE0_CORE0_DMA2D_IN_CH0_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_DMA2D_IN_CH0_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_DMA2D_IN_CH0_INT_MAP_M  (CORE0_CORE0_DMA2D_IN_CH0_INT_MAP_V << CORE0_CORE0_DMA2D_IN_CH0_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_DMA2D_IN_CH0_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_DMA2D_IN_CH0_INT_MAP_S  0
/** CORE0_CORE0_DMA2D_IN_CH0_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_DMA2D_IN_CH0_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_DMA2D_IN_CH0_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_DMA2D_IN_CH0_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_DMA2D_IN_CH0_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_DMA2D_IN_CH0_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_DMA2D_IN_CH0_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_DMA2D_IN_CH0_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_DMA2D_IN_CH0_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_DMA2D_IN_CH0_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_DMA2D_IN_CH0_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_DMA2D_IN_CH0_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_DMA2D_IN_CH0_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_DMA2D_IN_CH0_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_DMA2D_IN_CH1_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_DMA2D_IN_CH1_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x1a4)
/** CORE0_CORE0_DMA2D_IN_CH1_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_DMA2D_IN_CH1_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_DMA2D_IN_CH1_INT_MAP_M  (CORE0_CORE0_DMA2D_IN_CH1_INT_MAP_V << CORE0_CORE0_DMA2D_IN_CH1_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_DMA2D_IN_CH1_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_DMA2D_IN_CH1_INT_MAP_S  0
/** CORE0_CORE0_DMA2D_IN_CH1_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_DMA2D_IN_CH1_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_DMA2D_IN_CH1_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_DMA2D_IN_CH1_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_DMA2D_IN_CH1_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_DMA2D_IN_CH1_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_DMA2D_IN_CH1_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_DMA2D_IN_CH1_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_DMA2D_IN_CH1_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_DMA2D_IN_CH1_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_DMA2D_IN_CH1_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_DMA2D_IN_CH1_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_DMA2D_IN_CH1_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_DMA2D_IN_CH1_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_DMA2D_OUT_CH0_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_DMA2D_OUT_CH0_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x1a8)
/** CORE0_CORE0_DMA2D_OUT_CH0_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_DMA2D_OUT_CH0_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_DMA2D_OUT_CH0_INT_MAP_M  (CORE0_CORE0_DMA2D_OUT_CH0_INT_MAP_V << CORE0_CORE0_DMA2D_OUT_CH0_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_DMA2D_OUT_CH0_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_DMA2D_OUT_CH0_INT_MAP_S  0
/** CORE0_CORE0_DMA2D_OUT_CH0_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_DMA2D_OUT_CH0_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_DMA2D_OUT_CH0_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_DMA2D_OUT_CH0_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_DMA2D_OUT_CH0_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_DMA2D_OUT_CH0_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_DMA2D_OUT_CH0_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_DMA2D_OUT_CH0_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_DMA2D_OUT_CH0_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_DMA2D_OUT_CH0_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_DMA2D_OUT_CH0_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_DMA2D_OUT_CH0_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_DMA2D_OUT_CH0_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_DMA2D_OUT_CH0_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_DMA2D_OUT_CH1_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_DMA2D_OUT_CH1_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x1ac)
/** CORE0_CORE0_DMA2D_OUT_CH1_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_DMA2D_OUT_CH1_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_DMA2D_OUT_CH1_INT_MAP_M  (CORE0_CORE0_DMA2D_OUT_CH1_INT_MAP_V << CORE0_CORE0_DMA2D_OUT_CH1_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_DMA2D_OUT_CH1_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_DMA2D_OUT_CH1_INT_MAP_S  0
/** CORE0_CORE0_DMA2D_OUT_CH1_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_DMA2D_OUT_CH1_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_DMA2D_OUT_CH1_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_DMA2D_OUT_CH1_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_DMA2D_OUT_CH1_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_DMA2D_OUT_CH1_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_DMA2D_OUT_CH1_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_DMA2D_OUT_CH1_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_DMA2D_OUT_CH1_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_DMA2D_OUT_CH1_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_DMA2D_OUT_CH1_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_DMA2D_OUT_CH1_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_DMA2D_OUT_CH1_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_DMA2D_OUT_CH1_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_DMA2D_OUT_CH2_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_DMA2D_OUT_CH2_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x1b0)
/** CORE0_CORE0_DMA2D_OUT_CH2_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_DMA2D_OUT_CH2_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_DMA2D_OUT_CH2_INT_MAP_M  (CORE0_CORE0_DMA2D_OUT_CH2_INT_MAP_V << CORE0_CORE0_DMA2D_OUT_CH2_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_DMA2D_OUT_CH2_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_DMA2D_OUT_CH2_INT_MAP_S  0
/** CORE0_CORE0_DMA2D_OUT_CH2_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_DMA2D_OUT_CH2_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_DMA2D_OUT_CH2_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_DMA2D_OUT_CH2_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_DMA2D_OUT_CH2_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_DMA2D_OUT_CH2_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_DMA2D_OUT_CH2_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_DMA2D_OUT_CH2_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_DMA2D_OUT_CH2_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_DMA2D_OUT_CH2_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_DMA2D_OUT_CH2_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_DMA2D_OUT_CH2_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_DMA2D_OUT_CH2_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_DMA2D_OUT_CH2_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_PSRAM_MSPI_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_PSRAM_MSPI_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x1b4)
/** CORE0_CORE0_PSRAM_MSPI_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_PSRAM_MSPI_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_PSRAM_MSPI_INT_MAP_M  (CORE0_CORE0_PSRAM_MSPI_INT_MAP_V << CORE0_CORE0_PSRAM_MSPI_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_PSRAM_MSPI_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_PSRAM_MSPI_INT_MAP_S  0
/** CORE0_CORE0_PSRAM_MSPI_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_PSRAM_MSPI_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_PSRAM_MSPI_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_PSRAM_MSPI_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_PSRAM_MSPI_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_PSRAM_MSPI_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_PSRAM_MSPI_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_PSRAM_MSPI_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_PSRAM_MSPI_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_PSRAM_MSPI_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_PSRAM_MSPI_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_PSRAM_MSPI_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_PSRAM_MSPI_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_PSRAM_MSPI_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_HP_SYSREG_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_HP_SYSREG_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x1b8)
/** CORE0_CORE0_HP_SYSREG_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_HP_SYSREG_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_HP_SYSREG_INT_MAP_M  (CORE0_CORE0_HP_SYSREG_INT_MAP_V << CORE0_CORE0_HP_SYSREG_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_HP_SYSREG_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_HP_SYSREG_INT_MAP_S  0
/** CORE0_CORE0_HP_SYSREG_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_HP_SYSREG_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_HP_SYSREG_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_HP_SYSREG_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_HP_SYSREG_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_HP_SYSREG_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_HP_SYSREG_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_HP_SYSREG_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_HP_SYSREG_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_HP_SYSREG_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_HP_SYSREG_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_HP_SYSREG_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_HP_SYSREG_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_HP_SYSREG_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_PCNT_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_PCNT_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x1bc)
/** CORE0_CORE0_PCNT_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_PCNT_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_PCNT_INT_MAP_M  (CORE0_CORE0_PCNT_INT_MAP_V << CORE0_CORE0_PCNT_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_PCNT_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_PCNT_INT_MAP_S  0
/** CORE0_CORE0_PCNT_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_PCNT_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_PCNT_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_PCNT_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_PCNT_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_PCNT_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_PCNT_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_PCNT_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_PCNT_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_PCNT_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_PCNT_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_PCNT_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_PCNT_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_PCNT_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_HP_PAU_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_HP_PAU_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x1c0)
/** CORE0_CORE0_HP_PAU_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_HP_PAU_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_HP_PAU_INT_MAP_M  (CORE0_CORE0_HP_PAU_INT_MAP_V << CORE0_CORE0_HP_PAU_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_HP_PAU_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_HP_PAU_INT_MAP_S  0
/** CORE0_CORE0_HP_PAU_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_HP_PAU_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_HP_PAU_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_HP_PAU_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_HP_PAU_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_HP_PAU_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_HP_PAU_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_HP_PAU_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_HP_PAU_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_HP_PAU_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_HP_PAU_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_HP_PAU_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_HP_PAU_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_HP_PAU_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_HP_PARLIO_RX_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_HP_PARLIO_RX_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x1c4)
/** CORE0_CORE0_HP_PARLIO_RX_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_HP_PARLIO_RX_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_HP_PARLIO_RX_INT_MAP_M  (CORE0_CORE0_HP_PARLIO_RX_INT_MAP_V << CORE0_CORE0_HP_PARLIO_RX_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_HP_PARLIO_RX_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_HP_PARLIO_RX_INT_MAP_S  0
/** CORE0_CORE0_HP_PARLIO_RX_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_HP_PARLIO_RX_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_HP_PARLIO_RX_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_HP_PARLIO_RX_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_HP_PARLIO_RX_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_HP_PARLIO_RX_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_HP_PARLIO_RX_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_HP_PARLIO_RX_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_HP_PARLIO_RX_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_HP_PARLIO_RX_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_HP_PARLIO_RX_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_HP_PARLIO_RX_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_HP_PARLIO_RX_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_HP_PARLIO_RX_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_HP_PARLIO_TX_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_HP_PARLIO_TX_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x1c8)
/** CORE0_CORE0_HP_PARLIO_TX_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_HP_PARLIO_TX_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_HP_PARLIO_TX_INT_MAP_M  (CORE0_CORE0_HP_PARLIO_TX_INT_MAP_V << CORE0_CORE0_HP_PARLIO_TX_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_HP_PARLIO_TX_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_HP_PARLIO_TX_INT_MAP_S  0
/** CORE0_CORE0_HP_PARLIO_TX_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_HP_PARLIO_TX_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_HP_PARLIO_TX_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_HP_PARLIO_TX_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_HP_PARLIO_TX_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_HP_PARLIO_TX_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_HP_PARLIO_TX_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_HP_PARLIO_TX_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_HP_PARLIO_TX_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_HP_PARLIO_TX_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_HP_PARLIO_TX_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_HP_PARLIO_TX_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_HP_PARLIO_TX_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_HP_PARLIO_TX_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_H264_DMA2D_OUT_CH0_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_H264_DMA2D_OUT_CH0_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x1cc)
/** CORE0_CORE0_H264_DMA2D_OUT_CH0_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_OUT_CH0_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_OUT_CH0_INT_MAP_M  (CORE0_CORE0_H264_DMA2D_OUT_CH0_INT_MAP_V << CORE0_CORE0_H264_DMA2D_OUT_CH0_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_OUT_CH0_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_OUT_CH0_INT_MAP_S  0
/** CORE0_CORE0_H264_DMA2D_OUT_CH0_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_OUT_CH0_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_OUT_CH0_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_H264_DMA2D_OUT_CH0_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_H264_DMA2D_OUT_CH0_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_OUT_CH0_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_OUT_CH0_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_H264_DMA2D_OUT_CH0_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_OUT_CH0_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_OUT_CH0_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_H264_DMA2D_OUT_CH0_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_H264_DMA2D_OUT_CH0_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_OUT_CH0_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_OUT_CH0_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_H264_DMA2D_OUT_CH1_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_H264_DMA2D_OUT_CH1_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x1d0)
/** CORE0_CORE0_H264_DMA2D_OUT_CH1_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_OUT_CH1_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_OUT_CH1_INT_MAP_M  (CORE0_CORE0_H264_DMA2D_OUT_CH1_INT_MAP_V << CORE0_CORE0_H264_DMA2D_OUT_CH1_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_OUT_CH1_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_OUT_CH1_INT_MAP_S  0
/** CORE0_CORE0_H264_DMA2D_OUT_CH1_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_OUT_CH1_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_OUT_CH1_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_H264_DMA2D_OUT_CH1_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_H264_DMA2D_OUT_CH1_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_OUT_CH1_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_OUT_CH1_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_H264_DMA2D_OUT_CH1_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_OUT_CH1_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_OUT_CH1_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_H264_DMA2D_OUT_CH1_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_H264_DMA2D_OUT_CH1_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_OUT_CH1_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_OUT_CH1_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_H264_DMA2D_OUT_CH2_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_H264_DMA2D_OUT_CH2_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x1d4)
/** CORE0_CORE0_H264_DMA2D_OUT_CH2_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_OUT_CH2_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_OUT_CH2_INT_MAP_M  (CORE0_CORE0_H264_DMA2D_OUT_CH2_INT_MAP_V << CORE0_CORE0_H264_DMA2D_OUT_CH2_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_OUT_CH2_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_OUT_CH2_INT_MAP_S  0
/** CORE0_CORE0_H264_DMA2D_OUT_CH2_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_OUT_CH2_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_OUT_CH2_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_H264_DMA2D_OUT_CH2_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_H264_DMA2D_OUT_CH2_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_OUT_CH2_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_OUT_CH2_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_H264_DMA2D_OUT_CH2_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_OUT_CH2_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_OUT_CH2_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_H264_DMA2D_OUT_CH2_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_H264_DMA2D_OUT_CH2_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_OUT_CH2_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_OUT_CH2_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_H264_DMA2D_OUT_CH3_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_H264_DMA2D_OUT_CH3_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x1d8)
/** CORE0_CORE0_H264_DMA2D_OUT_CH3_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_OUT_CH3_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_OUT_CH3_INT_MAP_M  (CORE0_CORE0_H264_DMA2D_OUT_CH3_INT_MAP_V << CORE0_CORE0_H264_DMA2D_OUT_CH3_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_OUT_CH3_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_OUT_CH3_INT_MAP_S  0
/** CORE0_CORE0_H264_DMA2D_OUT_CH3_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_OUT_CH3_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_OUT_CH3_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_H264_DMA2D_OUT_CH3_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_H264_DMA2D_OUT_CH3_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_OUT_CH3_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_OUT_CH3_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_H264_DMA2D_OUT_CH3_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_OUT_CH3_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_OUT_CH3_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_H264_DMA2D_OUT_CH3_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_H264_DMA2D_OUT_CH3_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_OUT_CH3_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_OUT_CH3_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_H264_DMA2D_OUT_CH4_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_H264_DMA2D_OUT_CH4_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x1dc)
/** CORE0_CORE0_H264_DMA2D_OUT_CH4_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_OUT_CH4_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_OUT_CH4_INT_MAP_M  (CORE0_CORE0_H264_DMA2D_OUT_CH4_INT_MAP_V << CORE0_CORE0_H264_DMA2D_OUT_CH4_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_OUT_CH4_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_OUT_CH4_INT_MAP_S  0
/** CORE0_CORE0_H264_DMA2D_OUT_CH4_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_OUT_CH4_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_OUT_CH4_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_H264_DMA2D_OUT_CH4_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_H264_DMA2D_OUT_CH4_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_OUT_CH4_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_OUT_CH4_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_H264_DMA2D_OUT_CH4_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_OUT_CH4_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_OUT_CH4_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_H264_DMA2D_OUT_CH4_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_H264_DMA2D_OUT_CH4_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_OUT_CH4_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_OUT_CH4_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_H264_DMA2D_IN_CH0_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_H264_DMA2D_IN_CH0_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x1e0)
/** CORE0_CORE0_H264_DMA2D_IN_CH0_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_IN_CH0_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_IN_CH0_INT_MAP_M  (CORE0_CORE0_H264_DMA2D_IN_CH0_INT_MAP_V << CORE0_CORE0_H264_DMA2D_IN_CH0_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_IN_CH0_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_IN_CH0_INT_MAP_S  0
/** CORE0_CORE0_H264_DMA2D_IN_CH0_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_IN_CH0_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_IN_CH0_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_H264_DMA2D_IN_CH0_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_H264_DMA2D_IN_CH0_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_IN_CH0_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_IN_CH0_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_H264_DMA2D_IN_CH0_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_IN_CH0_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_IN_CH0_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_H264_DMA2D_IN_CH0_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_H264_DMA2D_IN_CH0_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_IN_CH0_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_IN_CH0_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_H264_DMA2D_IN_CH1_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_H264_DMA2D_IN_CH1_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x1e4)
/** CORE0_CORE0_H264_DMA2D_IN_CH1_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_IN_CH1_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_IN_CH1_INT_MAP_M  (CORE0_CORE0_H264_DMA2D_IN_CH1_INT_MAP_V << CORE0_CORE0_H264_DMA2D_IN_CH1_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_IN_CH1_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_IN_CH1_INT_MAP_S  0
/** CORE0_CORE0_H264_DMA2D_IN_CH1_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_IN_CH1_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_IN_CH1_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_H264_DMA2D_IN_CH1_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_H264_DMA2D_IN_CH1_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_IN_CH1_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_IN_CH1_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_H264_DMA2D_IN_CH1_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_IN_CH1_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_IN_CH1_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_H264_DMA2D_IN_CH1_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_H264_DMA2D_IN_CH1_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_IN_CH1_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_IN_CH1_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_H264_DMA2D_IN_CH2_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_H264_DMA2D_IN_CH2_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x1e8)
/** CORE0_CORE0_H264_DMA2D_IN_CH2_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_IN_CH2_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_IN_CH2_INT_MAP_M  (CORE0_CORE0_H264_DMA2D_IN_CH2_INT_MAP_V << CORE0_CORE0_H264_DMA2D_IN_CH2_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_IN_CH2_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_IN_CH2_INT_MAP_S  0
/** CORE0_CORE0_H264_DMA2D_IN_CH2_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_IN_CH2_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_IN_CH2_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_H264_DMA2D_IN_CH2_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_H264_DMA2D_IN_CH2_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_IN_CH2_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_IN_CH2_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_H264_DMA2D_IN_CH2_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_IN_CH2_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_IN_CH2_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_H264_DMA2D_IN_CH2_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_H264_DMA2D_IN_CH2_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_IN_CH2_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_IN_CH2_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_H264_DMA2D_IN_CH3_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_H264_DMA2D_IN_CH3_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x1ec)
/** CORE0_CORE0_H264_DMA2D_IN_CH3_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_IN_CH3_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_IN_CH3_INT_MAP_M  (CORE0_CORE0_H264_DMA2D_IN_CH3_INT_MAP_V << CORE0_CORE0_H264_DMA2D_IN_CH3_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_IN_CH3_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_IN_CH3_INT_MAP_S  0
/** CORE0_CORE0_H264_DMA2D_IN_CH3_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_IN_CH3_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_IN_CH3_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_H264_DMA2D_IN_CH3_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_H264_DMA2D_IN_CH3_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_IN_CH3_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_IN_CH3_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_H264_DMA2D_IN_CH3_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_IN_CH3_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_IN_CH3_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_H264_DMA2D_IN_CH3_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_H264_DMA2D_IN_CH3_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_IN_CH3_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_IN_CH3_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_H264_DMA2D_IN_CH4_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_H264_DMA2D_IN_CH4_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x1f0)
/** CORE0_CORE0_H264_DMA2D_IN_CH4_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_IN_CH4_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_IN_CH4_INT_MAP_M  (CORE0_CORE0_H264_DMA2D_IN_CH4_INT_MAP_V << CORE0_CORE0_H264_DMA2D_IN_CH4_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_IN_CH4_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_IN_CH4_INT_MAP_S  0
/** CORE0_CORE0_H264_DMA2D_IN_CH4_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_IN_CH4_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_IN_CH4_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_H264_DMA2D_IN_CH4_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_H264_DMA2D_IN_CH4_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_IN_CH4_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_IN_CH4_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_H264_DMA2D_IN_CH4_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_IN_CH4_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_IN_CH4_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_H264_DMA2D_IN_CH4_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_H264_DMA2D_IN_CH4_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_IN_CH4_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_IN_CH4_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_H264_DMA2D_IN_CH5_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_H264_DMA2D_IN_CH5_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x1f4)
/** CORE0_CORE0_H264_DMA2D_IN_CH5_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_IN_CH5_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_IN_CH5_INT_MAP_M  (CORE0_CORE0_H264_DMA2D_IN_CH5_INT_MAP_V << CORE0_CORE0_H264_DMA2D_IN_CH5_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_IN_CH5_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_IN_CH5_INT_MAP_S  0
/** CORE0_CORE0_H264_DMA2D_IN_CH5_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_IN_CH5_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_IN_CH5_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_H264_DMA2D_IN_CH5_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_H264_DMA2D_IN_CH5_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_IN_CH5_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_IN_CH5_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_H264_DMA2D_IN_CH5_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_IN_CH5_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_IN_CH5_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_H264_DMA2D_IN_CH5_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_H264_DMA2D_IN_CH5_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_IN_CH5_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_H264_DMA2D_IN_CH5_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_H264_REG_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_H264_REG_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x1f8)
/** CORE0_CORE0_H264_REG_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_H264_REG_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_H264_REG_INT_MAP_M  (CORE0_CORE0_H264_REG_INT_MAP_V << CORE0_CORE0_H264_REG_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_H264_REG_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_H264_REG_INT_MAP_S  0
/** CORE0_CORE0_H264_REG_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_H264_REG_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_H264_REG_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_H264_REG_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_H264_REG_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_H264_REG_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_H264_REG_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_H264_REG_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_H264_REG_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_H264_REG_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_H264_REG_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_H264_REG_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_H264_REG_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_H264_REG_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_ASSIST_DEBUG_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_ASSIST_DEBUG_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x1fc)
/** CORE0_CORE0_ASSIST_DEBUG_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_ASSIST_DEBUG_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_ASSIST_DEBUG_INT_MAP_M  (CORE0_CORE0_ASSIST_DEBUG_INT_MAP_V << CORE0_CORE0_ASSIST_DEBUG_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_ASSIST_DEBUG_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_ASSIST_DEBUG_INT_MAP_S  0
/** CORE0_CORE0_ASSIST_DEBUG_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_ASSIST_DEBUG_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_ASSIST_DEBUG_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_ASSIST_DEBUG_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_ASSIST_DEBUG_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_ASSIST_DEBUG_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_ASSIST_DEBUG_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_ASSIST_DEBUG_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_ASSIST_DEBUG_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_ASSIST_DEBUG_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_ASSIST_DEBUG_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_ASSIST_DEBUG_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_ASSIST_DEBUG_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_ASSIST_DEBUG_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_INTR_STATUS_REG_0_REG register
 *  NA
 */
#define INTERRUPT_CORE0_INTR_STATUS_REG_0_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x200)
/** CORE0_CORE0_INTR_STATUS_0 : RO; bitpos: [31:0]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_INTR_STATUS_0    0xFFFFFFFFU
#define INTERRUPT_CORE0_CORE0_INTR_STATUS_0_M  (CORE0_CORE0_INTR_STATUS_0_V << CORE0_CORE0_INTR_STATUS_0_S)
#define INTERRUPT_CORE0_CORE0_INTR_STATUS_0_V  0xFFFFFFFFU
#define INTERRUPT_CORE0_CORE0_INTR_STATUS_0_S  0

/** CORE0_INTR_STATUS_REG_1_REG register
 *  NA
 */
#define INTERRUPT_CORE0_INTR_STATUS_REG_1_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x204)
/** CORE0_CORE0_INTR_STATUS_1 : RO; bitpos: [31:0]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_INTR_STATUS_1    0xFFFFFFFFU
#define INTERRUPT_CORE0_CORE0_INTR_STATUS_1_M  (CORE0_CORE0_INTR_STATUS_1_V << CORE0_CORE0_INTR_STATUS_1_S)
#define INTERRUPT_CORE0_CORE0_INTR_STATUS_1_V  0xFFFFFFFFU
#define INTERRUPT_CORE0_CORE0_INTR_STATUS_1_S  0

/** CORE0_INTR_STATUS_REG_2_REG register
 *  NA
 */
#define INTERRUPT_CORE0_INTR_STATUS_REG_2_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x208)
/** CORE0_CORE0_INTR_STATUS_2 : RO; bitpos: [31:0]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_INTR_STATUS_2    0xFFFFFFFFU
#define INTERRUPT_CORE0_CORE0_INTR_STATUS_2_M  (CORE0_CORE0_INTR_STATUS_2_V << CORE0_CORE0_INTR_STATUS_2_S)
#define INTERRUPT_CORE0_CORE0_INTR_STATUS_2_V  0xFFFFFFFFU
#define INTERRUPT_CORE0_CORE0_INTR_STATUS_2_S  0

/** CORE0_INTR_STATUS_REG_3_REG register
 *  NA
 */
#define INTERRUPT_CORE0_INTR_STATUS_REG_3_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x20c)
/** CORE0_CORE0_INTR_STATUS_3 : RO; bitpos: [31:0]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_INTR_STATUS_3    0xFFFFFFFFU
#define INTERRUPT_CORE0_CORE0_INTR_STATUS_3_M  (CORE0_CORE0_INTR_STATUS_3_V << CORE0_CORE0_INTR_STATUS_3_S)
#define INTERRUPT_CORE0_CORE0_INTR_STATUS_3_V  0xFFFFFFFFU
#define INTERRUPT_CORE0_CORE0_INTR_STATUS_3_S  0

/** CORE0_CLOCK_GATE_REG register
 *  NA
 */
#define INTERRUPT_CORE0_CLOCK_GATE_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x210)
/** CORE0_CORE0_REG_CLK_EN : R/W; bitpos: [0]; default: 1;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_REG_CLK_EN    (BIT(0))
#define INTERRUPT_CORE0_CORE0_REG_CLK_EN_M  (CORE0_CORE0_REG_CLK_EN_V << CORE0_CORE0_REG_CLK_EN_S)
#define INTERRUPT_CORE0_CORE0_REG_CLK_EN_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_REG_CLK_EN_S  0

/** CORE0_DMA2D_IN_CH2_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_DMA2D_IN_CH2_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x214)
/** CORE0_CORE0_DMA2D_IN_CH2_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_DMA2D_IN_CH2_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_DMA2D_IN_CH2_INT_MAP_M  (CORE0_CORE0_DMA2D_IN_CH2_INT_MAP_V << CORE0_CORE0_DMA2D_IN_CH2_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_DMA2D_IN_CH2_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_DMA2D_IN_CH2_INT_MAP_S  0
/** CORE0_CORE0_DMA2D_IN_CH2_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_DMA2D_IN_CH2_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_DMA2D_IN_CH2_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_DMA2D_IN_CH2_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_DMA2D_IN_CH2_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_DMA2D_IN_CH2_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_DMA2D_IN_CH2_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_DMA2D_IN_CH2_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_DMA2D_IN_CH2_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_DMA2D_IN_CH2_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_DMA2D_IN_CH2_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_DMA2D_IN_CH2_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_DMA2D_IN_CH2_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_DMA2D_IN_CH2_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_DMA2D_OUT_CH3_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_DMA2D_OUT_CH3_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x218)
/** CORE0_CORE0_DMA2D_OUT_CH3_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_DMA2D_OUT_CH3_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_DMA2D_OUT_CH3_INT_MAP_M  (CORE0_CORE0_DMA2D_OUT_CH3_INT_MAP_V << CORE0_CORE0_DMA2D_OUT_CH3_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_DMA2D_OUT_CH3_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_DMA2D_OUT_CH3_INT_MAP_S  0
/** CORE0_CORE0_DMA2D_OUT_CH3_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_DMA2D_OUT_CH3_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_DMA2D_OUT_CH3_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_DMA2D_OUT_CH3_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_DMA2D_OUT_CH3_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_DMA2D_OUT_CH3_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_DMA2D_OUT_CH3_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_DMA2D_OUT_CH3_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_DMA2D_OUT_CH3_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_DMA2D_OUT_CH3_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_DMA2D_OUT_CH3_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_DMA2D_OUT_CH3_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_DMA2D_OUT_CH3_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_DMA2D_OUT_CH3_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_AXI_PERF_MON_INT_MAP_REG register
 *  NA
 */
#define INTERRUPT_CORE0_AXI_PERF_MON_INT_MAP_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x21c)
/** CORE0_CORE0_AXI_PERF_MON_INT_MAP : R/W; bitpos: [5:0]; default: 0;
 *  Configures the interrupt source into one CPU interrupt.
 */
#define INTERRUPT_CORE0_CORE0_AXI_PERF_MON_INT_MAP    0x0000003FU
#define INTERRUPT_CORE0_CORE0_AXI_PERF_MON_INT_MAP_M  (CORE0_CORE0_AXI_PERF_MON_INT_MAP_V << CORE0_CORE0_AXI_PERF_MON_INT_MAP_S)
#define INTERRUPT_CORE0_CORE0_AXI_PERF_MON_INT_MAP_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_AXI_PERF_MON_INT_MAP_S  0
/** CORE0_CORE0_AXI_PERF_MON_INT_SRC_PASS_IN_SEC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_AXI_PERF_MON_INT_SRC_PASS_IN_SEC    (BIT(6))
#define INTERRUPT_CORE0_CORE0_AXI_PERF_MON_INT_SRC_PASS_IN_SEC_M  (CORE0_CORE0_AXI_PERF_MON_INT_SRC_PASS_IN_SEC_V << CORE0_CORE0_AXI_PERF_MON_INT_SRC_PASS_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_AXI_PERF_MON_INT_SRC_PASS_IN_SEC_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_AXI_PERF_MON_INT_SRC_PASS_IN_SEC_S  6
/** CORE0_CORE0_AXI_PERF_MON_INT_SRC_IN_SEC_FLAG : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_AXI_PERF_MON_INT_SRC_IN_SEC_FLAG    (BIT(7))
#define INTERRUPT_CORE0_CORE0_AXI_PERF_MON_INT_SRC_IN_SEC_FLAG_M  (CORE0_CORE0_AXI_PERF_MON_INT_SRC_IN_SEC_FLAG_V << CORE0_CORE0_AXI_PERF_MON_INT_SRC_IN_SEC_FLAG_S)
#define INTERRUPT_CORE0_CORE0_AXI_PERF_MON_INT_SRC_IN_SEC_FLAG_V  0x00000001U
#define INTERRUPT_CORE0_CORE0_AXI_PERF_MON_INT_SRC_IN_SEC_FLAG_S  7

/** CORE0_INTR_STATUS_REG_4_REG register
 *  NA
 */
#define INTERRUPT_CORE0_INTR_STATUS_REG_4_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x220)
/** CORE0_CORE0_INTR_STATUS_4 : RO; bitpos: [31:0]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_INTR_STATUS_4    0xFFFFFFFFU
#define INTERRUPT_CORE0_CORE0_INTR_STATUS_4_M  (CORE0_CORE0_INTR_STATUS_4_V << CORE0_CORE0_INTR_STATUS_4_S)
#define INTERRUPT_CORE0_CORE0_INTR_STATUS_4_V  0xFFFFFFFFU
#define INTERRUPT_CORE0_CORE0_INTR_STATUS_4_S  0

/** CORE0_INTR_SIG_IDX_ASSERT_IN_SEC_REG register
 *  NA
 */
#define INTERRUPT_CORE0_INTR_SIG_IDX_ASSERT_IN_SEC_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x228)
/** CORE0_CORE0_INTR_SIG_IDX_ASSERT_IN_SEC : R/W; bitpos: [5:0]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_INTR_SIG_IDX_ASSERT_IN_SEC    0x0000003FU
#define INTERRUPT_CORE0_CORE0_INTR_SIG_IDX_ASSERT_IN_SEC_M  (CORE0_CORE0_INTR_SIG_IDX_ASSERT_IN_SEC_V << CORE0_CORE0_INTR_SIG_IDX_ASSERT_IN_SEC_S)
#define INTERRUPT_CORE0_CORE0_INTR_SIG_IDX_ASSERT_IN_SEC_V  0x0000003FU
#define INTERRUPT_CORE0_CORE0_INTR_SIG_IDX_ASSERT_IN_SEC_S  0

/** CORE0_INTR_SEC_STATUS_REG register
 *  NA
 */
#define INTERRUPT_CORE0_INTR_SEC_STATUS_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x22c)
/** CORE0_CORE0_INTR_SEC_STATUS : RO; bitpos: [31:0]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_INTR_SEC_STATUS    0xFFFFFFFFU
#define INTERRUPT_CORE0_CORE0_INTR_SEC_STATUS_M  (CORE0_CORE0_INTR_SEC_STATUS_V << CORE0_CORE0_INTR_SEC_STATUS_S)
#define INTERRUPT_CORE0_CORE0_INTR_SEC_STATUS_V  0xFFFFFFFFU
#define INTERRUPT_CORE0_CORE0_INTR_SEC_STATUS_S  0

/** CORE0_INTR_SRC_PASS_IN_SEC_STATUS_0_REG register
 *  NA
 */
#define INTERRUPT_CORE0_INTR_SRC_PASS_IN_SEC_STATUS_0_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x230)
/** CORE0_CORE0_INTR_SRC_PASS_IN_SEC_STATUS_0 : RO; bitpos: [31:0]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_INTR_SRC_PASS_IN_SEC_STATUS_0    0xFFFFFFFFU
#define INTERRUPT_CORE0_CORE0_INTR_SRC_PASS_IN_SEC_STATUS_0_M  (CORE0_CORE0_INTR_SRC_PASS_IN_SEC_STATUS_0_V << CORE0_CORE0_INTR_SRC_PASS_IN_SEC_STATUS_0_S)
#define INTERRUPT_CORE0_CORE0_INTR_SRC_PASS_IN_SEC_STATUS_0_V  0xFFFFFFFFU
#define INTERRUPT_CORE0_CORE0_INTR_SRC_PASS_IN_SEC_STATUS_0_S  0

/** CORE0_INTR_SRC_PASS_IN_SEC_STATUS_1_REG register
 *  NA
 */
#define INTERRUPT_CORE0_INTR_SRC_PASS_IN_SEC_STATUS_1_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x234)
/** CORE0_CORE0_INTR_SRC_PASS_IN_SEC_STATUS_1 : RO; bitpos: [31:0]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_INTR_SRC_PASS_IN_SEC_STATUS_1    0xFFFFFFFFU
#define INTERRUPT_CORE0_CORE0_INTR_SRC_PASS_IN_SEC_STATUS_1_M  (CORE0_CORE0_INTR_SRC_PASS_IN_SEC_STATUS_1_V << CORE0_CORE0_INTR_SRC_PASS_IN_SEC_STATUS_1_S)
#define INTERRUPT_CORE0_CORE0_INTR_SRC_PASS_IN_SEC_STATUS_1_V  0xFFFFFFFFU
#define INTERRUPT_CORE0_CORE0_INTR_SRC_PASS_IN_SEC_STATUS_1_S  0

/** CORE0_INTR_SRC_PASS_IN_SEC_STATUS_2_REG register
 *  NA
 */
#define INTERRUPT_CORE0_INTR_SRC_PASS_IN_SEC_STATUS_2_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x238)
/** CORE0_CORE0_INTR_SRC_PASS_IN_SEC_STATUS_2 : RO; bitpos: [31:0]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_INTR_SRC_PASS_IN_SEC_STATUS_2    0xFFFFFFFFU
#define INTERRUPT_CORE0_CORE0_INTR_SRC_PASS_IN_SEC_STATUS_2_M  (CORE0_CORE0_INTR_SRC_PASS_IN_SEC_STATUS_2_V << CORE0_CORE0_INTR_SRC_PASS_IN_SEC_STATUS_2_S)
#define INTERRUPT_CORE0_CORE0_INTR_SRC_PASS_IN_SEC_STATUS_2_V  0xFFFFFFFFU
#define INTERRUPT_CORE0_CORE0_INTR_SRC_PASS_IN_SEC_STATUS_2_S  0

/** CORE0_INTR_SRC_PASS_IN_SEC_STATUS_3_REG register
 *  NA
 */
#define INTERRUPT_CORE0_INTR_SRC_PASS_IN_SEC_STATUS_3_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x23c)
/** CORE0_CORE0_INTR_SRC_PASS_IN_SEC_STATUS_3 : RO; bitpos: [31:0]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_INTR_SRC_PASS_IN_SEC_STATUS_3    0xFFFFFFFFU
#define INTERRUPT_CORE0_CORE0_INTR_SRC_PASS_IN_SEC_STATUS_3_M  (CORE0_CORE0_INTR_SRC_PASS_IN_SEC_STATUS_3_V << CORE0_CORE0_INTR_SRC_PASS_IN_SEC_STATUS_3_S)
#define INTERRUPT_CORE0_CORE0_INTR_SRC_PASS_IN_SEC_STATUS_3_V  0xFFFFFFFFU
#define INTERRUPT_CORE0_CORE0_INTR_SRC_PASS_IN_SEC_STATUS_3_S  0

/** CORE0_INTR_SRC_PASS_IN_SEC_STATUS_4_REG register
 *  NA
 */
#define INTERRUPT_CORE0_INTR_SRC_PASS_IN_SEC_STATUS_4_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x240)
/** CORE0_CORE0_INTR_SRC_PASS_IN_SEC_STATUS_4 : RO; bitpos: [31:0]; default: 0;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_INTR_SRC_PASS_IN_SEC_STATUS_4    0xFFFFFFFFU
#define INTERRUPT_CORE0_CORE0_INTR_SRC_PASS_IN_SEC_STATUS_4_M  (CORE0_CORE0_INTR_SRC_PASS_IN_SEC_STATUS_4_V << CORE0_CORE0_INTR_SRC_PASS_IN_SEC_STATUS_4_S)
#define INTERRUPT_CORE0_CORE0_INTR_SRC_PASS_IN_SEC_STATUS_4_V  0xFFFFFFFFU
#define INTERRUPT_CORE0_CORE0_INTR_SRC_PASS_IN_SEC_STATUS_4_S  0

/** CORE0_INTERRUPT_REG_DATE_REG register
 *  NA
 */
#define INTERRUPT_CORE0_INTERRUPT_REG_DATE_REG (DR_REG_INTERRUPT_CORE0_BASE + 0x3fc)
/** CORE0_CORE0_INTERRUPT_REG_DATE : R/W; bitpos: [27:0]; default: 38806144;
 *  NA
 */
#define INTERRUPT_CORE0_CORE0_INTERRUPT_REG_DATE    0x0FFFFFFFU
#define INTERRUPT_CORE0_CORE0_INTERRUPT_REG_DATE_M  (CORE0_CORE0_INTERRUPT_REG_DATE_V << CORE0_CORE0_INTERRUPT_REG_DATE_S)
#define INTERRUPT_CORE0_CORE0_INTERRUPT_REG_DATE_V  0x0FFFFFFFU
#define INTERRUPT_CORE0_CORE0_INTERRUPT_REG_DATE_S  0

#ifdef __cplusplus
}
#endif
