/**
 * SPDX-FileCopyrightText: 2025 Espressif Systems (Shanghai) CO LTD
 *
 *  SPDX-License-Identifier: Apache-2.0
 */
#pragma once

#include <stdint.h>
#include "soc/soc.h"
#ifdef __cplusplus
extern "C" {
#endif

/** TOUCH_AON_APPROACH_WORK_MEAS_NUM_REG register
 *  need_des
 */
#define TOUCH_AON_APPROACH_WORK_MEAS_NUM_REG (DR_REG_TOUCH_AON_BASE + 0x0)
/** TOUCH_AON_TOUCH_APPROACH_MEAS_NUM2 : R/W; bitpos: [9:0]; default: 100;
 *  need_des
 */
#define TOUCH_AON_TOUCH_APPROACH_MEAS_NUM2    0x000003FFU
#define TOUCH_AON_TOUCH_APPROACH_MEAS_NUM2_M  (TOUCH_AON_TOUCH_APPROACH_MEAS_NUM2_V << TOUCH_AON_TOUCH_APPROACH_MEAS_NUM2_S)
#define TOUCH_AON_TOUCH_APPROACH_MEAS_NUM2_V  0x000003FFU
#define TOUCH_AON_TOUCH_APPROACH_MEAS_NUM2_S  0
/** TOUCH_AON_TOUCH_APPROACH_MEAS_NUM1 : R/W; bitpos: [19:10]; default: 100;
 *  need_des
 */
#define TOUCH_AON_TOUCH_APPROACH_MEAS_NUM1    0x000003FFU
#define TOUCH_AON_TOUCH_APPROACH_MEAS_NUM1_M  (TOUCH_AON_TOUCH_APPROACH_MEAS_NUM1_V << TOUCH_AON_TOUCH_APPROACH_MEAS_NUM1_S)
#define TOUCH_AON_TOUCH_APPROACH_MEAS_NUM1_V  0x000003FFU
#define TOUCH_AON_TOUCH_APPROACH_MEAS_NUM1_S  10
/** TOUCH_AON_TOUCH_APPROACH_MEAS_NUM0 : R/W; bitpos: [29:20]; default: 100;
 *  need_des
 */
#define TOUCH_AON_TOUCH_APPROACH_MEAS_NUM0    0x000003FFU
#define TOUCH_AON_TOUCH_APPROACH_MEAS_NUM0_M  (TOUCH_AON_TOUCH_APPROACH_MEAS_NUM0_V << TOUCH_AON_TOUCH_APPROACH_MEAS_NUM0_S)
#define TOUCH_AON_TOUCH_APPROACH_MEAS_NUM0_V  0x000003FFU
#define TOUCH_AON_TOUCH_APPROACH_MEAS_NUM0_S  20

/** TOUCH_AON_SCAN_CTRL1_REG register
 *  need_des
 */
#define TOUCH_AON_SCAN_CTRL1_REG (DR_REG_TOUCH_AON_BASE + 0x4)
/** TOUCH_AON_TOUCH_SHIELD_PAD_EN : R/W; bitpos: [0]; default: 0;
 *  need_des
 */
#define TOUCH_AON_TOUCH_SHIELD_PAD_EN    (BIT(0))
#define TOUCH_AON_TOUCH_SHIELD_PAD_EN_M  (TOUCH_AON_TOUCH_SHIELD_PAD_EN_V << TOUCH_AON_TOUCH_SHIELD_PAD_EN_S)
#define TOUCH_AON_TOUCH_SHIELD_PAD_EN_V  0x00000001U
#define TOUCH_AON_TOUCH_SHIELD_PAD_EN_S  0
/** TOUCH_AON_TOUCH_INACTIVE_CONNECTION : R/W; bitpos: [1]; default: 0;
 *  need_des
 */
#define TOUCH_AON_TOUCH_INACTIVE_CONNECTION    (BIT(1))
#define TOUCH_AON_TOUCH_INACTIVE_CONNECTION_M  (TOUCH_AON_TOUCH_INACTIVE_CONNECTION_V << TOUCH_AON_TOUCH_INACTIVE_CONNECTION_S)
#define TOUCH_AON_TOUCH_INACTIVE_CONNECTION_V  0x00000001U
#define TOUCH_AON_TOUCH_INACTIVE_CONNECTION_S  1
/** TOUCH_AON_TOUCH_SCAN_PAD_MAP : R/W; bitpos: [16:2]; default: 0;
 *  need_des
 */
#define TOUCH_AON_TOUCH_SCAN_PAD_MAP    0x00007FFFU
#define TOUCH_AON_TOUCH_SCAN_PAD_MAP_M  (TOUCH_AON_TOUCH_SCAN_PAD_MAP_V << TOUCH_AON_TOUCH_SCAN_PAD_MAP_S)
#define TOUCH_AON_TOUCH_SCAN_PAD_MAP_V  0x00007FFFU
#define TOUCH_AON_TOUCH_SCAN_PAD_MAP_S  2
/** TOUCH_AON_TOUCH_XPD_WAIT : R/W; bitpos: [31:17]; default: 4;
 *  need_des
 */
#define TOUCH_AON_TOUCH_XPD_WAIT    0x00007FFFU
#define TOUCH_AON_TOUCH_XPD_WAIT_M  (TOUCH_AON_TOUCH_XPD_WAIT_V << TOUCH_AON_TOUCH_XPD_WAIT_S)
#define TOUCH_AON_TOUCH_XPD_WAIT_V  0x00007FFFU
#define TOUCH_AON_TOUCH_XPD_WAIT_S  17

/** TOUCH_AON_SCAN_CTRL2_REG register
 *  need_des
 */
#define TOUCH_AON_SCAN_CTRL2_REG (DR_REG_TOUCH_AON_BASE + 0x8)
/** TOUCH_AON_FREQ_SCAN_CNT_RISE : R/W; bitpos: [1:0]; default: 1;
 *  need_des
 */
#define TOUCH_AON_FREQ_SCAN_CNT_RISE    0x00000003U
#define TOUCH_AON_FREQ_SCAN_CNT_RISE_M  (TOUCH_AON_FREQ_SCAN_CNT_RISE_V << TOUCH_AON_FREQ_SCAN_CNT_RISE_S)
#define TOUCH_AON_FREQ_SCAN_CNT_RISE_V  0x00000003U
#define TOUCH_AON_FREQ_SCAN_CNT_RISE_S  0
/** TOUCH_AON_TOUCH_TIMEOUT_NUM : R/W; bitpos: [21:6]; default: 65535;
 *  need_des
 */
#define TOUCH_AON_TOUCH_TIMEOUT_NUM    0x0000FFFFU
#define TOUCH_AON_TOUCH_TIMEOUT_NUM_M  (TOUCH_AON_TOUCH_TIMEOUT_NUM_V << TOUCH_AON_TOUCH_TIMEOUT_NUM_S)
#define TOUCH_AON_TOUCH_TIMEOUT_NUM_V  0x0000FFFFU
#define TOUCH_AON_TOUCH_TIMEOUT_NUM_S  6
/** TOUCH_AON_TOUCH_TIMEOUT_EN : R/W; bitpos: [22]; default: 0;
 *  need_des
 */
#define TOUCH_AON_TOUCH_TIMEOUT_EN    (BIT(22))
#define TOUCH_AON_TOUCH_TIMEOUT_EN_M  (TOUCH_AON_TOUCH_TIMEOUT_EN_V << TOUCH_AON_TOUCH_TIMEOUT_EN_S)
#define TOUCH_AON_TOUCH_TIMEOUT_EN_V  0x00000001U
#define TOUCH_AON_TOUCH_TIMEOUT_EN_S  22
/** TOUCH_AON_TOUCH_OUT_RING : R/W; bitpos: [26:23]; default: 15;
 *  need_des
 */
#define TOUCH_AON_TOUCH_OUT_RING    0x0000000FU
#define TOUCH_AON_TOUCH_OUT_RING_M  (TOUCH_AON_TOUCH_OUT_RING_V << TOUCH_AON_TOUCH_OUT_RING_S)
#define TOUCH_AON_TOUCH_OUT_RING_V  0x0000000FU
#define TOUCH_AON_TOUCH_OUT_RING_S  23
/** TOUCH_AON_FREQ_SCAN_EN : R/W; bitpos: [27]; default: 0;
 *  need_des
 */
#define TOUCH_AON_FREQ_SCAN_EN    (BIT(27))
#define TOUCH_AON_FREQ_SCAN_EN_M  (TOUCH_AON_FREQ_SCAN_EN_V << TOUCH_AON_FREQ_SCAN_EN_S)
#define TOUCH_AON_FREQ_SCAN_EN_V  0x00000001U
#define TOUCH_AON_FREQ_SCAN_EN_S  27
/** TOUCH_AON_FREQ_SCAN_CNT_LIMIT : R/W; bitpos: [29:28]; default: 3;
 *  need_des
 */
#define TOUCH_AON_FREQ_SCAN_CNT_LIMIT    0x00000003U
#define TOUCH_AON_FREQ_SCAN_CNT_LIMIT_M  (TOUCH_AON_FREQ_SCAN_CNT_LIMIT_V << TOUCH_AON_FREQ_SCAN_CNT_LIMIT_S)
#define TOUCH_AON_FREQ_SCAN_CNT_LIMIT_V  0x00000003U
#define TOUCH_AON_FREQ_SCAN_CNT_LIMIT_S  28

/** TOUCH_AON_WORK_REG register
 *  need_des
 */
#define TOUCH_AON_WORK_REG (DR_REG_TOUCH_AON_BASE + 0xc)
/** TOUCH_AON_DIV_NUM2 : R/W; bitpos: [18:16]; default: 0;
 *  need_des
 */
#define TOUCH_AON_DIV_NUM2    0x00000007U
#define TOUCH_AON_DIV_NUM2_M  (TOUCH_AON_DIV_NUM2_V << TOUCH_AON_DIV_NUM2_S)
#define TOUCH_AON_DIV_NUM2_V  0x00000007U
#define TOUCH_AON_DIV_NUM2_S  16
/** TOUCH_AON_DIV_NUM1 : R/W; bitpos: [21:19]; default: 0;
 *  need_des
 */
#define TOUCH_AON_DIV_NUM1    0x00000007U
#define TOUCH_AON_DIV_NUM1_M  (TOUCH_AON_DIV_NUM1_V << TOUCH_AON_DIV_NUM1_S)
#define TOUCH_AON_DIV_NUM1_V  0x00000007U
#define TOUCH_AON_DIV_NUM1_S  19
/** TOUCH_AON_DIV_NUM0 : R/W; bitpos: [24:22]; default: 0;
 *  need_des
 */
#define TOUCH_AON_DIV_NUM0    0x00000007U
#define TOUCH_AON_DIV_NUM0_M  (TOUCH_AON_DIV_NUM0_V << TOUCH_AON_DIV_NUM0_S)
#define TOUCH_AON_DIV_NUM0_V  0x00000007U
#define TOUCH_AON_DIV_NUM0_S  22
/** TOUCH_AON_TOUCH_OUT_SEL : R/W; bitpos: [25]; default: 0;
 *  need_des
 */
#define TOUCH_AON_TOUCH_OUT_SEL    (BIT(25))
#define TOUCH_AON_TOUCH_OUT_SEL_M  (TOUCH_AON_TOUCH_OUT_SEL_V << TOUCH_AON_TOUCH_OUT_SEL_S)
#define TOUCH_AON_TOUCH_OUT_SEL_V  0x00000001U
#define TOUCH_AON_TOUCH_OUT_SEL_S  25
/** TOUCH_AON_TOUCH_OUT_RESET : WT; bitpos: [26]; default: 0;
 *  need_des
 */
#define TOUCH_AON_TOUCH_OUT_RESET    (BIT(26))
#define TOUCH_AON_TOUCH_OUT_RESET_M  (TOUCH_AON_TOUCH_OUT_RESET_V << TOUCH_AON_TOUCH_OUT_RESET_S)
#define TOUCH_AON_TOUCH_OUT_RESET_V  0x00000001U
#define TOUCH_AON_TOUCH_OUT_RESET_S  26
/** TOUCH_AON_TOUCH_OUT_GATE : R/W; bitpos: [27]; default: 0;
 *  need_des
 */
#define TOUCH_AON_TOUCH_OUT_GATE    (BIT(27))
#define TOUCH_AON_TOUCH_OUT_GATE_M  (TOUCH_AON_TOUCH_OUT_GATE_V << TOUCH_AON_TOUCH_OUT_GATE_S)
#define TOUCH_AON_TOUCH_OUT_GATE_V  0x00000001U
#define TOUCH_AON_TOUCH_OUT_GATE_S  27

/** TOUCH_AON_WORK_MEAS_NUM_REG register
 *  need_des
 */
#define TOUCH_AON_WORK_MEAS_NUM_REG (DR_REG_TOUCH_AON_BASE + 0x10)
/** TOUCH_AON_TOUCH_MEAS_NUM2 : R/W; bitpos: [9:0]; default: 100;
 *  need_des
 */
#define TOUCH_AON_TOUCH_MEAS_NUM2    0x000003FFU
#define TOUCH_AON_TOUCH_MEAS_NUM2_M  (TOUCH_AON_TOUCH_MEAS_NUM2_V << TOUCH_AON_TOUCH_MEAS_NUM2_S)
#define TOUCH_AON_TOUCH_MEAS_NUM2_V  0x000003FFU
#define TOUCH_AON_TOUCH_MEAS_NUM2_S  0
/** TOUCH_AON_TOUCH_MEAS_NUM1 : R/W; bitpos: [19:10]; default: 100;
 *  need_des
 */
#define TOUCH_AON_TOUCH_MEAS_NUM1    0x000003FFU
#define TOUCH_AON_TOUCH_MEAS_NUM1_M  (TOUCH_AON_TOUCH_MEAS_NUM1_V << TOUCH_AON_TOUCH_MEAS_NUM1_S)
#define TOUCH_AON_TOUCH_MEAS_NUM1_V  0x000003FFU
#define TOUCH_AON_TOUCH_MEAS_NUM1_S  10
/** TOUCH_AON_TOUCH_MEAS_NUM0 : R/W; bitpos: [29:20]; default: 100;
 *  need_des
 */
#define TOUCH_AON_TOUCH_MEAS_NUM0    0x000003FFU
#define TOUCH_AON_TOUCH_MEAS_NUM0_M  (TOUCH_AON_TOUCH_MEAS_NUM0_V << TOUCH_AON_TOUCH_MEAS_NUM0_S)
#define TOUCH_AON_TOUCH_MEAS_NUM0_V  0x000003FFU
#define TOUCH_AON_TOUCH_MEAS_NUM0_S  20

/** TOUCH_AON_FILTER1_REG register
 *  need_des
 */
#define TOUCH_AON_FILTER1_REG (DR_REG_TOUCH_AON_BASE + 0x14)
/** TOUCH_AON_TOUCH_NN_DISUPDATE_BENCHMARK_EN : R/W; bitpos: [0]; default: 0;
 *  Reserved
 */
#define TOUCH_AON_TOUCH_NN_DISUPDATE_BENCHMARK_EN    (BIT(0))
#define TOUCH_AON_TOUCH_NN_DISUPDATE_BENCHMARK_EN_M  (TOUCH_AON_TOUCH_NN_DISUPDATE_BENCHMARK_EN_V << TOUCH_AON_TOUCH_NN_DISUPDATE_BENCHMARK_EN_S)
#define TOUCH_AON_TOUCH_NN_DISUPDATE_BENCHMARK_EN_V  0x00000001U
#define TOUCH_AON_TOUCH_NN_DISUPDATE_BENCHMARK_EN_S  0
/** TOUCH_AON_TOUCH_HYSTERESIS : R/W; bitpos: [2:1]; default: 0;
 *  need_des
 */
#define TOUCH_AON_TOUCH_HYSTERESIS    0x00000003U
#define TOUCH_AON_TOUCH_HYSTERESIS_M  (TOUCH_AON_TOUCH_HYSTERESIS_V << TOUCH_AON_TOUCH_HYSTERESIS_S)
#define TOUCH_AON_TOUCH_HYSTERESIS_V  0x00000003U
#define TOUCH_AON_TOUCH_HYSTERESIS_S  1
/** TOUCH_AON_TOUCH_NN_THRES : R/W; bitpos: [4:3]; default: 0;
 *  need_des
 */
#define TOUCH_AON_TOUCH_NN_THRES    0x00000003U
#define TOUCH_AON_TOUCH_NN_THRES_M  (TOUCH_AON_TOUCH_NN_THRES_V << TOUCH_AON_TOUCH_NN_THRES_S)
#define TOUCH_AON_TOUCH_NN_THRES_V  0x00000003U
#define TOUCH_AON_TOUCH_NN_THRES_S  3
/** TOUCH_AON_TOUCH_NOISE_THRES : R/W; bitpos: [6:5]; default: 0;
 *  need_des
 */
#define TOUCH_AON_TOUCH_NOISE_THRES    0x00000003U
#define TOUCH_AON_TOUCH_NOISE_THRES_M  (TOUCH_AON_TOUCH_NOISE_THRES_V << TOUCH_AON_TOUCH_NOISE_THRES_S)
#define TOUCH_AON_TOUCH_NOISE_THRES_V  0x00000003U
#define TOUCH_AON_TOUCH_NOISE_THRES_S  5
/** TOUCH_AON_TOUCH_SMOOTH_LVL : R/W; bitpos: [8:7]; default: 0;
 *  need_des
 */
#define TOUCH_AON_TOUCH_SMOOTH_LVL    0x00000003U
#define TOUCH_AON_TOUCH_SMOOTH_LVL_M  (TOUCH_AON_TOUCH_SMOOTH_LVL_V << TOUCH_AON_TOUCH_SMOOTH_LVL_S)
#define TOUCH_AON_TOUCH_SMOOTH_LVL_V  0x00000003U
#define TOUCH_AON_TOUCH_SMOOTH_LVL_S  7
/** TOUCH_AON_TOUCH_JITTER_STEP : R/W; bitpos: [12:9]; default: 1;
 *  need_des
 */
#define TOUCH_AON_TOUCH_JITTER_STEP    0x0000000FU
#define TOUCH_AON_TOUCH_JITTER_STEP_M  (TOUCH_AON_TOUCH_JITTER_STEP_V << TOUCH_AON_TOUCH_JITTER_STEP_S)
#define TOUCH_AON_TOUCH_JITTER_STEP_V  0x0000000FU
#define TOUCH_AON_TOUCH_JITTER_STEP_S  9
/** TOUCH_AON_TOUCH_FILTER_MODE : R/W; bitpos: [15:13]; default: 0;
 *  need_des
 */
#define TOUCH_AON_TOUCH_FILTER_MODE    0x00000007U
#define TOUCH_AON_TOUCH_FILTER_MODE_M  (TOUCH_AON_TOUCH_FILTER_MODE_V << TOUCH_AON_TOUCH_FILTER_MODE_S)
#define TOUCH_AON_TOUCH_FILTER_MODE_V  0x00000007U
#define TOUCH_AON_TOUCH_FILTER_MODE_S  13
/** TOUCH_AON_TOUCH_FILTER_EN : R/W; bitpos: [16]; default: 0;
 *  need_des
 */
#define TOUCH_AON_TOUCH_FILTER_EN    (BIT(16))
#define TOUCH_AON_TOUCH_FILTER_EN_M  (TOUCH_AON_TOUCH_FILTER_EN_V << TOUCH_AON_TOUCH_FILTER_EN_S)
#define TOUCH_AON_TOUCH_FILTER_EN_V  0x00000001U
#define TOUCH_AON_TOUCH_FILTER_EN_S  16
/** TOUCH_AON_TOUCH_NN_LIMIT : R/W; bitpos: [20:17]; default: 5;
 *  need_des
 */
#define TOUCH_AON_TOUCH_NN_LIMIT    0x0000000FU
#define TOUCH_AON_TOUCH_NN_LIMIT_M  (TOUCH_AON_TOUCH_NN_LIMIT_V << TOUCH_AON_TOUCH_NN_LIMIT_S)
#define TOUCH_AON_TOUCH_NN_LIMIT_V  0x0000000FU
#define TOUCH_AON_TOUCH_NN_LIMIT_S  17
/** TOUCH_AON_TOUCH_APPROACH_LIMIT : R/W; bitpos: [28:21]; default: 80;
 *  need_des
 */
#define TOUCH_AON_TOUCH_APPROACH_LIMIT    0x000000FFU
#define TOUCH_AON_TOUCH_APPROACH_LIMIT_M  (TOUCH_AON_TOUCH_APPROACH_LIMIT_V << TOUCH_AON_TOUCH_APPROACH_LIMIT_S)
#define TOUCH_AON_TOUCH_APPROACH_LIMIT_V  0x000000FFU
#define TOUCH_AON_TOUCH_APPROACH_LIMIT_S  21
/** TOUCH_AON_TOUCH_DEBOUNCE_LIMIT : R/W; bitpos: [31:29]; default: 3;
 *  need_des
 */
#define TOUCH_AON_TOUCH_DEBOUNCE_LIMIT    0x00000007U
#define TOUCH_AON_TOUCH_DEBOUNCE_LIMIT_M  (TOUCH_AON_TOUCH_DEBOUNCE_LIMIT_V << TOUCH_AON_TOUCH_DEBOUNCE_LIMIT_S)
#define TOUCH_AON_TOUCH_DEBOUNCE_LIMIT_V  0x00000007U
#define TOUCH_AON_TOUCH_DEBOUNCE_LIMIT_S  29

/** TOUCH_AON_FILTER2_REG register
 *  need_des
 */
#define TOUCH_AON_FILTER2_REG (DR_REG_TOUCH_AON_BASE + 0x18)
/** TOUCH_AON_TOUCH_OUTEN : R/W; bitpos: [29:15]; default: 16383;
 *  need_des
 */
#define TOUCH_AON_TOUCH_OUTEN    0x00007FFFU
#define TOUCH_AON_TOUCH_OUTEN_M  (TOUCH_AON_TOUCH_OUTEN_V << TOUCH_AON_TOUCH_OUTEN_S)
#define TOUCH_AON_TOUCH_OUTEN_V  0x00007FFFU
#define TOUCH_AON_TOUCH_OUTEN_S  15
/** TOUCH_AON_TOUCH_BYPASS_NOISE_THRES : R/W; bitpos: [30]; default: 0;
 *  need_des
 */
#define TOUCH_AON_TOUCH_BYPASS_NOISE_THRES    (BIT(30))
#define TOUCH_AON_TOUCH_BYPASS_NOISE_THRES_M  (TOUCH_AON_TOUCH_BYPASS_NOISE_THRES_V << TOUCH_AON_TOUCH_BYPASS_NOISE_THRES_S)
#define TOUCH_AON_TOUCH_BYPASS_NOISE_THRES_V  0x00000001U
#define TOUCH_AON_TOUCH_BYPASS_NOISE_THRES_S  30
/** TOUCH_AON_TOUCH_BYPASS_NN_THRES : R/W; bitpos: [31]; default: 0;
 *  need_des
 */
#define TOUCH_AON_TOUCH_BYPASS_NN_THRES    (BIT(31))
#define TOUCH_AON_TOUCH_BYPASS_NN_THRES_M  (TOUCH_AON_TOUCH_BYPASS_NN_THRES_V << TOUCH_AON_TOUCH_BYPASS_NN_THRES_S)
#define TOUCH_AON_TOUCH_BYPASS_NN_THRES_V  0x00000001U
#define TOUCH_AON_TOUCH_BYPASS_NN_THRES_S  31

/** TOUCH_AON_FILTER3_REG register
 *  need_des
 */
#define TOUCH_AON_FILTER3_REG (DR_REG_TOUCH_AON_BASE + 0x1c)
/** TOUCH_AON_TOUCH_BENCHMARK_SW : R/W; bitpos: [15:0]; default: 0;
 *  need_des
 */
#define TOUCH_AON_TOUCH_BENCHMARK_SW    0x0000FFFFU
#define TOUCH_AON_TOUCH_BENCHMARK_SW_M  (TOUCH_AON_TOUCH_BENCHMARK_SW_V << TOUCH_AON_TOUCH_BENCHMARK_SW_S)
#define TOUCH_AON_TOUCH_BENCHMARK_SW_V  0x0000FFFFU
#define TOUCH_AON_TOUCH_BENCHMARK_SW_S  0
/** TOUCH_AON_TOUCH_UPDATE_BENCHMARK_SW : WT; bitpos: [16]; default: 0;
 *  need_des
 */
#define TOUCH_AON_TOUCH_UPDATE_BENCHMARK_SW    (BIT(16))
#define TOUCH_AON_TOUCH_UPDATE_BENCHMARK_SW_M  (TOUCH_AON_TOUCH_UPDATE_BENCHMARK_SW_V << TOUCH_AON_TOUCH_UPDATE_BENCHMARK_SW_S)
#define TOUCH_AON_TOUCH_UPDATE_BENCHMARK_SW_V  0x00000001U
#define TOUCH_AON_TOUCH_UPDATE_BENCHMARK_SW_S  16
/** TOUCH_AON_TOUCH_UPDATE_BENCHMARK_FREQ_SEL : R/W; bitpos: [18:17]; default: 3;
 *  Reserved
 */
#define TOUCH_AON_TOUCH_UPDATE_BENCHMARK_FREQ_SEL    0x00000003U
#define TOUCH_AON_TOUCH_UPDATE_BENCHMARK_FREQ_SEL_M  (TOUCH_AON_TOUCH_UPDATE_BENCHMARK_FREQ_SEL_V << TOUCH_AON_TOUCH_UPDATE_BENCHMARK_FREQ_SEL_S)
#define TOUCH_AON_TOUCH_UPDATE_BENCHMARK_FREQ_SEL_V  0x00000003U
#define TOUCH_AON_TOUCH_UPDATE_BENCHMARK_FREQ_SEL_S  17
/** TOUCH_AON_TOUCH_UPDATE_BENCHMARK_PAD_SEL : R/W; bitpos: [22:19]; default: 15;
 *  Reserved
 */
#define TOUCH_AON_TOUCH_UPDATE_BENCHMARK_PAD_SEL    0x0000000FU
#define TOUCH_AON_TOUCH_UPDATE_BENCHMARK_PAD_SEL_M  (TOUCH_AON_TOUCH_UPDATE_BENCHMARK_PAD_SEL_V << TOUCH_AON_TOUCH_UPDATE_BENCHMARK_PAD_SEL_S)
#define TOUCH_AON_TOUCH_UPDATE_BENCHMARK_PAD_SEL_V  0x0000000FU
#define TOUCH_AON_TOUCH_UPDATE_BENCHMARK_PAD_SEL_S  19

/** TOUCH_AON_SLP0_REG register
 *  need_des
 */
#define TOUCH_AON_SLP0_REG (DR_REG_TOUCH_AON_BASE + 0x20)
/** TOUCH_AON_TOUCH_SLP_TH0 : R/W; bitpos: [15:0]; default: 0;
 *  need_des
 */
#define TOUCH_AON_TOUCH_SLP_TH0    0x0000FFFFU
#define TOUCH_AON_TOUCH_SLP_TH0_M  (TOUCH_AON_TOUCH_SLP_TH0_V << TOUCH_AON_TOUCH_SLP_TH0_S)
#define TOUCH_AON_TOUCH_SLP_TH0_V  0x0000FFFFU
#define TOUCH_AON_TOUCH_SLP_TH0_S  0
/** TOUCH_AON_TOUCH_SLP_CHANNEL_CLR : WT; bitpos: [16]; default: 0;
 *  need_des
 */
#define TOUCH_AON_TOUCH_SLP_CHANNEL_CLR    (BIT(16))
#define TOUCH_AON_TOUCH_SLP_CHANNEL_CLR_M  (TOUCH_AON_TOUCH_SLP_CHANNEL_CLR_V << TOUCH_AON_TOUCH_SLP_CHANNEL_CLR_S)
#define TOUCH_AON_TOUCH_SLP_CHANNEL_CLR_V  0x00000001U
#define TOUCH_AON_TOUCH_SLP_CHANNEL_CLR_S  16
/** TOUCH_AON_TOUCH_SLP_PAD : R/W; bitpos: [20:17]; default: 15;
 *  need_des
 */
#define TOUCH_AON_TOUCH_SLP_PAD    0x0000000FU
#define TOUCH_AON_TOUCH_SLP_PAD_M  (TOUCH_AON_TOUCH_SLP_PAD_V << TOUCH_AON_TOUCH_SLP_PAD_S)
#define TOUCH_AON_TOUCH_SLP_PAD_V  0x0000000FU
#define TOUCH_AON_TOUCH_SLP_PAD_S  17

/** TOUCH_AON_SLP1_REG register
 *  need_des
 */
#define TOUCH_AON_SLP1_REG (DR_REG_TOUCH_AON_BASE + 0x24)
/** TOUCH_AON_TOUCH_SLP_TH2 : R/W; bitpos: [15:0]; default: 0;
 *  need_des
 */
#define TOUCH_AON_TOUCH_SLP_TH2    0x0000FFFFU
#define TOUCH_AON_TOUCH_SLP_TH2_M  (TOUCH_AON_TOUCH_SLP_TH2_V << TOUCH_AON_TOUCH_SLP_TH2_S)
#define TOUCH_AON_TOUCH_SLP_TH2_V  0x0000FFFFU
#define TOUCH_AON_TOUCH_SLP_TH2_S  0
/** TOUCH_AON_TOUCH_SLP_TH1 : R/W; bitpos: [31:16]; default: 0;
 *  need_des
 */
#define TOUCH_AON_TOUCH_SLP_TH1    0x0000FFFFU
#define TOUCH_AON_TOUCH_SLP_TH1_M  (TOUCH_AON_TOUCH_SLP_TH1_V << TOUCH_AON_TOUCH_SLP_TH1_S)
#define TOUCH_AON_TOUCH_SLP_TH1_V  0x0000FFFFU
#define TOUCH_AON_TOUCH_SLP_TH1_S  16

/** TOUCH_AON_CLR_REG register
 *  need_des
 */
#define TOUCH_AON_CLR_REG (DR_REG_TOUCH_AON_BASE + 0x28)
/** TOUCH_AON_TOUCH_CHANNEL_CLR : WT; bitpos: [14:0]; default: 0;
 *  need_des
 */
#define TOUCH_AON_TOUCH_CHANNEL_CLR    0x00007FFFU
#define TOUCH_AON_TOUCH_CHANNEL_CLR_M  (TOUCH_AON_TOUCH_CHANNEL_CLR_V << TOUCH_AON_TOUCH_CHANNEL_CLR_S)
#define TOUCH_AON_TOUCH_CHANNEL_CLR_V  0x00007FFFU
#define TOUCH_AON_TOUCH_CHANNEL_CLR_S  0
/** TOUCH_AON_TOUCH_STATUS_CLR : WT; bitpos: [15]; default: 0;
 *  need_des
 */
#define TOUCH_AON_TOUCH_STATUS_CLR    (BIT(15))
#define TOUCH_AON_TOUCH_STATUS_CLR_M  (TOUCH_AON_TOUCH_STATUS_CLR_V << TOUCH_AON_TOUCH_STATUS_CLR_S)
#define TOUCH_AON_TOUCH_STATUS_CLR_V  0x00000001U
#define TOUCH_AON_TOUCH_STATUS_CLR_S  15

/** TOUCH_AON_APPROACH_REG register
 *  need_des
 */
#define TOUCH_AON_APPROACH_REG (DR_REG_TOUCH_AON_BASE + 0x2c)
/** TOUCH_AON_TOUCH_APPROACH_PAD0 : R/W; bitpos: [3:0]; default: 15;
 *  need_des
 */
#define TOUCH_AON_TOUCH_APPROACH_PAD0    0x0000000FU
#define TOUCH_AON_TOUCH_APPROACH_PAD0_M  (TOUCH_AON_TOUCH_APPROACH_PAD0_V << TOUCH_AON_TOUCH_APPROACH_PAD0_S)
#define TOUCH_AON_TOUCH_APPROACH_PAD0_V  0x0000000FU
#define TOUCH_AON_TOUCH_APPROACH_PAD0_S  0
/** TOUCH_AON_TOUCH_APPROACH_PAD1 : R/W; bitpos: [7:4]; default: 15;
 *  need_des
 */
#define TOUCH_AON_TOUCH_APPROACH_PAD1    0x0000000FU
#define TOUCH_AON_TOUCH_APPROACH_PAD1_M  (TOUCH_AON_TOUCH_APPROACH_PAD1_V << TOUCH_AON_TOUCH_APPROACH_PAD1_S)
#define TOUCH_AON_TOUCH_APPROACH_PAD1_V  0x0000000FU
#define TOUCH_AON_TOUCH_APPROACH_PAD1_S  4
/** TOUCH_AON_TOUCH_APPROACH_PAD2 : R/W; bitpos: [11:8]; default: 15;
 *  need_des
 */
#define TOUCH_AON_TOUCH_APPROACH_PAD2    0x0000000FU
#define TOUCH_AON_TOUCH_APPROACH_PAD2_M  (TOUCH_AON_TOUCH_APPROACH_PAD2_V << TOUCH_AON_TOUCH_APPROACH_PAD2_S)
#define TOUCH_AON_TOUCH_APPROACH_PAD2_V  0x0000000FU
#define TOUCH_AON_TOUCH_APPROACH_PAD2_S  8
/** TOUCH_AON_TOUCH_SLP_APPROACH_EN : R/W; bitpos: [12]; default: 0;
 *  need_des
 */
#define TOUCH_AON_TOUCH_SLP_APPROACH_EN    (BIT(12))
#define TOUCH_AON_TOUCH_SLP_APPROACH_EN_M  (TOUCH_AON_TOUCH_SLP_APPROACH_EN_V << TOUCH_AON_TOUCH_SLP_APPROACH_EN_S)
#define TOUCH_AON_TOUCH_SLP_APPROACH_EN_V  0x00000001U
#define TOUCH_AON_TOUCH_SLP_APPROACH_EN_S  12

/** TOUCH_AON_FREQ0_SCAN_PARA_REG register
 *  need_des
 */
#define TOUCH_AON_FREQ0_SCAN_PARA_REG (DR_REG_TOUCH_AON_BASE + 0x30)
/** TOUCH_AON_TOUCH_FREQ0_DCAP_LPF : R/W; bitpos: [6:0]; default: 0;
 *  need_des
 */
#define TOUCH_AON_TOUCH_FREQ0_DCAP_LPF    0x0000007FU
#define TOUCH_AON_TOUCH_FREQ0_DCAP_LPF_M  (TOUCH_AON_TOUCH_FREQ0_DCAP_LPF_V << TOUCH_AON_TOUCH_FREQ0_DCAP_LPF_S)
#define TOUCH_AON_TOUCH_FREQ0_DCAP_LPF_V  0x0000007FU
#define TOUCH_AON_TOUCH_FREQ0_DCAP_LPF_S  0
/** TOUCH_AON_TOUCH_FREQ0_DRES_LPF : R/W; bitpos: [8:7]; default: 0;
 *  need_des
 */
#define TOUCH_AON_TOUCH_FREQ0_DRES_LPF    0x00000003U
#define TOUCH_AON_TOUCH_FREQ0_DRES_LPF_M  (TOUCH_AON_TOUCH_FREQ0_DRES_LPF_V << TOUCH_AON_TOUCH_FREQ0_DRES_LPF_S)
#define TOUCH_AON_TOUCH_FREQ0_DRES_LPF_V  0x00000003U
#define TOUCH_AON_TOUCH_FREQ0_DRES_LPF_S  7
/** TOUCH_AON_TOUCH_FREQ0_DRV_LS : R/W; bitpos: [12:9]; default: 0;
 *  need_des
 */
#define TOUCH_AON_TOUCH_FREQ0_DRV_LS    0x0000000FU
#define TOUCH_AON_TOUCH_FREQ0_DRV_LS_M  (TOUCH_AON_TOUCH_FREQ0_DRV_LS_V << TOUCH_AON_TOUCH_FREQ0_DRV_LS_S)
#define TOUCH_AON_TOUCH_FREQ0_DRV_LS_V  0x0000000FU
#define TOUCH_AON_TOUCH_FREQ0_DRV_LS_S  9
/** TOUCH_AON_TOUCH_FREQ0_DRV_HS : R/W; bitpos: [17:13]; default: 0;
 *  need_des
 */
#define TOUCH_AON_TOUCH_FREQ0_DRV_HS    0x0000001FU
#define TOUCH_AON_TOUCH_FREQ0_DRV_HS_M  (TOUCH_AON_TOUCH_FREQ0_DRV_HS_V << TOUCH_AON_TOUCH_FREQ0_DRV_HS_S)
#define TOUCH_AON_TOUCH_FREQ0_DRV_HS_V  0x0000001FU
#define TOUCH_AON_TOUCH_FREQ0_DRV_HS_S  13
/** TOUCH_AON_TOUCH_FREQ0_DBIAS : R/W; bitpos: [22:18]; default: 0;
 *  need_des
 */
#define TOUCH_AON_TOUCH_FREQ0_DBIAS    0x0000001FU
#define TOUCH_AON_TOUCH_FREQ0_DBIAS_M  (TOUCH_AON_TOUCH_FREQ0_DBIAS_V << TOUCH_AON_TOUCH_FREQ0_DBIAS_S)
#define TOUCH_AON_TOUCH_FREQ0_DBIAS_V  0x0000001FU
#define TOUCH_AON_TOUCH_FREQ0_DBIAS_S  18
/** TOUCH_AON_TOUCH_FREQ0_BUF_SEL_EN : R/W; bitpos: [23]; default: 1;
 *  need_des
 */
#define TOUCH_AON_TOUCH_FREQ0_BUF_SEL_EN    (BIT(23))
#define TOUCH_AON_TOUCH_FREQ0_BUF_SEL_EN_M  (TOUCH_AON_TOUCH_FREQ0_BUF_SEL_EN_V << TOUCH_AON_TOUCH_FREQ0_BUF_SEL_EN_S)
#define TOUCH_AON_TOUCH_FREQ0_BUF_SEL_EN_V  0x00000001U
#define TOUCH_AON_TOUCH_FREQ0_BUF_SEL_EN_S  23

/** TOUCH_AON_FREQ1_SCAN_PARA_REG register
 *  need_des
 */
#define TOUCH_AON_FREQ1_SCAN_PARA_REG (DR_REG_TOUCH_AON_BASE + 0x34)
/** TOUCH_AON_TOUCH_FREQ1_DCAP_LPF : R/W; bitpos: [6:0]; default: 0;
 *  need_des
 */
#define TOUCH_AON_TOUCH_FREQ1_DCAP_LPF    0x0000007FU
#define TOUCH_AON_TOUCH_FREQ1_DCAP_LPF_M  (TOUCH_AON_TOUCH_FREQ1_DCAP_LPF_V << TOUCH_AON_TOUCH_FREQ1_DCAP_LPF_S)
#define TOUCH_AON_TOUCH_FREQ1_DCAP_LPF_V  0x0000007FU
#define TOUCH_AON_TOUCH_FREQ1_DCAP_LPF_S  0
/** TOUCH_AON_TOUCH_FREQ1_DRES_LPF : R/W; bitpos: [8:7]; default: 0;
 *  need_des
 */
#define TOUCH_AON_TOUCH_FREQ1_DRES_LPF    0x00000003U
#define TOUCH_AON_TOUCH_FREQ1_DRES_LPF_M  (TOUCH_AON_TOUCH_FREQ1_DRES_LPF_V << TOUCH_AON_TOUCH_FREQ1_DRES_LPF_S)
#define TOUCH_AON_TOUCH_FREQ1_DRES_LPF_V  0x00000003U
#define TOUCH_AON_TOUCH_FREQ1_DRES_LPF_S  7
/** TOUCH_AON_TOUCH_FREQ1_DRV_LS : R/W; bitpos: [12:9]; default: 0;
 *  need_des
 */
#define TOUCH_AON_TOUCH_FREQ1_DRV_LS    0x0000000FU
#define TOUCH_AON_TOUCH_FREQ1_DRV_LS_M  (TOUCH_AON_TOUCH_FREQ1_DRV_LS_V << TOUCH_AON_TOUCH_FREQ1_DRV_LS_S)
#define TOUCH_AON_TOUCH_FREQ1_DRV_LS_V  0x0000000FU
#define TOUCH_AON_TOUCH_FREQ1_DRV_LS_S  9
/** TOUCH_AON_TOUCH_FREQ1_DRV_HS : R/W; bitpos: [17:13]; default: 0;
 *  need_des
 */
#define TOUCH_AON_TOUCH_FREQ1_DRV_HS    0x0000001FU
#define TOUCH_AON_TOUCH_FREQ1_DRV_HS_M  (TOUCH_AON_TOUCH_FREQ1_DRV_HS_V << TOUCH_AON_TOUCH_FREQ1_DRV_HS_S)
#define TOUCH_AON_TOUCH_FREQ1_DRV_HS_V  0x0000001FU
#define TOUCH_AON_TOUCH_FREQ1_DRV_HS_S  13
/** TOUCH_AON_TOUCH_FREQ1_DBIAS : R/W; bitpos: [22:18]; default: 0;
 *  need_des
 */
#define TOUCH_AON_TOUCH_FREQ1_DBIAS    0x0000001FU
#define TOUCH_AON_TOUCH_FREQ1_DBIAS_M  (TOUCH_AON_TOUCH_FREQ1_DBIAS_V << TOUCH_AON_TOUCH_FREQ1_DBIAS_S)
#define TOUCH_AON_TOUCH_FREQ1_DBIAS_V  0x0000001FU
#define TOUCH_AON_TOUCH_FREQ1_DBIAS_S  18
/** TOUCH_AON_TOUCH_FREQ1_BUF_SEL_EN : R/W; bitpos: [23]; default: 1;
 *  need_des
 */
#define TOUCH_AON_TOUCH_FREQ1_BUF_SEL_EN    (BIT(23))
#define TOUCH_AON_TOUCH_FREQ1_BUF_SEL_EN_M  (TOUCH_AON_TOUCH_FREQ1_BUF_SEL_EN_V << TOUCH_AON_TOUCH_FREQ1_BUF_SEL_EN_S)
#define TOUCH_AON_TOUCH_FREQ1_BUF_SEL_EN_V  0x00000001U
#define TOUCH_AON_TOUCH_FREQ1_BUF_SEL_EN_S  23

/** TOUCH_AON_FREQ2_SCAN_PARA_REG register
 *  need_des
 */
#define TOUCH_AON_FREQ2_SCAN_PARA_REG (DR_REG_TOUCH_AON_BASE + 0x38)
/** TOUCH_AON_TOUCH_FREQ2_DCAP_LPF : R/W; bitpos: [6:0]; default: 0;
 *  need_des
 */
#define TOUCH_AON_TOUCH_FREQ2_DCAP_LPF    0x0000007FU
#define TOUCH_AON_TOUCH_FREQ2_DCAP_LPF_M  (TOUCH_AON_TOUCH_FREQ2_DCAP_LPF_V << TOUCH_AON_TOUCH_FREQ2_DCAP_LPF_S)
#define TOUCH_AON_TOUCH_FREQ2_DCAP_LPF_V  0x0000007FU
#define TOUCH_AON_TOUCH_FREQ2_DCAP_LPF_S  0
/** TOUCH_AON_TOUCH_FREQ2_DRES_LPF : R/W; bitpos: [8:7]; default: 0;
 *  need_des
 */
#define TOUCH_AON_TOUCH_FREQ2_DRES_LPF    0x00000003U
#define TOUCH_AON_TOUCH_FREQ2_DRES_LPF_M  (TOUCH_AON_TOUCH_FREQ2_DRES_LPF_V << TOUCH_AON_TOUCH_FREQ2_DRES_LPF_S)
#define TOUCH_AON_TOUCH_FREQ2_DRES_LPF_V  0x00000003U
#define TOUCH_AON_TOUCH_FREQ2_DRES_LPF_S  7
/** TOUCH_AON_TOUCH_FREQ2_DRV_LS : R/W; bitpos: [12:9]; default: 0;
 *  need_des
 */
#define TOUCH_AON_TOUCH_FREQ2_DRV_LS    0x0000000FU
#define TOUCH_AON_TOUCH_FREQ2_DRV_LS_M  (TOUCH_AON_TOUCH_FREQ2_DRV_LS_V << TOUCH_AON_TOUCH_FREQ2_DRV_LS_S)
#define TOUCH_AON_TOUCH_FREQ2_DRV_LS_V  0x0000000FU
#define TOUCH_AON_TOUCH_FREQ2_DRV_LS_S  9
/** TOUCH_AON_TOUCH_FREQ2_DRV_HS : R/W; bitpos: [17:13]; default: 0;
 *  need_des
 */
#define TOUCH_AON_TOUCH_FREQ2_DRV_HS    0x0000001FU
#define TOUCH_AON_TOUCH_FREQ2_DRV_HS_M  (TOUCH_AON_TOUCH_FREQ2_DRV_HS_V << TOUCH_AON_TOUCH_FREQ2_DRV_HS_S)
#define TOUCH_AON_TOUCH_FREQ2_DRV_HS_V  0x0000001FU
#define TOUCH_AON_TOUCH_FREQ2_DRV_HS_S  13
/** TOUCH_AON_TOUCH_FREQ2_DBIAS : R/W; bitpos: [22:18]; default: 0;
 *  need_des
 */
#define TOUCH_AON_TOUCH_FREQ2_DBIAS    0x0000001FU
#define TOUCH_AON_TOUCH_FREQ2_DBIAS_M  (TOUCH_AON_TOUCH_FREQ2_DBIAS_V << TOUCH_AON_TOUCH_FREQ2_DBIAS_S)
#define TOUCH_AON_TOUCH_FREQ2_DBIAS_V  0x0000001FU
#define TOUCH_AON_TOUCH_FREQ2_DBIAS_S  18
/** TOUCH_AON_TOUCH_FREQ2_BUF_SEL_EN : R/W; bitpos: [23]; default: 1;
 *  need_des
 */
#define TOUCH_AON_TOUCH_FREQ2_BUF_SEL_EN    (BIT(23))
#define TOUCH_AON_TOUCH_FREQ2_BUF_SEL_EN_M  (TOUCH_AON_TOUCH_FREQ2_BUF_SEL_EN_V << TOUCH_AON_TOUCH_FREQ2_BUF_SEL_EN_S)
#define TOUCH_AON_TOUCH_FREQ2_BUF_SEL_EN_V  0x00000001U
#define TOUCH_AON_TOUCH_FREQ2_BUF_SEL_EN_S  23

/** TOUCH_AON_ANA_PARA_REG register
 *  need_des
 */
#define TOUCH_AON_ANA_PARA_REG (DR_REG_TOUCH_AON_BASE + 0x3c)
/** TOUCH_AON_TOUCH_TOUCH_BUF_DRV : R/W; bitpos: [2:0]; default: 0;
 *  need_des
 */
#define TOUCH_AON_TOUCH_TOUCH_BUF_DRV    0x00000007U
#define TOUCH_AON_TOUCH_TOUCH_BUF_DRV_M  (TOUCH_AON_TOUCH_TOUCH_BUF_DRV_V << TOUCH_AON_TOUCH_TOUCH_BUF_DRV_S)
#define TOUCH_AON_TOUCH_TOUCH_BUF_DRV_V  0x00000007U
#define TOUCH_AON_TOUCH_TOUCH_BUF_DRV_S  0
/** TOUCH_AON_TOUCH_TOUCH_EN_CAL : R/W; bitpos: [3]; default: 0;
 *  need_des
 */
#define TOUCH_AON_TOUCH_TOUCH_EN_CAL    (BIT(3))
#define TOUCH_AON_TOUCH_TOUCH_EN_CAL_M  (TOUCH_AON_TOUCH_TOUCH_EN_CAL_V << TOUCH_AON_TOUCH_TOUCH_EN_CAL_S)
#define TOUCH_AON_TOUCH_TOUCH_EN_CAL_V  0x00000001U
#define TOUCH_AON_TOUCH_TOUCH_EN_CAL_S  3
/** TOUCH_AON_TOUCH_TOUCH_DCAP_CAL : R/W; bitpos: [10:4]; default: 0;
 *  need_des
 */
#define TOUCH_AON_TOUCH_TOUCH_DCAP_CAL    0x0000007FU
#define TOUCH_AON_TOUCH_TOUCH_DCAP_CAL_M  (TOUCH_AON_TOUCH_TOUCH_DCAP_CAL_V << TOUCH_AON_TOUCH_TOUCH_DCAP_CAL_S)
#define TOUCH_AON_TOUCH_TOUCH_DCAP_CAL_V  0x0000007FU
#define TOUCH_AON_TOUCH_TOUCH_DCAP_CAL_S  4

/** TOUCH_AON_MUX0_REG register
 *  need_des
 */
#define TOUCH_AON_MUX0_REG (DR_REG_TOUCH_AON_BASE + 0x40)
/** TOUCH_AON_TOUCH_DATA_SEL : R/W; bitpos: [9:8]; default: 0;
 *  need_des
 */
#define TOUCH_AON_TOUCH_DATA_SEL    0x00000003U
#define TOUCH_AON_TOUCH_DATA_SEL_M  (TOUCH_AON_TOUCH_DATA_SEL_V << TOUCH_AON_TOUCH_DATA_SEL_S)
#define TOUCH_AON_TOUCH_DATA_SEL_V  0x00000003U
#define TOUCH_AON_TOUCH_DATA_SEL_S  8
/** TOUCH_AON_TOUCH_FREQ_SEL : R/W; bitpos: [11:10]; default: 0;
 *  need_des
 */
#define TOUCH_AON_TOUCH_FREQ_SEL    0x00000003U
#define TOUCH_AON_TOUCH_FREQ_SEL_M  (TOUCH_AON_TOUCH_FREQ_SEL_V << TOUCH_AON_TOUCH_FREQ_SEL_S)
#define TOUCH_AON_TOUCH_FREQ_SEL_V  0x00000003U
#define TOUCH_AON_TOUCH_FREQ_SEL_S  10
/** TOUCH_AON_TOUCH_BUFSEL : R/W; bitpos: [26:12]; default: 0;
 *  need_des
 */
#define TOUCH_AON_TOUCH_BUFSEL    0x00007FFFU
#define TOUCH_AON_TOUCH_BUFSEL_M  (TOUCH_AON_TOUCH_BUFSEL_V << TOUCH_AON_TOUCH_BUFSEL_S)
#define TOUCH_AON_TOUCH_BUFSEL_V  0x00007FFFU
#define TOUCH_AON_TOUCH_BUFSEL_S  12
/** TOUCH_AON_TOUCH_DONE_EN : R/W; bitpos: [27]; default: 0;
 *  need_des
 */
#define TOUCH_AON_TOUCH_DONE_EN    (BIT(27))
#define TOUCH_AON_TOUCH_DONE_EN_M  (TOUCH_AON_TOUCH_DONE_EN_V << TOUCH_AON_TOUCH_DONE_EN_S)
#define TOUCH_AON_TOUCH_DONE_EN_V  0x00000001U
#define TOUCH_AON_TOUCH_DONE_EN_S  27
/** TOUCH_AON_TOUCH_DONE_FORCE : R/W; bitpos: [28]; default: 0;
 *  need_des
 */
#define TOUCH_AON_TOUCH_DONE_FORCE    (BIT(28))
#define TOUCH_AON_TOUCH_DONE_FORCE_M  (TOUCH_AON_TOUCH_DONE_FORCE_V << TOUCH_AON_TOUCH_DONE_FORCE_S)
#define TOUCH_AON_TOUCH_DONE_FORCE_V  0x00000001U
#define TOUCH_AON_TOUCH_DONE_FORCE_S  28
/** TOUCH_AON_TOUCH_FSM_EN : R/W; bitpos: [29]; default: 1;
 *  need_des
 */
#define TOUCH_AON_TOUCH_FSM_EN    (BIT(29))
#define TOUCH_AON_TOUCH_FSM_EN_M  (TOUCH_AON_TOUCH_FSM_EN_V << TOUCH_AON_TOUCH_FSM_EN_S)
#define TOUCH_AON_TOUCH_FSM_EN_V  0x00000001U
#define TOUCH_AON_TOUCH_FSM_EN_S  29
/** TOUCH_AON_TOUCH_START_EN : R/W; bitpos: [30]; default: 0;
 *  need_des
 */
#define TOUCH_AON_TOUCH_START_EN    (BIT(30))
#define TOUCH_AON_TOUCH_START_EN_M  (TOUCH_AON_TOUCH_START_EN_V << TOUCH_AON_TOUCH_START_EN_S)
#define TOUCH_AON_TOUCH_START_EN_V  0x00000001U
#define TOUCH_AON_TOUCH_START_EN_S  30
/** TOUCH_AON_TOUCH_START_FORCE : R/W; bitpos: [31]; default: 0;
 *  need_des
 */
#define TOUCH_AON_TOUCH_START_FORCE    (BIT(31))
#define TOUCH_AON_TOUCH_START_FORCE_M  (TOUCH_AON_TOUCH_START_FORCE_V << TOUCH_AON_TOUCH_START_FORCE_S)
#define TOUCH_AON_TOUCH_START_FORCE_V  0x00000001U
#define TOUCH_AON_TOUCH_START_FORCE_S  31

/** TOUCH_AON_MUX1_REG register
 *  need_des
 */
#define TOUCH_AON_MUX1_REG (DR_REG_TOUCH_AON_BASE + 0x44)
/** TOUCH_AON_TOUCH_START : R/W; bitpos: [14:0]; default: 0;
 *  need_des
 */
#define TOUCH_AON_TOUCH_START    0x00007FFFU
#define TOUCH_AON_TOUCH_START_M  (TOUCH_AON_TOUCH_START_V << TOUCH_AON_TOUCH_START_S)
#define TOUCH_AON_TOUCH_START_V  0x00007FFFU
#define TOUCH_AON_TOUCH_START_S  0
/** TOUCH_AON_TOUCH_XPD : R/W; bitpos: [29:15]; default: 0;
 *  need_des
 */
#define TOUCH_AON_TOUCH_XPD    0x00007FFFU
#define TOUCH_AON_TOUCH_XPD_M  (TOUCH_AON_TOUCH_XPD_V << TOUCH_AON_TOUCH_XPD_S)
#define TOUCH_AON_TOUCH_XPD_V  0x00007FFFU
#define TOUCH_AON_TOUCH_XPD_S  15

/** TOUCH_AON_PAD0_TH0_REG register
 *  need_des
 */
#define TOUCH_AON_PAD0_TH0_REG (DR_REG_TOUCH_AON_BASE + 0x48)
/** TOUCH_AON_TOUCH_PAD0_TH0 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define TOUCH_AON_TOUCH_PAD0_TH0    0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD0_TH0_M  (TOUCH_AON_TOUCH_PAD0_TH0_V << TOUCH_AON_TOUCH_PAD0_TH0_S)
#define TOUCH_AON_TOUCH_PAD0_TH0_V  0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD0_TH0_S  16

/** TOUCH_AON_PAD0_TH1_REG register
 *  need_des
 */
#define TOUCH_AON_PAD0_TH1_REG (DR_REG_TOUCH_AON_BASE + 0x4c)
/** TOUCH_AON_TOUCH_PAD0_TH1 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define TOUCH_AON_TOUCH_PAD0_TH1    0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD0_TH1_M  (TOUCH_AON_TOUCH_PAD0_TH1_V << TOUCH_AON_TOUCH_PAD0_TH1_S)
#define TOUCH_AON_TOUCH_PAD0_TH1_V  0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD0_TH1_S  16

/** TOUCH_AON_PAD0_TH2_REG register
 *  need_des
 */
#define TOUCH_AON_PAD0_TH2_REG (DR_REG_TOUCH_AON_BASE + 0x50)
/** TOUCH_AON_TOUCH_PAD0_TH2 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define TOUCH_AON_TOUCH_PAD0_TH2    0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD0_TH2_M  (TOUCH_AON_TOUCH_PAD0_TH2_V << TOUCH_AON_TOUCH_PAD0_TH2_S)
#define TOUCH_AON_TOUCH_PAD0_TH2_V  0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD0_TH2_S  16

/** TOUCH_AON_PAD1_TH0_REG register
 *  need_des
 */
#define TOUCH_AON_PAD1_TH0_REG (DR_REG_TOUCH_AON_BASE + 0x54)
/** TOUCH_AON_TOUCH_PAD1_TH0 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define TOUCH_AON_TOUCH_PAD1_TH0    0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD1_TH0_M  (TOUCH_AON_TOUCH_PAD1_TH0_V << TOUCH_AON_TOUCH_PAD1_TH0_S)
#define TOUCH_AON_TOUCH_PAD1_TH0_V  0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD1_TH0_S  16

/** TOUCH_AON_PAD1_TH1_REG register
 *  need_des
 */
#define TOUCH_AON_PAD1_TH1_REG (DR_REG_TOUCH_AON_BASE + 0x58)
/** TOUCH_AON_TOUCH_PAD1_TH1 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define TOUCH_AON_TOUCH_PAD1_TH1    0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD1_TH1_M  (TOUCH_AON_TOUCH_PAD1_TH1_V << TOUCH_AON_TOUCH_PAD1_TH1_S)
#define TOUCH_AON_TOUCH_PAD1_TH1_V  0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD1_TH1_S  16

/** TOUCH_AON_PAD1_TH2_REG register
 *  need_des
 */
#define TOUCH_AON_PAD1_TH2_REG (DR_REG_TOUCH_AON_BASE + 0x5c)
/** TOUCH_AON_TOUCH_PAD1_TH2 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define TOUCH_AON_TOUCH_PAD1_TH2    0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD1_TH2_M  (TOUCH_AON_TOUCH_PAD1_TH2_V << TOUCH_AON_TOUCH_PAD1_TH2_S)
#define TOUCH_AON_TOUCH_PAD1_TH2_V  0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD1_TH2_S  16

/** TOUCH_AON_PAD2_TH0_REG register
 *  need_des
 */
#define TOUCH_AON_PAD2_TH0_REG (DR_REG_TOUCH_AON_BASE + 0x60)
/** TOUCH_AON_TOUCH_PAD2_TH0 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define TOUCH_AON_TOUCH_PAD2_TH0    0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD2_TH0_M  (TOUCH_AON_TOUCH_PAD2_TH0_V << TOUCH_AON_TOUCH_PAD2_TH0_S)
#define TOUCH_AON_TOUCH_PAD2_TH0_V  0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD2_TH0_S  16

/** TOUCH_AON_PAD2_TH1_REG register
 *  need_des
 */
#define TOUCH_AON_PAD2_TH1_REG (DR_REG_TOUCH_AON_BASE + 0x64)
/** TOUCH_AON_TOUCH_PAD2_TH1 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define TOUCH_AON_TOUCH_PAD2_TH1    0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD2_TH1_M  (TOUCH_AON_TOUCH_PAD2_TH1_V << TOUCH_AON_TOUCH_PAD2_TH1_S)
#define TOUCH_AON_TOUCH_PAD2_TH1_V  0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD2_TH1_S  16

/** TOUCH_AON_PAD2_TH2_REG register
 *  need_des
 */
#define TOUCH_AON_PAD2_TH2_REG (DR_REG_TOUCH_AON_BASE + 0x68)
/** TOUCH_AON_TOUCH_PAD2_TH2 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define TOUCH_AON_TOUCH_PAD2_TH2    0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD2_TH2_M  (TOUCH_AON_TOUCH_PAD2_TH2_V << TOUCH_AON_TOUCH_PAD2_TH2_S)
#define TOUCH_AON_TOUCH_PAD2_TH2_V  0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD2_TH2_S  16

/** TOUCH_AON_PAD3_TH0_REG register
 *  need_des
 */
#define TOUCH_AON_PAD3_TH0_REG (DR_REG_TOUCH_AON_BASE + 0x6c)
/** TOUCH_AON_TOUCH_PAD3_TH0 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define TOUCH_AON_TOUCH_PAD3_TH0    0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD3_TH0_M  (TOUCH_AON_TOUCH_PAD3_TH0_V << TOUCH_AON_TOUCH_PAD3_TH0_S)
#define TOUCH_AON_TOUCH_PAD3_TH0_V  0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD3_TH0_S  16

/** TOUCH_AON_PAD3_TH1_REG register
 *  need_des
 */
#define TOUCH_AON_PAD3_TH1_REG (DR_REG_TOUCH_AON_BASE + 0x70)
/** TOUCH_AON_TOUCH_PAD3_TH1 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define TOUCH_AON_TOUCH_PAD3_TH1    0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD3_TH1_M  (TOUCH_AON_TOUCH_PAD3_TH1_V << TOUCH_AON_TOUCH_PAD3_TH1_S)
#define TOUCH_AON_TOUCH_PAD3_TH1_V  0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD3_TH1_S  16

/** TOUCH_AON_PAD3_TH2_REG register
 *  need_des
 */
#define TOUCH_AON_PAD3_TH2_REG (DR_REG_TOUCH_AON_BASE + 0x74)
/** TOUCH_AON_TOUCH_PAD3_TH2 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define TOUCH_AON_TOUCH_PAD3_TH2    0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD3_TH2_M  (TOUCH_AON_TOUCH_PAD3_TH2_V << TOUCH_AON_TOUCH_PAD3_TH2_S)
#define TOUCH_AON_TOUCH_PAD3_TH2_V  0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD3_TH2_S  16

/** TOUCH_AON_PAD4_TH0_REG register
 *  need_des
 */
#define TOUCH_AON_PAD4_TH0_REG (DR_REG_TOUCH_AON_BASE + 0x78)
/** TOUCH_AON_TOUCH_PAD4_TH0 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define TOUCH_AON_TOUCH_PAD4_TH0    0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD4_TH0_M  (TOUCH_AON_TOUCH_PAD4_TH0_V << TOUCH_AON_TOUCH_PAD4_TH0_S)
#define TOUCH_AON_TOUCH_PAD4_TH0_V  0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD4_TH0_S  16

/** TOUCH_AON_PAD4_TH1_REG register
 *  need_des
 */
#define TOUCH_AON_PAD4_TH1_REG (DR_REG_TOUCH_AON_BASE + 0x7c)
/** TOUCH_AON_TOUCH_PAD4_TH1 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define TOUCH_AON_TOUCH_PAD4_TH1    0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD4_TH1_M  (TOUCH_AON_TOUCH_PAD4_TH1_V << TOUCH_AON_TOUCH_PAD4_TH1_S)
#define TOUCH_AON_TOUCH_PAD4_TH1_V  0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD4_TH1_S  16

/** TOUCH_AON_PAD4_TH2_REG register
 *  need_des
 */
#define TOUCH_AON_PAD4_TH2_REG (DR_REG_TOUCH_AON_BASE + 0x80)
/** TOUCH_AON_TOUCH_PAD4_TH2 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define TOUCH_AON_TOUCH_PAD4_TH2    0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD4_TH2_M  (TOUCH_AON_TOUCH_PAD4_TH2_V << TOUCH_AON_TOUCH_PAD4_TH2_S)
#define TOUCH_AON_TOUCH_PAD4_TH2_V  0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD4_TH2_S  16

/** TOUCH_AON_PAD5_TH0_REG register
 *  need_des
 */
#define TOUCH_AON_PAD5_TH0_REG (DR_REG_TOUCH_AON_BASE + 0x84)
/** TOUCH_AON_TOUCH_PAD5_TH0 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define TOUCH_AON_TOUCH_PAD5_TH0    0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD5_TH0_M  (TOUCH_AON_TOUCH_PAD5_TH0_V << TOUCH_AON_TOUCH_PAD5_TH0_S)
#define TOUCH_AON_TOUCH_PAD5_TH0_V  0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD5_TH0_S  16

/** TOUCH_AON_PAD5_TH1_REG register
 *  need_des
 */
#define TOUCH_AON_PAD5_TH1_REG (DR_REG_TOUCH_AON_BASE + 0x88)
/** TOUCH_AON_TOUCH_PAD5_TH1 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define TOUCH_AON_TOUCH_PAD5_TH1    0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD5_TH1_M  (TOUCH_AON_TOUCH_PAD5_TH1_V << TOUCH_AON_TOUCH_PAD5_TH1_S)
#define TOUCH_AON_TOUCH_PAD5_TH1_V  0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD5_TH1_S  16

/** TOUCH_AON_PAD5_TH2_REG register
 *  need_des
 */
#define TOUCH_AON_PAD5_TH2_REG (DR_REG_TOUCH_AON_BASE + 0x8c)
/** TOUCH_AON_TOUCH_PAD5_TH2 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define TOUCH_AON_TOUCH_PAD5_TH2    0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD5_TH2_M  (TOUCH_AON_TOUCH_PAD5_TH2_V << TOUCH_AON_TOUCH_PAD5_TH2_S)
#define TOUCH_AON_TOUCH_PAD5_TH2_V  0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD5_TH2_S  16

/** TOUCH_AON_PAD6_TH0_REG register
 *  need_des
 */
#define TOUCH_AON_PAD6_TH0_REG (DR_REG_TOUCH_AON_BASE + 0x90)
/** TOUCH_AON_TOUCH_PAD6_TH0 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define TOUCH_AON_TOUCH_PAD6_TH0    0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD6_TH0_M  (TOUCH_AON_TOUCH_PAD6_TH0_V << TOUCH_AON_TOUCH_PAD6_TH0_S)
#define TOUCH_AON_TOUCH_PAD6_TH0_V  0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD6_TH0_S  16

/** TOUCH_AON_PAD6_TH1_REG register
 *  need_des
 */
#define TOUCH_AON_PAD6_TH1_REG (DR_REG_TOUCH_AON_BASE + 0x94)
/** TOUCH_AON_TOUCH_PAD6_TH1 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define TOUCH_AON_TOUCH_PAD6_TH1    0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD6_TH1_M  (TOUCH_AON_TOUCH_PAD6_TH1_V << TOUCH_AON_TOUCH_PAD6_TH1_S)
#define TOUCH_AON_TOUCH_PAD6_TH1_V  0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD6_TH1_S  16

/** TOUCH_AON_PAD6_TH2_REG register
 *  need_des
 */
#define TOUCH_AON_PAD6_TH2_REG (DR_REG_TOUCH_AON_BASE + 0x98)
/** TOUCH_AON_TOUCH_PAD6_TH2 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define TOUCH_AON_TOUCH_PAD6_TH2    0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD6_TH2_M  (TOUCH_AON_TOUCH_PAD6_TH2_V << TOUCH_AON_TOUCH_PAD6_TH2_S)
#define TOUCH_AON_TOUCH_PAD6_TH2_V  0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD6_TH2_S  16

/** TOUCH_AON_PAD7_TH0_REG register
 *  need_des
 */
#define TOUCH_AON_PAD7_TH0_REG (DR_REG_TOUCH_AON_BASE + 0x9c)
/** TOUCH_AON_TOUCH_PAD7_TH0 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define TOUCH_AON_TOUCH_PAD7_TH0    0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD7_TH0_M  (TOUCH_AON_TOUCH_PAD7_TH0_V << TOUCH_AON_TOUCH_PAD7_TH0_S)
#define TOUCH_AON_TOUCH_PAD7_TH0_V  0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD7_TH0_S  16

/** TOUCH_AON_PAD7_TH1_REG register
 *  need_des
 */
#define TOUCH_AON_PAD7_TH1_REG (DR_REG_TOUCH_AON_BASE + 0xa0)
/** TOUCH_AON_TOUCH_PAD7_TH1 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define TOUCH_AON_TOUCH_PAD7_TH1    0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD7_TH1_M  (TOUCH_AON_TOUCH_PAD7_TH1_V << TOUCH_AON_TOUCH_PAD7_TH1_S)
#define TOUCH_AON_TOUCH_PAD7_TH1_V  0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD7_TH1_S  16

/** TOUCH_AON_PAD7_TH2_REG register
 *  need_des
 */
#define TOUCH_AON_PAD7_TH2_REG (DR_REG_TOUCH_AON_BASE + 0xa4)
/** TOUCH_AON_TOUCH_PAD7_TH2 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define TOUCH_AON_TOUCH_PAD7_TH2    0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD7_TH2_M  (TOUCH_AON_TOUCH_PAD7_TH2_V << TOUCH_AON_TOUCH_PAD7_TH2_S)
#define TOUCH_AON_TOUCH_PAD7_TH2_V  0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD7_TH2_S  16

/** TOUCH_AON_PAD8_TH0_REG register
 *  need_des
 */
#define TOUCH_AON_PAD8_TH0_REG (DR_REG_TOUCH_AON_BASE + 0xa8)
/** TOUCH_AON_TOUCH_PAD8_TH0 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define TOUCH_AON_TOUCH_PAD8_TH0    0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD8_TH0_M  (TOUCH_AON_TOUCH_PAD8_TH0_V << TOUCH_AON_TOUCH_PAD8_TH0_S)
#define TOUCH_AON_TOUCH_PAD8_TH0_V  0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD8_TH0_S  16

/** TOUCH_AON_PAD8_TH1_REG register
 *  need_des
 */
#define TOUCH_AON_PAD8_TH1_REG (DR_REG_TOUCH_AON_BASE + 0xac)
/** TOUCH_AON_TOUCH_PAD8_TH1 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define TOUCH_AON_TOUCH_PAD8_TH1    0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD8_TH1_M  (TOUCH_AON_TOUCH_PAD8_TH1_V << TOUCH_AON_TOUCH_PAD8_TH1_S)
#define TOUCH_AON_TOUCH_PAD8_TH1_V  0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD8_TH1_S  16

/** TOUCH_AON_PAD8_TH2_REG register
 *  need_des
 */
#define TOUCH_AON_PAD8_TH2_REG (DR_REG_TOUCH_AON_BASE + 0xb0)
/** TOUCH_AON_TOUCH_PAD8_TH2 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define TOUCH_AON_TOUCH_PAD8_TH2    0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD8_TH2_M  (TOUCH_AON_TOUCH_PAD8_TH2_V << TOUCH_AON_TOUCH_PAD8_TH2_S)
#define TOUCH_AON_TOUCH_PAD8_TH2_V  0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD8_TH2_S  16

/** TOUCH_AON_PAD9_TH0_REG register
 *  need_des
 */
#define TOUCH_AON_PAD9_TH0_REG (DR_REG_TOUCH_AON_BASE + 0xb4)
/** TOUCH_AON_TOUCH_PAD9_TH0 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define TOUCH_AON_TOUCH_PAD9_TH0    0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD9_TH0_M  (TOUCH_AON_TOUCH_PAD9_TH0_V << TOUCH_AON_TOUCH_PAD9_TH0_S)
#define TOUCH_AON_TOUCH_PAD9_TH0_V  0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD9_TH0_S  16

/** TOUCH_AON_PAD9_TH1_REG register
 *  need_des
 */
#define TOUCH_AON_PAD9_TH1_REG (DR_REG_TOUCH_AON_BASE + 0xb8)
/** TOUCH_AON_TOUCH_PAD9_TH1 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define TOUCH_AON_TOUCH_PAD9_TH1    0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD9_TH1_M  (TOUCH_AON_TOUCH_PAD9_TH1_V << TOUCH_AON_TOUCH_PAD9_TH1_S)
#define TOUCH_AON_TOUCH_PAD9_TH1_V  0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD9_TH1_S  16

/** TOUCH_AON_PAD9_TH2_REG register
 *  need_des
 */
#define TOUCH_AON_PAD9_TH2_REG (DR_REG_TOUCH_AON_BASE + 0xbc)
/** TOUCH_AON_TOUCH_PAD9_TH2 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define TOUCH_AON_TOUCH_PAD9_TH2    0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD9_TH2_M  (TOUCH_AON_TOUCH_PAD9_TH2_V << TOUCH_AON_TOUCH_PAD9_TH2_S)
#define TOUCH_AON_TOUCH_PAD9_TH2_V  0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD9_TH2_S  16

/** TOUCH_AON_PAD10_TH0_REG register
 *  need_des
 */
#define TOUCH_AON_PAD10_TH0_REG (DR_REG_TOUCH_AON_BASE + 0xc0)
/** TOUCH_AON_TOUCH_PAD10_TH0 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define TOUCH_AON_TOUCH_PAD10_TH0    0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD10_TH0_M  (TOUCH_AON_TOUCH_PAD10_TH0_V << TOUCH_AON_TOUCH_PAD10_TH0_S)
#define TOUCH_AON_TOUCH_PAD10_TH0_V  0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD10_TH0_S  16

/** TOUCH_AON_PAD10_TH1_REG register
 *  need_des
 */
#define TOUCH_AON_PAD10_TH1_REG (DR_REG_TOUCH_AON_BASE + 0xc4)
/** TOUCH_AON_TOUCH_PAD10_TH1 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define TOUCH_AON_TOUCH_PAD10_TH1    0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD10_TH1_M  (TOUCH_AON_TOUCH_PAD10_TH1_V << TOUCH_AON_TOUCH_PAD10_TH1_S)
#define TOUCH_AON_TOUCH_PAD10_TH1_V  0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD10_TH1_S  16

/** TOUCH_AON_PAD10_TH2_REG register
 *  need_des
 */
#define TOUCH_AON_PAD10_TH2_REG (DR_REG_TOUCH_AON_BASE + 0xc8)
/** TOUCH_AON_TOUCH_PAD10_TH2 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define TOUCH_AON_TOUCH_PAD10_TH2    0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD10_TH2_M  (TOUCH_AON_TOUCH_PAD10_TH2_V << TOUCH_AON_TOUCH_PAD10_TH2_S)
#define TOUCH_AON_TOUCH_PAD10_TH2_V  0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD10_TH2_S  16

/** TOUCH_AON_PAD11_TH0_REG register
 *  need_des
 */
#define TOUCH_AON_PAD11_TH0_REG (DR_REG_TOUCH_AON_BASE + 0xcc)
/** TOUCH_AON_TOUCH_PAD11_TH0 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define TOUCH_AON_TOUCH_PAD11_TH0    0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD11_TH0_M  (TOUCH_AON_TOUCH_PAD11_TH0_V << TOUCH_AON_TOUCH_PAD11_TH0_S)
#define TOUCH_AON_TOUCH_PAD11_TH0_V  0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD11_TH0_S  16

/** TOUCH_AON_PAD11_TH1_REG register
 *  need_des
 */
#define TOUCH_AON_PAD11_TH1_REG (DR_REG_TOUCH_AON_BASE + 0xd0)
/** TOUCH_AON_TOUCH_PAD11_TH1 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define TOUCH_AON_TOUCH_PAD11_TH1    0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD11_TH1_M  (TOUCH_AON_TOUCH_PAD11_TH1_V << TOUCH_AON_TOUCH_PAD11_TH1_S)
#define TOUCH_AON_TOUCH_PAD11_TH1_V  0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD11_TH1_S  16

/** TOUCH_AON_PAD11_TH2_REG register
 *  need_des
 */
#define TOUCH_AON_PAD11_TH2_REG (DR_REG_TOUCH_AON_BASE + 0xd4)
/** TOUCH_AON_TOUCH_PAD11_TH2 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define TOUCH_AON_TOUCH_PAD11_TH2    0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD11_TH2_M  (TOUCH_AON_TOUCH_PAD11_TH2_V << TOUCH_AON_TOUCH_PAD11_TH2_S)
#define TOUCH_AON_TOUCH_PAD11_TH2_V  0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD11_TH2_S  16

/** TOUCH_AON_PAD12_TH0_REG register
 *  need_des
 */
#define TOUCH_AON_PAD12_TH0_REG (DR_REG_TOUCH_AON_BASE + 0xd8)
/** TOUCH_AON_TOUCH_PAD12_TH0 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define TOUCH_AON_TOUCH_PAD12_TH0    0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD12_TH0_M  (TOUCH_AON_TOUCH_PAD12_TH0_V << TOUCH_AON_TOUCH_PAD12_TH0_S)
#define TOUCH_AON_TOUCH_PAD12_TH0_V  0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD12_TH0_S  16

/** TOUCH_AON_PAD12_TH1_REG register
 *  need_des
 */
#define TOUCH_AON_PAD12_TH1_REG (DR_REG_TOUCH_AON_BASE + 0xdc)
/** TOUCH_AON_TOUCH_PAD12_TH1 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define TOUCH_AON_TOUCH_PAD12_TH1    0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD12_TH1_M  (TOUCH_AON_TOUCH_PAD12_TH1_V << TOUCH_AON_TOUCH_PAD12_TH1_S)
#define TOUCH_AON_TOUCH_PAD12_TH1_V  0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD12_TH1_S  16

/** TOUCH_AON_PAD12_TH2_REG register
 *  need_des
 */
#define TOUCH_AON_PAD12_TH2_REG (DR_REG_TOUCH_AON_BASE + 0xe0)
/** TOUCH_AON_TOUCH_PAD12_TH2 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define TOUCH_AON_TOUCH_PAD12_TH2    0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD12_TH2_M  (TOUCH_AON_TOUCH_PAD12_TH2_V << TOUCH_AON_TOUCH_PAD12_TH2_S)
#define TOUCH_AON_TOUCH_PAD12_TH2_V  0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD12_TH2_S  16

/** TOUCH_AON_PAD13_TH0_REG register
 *  need_des
 */
#define TOUCH_AON_PAD13_TH0_REG (DR_REG_TOUCH_AON_BASE + 0xe4)
/** TOUCH_AON_TOUCH_PAD13_TH0 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define TOUCH_AON_TOUCH_PAD13_TH0    0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD13_TH0_M  (TOUCH_AON_TOUCH_PAD13_TH0_V << TOUCH_AON_TOUCH_PAD13_TH0_S)
#define TOUCH_AON_TOUCH_PAD13_TH0_V  0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD13_TH0_S  16

/** TOUCH_AON_PAD13_TH1_REG register
 *  need_des
 */
#define TOUCH_AON_PAD13_TH1_REG (DR_REG_TOUCH_AON_BASE + 0xe8)
/** TOUCH_AON_TOUCH_PAD13_TH1 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define TOUCH_AON_TOUCH_PAD13_TH1    0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD13_TH1_M  (TOUCH_AON_TOUCH_PAD13_TH1_V << TOUCH_AON_TOUCH_PAD13_TH1_S)
#define TOUCH_AON_TOUCH_PAD13_TH1_V  0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD13_TH1_S  16

/** TOUCH_AON_PAD13_TH2_REG register
 *  need_des
 */
#define TOUCH_AON_PAD13_TH2_REG (DR_REG_TOUCH_AON_BASE + 0xec)
/** TOUCH_AON_TOUCH_PAD13_TH2 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define TOUCH_AON_TOUCH_PAD13_TH2    0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD13_TH2_M  (TOUCH_AON_TOUCH_PAD13_TH2_V << TOUCH_AON_TOUCH_PAD13_TH2_S)
#define TOUCH_AON_TOUCH_PAD13_TH2_V  0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD13_TH2_S  16

/** TOUCH_AON_PAD14_TH0_REG register
 *  need_des
 */
#define TOUCH_AON_PAD14_TH0_REG (DR_REG_TOUCH_AON_BASE + 0xf0)
/** TOUCH_AON_TOUCH_PAD14_TH0 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define TOUCH_AON_TOUCH_PAD14_TH0    0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD14_TH0_M  (TOUCH_AON_TOUCH_PAD14_TH0_V << TOUCH_AON_TOUCH_PAD14_TH0_S)
#define TOUCH_AON_TOUCH_PAD14_TH0_V  0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD14_TH0_S  16

/** TOUCH_AON_PAD14_TH1_REG register
 *  need_des
 */
#define TOUCH_AON_PAD14_TH1_REG (DR_REG_TOUCH_AON_BASE + 0xf4)
/** TOUCH_AON_TOUCH_PAD14_TH1 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define TOUCH_AON_TOUCH_PAD14_TH1    0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD14_TH1_M  (TOUCH_AON_TOUCH_PAD14_TH1_V << TOUCH_AON_TOUCH_PAD14_TH1_S)
#define TOUCH_AON_TOUCH_PAD14_TH1_V  0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD14_TH1_S  16

/** TOUCH_AON_PAD14_TH2_REG register
 *  need_des
 */
#define TOUCH_AON_PAD14_TH2_REG (DR_REG_TOUCH_AON_BASE + 0xf8)
/** TOUCH_AON_TOUCH_PAD14_TH2 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define TOUCH_AON_TOUCH_PAD14_TH2    0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD14_TH2_M  (TOUCH_AON_TOUCH_PAD14_TH2_V << TOUCH_AON_TOUCH_PAD14_TH2_S)
#define TOUCH_AON_TOUCH_PAD14_TH2_V  0x0000FFFFU
#define TOUCH_AON_TOUCH_PAD14_TH2_S  16

/** TOUCH_AON_DATE_REG register
 *  need_des
 */
#define TOUCH_AON_DATE_REG (DR_REG_TOUCH_AON_BASE + 0xfc)
/** TOUCH_AON_DATE : R/W; bitpos: [30:0]; default: 38813808;
 *  need_des
 */
#define TOUCH_AON_DATE    0x7FFFFFFFU
#define TOUCH_AON_DATE_M  (TOUCH_AON_DATE_V << TOUCH_AON_DATE_S)
#define TOUCH_AON_DATE_V  0x7FFFFFFFU
#define TOUCH_AON_DATE_S  0
/** TOUCH_AON_CLK_EN : R/W; bitpos: [31]; default: 0;
 *  need_des
 */
#define TOUCH_AON_CLK_EN    (BIT(31))
#define TOUCH_AON_CLK_EN_M  (TOUCH_AON_CLK_EN_V << TOUCH_AON_CLK_EN_S)
#define TOUCH_AON_CLK_EN_V  0x00000001U
#define TOUCH_AON_CLK_EN_S  31

#ifdef __cplusplus
}
#endif
