/*
 * SPDX-FileCopyrightText: 2023-2025 Espressif Systems (Shanghai) CO LTD
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 */

#include "soc/soc_caps.h"

#if SOC_AES_SUPPORTED

#define ESP_AES_ENCRYPT     1 /**< AES encryption. */
#define ESP_AES_DECRYPT     0 /**< AES decryption. */

#define TEST_AES_MALLOC_CAPS (MALLOC_CAP_8BIT | MALLOC_CAP_INTERNAL | MALLOC_CAP_DMA)

static const uint8_t key_256[] = {
    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
    0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
    0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
    0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,
};

static const uint8_t iv[] = {
    0x10, 0x0f, 0x0e, 0x0d, 0x0c, 0x0b, 0x0a, 0x09,
    0x08, 0x07, 0x06, 0x05, 0x04, 0x03, 0x02, 0x01,
};

#define AES_BUFFER_SIZE_BLOCK_MODE 128 /* Shorter data length to test the block mode */

const uint8_t expected_cipher_end_block_cbc[32] = {
    0x89, 0xc1, 0x6b, 0x75, 0x19, 0x03, 0x0f, 0x1d,
    0xdb, 0xfb, 0xb9, 0x90, 0x02, 0x30, 0x34, 0x3c,
    0xf0, 0x12, 0xa1, 0xa3, 0x87, 0x0f, 0x61, 0x32,
    0x58, 0xdd, 0x20, 0xbe, 0xff, 0x30, 0x58, 0x38,
};

const uint8_t expected_cipher_end_block_ctr[32] = {
    0xd4, 0xf8, 0x63, 0xd3, 0x1f, 0xfa, 0xfa, 0xf5,
    0x42, 0x7e, 0x3e, 0xad, 0x63, 0x99, 0x69, 0x3d,
    0x91, 0x40, 0xfa, 0xa8, 0x74, 0x89, 0xae, 0xbe,
    0xee, 0x5c, 0xea, 0x45, 0xef, 0x77, 0x2b, 0x83,
};

#define AES_BUFFER_SIZE_DMA_MODE 1600 /* Longer data length to test the DMA mode */

/* Expected cipher text's last 32 bytes for 1600 bytes data length */
const uint8_t expected_cipher_end_dma_cbc[32] = {
    0x3e, 0x68, 0x8a, 0x02, 0xe6, 0xf2, 0x6a, 0x9e,
    0x9b, 0xb2, 0xc0, 0xc4, 0x63, 0x63, 0xd9, 0x25,
    0x51, 0xdc, 0xc2, 0x71, 0x96, 0xb3, 0xe5, 0xcd,
    0xbd, 0x0e, 0xf2, 0xef, 0xa9, 0xab, 0xab, 0x2d,
};

const uint8_t expected_cipher_end_dma_ctr[32] = {
    0xed, 0xa4, 0xa4, 0xe0, 0xee, 0x1d, 0x73, 0x96,
    0xd3, 0xde, 0xaa, 0xe0, 0xb7, 0x76, 0x7f, 0xcb,
    0x0f, 0xe8, 0x64, 0xf0, 0xd3, 0xf1, 0xab, 0x14,
    0x5a, 0x89, 0x47, 0xb4, 0x32, 0xed, 0x41, 0x9c,
};

const uint8_t expected_cipher_end_dma_ofb[32] = {
    0x9e, 0x12, 0x10, 0xf0, 0x3f, 0xbf, 0xf8, 0x34,
    0x08, 0x86, 0x7c, 0x02, 0x6b, 0x8a, 0x76, 0xa6,
    0x25, 0x9f, 0x34, 0x61, 0x8b, 0x89, 0x60, 0x16,
    0xe6, 0xa0, 0xa5, 0xb6, 0x5b, 0x0a, 0xeb, 0x1f,
};

const uint8_t expected_cipher_end_dma_cfb8[32] = {
    0x76, 0x95, 0x22, 0x72, 0x3f, 0x44, 0x2d, 0x32,
    0x3e, 0x85, 0xb8, 0xe8, 0xf7, 0x38, 0x04, 0xd6,
    0x4a, 0xc5, 0xdb, 0x2c, 0x46, 0x5f, 0x5b, 0xa2,
    0x24, 0x4a, 0x35, 0xcb, 0xe5, 0x94, 0x71, 0x21,
};

const uint8_t expected_cipher_end_dma_cfb128[32] = {
    0xd0, 0x9b, 0x2e, 0x25, 0xd5, 0xeb, 0x08, 0xbd,
    0xd8, 0x7e, 0x64, 0xde, 0x35, 0x2b, 0xb1, 0x53,
    0xf8, 0x3a, 0xf7, 0xa8, 0x1e, 0x96, 0xaa, 0xce,
    0xa4, 0xf2, 0x8a, 0x2d, 0x01, 0xd5, 0x62, 0xa0,
};

#define AES_BUFFER_SIZE_DMA_MODE_WITH_INTERRUPT 8000

const uint8_t expected_cipher_end_dma_cbc_with_interrupt[32] = {
    0xd1, 0x32, 0x62, 0x9d, 0x2f, 0x0e, 0x1d, 0x27,
    0x0e, 0x2b, 0x53, 0x0b, 0x81, 0x53, 0x92, 0x69,
    0x8a, 0x9c, 0x25, 0xb1, 0x77, 0x2b, 0xe4, 0x80,
    0x3a, 0xee, 0xdc, 0xbb, 0x80, 0xd6, 0x1a, 0x42,
};

const uint8_t expected_cipher_end_dma_ctr_with_interrupt[32] = {
    0x30, 0x8e, 0x3b, 0x27, 0x54, 0x85, 0x58, 0x20,
    0x1a, 0xa6, 0xca, 0x81, 0x12, 0x23, 0x7f, 0x01,
    0xba, 0x27, 0x72, 0x44, 0xa9, 0x00, 0x42, 0x8a,
    0x4e, 0xda, 0x26, 0xf9, 0xd9, 0x0b, 0xb1, 0xa5,
};

const uint8_t expected_cipher_end_dma_ofb_with_interrupt[32] = {
    0xdc, 0xd1, 0x8a, 0x5c, 0x38, 0xb4, 0xce, 0xdf,
    0x21, 0xa0, 0xa4, 0x0b, 0x87, 0xbb, 0xdf, 0xf5,
    0x42, 0xc6, 0xe2, 0x1f, 0x9f, 0x93, 0x3b, 0xa4,
    0xdd, 0xb0, 0xce, 0xf0, 0x98, 0x47, 0x23, 0x20,
};

const uint8_t expected_cipher_end_dma_cfb8_with_interrupt[32] = {
    0x9a, 0x2a, 0xaf, 0xec, 0xd1, 0xf3, 0xd2, 0xe2,
    0xf5, 0x62, 0x16, 0x5c, 0x42, 0x8f, 0xc1, 0xa3,
    0x34, 0x05, 0x9b, 0xa5, 0x44, 0x02, 0xff, 0xf4,
    0x6b, 0xca, 0x3c, 0xac, 0xff, 0x6e, 0xb6, 0x7a,
};

const uint8_t expected_cipher_end_dma_cfb128_with_interrupt[32] = {
    0x6c, 0x63, 0xa9, 0x19, 0x12, 0x89, 0x57, 0xeb,
    0xbe, 0x73, 0x17, 0x62, 0xc6, 0xfc, 0xf0, 0x43,
    0x6d, 0x49, 0x6b, 0xc6, 0x35, 0xf8, 0xc1, 0x48,
    0xe2, 0xb7, 0xb1, 0x6f, 0x26, 0x9f, 0x04, 0x8b,
};

#define KEY_BITS 256

#endif /* SOC_AES_SUPPORTED */
