import type * as React from 'react'

export const NetworkDisconnectedIcon = (
  props: React.SVGProps<SVGSVGElement>
) => {
  return (
    <svg
      xmlns='http://www.w3.org/2000/svg'
      viewBox='0 0 22 22'
      fill='none'
      {...props}
    >
      <path
        fillRule='evenodd'
        clipRule='evenodd'
        d='M5.50214 4.88523C4.18844 5.50044 2.95749 6.35055 1.87249 7.43555C1.51451 7.79353 1.51451 8.37394 1.87249 8.73192C2.23047 9.0899 2.81087 9.0899 3.16885 8.73192C4.179 7.72177 5.33674 6.94915 6.57265 6.41408L5.50214 4.88523ZM8.87446 5.706L7.73763 4.08245C11.9893 2.98874 16.6925 4.10644 20.0216 7.43555C20.3795 7.79353 20.3795 8.37394 20.0216 8.73192C19.6636 9.0899 19.0832 9.0899 18.7252 8.73192C16.0477 6.05438 12.3332 5.04575 8.87446 5.706ZM7.7943 8.15878C6.63852 8.60546 5.55504 9.29508 4.62249 10.2276C4.26451 10.5856 4.26451 11.166 4.62249 11.524C4.98047 11.882 5.56087 11.882 5.91885 11.524C6.77945 10.6634 7.80072 10.0614 8.88611 9.71804L7.7943 8.15878ZM11.45 9.38421L10.1922 7.58798C12.832 7.32557 15.5639 8.20545 17.5861 10.2276C17.9441 10.5856 17.9441 11.166 17.5861 11.524C17.2281 11.882 16.6477 11.882 16.2898 11.524C14.9458 10.18 13.2099 9.46674 11.45 9.38421ZM10.2927 11.7269C9.16647 11.894 8.0821 12.411 7.21514 13.278C6.85716 13.636 6.85716 14.2164 7.21514 14.5744C7.57312 14.9323 8.15352 14.9323 8.5115 14.5744C9.34204 13.7438 10.4719 13.395 11.5538 13.5279L10.2927 11.7269ZM15.0449 14.5183L13.3983 12.1667C13.9761 12.4317 14.5175 12.8022 14.9933 13.278C15.3332 13.6179 15.3504 14.1582 15.0449 14.5183ZM12.2386 18.246C12.865 17.6195 12.865 16.6038 12.2386 15.9774C11.6121 15.3509 10.5964 15.3509 9.96992 15.9774C9.34345 16.6038 9.34345 17.6195 9.96992 18.246C10.5964 18.8725 11.6121 18.8725 12.2386 18.246Z'
        fill='currentColor'
      />
      <rect
        width='1.375'
        height='17.1585'
        rx='0.6875'
        transform='matrix(-0.819152 0.573576 0.573576 0.819152 5.73462 3.27441)'
        fill='currentColor'
      />
    </svg>
  )
}

export const NetworkMediumIcon = (props: React.SVGProps<SVGSVGElement>) => {
  return (
    <svg
      xmlns='http://www.w3.org/2000/svg'
      viewBox='0 0 22 22'
      fill='none'
      {...props}
    >
      <path
        fillRule='evenodd'
        clipRule='evenodd'
        d='M1.87249 7.43555C1.51451 7.79353 1.51451 8.37394 1.87249 8.73192C2.23047 9.0899 2.81087 9.0899 3.16885 8.73192C7.46462 4.43615 14.4294 4.43615 18.7252 8.73192C19.0832 9.0899 19.6636 9.0899 20.0216 8.73192C20.3795 8.37394 20.3795 7.79353 20.0216 7.43555C15.0098 2.42383 6.88422 2.42383 1.87249 7.43555ZM4.62249 10.2276C4.26451 10.5856 4.26451 11.166 4.62249 11.524C4.98047 11.882 5.56087 11.882 5.91885 11.524C8.7827 8.66014 13.4259 8.66014 16.2898 11.524C16.6477 11.882 17.2281 11.882 17.5861 11.524C17.9441 11.166 17.9441 10.5856 17.5861 10.2276C14.0063 6.64782 8.2023 6.64782 4.62249 10.2276Z'
        fill='currentColor'
        fillOpacity='0.5'
      />
      <path
        fillRule='evenodd'
        clipRule='evenodd'
        d='M6.91424 13.2779C6.55626 13.6359 6.55626 14.2163 6.91424 14.5743C7.27222 14.9322 7.85262 14.9322 8.2106 14.5743C9.64252 13.1423 11.9641 13.1423 13.396 14.5743C13.754 14.9322 14.3344 14.9322 14.6924 14.5743C15.0504 14.2163 15.0504 13.6359 14.6924 13.2779C12.5445 11.13 9.06212 11.13 6.91424 13.2779ZM11.9377 18.2459C12.5641 17.6194 12.5641 16.6037 11.9377 15.9773C11.3112 15.3508 10.2955 15.3508 9.66902 15.9773C9.04255 16.6037 9.04255 17.6194 9.66902 18.2459C10.2955 18.8724 11.3112 18.8724 11.9377 18.2459Z'
        fill='#FFC700'
      />
    </svg>
  )
}

export const NetworkPoorIcon = (props: React.SVGProps<SVGSVGElement>) => {
  return (
    <svg
      xmlns='http://www.w3.org/2000/svg'
      viewBox='0 0 22 22'
      fill='none'
      {...props}
    >
      <path
        fillRule='evenodd'
        clipRule='evenodd'
        d='M1.87249 8.73192C1.51451 8.37394 1.51451 7.79353 1.87249 7.43555C6.88422 2.42383 15.0098 2.42383 20.0216 7.43555C20.3795 7.79353 20.3795 8.37394 20.0216 8.73192C19.6636 9.0899 19.0832 9.0899 18.7252 8.73192C14.4294 4.43615 7.46462 4.43615 3.16885 8.73192C2.81087 9.0899 2.23047 9.0899 1.87249 8.73192ZM4.62249 11.524C4.26451 11.166 4.26451 10.5856 4.62249 10.2276C8.2023 6.64782 14.0063 6.64782 17.5861 10.2276C17.9441 10.5856 17.9441 11.166 17.5861 11.524C17.2281 11.882 16.6477 11.882 16.2898 11.524C13.4259 8.66014 8.7827 8.66014 5.91885 11.524C5.56087 11.882 4.98047 11.882 4.62249 11.524ZM7.21516 13.2789C6.85718 13.6368 6.85718 14.2172 7.21516 14.5752C7.57314 14.9332 8.15354 14.9332 8.51152 14.5752C9.94345 13.1433 12.2651 13.1433 13.697 14.5752C14.055 14.9332 14.6354 14.9332 14.9933 14.5752C15.3513 14.2172 15.3513 13.6368 14.9933 13.2789C12.8455 11.131 9.36305 11.131 7.21516 13.2789Z'
        fill='currentColor'
        fillOpacity='0.5'
      />
      <circle
        cx='11.1043'
        cy='17.1123'
        r='1.60417'
        transform='rotate(-45 11.1043 17.1123)'
        fill='#F5655C'
      />
    </svg>
  )
}

export const NetworkExcellentIcon = (props: React.SVGProps<SVGSVGElement>) => {
  return (
    <svg
      xmlns='http://www.w3.org/2000/svg'
      viewBox='0 0 22 22'
      fill='none'
      {...props}
    >
      <path
        fillRule='evenodd'
        clipRule='evenodd'
        d='M1.87249 7.43555C1.51451 7.79353 1.51451 8.37394 1.87249 8.73192C2.23047 9.0899 2.81087 9.0899 3.16885 8.73192C7.46462 4.43615 14.4294 4.43615 18.7252 8.73192C19.0832 9.0899 19.6636 9.0899 20.0216 8.73192C20.3795 8.37394 20.3795 7.79353 20.0216 7.43555C15.0098 2.42383 6.88422 2.42383 1.87249 7.43555ZM4.62249 10.2276C4.26451 10.5856 4.26451 11.166 4.62249 11.524C4.98047 11.882 5.56087 11.882 5.91885 11.524C8.7827 8.66014 13.4259 8.66014 16.2898 11.524C16.6477 11.882 17.2281 11.882 17.5861 11.524C17.9441 11.166 17.9441 10.5856 17.5861 10.2276C14.0063 6.64782 8.2023 6.64782 4.62249 10.2276ZM7.21516 14.5752C6.85718 14.2172 6.85718 13.6368 7.21516 13.2789C9.36305 11.131 12.8455 11.131 14.9933 13.2789C15.3513 13.6368 15.3513 14.2172 14.9933 14.5752C14.6354 14.9332 14.055 14.9332 13.697 14.5752C12.2651 13.1433 9.94345 13.1433 8.51152 14.5752C8.15354 14.9332 7.57314 14.9332 7.21516 14.5752ZM12.2386 18.2464C12.865 17.6199 12.865 16.6042 12.2386 15.9778C11.6121 15.3513 10.5964 15.3513 9.96994 15.9778C9.34347 16.6042 9.34347 17.6199 9.96994 18.2464C10.5964 18.8729 11.6121 18.8729 12.2386 18.2464Z'
        fill='#16D1A4'
      />
    </svg>
  )
}
