import type * as React from 'react'

import { cn } from '@/lib/utils'

export * from '@/components/icon/agent'

export const BrandLogo = (props: React.SVGProps<SVGSVGElement>) => {
  return (
    <svg
      xmlns='http://www.w3.org/2000/svg'
      viewBox='0 0 28 28'
      fill='none'
      {...props}
    >
      <path
        d='M14.8663 1.14286C14.9857 0.859478 15.2582 0.666504 15.5657 0.666504H22.7084C23.5463 0.666504 24.1788 1.43186 23.9518 2.23851C23.3229 4.47308 22.296 6.58713 20.9127 8.48008C19.4373 10.4989 17.5902 12.2202 15.4728 13.5578C16.3133 13.1694 17.1827 12.8378 18.0751 12.5665C20.7105 11.7651 23.4814 11.5088 26.214 11.8083C26.8621 11.8794 27.3333 12.4406 27.3333 13.0926V19.2193C27.3333 20.1192 26.456 20.7611 25.5651 20.634C24.3279 20.4576 23.0627 20.4879 21.8236 20.7303C19.6802 21.1495 17.7115 22.1842 16.1662 23.7035C15.324 24.5317 14.6282 25.4835 14.1003 26.5195C13.8545 27.002 13.3736 27.3332 12.8321 27.3332H6.03717C5.18857 27.3332 4.55416 26.5495 4.80127 25.7376C4.8646 25.5296 4.93147 25.3224 5.00189 25.1162C6.01295 22.155 7.72571 19.4727 9.99881 17.2907C10.9697 16.3587 12.0309 15.5293 13.1647 14.8131C10.5058 16.0417 7.60186 16.6817 4.65829 16.6838C3.67873 16.6866 2.70511 16.618 1.74488 16.4805C1.1153 16.3904 0.666656 15.8381 0.666656 15.2021V9.04833C0.666656 8.11405 1.60891 7.46509 2.52605 7.64323C3.22335 7.77868 3.93716 7.84863 4.65829 7.84935C6.84362 7.84935 8.97984 7.21219 10.7968 6.01844C12.6138 4.82469 14.03 3.128 14.8663 1.14286Z'
        fill='url(#paint0_linear_2918_3509)'
      />
      <defs>
        <linearGradient
          id='paint0_linear_2918_3509'
          x1='27.3333'
          y1='1.0665'
          x2='-4.22016'
          y2='19.0031'
          gradientUnits='userSpaceOnUse'
        >
          <stop stopColor='#2339FF' />
          <stop offset='0.325' stopColor='#2364FF' />
          <stop offset='0.58' stopColor='#A0FAFF' />
          <stop offset='1' stopColor='white' />
        </linearGradient>
      </defs>
    </svg>
  )
}

export const LoadingSpinner = (props: React.SVGProps<SVGSVGElement>) => {
  const { className, ...rest } = props
  return (
    <svg
      className={cn('-ml-1 mr-3 h-5 w-5 animate-spin', className)}
      xmlns='http://www.w3.org/2000/svg'
      fill='none'
      viewBox='0 0 24 24'
      {...rest}
    >
      <circle
        className='opacity-25'
        cx='12'
        cy='12'
        r='10'
        stroke='currentColor'
        strokeWidth='4'
      ></circle>
      <path
        className='opacity-75'
        fill='currentColor'
        d='M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z'
      ></path>
    </svg>
  )
}

export const WebInfo = (props: React.SVGProps<SVGSVGElement>) => {
  return (
    <svg
      xmlns='http://www.w3.org/2000/svg'
      viewBox='0 0 22 22'
      fill='none'
      {...props}
    >
      <path
        fillRule='evenodd'
        clipRule='evenodd'
        d='M6.18758 4.12435C6.18758 3.49152 6.70059 2.97852 7.33341 2.97852H13.0626V5.04102C13.0626 6.68636 14.3964 8.02018 16.0417 8.02018H18.5626V17.416C18.5626 18.0488 18.0496 18.5618 17.4167 18.5618H14.2084C13.8287 18.5618 13.5209 18.8697 13.5209 19.2493C13.5209 19.629 13.8287 19.9368 14.2084 19.9368H17.4167C18.809 19.9368 19.9376 18.8082 19.9376 17.416V7.46741C19.9376 6.64674 19.599 5.86241 19.0018 5.2995L15.9414 2.41478C15.3886 1.89372 14.6576 1.60352 13.898 1.60352H7.33341C5.9412 1.60352 4.81258 2.73213 4.81258 4.12435V7.02713C4.81258 7.40682 5.12039 7.71463 5.50008 7.71463C5.87978 7.71463 6.18758 7.40682 6.18758 7.02713V4.12435ZM18.3358 6.64518C18.2606 6.51905 18.1676 6.40273 18.0587 6.30008L14.9983 3.41535C14.8356 3.26205 14.6444 3.14587 14.4376 3.072V5.04102C14.4376 5.92697 15.1558 6.64518 16.0417 6.64518H18.3358ZM7.33342 9.39518C6.44746 9.39518 5.72925 10.1134 5.72925 10.9993C5.72925 11.8853 6.44746 12.6035 7.33342 12.6035C8.21937 12.6035 8.93758 11.8853 8.93758 10.9993C8.93758 10.1134 8.21937 9.39518 7.33342 9.39518ZM4.35425 10.9993C4.35425 9.354 5.68807 8.02018 7.33342 8.02018C8.97876 8.02018 10.3126 9.354 10.3126 10.9993C10.3126 12.6447 8.97876 13.9785 7.33342 13.9785C5.68807 13.9785 4.35425 12.6447 4.35425 10.9993ZM5.00368 14.8952C3.12622 14.8952 1.60425 16.4172 1.60425 18.2946C1.60425 18.8418 1.9657 19.3231 2.49114 19.4757L3.81856 19.8612C6.11437 20.5279 8.55246 20.5279 10.8483 19.8612L12.1757 19.4757C12.7011 19.3231 13.0626 18.8418 13.0626 18.2946C13.0626 16.4172 11.5406 14.8952 9.66315 14.8952H5.00368ZM4.20203 18.5407L2.98209 18.1865C3.03829 17.1187 3.92189 16.2702 5.00368 16.2702H9.66315C10.7449 16.2702 11.6285 17.1187 11.6847 18.1865L10.4648 18.5407C8.41946 19.1347 6.24737 19.1347 4.20203 18.5407Z'
        fill='currentColor'
      />
    </svg>
  )
}

export const DropdownIcon = (props: React.SVGProps<SVGSVGElement>) => {
  return (
    <svg
      xmlns='http://www.w3.org/2000/svg'
      viewBox='0 0 24 24'
      fill='none'
      {...props}
    >
      <path
        d='M12.4029 16.9517C12.2031 17.2236 11.7969 17.2236 11.5971 16.9517L6.52278 10.0461C6.28014 9.71586 6.51593 9.25 6.9257 9.25L17.0743 9.25C17.4841 9.25 17.7199 9.71586 17.4772 10.0461L12.4029 16.9517Z'
        fill='currentColor'
      />
    </svg>
  )
}

export const UserIcon = (props: React.SVGProps<SVGSVGElement>) => {
  return (
    <svg
      xmlns='http://www.w3.org/2000/svg'
      viewBox='0 0 32 32'
      fill='none'
      {...props}
    >
      <g clipPath='url(#clip0_3020_2329)'>
        <circle cx='16' cy='16.0003' r='15.3333' fill='currentColor' />
        <path
          fillRule='evenodd'
          clipRule='evenodd'
          d='M16.0001 15.3327C17.841 15.3327 19.3334 13.8403 19.3334 11.9993C19.3334 10.1584 17.841 8.66602 16.0001 8.66602C14.1591 8.66602 12.6667 10.1584 12.6667 11.9993C12.6667 13.8403 14.1591 15.3327 16.0001 15.3327ZM14.7459 15.9993C11.3885 15.9993 8.66675 18.7211 8.66675 22.0785C8.66675 22.2434 8.76664 22.3918 8.91939 22.4539L9.39551 22.6475C13.6303 24.3692 18.3699 24.3692 22.6047 22.6475L23.0808 22.4539C23.2335 22.3918 23.3334 22.2434 23.3334 22.0785C23.3334 18.7211 20.6117 15.9993 17.2543 15.9993H14.7459Z'
          fill='black'
          fillOpacity='0.98'
        />
      </g>
      <defs>
        <clipPath id='clip0_3020_2329'>
          <rect width='32' height='32' fill='currentColor' />
        </clipPath>
      </defs>
    </svg>
  )
}

export const CheckFilledIcon = (props: React.SVGProps<SVGSVGElement>) => {
  return (
    <svg
      xmlns='http://www.w3.org/2000/svg'
      viewBox='0 0 22 22'
      fill='none'
      {...props}
    >
      <circle cx='11.0002' cy='10.9997' r='9.16667' fill='currentColor' />
      <path
        d='M7.3335 11.3587L9.41153 13.7924C9.59672 14.0093 9.93292 14.0062 10.1141 13.7859L14.6668 8.25'
        stroke='white'
        strokeWidth='2.29167'
        strokeLinecap='round'
      />
    </svg>
  )
}

/** @deprecated */
export const HotTailIcon = (props: React.SVGProps<SVGSVGElement>) => {
  return (
    <svg
      xmlns='http://www.w3.org/2000/svg'
      width='33'
      height='12'
      viewBox='0 0 33 12'
      fill='none'
      {...props}
    >
      <mask
        id='path-1-outside-1_2966_4006'
        maskUnits='userSpaceOnUse'
        x='0'
        y='0'
        width='33'
        height='12'
        fill='black'
      >
        <rect fill='white' width='33' height='12' />
        <path
          fillRule='evenodd'
          clipRule='evenodd'
          d='M17.7805 11.164C14.6445 11.164 12.7825 9.288 12.7825 6.194C12.7825 3.044 14.6445 1 17.7805 1C20.9165 1 22.7645 3.044 22.7645 6.194C22.7645 9.316 20.9165 11.164 17.7805 11.164ZM15.2325 6.194C15.2325 8.21 16.1705 9.456 17.7805 9.456C19.3625 9.456 20.3145 8.21 20.3145 6.194C20.3145 5.536 20.2165 4.934 20.0205 4.416C19.6285 3.366 18.8305 2.736 17.7805 2.736C16.2405 2.736 15.2325 4.15 15.2325 6.194ZM23.2887 4.07164V1.18164H31.6527V4.07164H29.1327V10.9816H25.8087V4.07164H23.2887ZM11.386 1.19922H8.076V4.96522H4.31V1.19922H1V10.9992H4.31V6.85522H8.076V10.9992H11.386V1.19922Z'
        />
      </mask>
      <path
        fillRule='evenodd'
        clipRule='evenodd'
        d='M17.7805 11.164C14.6445 11.164 12.7825 9.288 12.7825 6.194C12.7825 3.044 14.6445 1 17.7805 1C20.9165 1 22.7645 3.044 22.7645 6.194C22.7645 9.316 20.9165 11.164 17.7805 11.164ZM15.2325 6.194C15.2325 8.21 16.1705 9.456 17.7805 9.456C19.3625 9.456 20.3145 8.21 20.3145 6.194C20.3145 5.536 20.2165 4.934 20.0205 4.416C19.6285 3.366 18.8305 2.736 17.7805 2.736C16.2405 2.736 15.2325 4.15 15.2325 6.194ZM23.2887 4.07164V1.18164H31.6527V4.07164H29.1327V10.9816H25.8087V4.07164H23.2887ZM11.386 1.19922H8.076V4.96522H4.31V1.19922H1V10.9992H4.31V6.85522H8.076V10.9992H11.386V1.19922Z'
        fill='url(#paint0_linear_2966_4006)'
      />
      <path
        d='M20.0205 4.416L19.271 4.69581L19.2722 4.69912L20.0205 4.416ZM23.2887 1.18164V0.381641H22.4887V1.18164H23.2887ZM23.2887 4.07164H22.4887V4.87164H23.2887V4.07164ZM31.6527 1.18164H32.4527V0.381641H31.6527V1.18164ZM31.6527 4.07164V4.87164H32.4527V4.07164H31.6527ZM29.1327 4.07164V3.27164H28.3327V4.07164H29.1327ZM29.1327 10.9816V11.7816H29.9327V10.9816H29.1327ZM25.8087 10.9816H25.0087V11.7816H25.8087V10.9816ZM25.8087 4.07164H26.6087V3.27164H25.8087V4.07164ZM8.076 1.19922V0.399219H7.276V1.19922H8.076ZM11.386 1.19922H12.186V0.399219H11.386V1.19922ZM8.076 4.96522V5.76522H8.876V4.96522H8.076ZM4.31 4.96522H3.51V5.76522H4.31V4.96522ZM4.31 1.19922H5.11V0.399219H4.31V1.19922ZM1 1.19922V0.399219H0.2V1.19922H1ZM1 10.9992H0.2V11.7992H1V10.9992ZM4.31 10.9992V11.7992H5.11V10.9992H4.31ZM4.31 6.85522V6.05522H3.51V6.85522H4.31ZM8.076 6.85522H8.876V6.05522H8.076V6.85522ZM8.076 10.9992H7.276V11.7992H8.076V10.9992ZM11.386 10.9992V11.7992H12.186V10.9992H11.386ZM11.9825 6.194C11.9825 7.90197 12.4996 9.36686 13.5404 10.4055C14.5811 11.4441 16.0526 11.964 17.7805 11.964V10.364C16.3723 10.364 15.3449 9.94592 14.6706 9.27299C13.9964 8.60014 13.5825 7.58003 13.5825 6.194H11.9825ZM17.7805 0.2C16.0328 0.2 14.5589 0.774424 13.5248 1.86543C12.4961 2.95088 11.9825 4.46321 11.9825 6.194H13.5825C13.5825 4.7748 13.9999 3.69012 14.6861 2.96607C15.3671 2.24758 16.3921 1.8 17.7805 1.8V0.2ZM23.5645 6.194C23.5645 4.4648 23.0553 2.9526 22.0302 1.86662C20.9995 0.774593 19.5283 0.2 17.7805 0.2V1.8C19.1686 1.8 20.1895 2.24741 20.8667 2.96488C21.5496 3.6884 21.9645 4.77321 21.9645 6.194H23.5645ZM17.7805 11.964C19.5052 11.964 20.9746 11.4529 22.0136 10.416C23.0527 9.37897 23.5645 7.91267 23.5645 6.194H21.9645C21.9645 7.59733 21.5522 8.61603 20.8834 9.28349C20.2143 9.95114 19.1918 10.364 17.7805 10.364V11.964ZM17.7805 8.656C17.2045 8.656 16.8088 8.44493 16.5356 8.09162C16.2423 7.7124 16.0325 7.09023 16.0325 6.194H14.4325C14.4325 7.31377 14.6916 8.3226 15.2699 9.07038C15.8682 9.84407 16.7464 10.256 17.7805 10.256V8.656ZM19.5145 6.194C19.5145 7.0876 19.3023 7.71088 19.0079 8.09162C18.7324 8.44789 18.3385 8.656 17.7805 8.656V10.256C18.8045 10.256 19.6776 9.84111 20.2736 9.07038C20.8507 8.32412 21.1145 7.3164 21.1145 6.194H19.5145ZM19.2722 4.69912C19.4276 5.10964 19.5145 5.6127 19.5145 6.194H21.1145C21.1145 5.4593 21.0054 4.75836 20.7687 4.13289L19.2722 4.69912ZM17.7805 3.536C18.442 3.536 18.9755 3.90424 19.271 4.6958L20.7699 4.1362C20.2815 2.82776 19.2189 1.936 17.7805 1.936V3.536ZM16.0325 6.194C16.0325 5.29377 16.2555 4.60809 16.5752 4.17014C16.8807 3.75149 17.2851 3.536 17.7805 3.536V1.936C16.7358 1.936 15.8662 2.42751 15.2828 3.22686C14.7134 4.00691 14.4325 5.05023 14.4325 6.194H16.0325ZM22.4887 1.18164V4.07164H24.0887V1.18164H22.4887ZM31.6527 0.381641H23.2887V1.98164H31.6527V0.381641ZM32.4527 4.07164V1.18164H30.8527V4.07164H32.4527ZM29.1327 4.87164H31.6527V3.27164H29.1327V4.87164ZM29.9327 10.9816V4.07164H28.3327V10.9816H29.9327ZM25.8087 11.7816H29.1327V10.1816H25.8087V11.7816ZM25.0087 4.07164V10.9816H26.6087V4.07164H25.0087ZM23.2887 4.87164H25.8087V3.27164H23.2887V4.87164ZM8.076 1.99922H11.386V0.399219H8.076V1.99922ZM8.876 4.96522V1.19922H7.276V4.96522H8.876ZM4.31 5.76522H8.076V4.16522H4.31V5.76522ZM3.51 1.19922V4.96522H5.11V1.19922H3.51ZM1 1.99922H4.31V0.399219H1V1.99922ZM1.8 10.9992V1.19922H0.2V10.9992H1.8ZM4.31 10.1992H1V11.7992H4.31V10.1992ZM3.51 6.85522V10.9992H5.11V6.85522H3.51ZM8.076 6.05522H4.31V7.65522H8.076V6.05522ZM8.876 10.9992V6.85522H7.276V10.9992H8.876ZM11.386 10.1992H8.076V11.7992H11.386V10.1992ZM10.586 1.19922V10.9992H12.186V1.19922H10.586Z'
        fill='white'
        mask='url(#path-1-outside-1_2966_4006)'
      />
      <defs>
        <linearGradient
          id='paint0_linear_2966_4006'
          x1='1.16'
          y1='6.49922'
          x2='30.16'
          y2='6.49922'
          gradientUnits='userSpaceOnUse'
        >
          <stop stopColor='#FF6A1F' />
          <stop offset='1' stopColor='#FF4453' />
        </linearGradient>
      </defs>
    </svg>
  )
}

export const MoreIcon = (props: React.SVGProps<SVGSVGElement>) => {
  return (
    <svg
      xmlns='http://www.w3.org/2000/svg'
      viewBox='0 0 24 24'
      fill='none'
      {...props}
    >
      <rect x='3.5' y='5.5' width='17' height='2' rx='1' fill='currentColor' />
      <rect x='3.5' y='11' width='17' height='2' rx='1' fill='currentColor' />
      <rect x='10' y='17' width='10.5' height='2' rx='1' fill='currentColor' />
    </svg>
  )
}

export const LockCheckedIcon = (props: React.SVGProps<SVGSVGElement>) => (
  <svg
    xmlns='http://www.w3.org/2000/svg'
    viewBox='0 0 22 22'
    fill='none'
    {...props}
  >
    <g clip-path='url(#clip0_43867_2887)'>
      <path
        d='M12.3335 -0.000976562C14.8646 -0.00071264 16.9175 2.05284 16.9175 4.58398V5.57031C18.7676 5.92181 20.1665 7.5476 20.1665 9.5V18L20.1616 18.2061C20.0544 20.3194 18.3065 21.9999 16.1665 22H5.8335C3.69346 22 1.94562 20.3194 1.83838 18.2061L1.8335 18V9.5C1.8335 7.54718 3.23281 5.92138 5.0835 5.57031V4.58398C5.0835 2.05268 7.13618 -0.000976562 9.66748 -0.000976562H12.3335ZM5.8335 7.33301C4.63688 7.33301 3.6665 8.30338 3.6665 9.5V18C3.6665 19.1966 4.63688 20.167 5.8335 20.167H16.1665C17.363 20.1669 18.3335 19.1966 18.3335 18V9.5C18.3335 8.30344 17.363 7.3331 16.1665 7.33301H5.8335ZM13.8989 10.3594C14.2525 9.93558 14.883 9.87811 15.3071 10.2314C15.7313 10.585 15.7885 11.2164 15.4351 11.6406L11.4468 16.4258C10.7625 17.2469 9.53866 17.3499 8.72705 16.6543L6.68311 14.9023C6.26378 14.5429 6.21528 13.9115 6.57471 13.4922C6.93412 13.0731 7.56464 13.0246 7.98389 13.3838L9.96436 15.0801L13.8989 10.3594ZM9.66748 1.83398C8.1487 1.83398 6.91748 3.0652 6.91748 4.58398V5.5H15.0835V4.58398C15.0835 3.06536 13.8521 1.83425 12.3335 1.83398H9.66748Z'
        fill='currentColor'
        fillOpacity='0.5'
      />
    </g>
    <defs>
      <clipPath id='clip0_43867_2887'>
        <rect width='22' height='22' fill='currentColor' />
      </clipPath>
    </defs>
  </svg>
)
